/*
 * Decompiled with CFR 0.152.
 */
package com.sap.conn.jco.rt;

import com.sap.conn.jco.JCoRuntimeException;
import com.sap.conn.jco.monitor.JCoConnectionData;
import com.sap.conn.jco.monitor.JCoConnectionMonitor;
import com.sap.conn.jco.rt.AbstractConnection;
import com.sap.conn.jco.rt.ConnectionManager;
import com.sap.conn.jco.rt.JCoRuntimeFactory;
import com.sap.conn.jco.rt.MonitoredConnectionData;
import com.sap.conn.jco.rt.Trace;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConnectionMonitor
extends JCoConnectionMonitor {
    private Object mutex = new Object();
    private boolean collecting = false;
    private Map<String, List<AbstractConnection>> externalGroups = new HashMap<String, List<AbstractConnection>>(3);
    private List<MonitoredConnectionData> monitoredData = new ArrayList<MonitoredConnectionData>();

    ConnectionMonitor() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    protected List<? extends JCoConnectionData> getConnsData() {
        var1_1 = this.mutex;
        // MONITORENTER : var1_1
        if (this.collecting) {
            try {
                this.mutex.wait();
            }
            catch (InterruptedException ex) {
                throw new RuntimeException("operation was interrupted", ex);
            }
            if (Trace.isOn(128, true)) {
                msg = new StringBuilder("[JCoAPI] ConnectionMonitor ");
                msg.append("reports ").append(this.monitoredData.size()).append(" connections. Data was collected by an other thread.");
                Trace.fireTrace(128, msg.toString());
            }
            // MONITOREXIT : var1_1
            return this.monitoredData;
        }
        this.collecting = true;
        // MONITOREXIT : var1_1
        monitoredDataTmp = new ArrayList<MonitoredConnectionData>();
        exception = null;
        try {
            try {
                ConnectionManager.getConnectionManager().getMonitoredData(monitoredDataTmp);
                JCoRuntimeFactory.getRuntime().getJCoServerFactoryInstance().getMonitoredData(monitoredDataTmp);
                if (!this.externalGroups.isEmpty()) {
                    groupNames = new ArrayList<String>();
                    var4_7 = ConnectionMonitor.class;
                    // MONITORENTER : com.sap.conn.jco.rt.ConnectionMonitor.class
                    groupNames.addAll(this.externalGroups.keySet());
                    // MONITOREXIT : var4_7
                    groupsIt = groupNames.iterator();
                    groupCopy = new ArrayList<AbstractConnection>();
                    while (groupsIt.hasNext()) {
                        groupCopy.clear();
                        var11_14 = ConnectionMonitor.class;
                        // MONITORENTER : com.sap.conn.jco.rt.ConnectionMonitor.class
                        groupName = (String)groupsIt.next();
                        group = this.externalGroups.get(groupName);
                        if (group == null) {
                            // MONITOREXIT : var11_14
                            continue;
                        }
                        groupCopy.addAll(group);
                        // MONITOREXIT : var11_14
                        for (AbstractConnection conn : groupCopy) {
                            mcd = conn.getMonitoredData();
                            mcd.group = groupName;
                            monitoredDataTmp.add(mcd);
                        }
                    }
                }
                var14_15 = null;
            }
            catch (RuntimeException exc) {
                block37: {
                    exception = exc;
                    var14_16 = null;
                    ** try [egrp 6[TRYBLOCK] [13 : 382->473)] { 
lbl58:
                    // 1 sources

                    v0 = traceLevel = exception == null ? 128 : 4;
                    if (Trace.isOn(traceLevel, true)) {
                        msg = new StringBuilder("[JCoAPI] ConnectionMonitor ");
                        if (exception != null) {
                            msg.append("thrown exception ").append(exception.toString());
                        } else {
                            msg.append("reports ").append(monitoredDataTmp.size()).append(" connections.");
                        }
                        Trace.fireTrace(traceLevel, msg.toString(), exception);
                    }
                    break block37;
lbl69:
                    // 1 sources

                    catch (RuntimeException excInFinally) {
                        // empty catch block
                    }
                }
                var15_23 = this.mutex;
                // MONITORENTER : var15_23
                this.monitoredData = monitoredDataTmp;
                this.collecting = false;
                this.mutex.notifyAll();
                // MONITOREXIT : var15_23
            }
            try {
                v1 = traceLevel = exception == null ? 128 : 4;
                if (Trace.isOn(traceLevel, true)) {
                    msg = new StringBuilder("[JCoAPI] ConnectionMonitor ");
                    if (exception != null) {
                        msg.append("thrown exception ").append(exception.toString());
                    } else {
                        msg.append("reports ").append(monitoredDataTmp.size()).append(" connections.");
                    }
                    Trace.fireTrace(traceLevel, msg.toString(), exception);
                }
            }
            catch (RuntimeException excInFinally) {
                // empty catch block
            }
            var15_20 = this.mutex;
            // MONITORENTER : var15_20
            this.monitoredData = monitoredDataTmp;
            this.collecting = false;
            this.mutex.notifyAll();
            // MONITOREXIT : var15_20
        }
        catch (Throwable var13_30) {
            block38: {
                var14_17 = null;
                ** try [egrp 6[TRYBLOCK] [13 : 382->473)] { 
lbl105:
                // 1 sources

                v2 = traceLevel = exception == null ? 128 : 4;
                if (Trace.isOn(traceLevel, true)) {
                    msg = new StringBuilder("[JCoAPI] ConnectionMonitor ");
                    if (exception != null) {
                        msg.append("thrown exception ").append(exception.toString());
                    } else {
                        msg.append("reports ").append(monitoredDataTmp.size()).append(" connections.");
                    }
                    Trace.fireTrace(traceLevel, msg.toString(), exception);
                }
                break block38;
lbl116:
                // 1 sources

                catch (RuntimeException excInFinally) {
                    // empty catch block
                }
            }
            var15_26 = this.mutex;
            // MONITORENTER : var15_26
            this.monitoredData = monitoredDataTmp;
            this.collecting = false;
            this.mutex.notifyAll();
            // MONITOREXIT : var15_26
            throw var13_30;
        }
        if (exception == null) return this.monitoredData;
        throw new JCoRuntimeException(108, "JCO_ERROR_INTERNAL", "Unable to collect monitoring data, caused by " + exception.toString(), exception);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void internalRegisterConnection(String groupName, AbstractConnection conn) {
        Class<ConnectionMonitor> clazz = ConnectionMonitor.class;
        synchronized (ConnectionMonitor.class) {
            List<AbstractConnection> group = this.externalGroups.get(groupName);
            if (group == null) {
                group = new ArrayList<AbstractConnection>();
                this.externalGroups.put(groupName, group);
            }
            group.add(conn);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    public static void registerConnection(String groupName, AbstractConnection conn) {
        ConnectionMonitor monitor = JCoRuntimeFactory.getRuntime().getConnectionMonitor();
        if (monitor != null) {
            monitor.internalRegisterConnection(groupName, conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void internalUnregisterConnection(String groupName, AbstractConnection conn) {
        boolean removed = false;
        List<AbstractConnection> group = null;
        Class<ConnectionMonitor> clazz = ConnectionMonitor.class;
        synchronized (ConnectionMonitor.class) {
            group = this.externalGroups.get(groupName);
            if (group != null) {
                removed = group.remove(conn);
                if (group.isEmpty()) {
                    this.externalGroups.remove(groupName);
                }
            }
            // ** MonitorExit[var5_5] (shouldn't be in output)
            if (!removed & Trace.isOn(4)) {
                StringBuilder sb = new StringBuilder(200);
                sb.append("[JCoAPI] ConnectionMonitor unable to unregister the client ");
                sb.append(System.identityHashCode(conn)).append(" by the group ").append(groupName);
                sb.append(", because the ").append(group == null ? "client" : "group").append(" is not available");
                Trace.fireTrace(4, sb.toString());
            }
            return;
        }
    }

    public static void unregisterConnection(String groupName, AbstractConnection conn) {
        ConnectionMonitor monitor = JCoRuntimeFactory.getRuntime().getConnectionMonitor();
        if (monitor != null) {
            monitor.internalUnregisterConnection(groupName, conn);
        }
    }
}

