/*
 * Decompiled with CFR 0.152.
 */
package com.sap.conn.jco.rt;

import com.sap.conn.jco.JCoBackgroundUnitAttributes;
import com.sap.conn.jco.JCoDestination;
import com.sap.conn.jco.JCoException;
import com.sap.conn.jco.JCoFunction;
import com.sap.conn.jco.JCoFunctionUnit;
import com.sap.conn.jco.JCoRuntimeException;
import com.sap.conn.jco.JCoUnitIdentifier;
import com.sap.conn.jco.rt.InternalDestination;
import com.sap.conn.jco.util.Codecs;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class AbapFunctionUnit
implements JCoFunctionUnit {
    private boolean editable = true;
    List<JCoFunction> functionList = new ArrayList<JCoFunction>();
    Set<String> queueSet = new HashSet<String>();
    byte[] guid;
    int partnerRelease;
    JCoBackgroundUnitAttributes unitAttributes;
    UnitIdentifier unitIdentifier;

    AbapFunctionUnit(JCoBackgroundUnitAttributes unitAttributes) {
        this.unitAttributes = unitAttributes;
    }

    void check() throws JCoRuntimeException {
        if (!this.editable) {
            throw new JCoRuntimeException(136, "JCO_ERROR_ILLEGAL_STATE", "Unit cannot be changed after commit");
        }
    }

    void checkQueueName(String queueName) {
        boolean valid;
        boolean bl = valid = queueName.length() > 0;
        if (valid) {
            valid = Character.getType(queueName.charAt(0)) == 1;
        }
        for (int i = 1; i < queueName.length() && valid; ++i) {
            char c = queueName.charAt(i);
            int cType = Character.getType(c);
            valid = cType == 1 || cType == 9 || c == '_';
        }
        if (!valid) {
            throw new JCoRuntimeException(131, "JCO_ERROR_ILLEGAL_ARGUMENT", "Queue name " + queueName + " is not allowed. Only queue names matching [A-Z]([A-Z]|[0-9])* are allowed.");
        }
    }

    void lock() {
        this.editable = false;
    }

    void setID(byte[] id) {
        this.guid = id;
        this.unitIdentifier = null;
    }

    @Override
    public void addFunction(JCoFunction function) {
        this.check();
        this.functionList.add(function);
    }

    @Override
    public void addFunctions(List<JCoFunction> functions) {
        this.check();
        this.functionList.addAll(functions);
    }

    @Override
    public List<JCoFunction> getFunctions() {
        return Collections.unmodifiableList(this.functionList);
    }

    @Override
    public Set<String> getQueueNames() {
        return Collections.unmodifiableSet(this.queueSet);
    }

    @Override
    public boolean addQueueName(String queueName) {
        this.check();
        if (queueName == null) {
            return false;
        }
        this.checkQueueName(queueName);
        if (this.queueSet.isEmpty()) {
            this.unitIdentifier = null;
        }
        return this.queueSet.add(queueName);
    }

    @Override
    public boolean addQueueNames(Set<String> queueNames) {
        this.check();
        if (queueNames == null) {
            return false;
        }
        for (String queueName : queueNames) {
            this.checkQueueName(queueName);
        }
        if (this.queueSet.isEmpty()) {
            this.unitIdentifier = null;
        }
        return this.queueSet.addAll(queueNames);
    }

    @Override
    public UnitIdentifier getIdentifier() {
        if (this.unitIdentifier == null) {
            this.unitIdentifier = new UnitIdentifier(this);
        }
        return this.unitIdentifier;
    }

    public String toString() {
        boolean first;
        StringBuilder buf = new StringBuilder();
        buf.append("Function unit: id=").append(Codecs.Hex.encode(this.guid));
        if (this.queueSet != null) {
            buf.append(", queues=[");
            first = true;
            for (String queue : this.queueSet) {
                if (!first) {
                    buf.append(", ");
                } else {
                    first = false;
                }
                buf.append(queue);
            }
            buf.append("]");
        }
        buf.append(", functions=[");
        first = true;
        for (JCoFunction f : this.functionList) {
            if (!first) {
                buf.append(", ");
            } else {
                first = false;
            }
            buf.append(f.getName());
        }
        buf.append("]");
        return buf.toString();
    }

    @Override
    public void commit(JCoDestination destination) throws JCoException {
        if (destination == null) {
            throw new JCoException(131, "JCO_ERROR_ILLEGAL_ARGUMENT", "Destination equals null is not allowed.");
        }
        this.lock();
        try {
            ((InternalDestination)destination).execute(this);
        }
        catch (ClassCastException cce) {
            throw new JCoException(131, "JCO_ERROR_ILLEGAL_ARGUMENT", "Only destination instatnce created by JCoDestinationManager are allowed. [" + destination.getClass().getName() + "]");
        }
    }

    static class UnitIdentifier
    implements JCoUnitIdentifier {
        static final long serialVersionUID = 1L;
        private byte[] id;
        private JCoUnitIdentifier.Type type;

        UnitIdentifier(AbapFunctionUnit unit) {
            this.id = unit.guid;
            this.type = unit.queueSet.isEmpty() ? JCoUnitIdentifier.Type.TYPE_T : JCoUnitIdentifier.Type.TYPE_Q;
        }

        UnitIdentifier() {
        }

        void update(byte[] uid, JCoUnitIdentifier.Type utype) {
            this.id = uid;
            this.type = utype;
        }

        public String getID() {
            return Codecs.Hex.encode(this.id);
        }

        public byte[] getIDAsBytes() {
            return this.id;
        }

        public JCoUnitIdentifier.Type getType() {
            return this.type;
        }

        public boolean equals(Object obj) {
            if (obj instanceof UnitIdentifier) {
                UnitIdentifier uID = (UnitIdentifier)obj;
                return uID.type == this.type && uID.id.length == this.id.length && Arrays.equals(uID.id, this.id);
            }
            return super.equals(obj);
        }

        public int hashCode() {
            int key = Arrays.hashCode(this.id) & 0xFFFFFFF;
            key = this.type == JCoUnitIdentifier.Type.TYPE_Q ? (key |= 0xB000000) : (this.type == JCoUnitIdentifier.Type.TYPE_T ? (key |= 0xA000000) : (key |= 0xF000000));
            return key;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder(40);
            sb.append(this.getType() == JCoUnitIdentifier.Type.TYPE_T ? (char)'T' : 'Q').append('-');
            sb.append(this.getID());
            return sb.toString();
        }
    }
}

