/*
 * Decompiled with CFR 0.152.
 */
package com.sap.conn.jco.ext;

import com.sap.conn.jco.ext.JCoSessionReference;
import com.sap.conn.jco.ext.SessionException;
import com.sap.conn.jco.ext.SessionReferenceProvider;
import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class DefaultSessionReferenceProvider
implements SessionReferenceProvider {
    private ThreadLocal<SessionReference> threadLocalSessionRef = new ThreadLocal();
    private Map<String, SessionReference> activeClientSessions = Collections.synchronizedMap(new HashMap());
    private Map<String, SessionReference> statefulServerSessions = Collections.synchronizedMap(new HashMap());
    private boolean supportsScopes;

    public DefaultSessionReferenceProvider() {
        this(true);
    }

    public DefaultSessionReferenceProvider(boolean supportScopes) {
        this.supportsScopes = supportScopes;
    }

    public JCoSessionReference getCurrentSessionReference(String scopeType) {
        SessionReference ref = this.threadLocalSessionRef.get();
        if (ref == null) {
            ref = new SessionReference(false);
            this.activeClientSessions.put(ref.getID(), ref);
            this.threadLocalSessionRef.set(ref);
        }
        if (scopeType != null && this.supportsScopes) {
            return ref.getScopeSessionReference(scopeType);
        }
        return ref;
    }

    public boolean isSessionAlive(String sessionId) {
        SessionReference ref;
        if (sessionId.charAt(0) == 'S') {
            return true;
        }
        String clientSessionID = sessionId;
        if (sessionId.charAt(sessionId.length() - 1) == ']') {
            clientSessionID = sessionId.substring(0, sessionId.indexOf(58));
        }
        if ((ref = this.activeClientSessions.get(clientSessionID)) != null) {
            if (ref.isAlive()) {
                return true;
            }
            this.activeClientSessions.remove(clientSessionID);
        }
        return false;
    }

    public JCoSessionReference jcoServerSessionStarted() {
        SessionReference ref = this.threadLocalSessionRef.get();
        if (ref != null) {
            if (ref.isClientSession()) {
                this.activeClientSessions.remove(ref.getID());
            } else {
                throw new SessionException(SessionException.Type.CREATE_SESSION, "Session conflict. A new session could not be created within the current thread session '" + ref.getID() + "'.");
            }
        }
        ref = new SessionReference(true);
        this.threadLocalSessionRef.set(ref);
        return ref;
    }

    public void jcoServerSessionPassivated(String sessionID) {
        SessionReference ref = this.threadLocalSessionRef.get();
        if (ref == null) {
            throw new SessionException(SessionException.Type.PASSIVATE_SESSION, "Session not active. The session '" + sessionID + "' could not be passivated within the current thread.");
        }
        if (ref.isClientSession()) {
            throw new SessionException(SessionException.Type.PASSIVATE_SESSION, "Session type mismatch. The session '" + sessionID + "' could not be passivated within the current thread session '" + ref.getID() + "'.");
        }
        if (!ref.getID().equals(sessionID)) {
            throw new SessionException(SessionException.Type.PASSIVATE_SESSION, "Session ID mismatch. The session '" + sessionID + "' could not be passivated within the current thread session '" + ref.getID() + "'.");
        }
        if (!ref.isServerContextStateful()) {
            this.statefulServerSessions.put(ref.getID(), ref);
        }
        ref.passivate();
        this.threadLocalSessionRef.set(null);
    }

    public void jcoServerSessionContinued(String sessionID) {
        SessionReference ref = this.threadLocalSessionRef.get();
        if (ref != null) {
            if (ref.isClientSession()) {
                this.activeClientSessions.remove(ref.getID());
            } else {
                throw new SessionException(SessionException.Type.RESTORE_SESSION, "Session conflict. The passivated session '" + sessionID + "' could not be restored within the current thread session '" + ref.getID() + "'.");
            }
        }
        if ((ref = this.statefulServerSessions.get(sessionID)).isActive()) {
            throw new SessionException(SessionException.Type.RESTORE_SESSION, "Session not found. The passivated session '" + sessionID + "' could not be restored.");
        }
        ref.activate();
        this.threadLocalSessionRef.set(ref);
    }

    public void jcoServerSessionFinished(String sessionID) {
        SessionReference ref = this.threadLocalSessionRef.get();
        if (ref == null) {
            throw new SessionException(SessionException.Type.DESTROY_SESSION, "Session not active. The session '" + sessionID + "' could not be destroyed within the current thread.");
        }
        if (ref.isClientSession()) {
            throw new SessionException(SessionException.Type.DESTROY_SESSION, "Session type mismatch. The session '" + sessionID + "' could not be destroyed within the current thread session '" + ref.getID() + "'.");
        }
        if (!ref.getID().equals(sessionID)) {
            throw new SessionException(SessionException.Type.DESTROY_SESSION, "Session ID mismatch. The session '" + sessionID + "' could not be destroyed within the current thread session '" + ref.getID() + "'.");
        }
        if (ref.isServerContextStateful()) {
            this.statefulServerSessions.remove(ref.getID());
        }
        ref.passivate();
        this.threadLocalSessionRef.set(null);
    }

    static final class ScopeSessionReference
    implements JCoSessionReference {
        private String ID = null;
        private String scopeType = null;
        private SessionReference parentSessionRef = null;
        private boolean inStatefulContext = false;

        ScopeSessionReference(SessionReference parent, String scopeType) {
            String parentSessionID = parent.getID();
            this.ID = new StringBuilder(parentSessionID.length() + scopeType.length() + 3).append(parentSessionID).append(":[").append(scopeType).append(']').toString();
            this.scopeType = scopeType;
            this.parentSessionRef = parent;
        }

        String getScopeType() {
            return this.scopeType;
        }

        public String getID() {
            return this.ID;
        }

        public void contextStarted() {
            this.inStatefulContext = true;
        }

        public void contextFinished() {
            this.inStatefulContext = false;
        }

        public String toString() {
            return new StringBuilder(100).append("Scope Session Reference ").append(this.ID).append(this.inStatefulContext ? " [stateful]" : " [stateless]").toString();
        }
    }

    static class SessionReference
    implements JCoSessionReference {
        private static long clientSessionCounter = 0L;
        private static long serverSessionCounter = 0L;
        private String ID = null;
        private boolean isServerSession = false;
        private boolean isServerContextStateful = false;
        private boolean isClientContextStateful = false;
        private WeakReference<Thread> refToThread = new WeakReference<Thread>(Thread.currentThread());
        private Map<String, ScopeSessionReference> scopeSessionRefs = null;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        SessionReference(boolean serverSession) {
            Class<SessionReference> clazz = SessionReference.class;
            synchronized (SessionReference.class) {
                long counter = serverSession ? ++serverSessionCounter : ++clientSessionCounter;
                // ** MonitorExit[var4_2] (shouldn't be in output)
                this.ID = new StringBuilder(48).append(serverSession ? "Server" : "Client").append('-').append(Thread.currentThread().getId()).append('-').append(counter).toString();
                this.isServerSession = serverSession;
                return;
            }
        }

        ScopeSessionReference getScopeSessionReference(String scopeType) {
            ScopeSessionReference sref = null;
            if (this.scopeSessionRefs == null) {
                this.scopeSessionRefs = new HashMap<String, ScopeSessionReference>(3);
            } else {
                sref = this.scopeSessionRefs.get(scopeType);
            }
            if (sref == null) {
                sref = new ScopeSessionReference(this, scopeType);
                this.scopeSessionRefs.put(scopeType, sref);
            }
            return sref;
        }

        boolean isClientSession() {
            return !this.isServerSession;
        }

        boolean isServerSession() {
            return this.isServerSession;
        }

        boolean isAlive() {
            Thread thread;
            if (this.isServerSession) {
                return true;
            }
            Thread thread2 = thread = this.refToThread != null ? (Thread)this.refToThread.get() : null;
            if (thread != null) {
                return thread.isAlive();
            }
            return false;
        }

        void activate() {
            this.refToThread = new WeakReference<Thread>(Thread.currentThread());
        }

        boolean isActive() {
            return this.refToThread != null;
        }

        void passivate() {
            this.refToThread = null;
            this.isServerContextStateful = true;
        }

        boolean isServerContextStateful() {
            return this.isServerContextStateful;
        }

        public String getID() {
            return this.ID;
        }

        public void contextStarted() {
            this.isClientContextStateful = true;
        }

        public void contextFinished() {
            this.isClientContextStateful = false;
        }

        public String toString() {
            return new StringBuilder(80).append("Session Reference ").append(this.ID).append(this.isClientContextStateful ? " [stateful]" : " [stateless]").toString();
        }
    }
}

