/*
 * Decompiled with CFR 0.152.
 */
package com.sap.conn.jco.rt;

import com.sap.conn.jco.JCoException;
import com.sap.conn.jco.rt.ClientConnection;
import com.sap.conn.jco.rt.ConnectionAttributes;
import com.sap.conn.jco.rt.InternalDestination;
import com.sap.conn.jco.rt.JCoRuntime;
import com.sap.conn.jco.rt.MonitoredConnectionData;
import com.sap.conn.jco.rt.RfcDestinationMonitor;
import com.sap.conn.jco.rt.Trace;
import com.sap.conn.jco.util.ObjectList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ClientFactory {
    protected String destinationId;
    protected String originDestinationId;
    protected ObjectList<ClientConnection> allocated = new ObjectList(10, 10);
    ClientConnection master;
    RfcDestinationMonitor destMonitor = null;
    private int maxUsed;
    protected long maxGetClientTime = 30000L;
    protected long expirationTime = 0L;
    protected long expirationCheckPeriod = 600000L;
    protected ConnectionAttributes attributes = null;
    boolean repositoryFactory;
    protected long lastActiveTimestamp;
    private int delayedTimeout = 0;

    protected ClientFactory(InternalDestination destination, boolean repositoryFactory) {
        this.repositoryFactory = repositoryFactory;
        this.setDestinationID(destination);
        this.originDestinationId = destination.getOriginDestinationID(repositoryFactory);
        this.lastActiveTimestamp = System.currentTimeMillis();
    }

    void updateDestination(InternalDestination destination) {
        this.setDestinationID(destination);
    }

    private void setDestinationID(InternalDestination destination) {
        this.destinationId = this.repositoryFactory ? destination.getRepositoryKey() : destination.getDestinationID();
        RfcDestinationMonitor monitor = this.getDestinationMonitor();
        if (monitor != null) {
            monitor.destinationId = this.destinationId;
        }
    }

    protected abstract void init(InternalDestination var1) throws JCoException;

    public final String getName() {
        return this.destinationId;
    }

    protected abstract int getCapacity();

    abstract void setCapacity(int var1);

    public abstract int getPeakLimit();

    abstract void setPeakLimit(int var1);

    public abstract int getCurrentPoolSize();

    public int getPooledConnectionCount() {
        return 0;
    }

    public final int getMaxUsed() {
        return this.maxUsed;
    }

    protected void setMaxUsed(int currUsed) {
        if (this.maxUsed < currUsed) {
            this.maxUsed = currUsed;
        }
    }

    public final int getNumUsed() {
        return this.allocated.size();
    }

    final long getLastActivityTimestamp() {
        return this.lastActiveTimestamp;
    }

    protected void allocate(ClientConnection client) {
        this.allocated.add(client);
        this.delayedTimeout = 0;
        this.lastActiveTimestamp = System.currentTimeMillis();
    }

    protected void deallocate(ClientConnection client) {
        this.allocated.remove(client);
        this.delayedTimeout = 0;
        this.lastActiveTimestamp = System.currentTimeMillis();
    }

    protected String describeAllocatedClients(ObjectList<ClientConnection> allocatedClients) {
        long now = System.currentTimeMillis();
        StringBuilder buffer = new StringBuilder(100);
        buffer.append("Pool ").append(this.getName());
        buffer.append(" created ").append(this.getNumUsed()).append(" clients").append(JCoRuntime.CRLF);
        for (int i = 0; i < allocatedClients.size(); ++i) {
            ClientConnection c = allocatedClients.get(i);
            if (c == null) continue;
            byte state = c.getState();
            long lastUsed = c.last_active_timestamp;
            long lastCall = c.start_time;
            buffer.append(i + 1);
            buffer.append(" client [").append(c.getConnectionHandle()).append("|").append(c.getConversationID()).append("]");
            if (lastCall > 0L) {
                if ((state & 4) != 0) {
                    buffer.append(" is calling since ");
                } else {
                    buffer.append(" is idle since ").append(now - lastUsed);
                    buffer.append(" ms, since last call ");
                }
                buffer.append(now - lastCall).append(" ms, function ").append(c.rfm_name);
            } else {
                buffer.append(" was allocated, but no calls are performed");
            }
            if (c.getSessionId() == null) {
                buffer.append("[stateless]");
            } else {
                buffer.append("[stateful session id: ").append(c.getSessionId()).append("]");
            }
            buffer.append(JCoRuntime.CRLF);
        }
        return buffer.toString();
    }

    public abstract int getNumWaitingThreads();

    public final void setMaxGetClientTime(long maxGetClientTime) {
        if (Trace.isOn(64)) {
            Trace.fireTrace(64, new StringBuilder(100).append("[JCoAPI] Pool.maxGetClientTime(").append(maxGetClientTime).append(") on pool ").append(this.destinationId).toString());
        }
        if (maxGetClientTime >= 0L) {
            this.maxGetClientTime = maxGetClientTime;
        }
    }

    public final long getMaxWaitTime() {
        return this.maxGetClientTime;
    }

    public final long getExpirationTime() {
        return this.expirationTime;
    }

    public final void setExpirationTime(long expirationTime) {
        if (Trace.isOn(64)) {
            Trace.fireTrace(64, new StringBuilder(100).append("[JCoAPI] Pool.setExpirationTime(").append(expirationTime).append(") on pool ").append(this.destinationId).toString());
        }
        this.expirationTime = expirationTime;
    }

    public final long getExpirationCheckPeriod() {
        return this.expirationCheckPeriod;
    }

    public void setExpirationCheckPeriod(long expirationCheckPeriod) {
        if (Trace.isOn(64)) {
            Trace.fireTrace(64, new StringBuilder(100).append("[JCoAPI] Pool.setExpirationCheckPeriod(").append(expirationCheckPeriod).append(") on pool ").append(this.destinationId).toString());
        }
        if (expirationCheckPeriod < 0L) {
            throw new IllegalArgumentException(new StringBuilder(100).append("timeout_check_period ").append(expirationCheckPeriod).append(" must be greater than or equal to zero.").toString());
        }
        this.expirationCheckPeriod = expirationCheckPeriod;
    }

    protected abstract void clear();

    protected abstract ClientConnection getClient() throws JCoException;

    protected abstract void releaseClient(ClientConnection var1) throws JCoException;

    protected boolean isTimedOut(long now) {
        this.delayedTimeout = now > this.lastActiveTimestamp + this.expirationCheckPeriod + this.expirationTime && this.getNumUsed() == 0 ? ++this.delayedTimeout : 0;
        return this.delayedTimeout == 3;
    }

    protected void setAttributes(ConnectionAttributes attributes) {
        this.attributes = attributes;
    }

    protected ConnectionAttributes getAttributes() {
        return this.attributes;
    }

    protected abstract void detachFromPool(ClientConnection var1) throws JCoException;

    protected abstract void attachToPool(ClientConnection var1, boolean var2) throws JCoException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void getMonitoredData(List<MonitoredConnectionData> monitoredData) {
        Object allocatedCopy;
        ClientConnection clientConnection = this.master;
        synchronized (clientConnection) {
            allocatedCopy = this.allocated.clone();
        }
        ClientConnection conn = (ClientConnection)((ObjectList)allocatedCopy).pop();
        while (conn != null) {
            MonitoredConnectionData md = conn.getMonitoredData();
            monitoredData.add(md);
            conn = (ClientConnection)((ObjectList)allocatedCopy).pop();
        }
    }

    RfcDestinationMonitor getDestinationMonitor() {
        return this.destMonitor;
    }

    void setDestinationMonitor(RfcDestinationMonitor monitor) {
        if (this.destMonitor != monitor) {
            if (this.destMonitor != null) {
                this.removeDestinationMonitor();
            }
            this.destMonitor = monitor;
        }
    }

    void removeDestinationMonitor() {
        RfcDestinationMonitor monitor = this.destMonitor;
        if (monitor != null) {
            monitor.removeClientFactory(this);
            this.destMonitor = null;
        }
    }

    final String getDestinationID() {
        return this.destinationId;
    }

    final String getOriginDestinationID() {
        return this.originDestinationId;
    }
}

