/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.logging;

import com.sap.tc.logging.Location;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;

public class DCMapping {
    public static final String RESET = "RESET";
    private static Properties savedDCSeverity;
    private static Properties dcNamesForReset;
    private static final Location mLoc;

    public static void saveLastDCSeverity(Properties dcSeverity) {
        try {
            mLoc.debugT("Size of dcSeverity is: " + Integer.toString(dcSeverity.size()));
            dcNamesForReset = new Properties();
            if (savedDCSeverity != null) {
                Iterator<Map.Entry<Object, Object>> iter = savedDCSeverity.entrySet().iterator();
                while (iter.hasNext()) {
                    String dc = null;
                    Map.Entry<Object, Object> entry = iter.next();
                    dc = (String)entry.getKey();
                    if (dc == null || dcSeverity.get(dc) != null) continue;
                    mLoc.infoT("DC " + dc + " was added for reset.");
                    dcNamesForReset.put(dc, RESET);
                }
            }
            savedDCSeverity = (Properties)dcSeverity.clone();
            mLoc.debugT("Size of savedDCSeverity is: " + Integer.toString(savedDCSeverity.size()));
        }
        catch (Exception e) {
            mLoc.traceThrowableT(500, "Unexpected error occur.", new Exception());
        }
    }

    public static Properties getDCNamesForReset() {
        return dcNamesForReset;
    }

    public static String dcSeverity(String dcName) {
        if (savedDCSeverity != null) {
            return savedDCSeverity.getProperty(dcName);
        }
        return null;
    }

    static {
        mLoc = Location.getLocation(DCMapping.class.getName(), "tc~logging~java", "BC-JAS-ADM-LOG-API");
    }
}

