/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.logging.reader;

import com.sap.tc.logging.FileLogInfoData;
import com.sap.tc.logging.HelperLib;
import com.sap.tc.logging.interfaces.IFileSetLog;
import com.sap.tc.logging.reader.ReadLog;
import com.sap.tc.logging.reader.ReaderLogger;
import java.io.File;

public abstract class ReadFileSetLog
extends ReadLog
implements IFileSetLog {
    private static String strLoc = "ReadFileSetLog";
    private static final int MODE_MIN = 0;
    public static final int MODE_SINGLE_FILE = 1;
    public static final int MODE_FILE_SET = 2;
    private static final int MODE_MAX = 3;
    private String fileName;
    private int fsSize;
    private int fsLimit;
    private int fsIndex;
    private boolean isInFileSet = false;

    public ReadFileSetLog(String fileName) {
        this.fileName = fileName;
        String tmpFileSet = this.checkForFile(fileName);
        try {
            FileLogInfoData fileHeader = new FileLogInfoData(tmpFileSet);
            this.fsSize = fileHeader.getFileSetSize();
            this.fsLimit = fileHeader.getFileSetLimit();
            this.setPattern(fileName);
            if (!fileName.equalsIgnoreCase(tmpFileSet)) {
                this.moveToEOFS();
                this.setMode(2);
            } else {
                this.setSource(HelperLib.expandPattern(this.getPattern(), 0, false, false));
            }
        }
        catch (Exception ex) {
            ReaderLogger.logIntByAPI(400, ReaderLogger.ReaderLocation, strLoc, (Object)"ASJ.log_api.000017", "Unexcepted error occured on {0}!", (Object[])new String[]{fileName});
            ReaderLogger.catchingIntByAPI(ex);
        }
    }

    public ReadFileSetLog(String fileName, int size, int limit) {
        this.fileName = fileName;
        this.fsSize = size;
        this.fsLimit = limit;
        this.isInFileSet = this.fsSize > 0;
        this.setPattern(fileName);
        if (this.isInFileSet()) {
            this.moveToEOFS();
            this.setMode(2);
        } else {
            this.setSource(HelperLib.expandPattern(this.getPattern(), 0, false, false));
        }
    }

    public synchronized File getFile() {
        return new File(this.expandPattern());
    }

    public synchronized File getFile(int index) {
        if (index < 0 || index >= this.getSize()) {
            return this.getFile();
        }
        return new File(this.expandPattern(index));
    }

    public File getFileLatest() {
        return new File(this.expandPattern(this.findEndIndex()));
    }

    public File getFilePrime() {
        return new File(this.expandPattern(this.findStartIndex()));
    }

    public synchronized int getIndex() {
        return this.fsIndex;
    }

    public synchronized void setIndex(int value) {
        this.fsIndex = value;
        this.setSource(this.expandPattern());
    }

    public synchronized void setLimit(int value) {
        this.fsLimit = value;
    }

    public synchronized int getLimit() {
        return this.fsLimit;
    }

    public synchronized void setSize(int value) {
        this.fsSize = value;
    }

    public synchronized int getSize() {
        return this.fsSize;
    }

    public synchronized boolean isInFileSet() {
        return this.isInFileSet;
    }

    public boolean isInFileSetMode() {
        return this.getMode() == 2;
    }

    public boolean isInSingleFileMode() {
        return this.getMode() == 1;
    }

    public synchronized void moveToBOFS() {
        this.setIndex(this.findStartIndex());
    }

    public synchronized void moveToEOFS() {
        this.setIndex(this.findEndIndex());
    }

    public synchronized void next() {
        if (!this.isEnd() && this.isInFileSetMode()) {
            this.setIndex(this.findNextIndex());
        }
    }

    public synchronized void previous() {
        if (!this.isStart() && this.isInFileSetMode()) {
            this.setIndex(this.findPreviousIndex());
        }
    }

    private int findNextIndex() {
        int tmpIndex = this.getIndex() + 1;
        if (tmpIndex == this.getSize()) {
            return 0;
        }
        return tmpIndex;
    }

    private int findPreviousIndex() {
        int tmpIndex = this.getIndex() - 1;
        if (tmpIndex < 0) {
            return this.getSize() - 1;
        }
        return tmpIndex;
    }

    private int findStartIndex() {
        int oldestIndex = this.getIndex();
        if (this.isInFileSet()) {
            long oldestDate = Long.MAX_VALUE;
            File file = null;
            for (int i = this.getSize() - 1; i >= 0; --i) {
                file = new File(this.expandPattern(i));
                if (!file.exists()) continue;
                if (file.lastModified() > oldestDate) break;
                oldestDate = file.lastModified();
                oldestIndex = i;
            }
        }
        return oldestIndex;
    }

    private int findEndIndex() {
        int latestIndex = this.getIndex();
        if (this.isInFileSet()) {
            long latestDate = 0L;
            File file = null;
            for (int i = 0; i < this.getSize(); ++i) {
                file = new File(this.expandPattern(i));
                if (!file.exists()) continue;
                if (file.lastModified() < latestDate) break;
                latestDate = file.lastModified();
                latestIndex = i;
            }
        }
        return latestIndex;
    }

    public boolean isStart() {
        return this.getIndex() == this.findStartIndex();
    }

    public boolean isEnd() {
        return this.getIndex() == this.findEndIndex();
    }

    private String checkForFile(String fileName) {
        String tmpFileName = fileName;
        boolean isFileExists = false;
        File file = new File(fileName);
        isFileExists = file.exists();
        if (!isFileExists) {
            for (int i = 0; i < 10; ++i) {
                tmpFileName = this.expandPattern(fileName, i);
                file = new File(tmpFileName);
                isFileExists = file.exists();
                if (!isFileExists) continue;
                this.isInFileSet = true;
                break;
            }
        }
        if (!isFileExists) {
            tmpFileName = fileName;
        }
        return tmpFileName;
    }

    private String expandPattern() {
        return HelperLib.expandPattern(this.fileName, this.fsIndex, this.isInFileSet, false);
    }

    private String expandPattern(String fileName, int index) {
        return HelperLib.expandPattern(fileName, index, true, false);
    }

    private String expandPattern(int index) {
        return HelperLib.expandPattern(this.fileName, index, this.isInFileSet, false);
    }

    private String expandPattern(int fileIndex, boolean onlyNewFormat) {
        return HelperLib.expandPattern(this.fileName, this.fsIndex, this.isInFileSet, onlyNewFormat);
    }
}

