/*
 * Decompiled with CFR 0.152.
 */
package com.sap.conn.jco.rt;

import com.sap.conn.jco.JCoBackgroundUnitAttributes;
import com.sap.conn.jco.JCoRuntimeException;

public class AbapBackgroundUnitAttributes
implements JCoBackgroundUnitAttributes {
    private String client;
    private String userID;
    private String programName;
    private boolean commitCheckOn;
    private boolean kernelTraceOn;
    private boolean unitHistoryOn;
    private boolean lockOn;
    private boolean readOnly = false;

    void lock() {
        this.readOnly = true;
    }

    private void checkWriteAccess() {
        if (this.readOnly) {
            throw new JCoRuntimeException(136, "JCO_ERROR_ILLEGAL_STATE", "The function unit attributes have been set by the ABAP client and cannot be modified");
        }
    }

    public String getClient() {
        return this.client;
    }

    public String getProgramName() {
        return this.programName;
    }

    public String getUserID() {
        return this.userID;
    }

    public boolean isCommitCheckOn() {
        return this.commitCheckOn;
    }

    public boolean isKernelTraceOn() {
        return this.kernelTraceOn;
    }

    public boolean isUnitHistoryOn() {
        return this.unitHistoryOn;
    }

    public boolean isUnitLocked() {
        return this.lockOn;
    }

    public void setClient(String client) {
        this.checkWriteAccess();
        this.client = client;
    }

    public void setCommitCheckOn(boolean checkOn) {
        this.checkWriteAccess();
        this.commitCheckOn = checkOn;
    }

    public void setKernelTrace(boolean traceOn) {
        this.checkWriteAccess();
        this.kernelTraceOn = traceOn;
    }

    public void setLock(boolean lock) {
        this.checkWriteAccess();
        this.lockOn = lock;
    }

    public void setProgramName(String programName) {
        this.checkWriteAccess();
        this.programName = programName;
    }

    public void setUnitHistory(boolean historyOn) {
        this.checkWriteAccess();
        this.unitHistoryOn = historyOn;
    }

    public void setUser(String userID) {
        this.checkWriteAccess();
        this.userID = userID;
    }
}

