/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.logging;

import com.sap.tc.logging.APILogger;
import com.sap.tc.logging.ExceptionHandling;
import com.sap.tc.logging.ExceptionManager;
import com.sap.tc.logging.GUId;
import com.sap.tc.logging.Group;
import com.sap.tc.logging.ILogRecordFull;
import com.sap.tc.logging.Location;
import com.sap.tc.logging.LogController;
import com.sap.tc.logging.LoggingManager;
import com.sap.tc.logging.interfaces.IRPPublisher;
import com.sap.tc.logging.messagedepot.LocalizedMessage;
import com.sap.tc.logging.messagedepot.MessageAccessor;
import com.sap.tc.logging.messagedepot.MessageID;
import java.io.Serializable;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Locale;

public class LogRecord
extends ExceptionHandling
implements Serializable,
ILogRecordFull {
    private static Location classLoc = Location.getLocation(LogRecord.class.getName(), "tc~logging~java", "BC-JAS-ADM-LOG-API");
    static String version = "$Id:$";
    static final Locale STANDARD_LOCALE = Locale.US;
    static final String NULL_STRING = "<null>";
    private static final DateFormat timeFormatter = DateFormat.getDateTimeInstance(2, 2, Locale.US);
    private static final String EMPTY_STRING = "";
    private static final String EXCEPTION_POINTER = " \n[EXCEPTION]\n ";
    private static volatile long lastTimeInSeconds = 0L;
    private static volatile String lastTimeString = null;
    private static IRPPublisher rpPublisher;
    private GUId id;
    private int lrSize;
    private long lrBookMark = -1L;
    private String lrLogName;
    private Date time;
    private Date timeOfTracing = new Date(0L);
    private Date timeOfCreation = new Date(0L);
    private String timeZone;
    private String thrName;
    private String[] args;
    private Object[] argsObj;
    private int nonExceptionArgsCount = 0;
    private int severity;
    private String sourceName;
    private String locationName;
    private String[] relatives;
    private String application;
    private String user;
    private String session;
    private String transaction;
    private String dsrTransactionID;
    private String dsrRootContextID;
    private String dsrConnection;
    private int dsrCounter = -1;
    private long correlatorID = -1L;
    private String sysName;
    private String sysInstanceName;
    private String sysHostName;
    private String sysNodeID;
    private int msgType = 0;
    private String msgCode;
    private String msgAlias;
    protected String resourceBundleName;
    protected String msgClear;
    protected String msgDefault;
    protected String msgLocalized;
    private Throwable msgException;
    String csnComponent;
    String dcName;
    private boolean internalThread = false;

    LogRecord(LogController source, String loc, int severity, String[] relatives, int msgType, String msg, String[] args) {
        this(source, loc, Thread.currentThread(), severity, relatives, msgType, null, null, msg, args, null);
    }

    protected LogRecord(LogController source, String locName, int severity, String[] relatives, int msgType, Object msgCode, String resourceBundleName, String msgClear, String[] args) {
        this(source, locName, Thread.currentThread(), severity, relatives, msgType, msgCode, resourceBundleName, msgClear, args, null);
    }

    protected LogRecord(LogController source, String locName, Thread thr, int severity, String[] relatives, int msgType, Object msgCode, String resourceBundleName, String msgClear, String[] args, String csnComponent) {
        this.setRuntimeProperties();
        this.setThreadRuntimeProperties();
        this.id = new GUId();
        this.time = new Date();
        this.timeOfCreation = new Date(this.time.getTime());
        if (source != null) {
            this.sourceName = source.getName();
        }
        this.locationName = locName;
        this.thrName = thr.toString();
        this.relatives = relatives;
        this.severity = severity;
        this.args = args;
        if (args != null) {
            this.nonExceptionArgsCount = args.length;
        }
        this.msgType = msgType;
        this.msgDefault = msgClear;
        this.msgClear = msgClear;
        this.csnComponent = csnComponent;
        if (msgCode != null) {
            this.msgCode = msgCode.toString();
        }
    }

    protected LogRecord(String msgId, String correlationID, int size, Date time, String timeZone, String source, int severity, String loc, String[] relatives, String thr, int msgType, String msgCode, String msgAlias, String resourceBundleName, String msgClear, Object[] args, String application, String user, String session, String transaction, String dsrTransaction, String dsrRootContextID, String dsrConnection, int dsrCounter, MessageAccessor msgAccessor, String csnComponent, String dcName) {
        this.id = new GUId(msgId);
        try {
            this.correlatorID = Long.parseLong(correlationID);
        }
        catch (NumberFormatException e) {
            this.correlatorID = -1L;
        }
        this.lrSize = size;
        this.internalThread = true;
        this.time = time;
        this.timeZone = timeZone;
        this.sourceName = source;
        this.severity = severity;
        this.locationName = loc;
        this.relatives = relatives;
        this.thrName = thr;
        this.msgType = msgType;
        this.msgCode = msgCode;
        this.msgAlias = msgAlias;
        this.resourceBundleName = resourceBundleName;
        this.args = LogRecord.getArgStrsInt(args);
        this.argsObj = args;
        if (args != null) {
            this.nonExceptionArgsCount = args.length;
        }
        this.application = application;
        this.user = user;
        this.session = session;
        this.transaction = transaction;
        this.dsrTransactionID = dsrTransaction;
        this.dsrRootContextID = dsrRootContextID;
        this.dsrConnection = dsrConnection;
        this.dsrCounter = dsrCounter;
        this.msgDefault = msgClear;
        this.msgClear = msgClear;
        this.csnComponent = csnComponent;
        this.dcName = dcName;
        if (msgAccessor != null && msgCode != null) {
            try {
                LocalizedMessage locMessage = msgAccessor.getLocalizedMessage(new MessageID(msgCode));
                if (locMessage != null) {
                    this.msgClear = this.msgLocalized = locMessage.getLongText();
                } else {
                    this.msgLocalized = null;
                    this.msgClear = msgClear;
                }
            }
            catch (Exception ex) {
                this.msgLocalized = null;
                this.msgClear = msgClear;
            }
        }
    }

    protected LogRecord(String msgId, Date time, String source, int severity, String loc, String[] relatives, String groupId, int level, int indent, String thr, int msgType, String msgCode, String resourceBundleName, String msgClear, Object[] args, String application, String user, String session, String transaction, String dsrTransaction, String dsrRootContextID, String dsrConnection, int dsrCounter) {
        this.id = new GUId(msgId);
        this.internalThread = true;
        this.time = time;
        this.sourceName = source;
        this.severity = severity;
        this.locationName = loc;
        this.relatives = relatives;
        this.thrName = thr;
        this.msgType = msgType;
        this.msgCode = msgCode;
        this.resourceBundleName = resourceBundleName;
        this.msgClear = msgClear;
        this.args = LogRecord.getArgStrsInt(args);
        this.argsObj = args;
        if (args != null) {
            this.nonExceptionArgsCount = args.length;
        }
        this.application = application;
        this.user = user;
        this.session = session;
        this.transaction = transaction;
        this.dsrTransactionID = dsrTransaction;
        this.dsrRootContextID = dsrRootContextID;
        this.dsrConnection = dsrConnection;
        this.dsrCounter = dsrCounter;
    }

    LogRecord(LogController source, String loc, int severity, String[] relatives, int msgType, String msg, Object[] args, Throwable msgException) {
        this(source, loc, severity, relatives, msgType, msg, LogRecord.getArgStrsInt(args));
        this.argsObj = args;
        this.msgException = msgException;
        this.buildException(source);
    }

    LogRecord(LogController source, String loc, int severity, String[] relatives, int msgType, String msg, Object[] args) {
        this(source, loc, severity, relatives, msgType, msg, LogRecord.getArgStrsInt(args));
        this.argsObj = args;
    }

    protected LogRecord(LogController source, String locName, int severity, String[] relatives, int msgType, Object msgCode, String resourceBundleName, String msgClear, Object[] args, Throwable msgExc) {
        this(source, locName, severity, relatives, msgType, msgCode, resourceBundleName, msgClear, args, msgExc, null);
    }

    protected LogRecord(LogController source, String locName, int severity, String[] relatives, int msgType, Object msgCode, String resourceBundleName, String msgClear, Object[] args, Throwable msgExc, String csnComponent) {
        this(source, locName, Thread.currentThread(), severity, relatives, msgType, msgCode, resourceBundleName, msgClear, LogRecord.getArgStrsInt(args), csnComponent);
        this.argsObj = args;
        this.msgException = msgExc;
        this.buildException(source);
    }

    protected LogRecord(LogController source, String locName, int severity, String[] relatives, int msgType, Object msgCode, String resourceBundleName, String msgClear, Object[] args) {
        this(source, locName, Thread.currentThread(), severity, relatives, msgType, msgCode, resourceBundleName, msgClear, LogRecord.getArgStrsInt(args), null);
        this.argsObj = args;
    }

    protected LogRecord(LogController source, String locName, Thread thr, int severity, String[] relatives, int msgType, Object msgCode, String resourceBundleName, String msgClear, Object[] args) {
        this(source, locName, thr, severity, relatives, msgType, msgCode, resourceBundleName, msgClear, LogRecord.getArgStrsInt(args), null);
        this.argsObj = args;
    }

    protected LogRecord(String msgId, Date time, String source, int severity, String loc, LogController[] relatives, String groupId, int level, int indent, String thr, int msgType, String msgCode, String resourceBundleName, String msgClear, String[] args, String application, String user, String session, String transaction) {
        this(msgId, time, source, severity, loc, LogRecord.convertRelatives(relatives), groupId, level, indent, thr, msgType, msgCode, resourceBundleName, msgClear, args, application, user, session, transaction, EMPTY_STRING, EMPTY_STRING, EMPTY_STRING, 0);
    }

    protected LogRecord(LogController source, String locName, Thread thr, int severity, LogController[] relatives, int msgType, Object msgCode, String resourceBundleName, String msgClear, Object[] args) {
        this(source, locName, thr, severity, LogRecord.convertRelatives(relatives), msgType, msgCode, resourceBundleName, msgClear, LogRecord.getArgStrsInt(args));
        this.argsObj = args;
    }

    public GUId getId() {
        return this.id;
    }

    public int getSize() {
        return this.lrSize;
    }

    public boolean isThreadInternal() {
        return this.internalThread;
    }

    public void setThreadInternal(boolean b) {
        this.internalThread = b;
    }

    public Date getTime() {
        if (this.internalThread) {
            return this.time;
        }
        return this.refreshTime(new Date(System.currentTimeMillis()));
    }

    public Date refreshTime(Date timeStamp) {
        if (this.time.before(timeStamp)) {
            this.time = timeStamp;
        }
        return this.time;
    }

    public Date getTimeOfCreation() {
        return this.timeOfCreation;
    }

    public Date getTimeOfTracing() {
        return this.timeOfTracing;
    }

    protected void setTimeOfTracing() {
        this.timeOfTracing = new Date(this.time.getTime());
    }

    public String getTimeZone() {
        int num;
        if (this.timeZone != null) {
            return this.timeZone;
        }
        GregorianCalendar c = new GregorianCalendar();
        c.setTime(this.time);
        StringBuilder sb = new StringBuilder(5);
        int value = (c.get(15) + c.get(16)) / 60000;
        if (value >= 0) {
            sb.append('+');
        }
        sb.append((num = value / 60 * 100 + value % 60) < 1000 ? "0" + num : Integer.valueOf(num));
        this.timeZone = sb.toString();
        return this.timeZone;
    }

    public String getApplication() {
        if (this.application != null) {
            return this.application;
        }
        return EMPTY_STRING;
    }

    public void setApplication(String value) {
        this.application = value;
    }

    public String getUser() {
        if (this.user != null) {
            return this.user;
        }
        return EMPTY_STRING;
    }

    public void setUser(String value) {
        this.user = value;
    }

    public String getSession() {
        if (this.session != null) {
            return this.session;
        }
        return EMPTY_STRING;
    }

    public void setSession(String value) {
        this.session = value;
    }

    public void setSourceName(String source) {
        this.sourceName = source;
    }

    public String getTransaction() {
        if (this.transaction != null) {
            return this.transaction;
        }
        return EMPTY_STRING;
    }

    public void setTransaction(String value) {
        this.transaction = value;
    }

    public String getDsrComponent() {
        return EMPTY_STRING;
    }

    public void setDsrComponent(String value) {
    }

    public String getDsrUser() {
        return EMPTY_STRING;
    }

    public void setDsrUser(String value) {
    }

    public String getDsrTransaction() {
        return EMPTY_STRING;
    }

    public void setDsrTransaction(String value) {
    }

    public String getDSRRootContextID() {
        if (this.dsrRootContextID != null) {
            return this.dsrRootContextID;
        }
        return EMPTY_STRING;
    }

    public void setDSRRootContextID(String value) {
        this.dsrRootContextID = value;
    }

    public String getDSRConnection() {
        if (this.dsrConnection != null) {
            return this.dsrConnection;
        }
        return EMPTY_STRING;
    }

    public void setDSRConnection(String value) {
        this.dsrConnection = value;
    }

    public int getDSRCounter() {
        return this.dsrCounter;
    }

    public void setDSRCounter(int value) {
        this.dsrCounter = value;
    }

    public String getDSRTransactionID() {
        if (this.dsrTransactionID != null) {
            return this.dsrTransactionID;
        }
        return EMPTY_STRING;
    }

    public void setDSRTransactionID(String value) {
        this.dsrTransactionID = value;
    }

    public long getCorrelatorID() {
        return this.correlatorID;
    }

    public void setCorrelatorID(long value) {
        this.correlatorID = value;
    }

    public String getSysHostName() {
        if (this.sysHostName != null) {
            return this.sysHostName;
        }
        return EMPTY_STRING;
    }

    public void setSysHostName(String value) {
        this.sysHostName = value;
    }

    public String getSysInstanceName() {
        if (this.sysInstanceName != null) {
            return this.sysInstanceName;
        }
        return EMPTY_STRING;
    }

    public void setSysInstanceName(String value) {
        this.sysInstanceName = value;
    }

    public String getSysName() {
        if (this.sysName != null) {
            return this.sysName;
        }
        return EMPTY_STRING;
    }

    public void setSysName(String value) {
        this.sysName = value;
    }

    public String getSysNodeID() {
        if (this.sysNodeID != null) {
            return this.sysNodeID;
        }
        return EMPTY_STRING;
    }

    public void setSysNodeID(String value) {
        this.sysNodeID = value;
    }

    public boolean isGroupActive() {
        return false;
    }

    public List getGroups() {
        return Collections.EMPTY_LIST;
    }

    public Group getGroup() {
        return null;
    }

    public GUId getGroupId() {
        return null;
    }

    public String getGroupID() {
        return EMPTY_STRING;
    }

    public String getSourceName() {
        if (this.sourceName != null) {
            return this.sourceName;
        }
        return EMPTY_STRING;
    }

    public String getLocationName() {
        if (this.locationName != null) {
            return this.locationName;
        }
        return EMPTY_STRING;
    }

    public String getGroupName() {
        return EMPTY_STRING;
    }

    public String getGroupDescription() {
        return EMPTY_STRING;
    }

    public int getGroupIndent() {
        return -1;
    }

    public int getGroupLevel() {
        return -1;
    }

    public String getThreadName() {
        if (this.thrName != null) {
            return this.thrName;
        }
        return EMPTY_STRING;
    }

    public int getSeverity() {
        return this.severity;
    }

    public int getMsgType() {
        return this.msgType;
    }

    public String getMsgCode() {
        if (this.msgCode != null) {
            return this.msgCode;
        }
        return EMPTY_STRING;
    }

    public String getCsnComponent() {
        if (this.csnComponent != null) {
            return this.csnComponent;
        }
        return EMPTY_STRING;
    }

    public String getDCName() {
        if (this.dcName != null) {
            return this.dcName;
        }
        return EMPTY_STRING;
    }

    public String getMsgAlias() {
        if (this.msgAlias != null) {
            return this.msgAlias;
        }
        return EMPTY_STRING;
    }

    public String getResourceBundleName() {
        if (this.resourceBundleName != null) {
            return this.resourceBundleName;
        }
        return EMPTY_STRING;
    }

    public String getMessage() {
        if (this.msgType == 1) {
            return LogController.replaceArguments(this.getMsgClear(), this.getArgsInt());
        }
        return this.msgClear;
    }

    public String getMsgClear() {
        if (this.msgClear != null) {
            return this.msgClear;
        }
        return EMPTY_STRING;
    }

    public String getMsgDefault() {
        if (this.msgDefault != null) {
            return this.msgDefault;
        }
        return EMPTY_STRING;
    }

    public String getMsgLocalized() {
        if (this.msgLocalized != null) {
            return this.msgLocalized;
        }
        return EMPTY_STRING;
    }

    public Throwable getMsgException() {
        return this.msgException;
    }

    public List getArgs() {
        if (this.args != null) {
            return Collections.unmodifiableList(new ArrayList<String>(Arrays.asList(this.args)));
        }
        return Collections.EMPTY_LIST;
    }

    public List getArgObjs() {
        if (this.argsObj != null) {
            return Collections.unmodifiableList(new ArrayList<Object>(Arrays.asList(this.argsObj)));
        }
        return Collections.EMPTY_LIST;
    }

    public int getNonExceptionArgsCount() {
        return this.nonExceptionArgsCount;
    }

    public Collection getRelatives() {
        if (this.relatives != null) {
            return Collections.unmodifiableCollection(new ArrayList<String>(Arrays.asList(this.relatives)));
        }
        return Collections.EMPTY_LIST;
    }

    public boolean equals(Object obj) {
        if (obj instanceof LogRecord) {
            return this.id.equals(((LogRecord)obj).id);
        }
        return false;
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public void setBookMark(long value) {
        this.lrBookMark = value;
    }

    public long getBookMark() {
        return this.lrBookMark;
    }

    public String getLogName() {
        return this.lrLogName;
    }

    public void setLogName(String value) {
        this.lrLogName = value;
    }

    String getTimeString() {
        return LogRecord.formatTime(this.time);
    }

    String[] getRelativesInt() {
        return this.relatives;
    }

    static String[] getArgStrsInt(Object[] argsLikeObjects) {
        String[] argStrs = null;
        if (argsLikeObjects != null) {
            argStrs = new String[argsLikeObjects.length];
            for (int i = 0; i < argsLikeObjects.length; ++i) {
                if (argsLikeObjects[i] != null) {
                    try {
                        argStrs[i] = argsLikeObjects[i].toString();
                    }
                    catch (Exception ex) {
                        APILogger.logIntByAPI(400, classLoc, "[getArgStrsInt()]", "ASJ.log_api.000051", "Message argument error! Invocation of Object.toString() failed", null);
                        APILogger.catchingIntByAPI(ex);
                        argStrs[i] = NULL_STRING;
                    }
                    continue;
                }
                argStrs[i] = NULL_STRING;
            }
        }
        return argStrs;
    }

    static String formatTime(Date time) {
        long thisTimeInSeconds = time.getTime() / 1000L;
        if (lastTimeInSeconds != thisTimeInSeconds) {
            lastTimeString = timeFormatter.format(time);
            lastTimeInSeconds = thisTimeInSeconds;
        }
        return lastTimeString;
    }

    void setGroupID(String value) {
    }

    void setGroupName(String value) {
    }

    void setGroupDescription(String value) {
    }

    void setGroupIndent(int value) {
    }

    void setGroupLevel(int value) {
    }

    Object[] getArgsInt() {
        return this.args;
    }

    private static String[] convertRelatives(LogController[] relatives) {
        String[] tmpValues = null;
        if (relatives != null) {
            tmpValues = new String[relatives.length];
            for (int i = 0; i < relatives.length; ++i) {
                tmpValues[i] = relatives[i].getName();
            }
        }
        return tmpValues;
    }

    private void setThreadRuntimeProperties() {
        if (LoggingManager.threadInfoProvider != null) {
            this.correlatorID = LoggingManager.threadInfoProvider.getCorrelationID();
            this.dsrTransactionID = LoggingManager.threadInfoProvider.getDsrTransactionID();
        }
    }

    private void setRuntimeProperties() {
        try {
            if (rpPublisher == null) {
                rpPublisher = LoggingManager.getRuntimePropertiesPublisher();
            }
            if (rpPublisher != null) {
                rpPublisher.reInitProperties(this);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private LogController[] copyRelatives(LogController[] relatives) {
        if (relatives != null) {
            LogController[] tmpRelatives = null;
            int relativesCnt = 0;
            for (int i = 0; i < relatives.length; ++i) {
                if (relatives[i] == null) continue;
                ++relativesCnt;
            }
            if (relativesCnt > 0) {
                int j = 0;
                tmpRelatives = new LogController[relativesCnt];
                for (int i = 0; i < relatives.length; ++i) {
                    if (relatives[i] == null) continue;
                    tmpRelatives[j] = relatives[i];
                    ++j;
                }
            }
            return tmpRelatives;
        }
        return null;
    }

    private String getNewMsg(String msg, int argsLength) {
        return msg + EXCEPTION_POINTER + "{" + (argsLength - 1) + "}";
    }

    private Object[] getNewArgs(Object[] args, Throwable exc) {
        Object[] tmpArgs = args;
        if (args != null) {
            tmpArgs = new Object[args.length + 1];
            for (int i = 0; i < args.length; ++i) {
                tmpArgs[i] = args[i];
            }
            tmpArgs[tmpArgs.length - 1] = ExceptionManager.getStackTrace(exc);
        }
        return tmpArgs;
    }

    private void buildException(LogController source) {
        if (this.msgException != null && source != null && source instanceof Location) {
            if (this.argsObj == null) {
                this.argsObj = new Object[]{ExceptionManager.getStackTrace(this.msgException)};
                this.msgType = 1;
            } else {
                this.argsObj = this.getNewArgs(this.argsObj, this.msgException);
            }
            this.msgClear = this.getNewMsg(this.msgClear, this.argsObj.length);
            this.args = LogRecord.getArgStrsInt(this.argsObj);
        }
    }

    public LogController getSource() {
        return null;
    }

    public String getLocation() {
        return this.getLocationName();
    }

    public int getLevel() {
        return this.getGroupLevel();
    }

    public int getIndent() {
        return this.getGroupIndent();
    }

    public Thread getThread() {
        return null;
    }

    protected LogRecord(LogController source, String locName, Thread thr, int severity, String[] relatives, int msgType, Object msgCode, String resourceBundleName, String msgClear, String[] args) {
        this(source, locName, thr, severity, relatives, msgType, msgCode, resourceBundleName, msgClear, args, null);
    }

    protected LogRecord(String msgId, int size, Date time, String source, int severity, String loc, String[] relatives, String groupId, int level, int indent, String thr, int msgType, String msgCode, String msgAlias, String resourceBundleName, String msgClear, Object[] args, String application, String user, String session, String transaction, String dsrComponent, String dsrUser, String dsrTransaction, MessageAccessor msgAccessor) {
        this(msgId, "-1", size, time, null, source, severity, loc, relatives, thr, msgType, msgCode, msgAlias, resourceBundleName, msgClear, args, application, user, session, transaction, dsrTransaction, dsrUser, dsrComponent, -1, msgAccessor, null, null);
    }

    protected LogRecord(String msgId, int size, Date time, String source, int severity, String loc, String[] relatives, String groupId, int level, int indent, String thr, int msgType, String msgCode, String resourceBundleName, String msgClear, Object[] args, String application, String user, String session, String transaction, String dsrComponent, String dsrUser, String dsrTransaction) {
        this(msgId, "-1", size, time, null, source, severity, loc, relatives, thr, msgType, msgCode, null, resourceBundleName, msgClear, args, application, user, session, transaction, dsrTransaction, dsrUser, dsrComponent, -1, null, null, null);
    }

    protected LogRecord(String msgId, Date time, String source, int severity, String loc, String[] relatives, String groupId, int level, int indent, String thr, int msgType, String msgCode, String resourceBundleName, String msgClear, Object[] args, String application, String user, String session, String transaction, String dsrComponent, String dsrUser, String dsrTransaction) {
        this(msgId, time, source, severity, loc, relatives, groupId, level, indent, thr, msgType, msgCode, resourceBundleName, msgClear, args, application, user, session, transaction, dsrComponent, dsrUser, dsrTransaction, -1);
    }
}

