/*
 * Decompiled with CFR 0.152.
 */
package com.sap.i18n.cp;

import com.sap.i18n.cp.ConvertArrException;
import com.sap.i18n.cp.ConvertCCCDataErrInfo;
import com.sap.i18n.cp.ConvertCToX;

public class ConvertUc2Sb
extends ConvertCToX {
    private byte[] m_abUc2SbTab;

    public ConvertUc2Sb(char[] sInCp, boolean bIgnoreErr, byte[] abUc2SbTab) {
        super(sInCp, bIgnoreErr);
        this.m_abUc2SbTab = abUc2SbTab;
    }

    public int ConvertArrImpl(char[] acIn, int nInBeginIndex, int nInEndIndex, byte[] abOut, int nOutBeginIndex, int nOutEndIndex) throws ConvertArrException {
        this.m_oCnvLastErr = null;
        int nInLen = nInEndIndex - nInBeginIndex;
        int nOutLen = nOutEndIndex - nOutBeginIndex;
        int nCnvLen = nInLen <= nOutLen ? nInLen : nOutLen;
        int nCharEnd = this.m_abUc2SbTab.length;
        for (int i = 0; i < nCnvLen; ++i) {
            int cCurIn = acIn[nInBeginIndex + i] & 0xFFFF;
            int bOut = cCurIn < nCharEnd ? this.m_abUc2SbTab[cCurIn] : 35;
            if (bOut == 35 && cCurIn != 35 && !this.m_bIgnoreErr) {
                ConvertCCCDataErrInfo oCnvErrInfo = this.createCnvErr("ConvertSb2UcArr", 2048, acIn, nInBeginIndex, nInEndIndex, nInBeginIndex + i, abOut, nOutBeginIndex, nOutBeginIndex + i);
                throw new ConvertArrException(oCnvErrInfo);
            }
            abOut[nOutBeginIndex + i] = bOut;
        }
        if (nInLen > nOutLen) {
            ConvertCCCDataErrInfo oCnvErrInfo = this.createCnvErr("ConvertSb2UcArr", 32, acIn, nInBeginIndex, nInEndIndex, nInBeginIndex + nOutLen, abOut, nOutBeginIndex, nOutBeginIndex + nOutLen);
            throw new ConvertArrException(oCnvErrInfo);
        }
        return nCnvLen;
    }

    public int outLength(char[] acIn, int nInBeginIndex, int nInEndIndex) {
        int nInLen = nInEndIndex - nInBeginIndex;
        return nInLen;
    }

    protected boolean isShortcut() {
        return true;
    }
}

