/*
 * Decompiled with CFR 0.152.
 */
package com.sap.i18n.cp;

import com.sap.i18n.cp.ConvertCCCErrInfo;
import com.sap.i18n.cp.ConverterException;
import com.sap.i18n.cp.ConverterJNI;
import com.sap.i18n.cp.ConverterRuntimeException;
import com.sap.tc.logging.Category;
import com.sap.tc.logging.Location;

public abstract class ConvertBase {
    private static final Location m_oLoc = Location.getLocation("com.sap.i18n.cp.ConvertBase");
    protected static final Category m_oLog = Category.SYS_SERVER;
    private static boolean m_bConverterJNILoadTried = false;
    private static ExceptionInInitializerError m_eConverterJNILoadException = null;
    private static ConverterRuntimeException m_eConverterJNILoadExceptionCause = null;
    protected static boolean m_bCnvArrAvailable = false;
    static boolean m_bCnvShortcutsAvailable = false;
    public static char[] m_acUcCp = new char[]{'0', '0', '0', '0'};
    protected ConvertCCCErrInfo m_oCnvLastErr;

    public ConvertBase() {
        ConvertBase.CheckConverterJNIAvailable();
        this.m_oCnvLastErr = null;
    }

    public static String GetJavaVersion() {
        ConvertBase.CheckConverterJNIAvailable();
        return new String("1.1.0");
    }

    public static String GetNativeVersion() {
        ConvertBase.CheckConverterJNIAvailable();
        return ConverterJNI.GetVersion();
    }

    public static void CheckConverterJNIAvailable() {
        if (m_bConverterJNILoadTried) {
            if (m_eConverterJNILoadException == null) {
                return;
            }
            if (m_eConverterJNILoadExceptionCause != null) {
                ConvertBase.throwJNILoadException(m_eConverterJNILoadExceptionCause);
            } else {
                ConvertBase.throwJNILoadException(m_eConverterJNILoadException);
            }
        }
        m_bConverterJNILoadTried = true;
        try {
            ConverterJNI.DummyToTriggerLoad();
        }
        catch (ExceptionInInitializerError e) {
            m_eConverterJNILoadException = e;
            ConvertBase.throwJNILoadException(m_eConverterJNILoadException);
        }
        m_bCnvArrAvailable = ConverterJNI.CheckRequiredVersion(3, 1);
        m_bCnvShortcutsAvailable = ConverterJNI.CheckRequiredVersion(2, 2);
    }

    public ConvertCCCErrInfo GetLastError() {
        return this.m_oCnvLastErr;
    }

    public int GetLastRet() {
        return this.m_oCnvLastErr == null ? 0 : this.m_oCnvLastErr.m_nRet;
    }

    public static void throwConverterRuntimeException(Location oLoc, String sMessage) {
        m_oLog.errorT(oLoc, "ConvertRuntimeException", "{0}", new Object[]{sMessage});
        ConverterRuntimeException eCnv = new ConverterRuntimeException(sMessage);
        throw eCnv;
    }

    public static void throwConverterException(Location oLoc, String sMessage) throws ConverterException {
        m_oLog.errorT(oLoc, "ConvertException", "{0}", new Object[]{sMessage});
        ConverterException eCnv = new ConverterException(sMessage);
        throw eCnv;
    }

    private static void throwJNILoadException(RuntimeException e) {
        m_oLog.errorT(m_oLoc, "ConvertException", "{0}", new Object[]{e.getMessage()});
        throw e;
    }

    private static void throwJNILoadException(ExceptionInInitializerError e) {
        m_oLog.errorT(m_oLoc, "ConvertException", "{0}", new Object[]{e.getMessage()});
        throw e;
    }

    static void throwExceptions4Test() {
        Throwable cause = new Throwable();
        new ConverterRuntimeException("Exception created just for test", cause);
        new ConverterRuntimeException(cause);
        try {
            ConvertBase.throwConverterRuntimeException(m_oLoc, "Exception created just for test");
        }
        catch (Exception e) {
            System.out.println("Exception thrown 4 Test: " + e.getMessage());
        }
        try {
            ConvertBase.throwJNILoadException(new RuntimeException("Exception created just for test"));
        }
        catch (Exception e) {
            System.out.println("Exception thrown 4 Test: " + e.getMessage());
        }
    }

    public static char[] getSystemCP() {
        char[] acCodepage = null;
        ConverterJNI.checkVersion(1, 1);
        acCodepage = ConverterJNI.GetSystemCodePage();
        if (acCodepage == null) {
            ConvertBase.throwConverterRuntimeException(m_oLoc, "getSystemCP failed");
        }
        return acCodepage;
    }
}

