/*
 * Decompiled with CFR 0.152.
 */
package com.sap.conn.rfc.exceptions;

import com.sap.conn.jco.rt.AbapClassExceptionInfo;
import com.sap.conn.jco.rt.DefaultRemoteContext;
import com.sap.conn.rfc.engine.Trc;
import com.sap.conn.rfc.exceptions.RfcGetErrorCode;
import com.sap.conn.rfc.exceptions.RfcIoException;
import com.sap.conn.rfc.exceptions.RfcRc;

public final class RfcGetException
extends Exception
implements RfcGetErrorCode,
RfcRc {
    private static final long serialVersionUID = 300012082005L;
    private int get_rc;
    private String key;
    private int errorGroup;
    private String m_msgId;
    private char m_msgTy;
    private String m_msgNo;
    private String[] messageParameters;
    private AbapClassExceptionInfo classExceptionInfo;

    public RfcGetException(int get_rc, String message, Throwable cause) {
        super(message == null || message.length() == 0 ? "no message received" : message, cause);
        this.get_rc = get_rc;
        this.processGetRC();
    }

    public RfcGetException(int get_rc, String message) {
        this(get_rc, message, null);
    }

    public RfcGetException(int get_rc, Throwable cause) {
        this(get_rc, cause.getMessage(), cause);
    }

    public RfcGetException(String message, RfcIoException cause) {
        super(message, cause);
        switch (cause.getIoRc()) {
            case 10: 
            case 29: {
                this.get_rc = 11;
                break;
            }
            case 33: {
                this.get_rc = 21;
                break;
            }
            case 27: {
                this.get_rc = 7;
                break;
            }
            case 34: {
                this.get_rc = 24;
                break;
            }
            default: {
                this.get_rc = 3;
            }
        }
        this.processGetRC();
    }

    public RfcGetException(RfcIoException cause) {
        this(cause.getMessage(), cause);
    }

    public RfcGetException(AbapClassExceptionInfo classExceptionInfo) {
        this(22, "Backend raised an ABAP class exception", null);
        this.classExceptionInfo = classExceptionInfo;
    }

    public RfcGetException(int get_rc, String message, String msgId, char msgTy, String msgNo, String msgv1, String msgv2, String msgv3, String msgv4) {
        this(get_rc, message, null);
        switch (get_rc) {
            case 7: 
            case 8: {
                this.m_msgId = msgId;
                this.m_msgTy = msgTy;
                this.m_msgNo = msgNo;
                this.messageParameters = new String[]{msgv1, msgv2, msgv3, msgv4};
                break;
            }
        }
    }

    public int getRc() {
        return this.get_rc;
    }

    public int getErrorGroup() {
        return this.errorGroup;
    }

    public String getKey() {
        return this.key;
    }

    private void processGetRC() {
        switch (this.get_rc) {
            case 3: 
            case 11: {
                this.errorGroup = 102;
                this.key = "RFC_ERROR_COMMUNICATION";
                break;
            }
            case 9: {
                this.errorGroup = 107;
                this.key = "RFC_ERROR_PROTOCOL";
                break;
            }
            case 24: {
                this.errorGroup = 112;
                this.key = "RFC_ERROR_REQUEST_CANCELLED";
                break;
            }
            case 21: {
                this.errorGroup = 104;
                this.key = "RFC_ERROR_SYSTEM_FAILURE";
                break;
            }
            case 8: {
                this.errorGroup = 105;
                this.key = "RFC_ERROR_APPLICATION_EXCEPTION";
                break;
            }
            case 22: {
                this.errorGroup = 111;
                this.key = "RFC_ERROR_CLASS_EXCEPTION";
                break;
            }
            default: {
                this.errorGroup = 104;
                this.key = "RFC_ERROR_SYSTEM_FAILURE";
            }
        }
        switch (this.get_rc) {
            case 8: 
            case 9: 
            case 11: {
                break;
            }
            default: {
                StringBuilder text = new StringBuilder(100);
                text.append(">RfcGetException rc (");
                text.append(this.get_rc);
                text.append(") message: ");
                text.append(this.getMessage());
                text.append("\n<RfcGetException\n");
                Trc.criticalTrace(null, text.toString());
            }
        }
    }

    public char getMessageType() {
        return this.m_msgTy;
    }

    public String[] getMessageParameters() {
        return this.messageParameters;
    }

    public String getMessageClass() {
        return this.m_msgId;
    }

    public String getMessageNumber() {
        return this.m_msgNo;
    }

    AbapClassExceptionInfo getClassExceptionInfo() {
        return this.classExceptionInfo;
    }

    public void setRemoteContext(DefaultRemoteContext remoteContext) {
        if (this.classExceptionInfo != null) {
            this.classExceptionInfo.setRemoteContext(remoteContext);
        }
    }
}

