/*
 * Decompiled with CFR 0.152.
 */
package com.sap.conn.jco.util;

import com.sap.conn.jco.util.CharacterEncoding;
import com.sap.conn.jco.util.Codepage;
import com.sap.i18n.cp.ConvertCToX;
import com.sap.i18n.cp.ConvertCToXFactory;
import com.sap.i18n.cp.ConvertXToC;
import com.sap.i18n.cp.ConvertXToCFactory;
import java.util.Hashtable;

public abstract class I18NConverters {
    private static Hashtable<String, ConvertXToC> m_ConvertersXToC = new Hashtable(11);
    private static Hashtable<String, ConvertCToX> m_ConvertersCToX = new Hashtable(11);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ConvertXToC getConvertXToC(String charEncoding) {
        ConvertXToC converter = m_ConvertersXToC.get(charEncoding);
        if (converter == null) {
            Hashtable<String, ConvertXToC> hashtable = m_ConvertersXToC;
            synchronized (hashtable) {
                converter = m_ConvertersXToC.get(charEncoding);
                if (converter == null && charEncoding != null) {
                    String sapCodepage = CharacterEncoding.mapJavaToSAPEncoding(charEncoding);
                    if (sapCodepage == null) {
                        sapCodepage = Codepage.getCodepage(charEncoding);
                    }
                    if (sapCodepage != null && (converter = ConvertXToCFactory.createConvertXToC(sapCodepage.toCharArray(), true)) != null) {
                        m_ConvertersXToC.put(charEncoding, converter);
                    }
                }
            }
        }
        return converter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ConvertCToX getConvertCToX(String charEncoding) {
        ConvertCToX converter = m_ConvertersCToX.get(charEncoding);
        if (converter == null) {
            Hashtable<String, ConvertCToX> hashtable = m_ConvertersCToX;
            synchronized (hashtable) {
                converter = m_ConvertersCToX.get(charEncoding);
                if (converter == null && charEncoding != null) {
                    String sapCodepage = CharacterEncoding.mapJavaToSAPEncoding(charEncoding);
                    if (sapCodepage == null) {
                        sapCodepage = Codepage.getCodepage(charEncoding);
                    }
                    if (sapCodepage != null && (converter = ConvertCToXFactory.createConvertCToX(sapCodepage.toCharArray(), true)) != null) {
                        m_ConvertersCToX.put(charEncoding, converter);
                    }
                }
            }
        }
        return converter;
    }
}

