/*
 * Decompiled with CFR 0.152.
 */
package defaultPackage;

import com.sap.conn.jco.JCoException;
import defaultPackage.AusgabeDateien;
import defaultPackage.MainClassGUI;
import defaultPackage.Nummernkreise;
import defaultPackage.SAPsystem;
import defaultPackage.Start;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class ActionClass
implements ActionListener {
    JButton button;
    Nummernkreise numkr;
    AusgabeDateien ausg;
    SAPsystem sys;
    JCheckBox checkBoxPerf;
    JCheckBox checkBoxProt;

    public ActionClass(JButton button, Nummernkreise numkr, AusgabeDateien ausg, SAPsystem sys, JCheckBox checkBoxPerf, JCheckBox checkBoxProt) {
        this.button = button;
        this.numkr = numkr;
        this.ausg = ausg;
        this.sys = sys;
        this.checkBoxPerf = checkBoxPerf;
        this.checkBoxProt = checkBoxProt;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.button) {
            if (((JButton)e.getSource()).getText() == "SAP Defaultwerte") {
                int dialog = JOptionPane.showConfirmDialog(null, "SAP-Standardwerte wiederherstellen?", "Nummernkreise", 2);
                if (dialog == 0) {
                    this.numkr.setNUMdefault();
                    System.out.println("SAP Defaultwerte wiederhergestellt");
                    MainClassGUI.panel1b.add(new JLabel("SAP Defaultwerte der Nummernkreise wiederhergestellt."));
                    MainClassGUI.panel1b.add(new JLabel(" "));
                }
            } else if (((JButton)e.getSource()).getText() == "Werte laden") {
                System.out.println("Nummernkreise laden...");
                this.numkr.loadNUM(this.ausg);
            } else if (((JButton)e.getSource()).getText() == "Werte speichern") {
                System.out.println("Nummernkreise speichern...");
                this.numkr.saveNUM(this.numkr, this.ausg);
            } else if (((JButton)e.getSource()).getText() == "Aus SAP auslesen") {
                System.out.println("Tabelle NRIV (Nummernkreisintervalle) aus SAP auslesen...");
                try {
                    Start.auslesenNRIV(this.sys);
                    System.out.println("Nummernkreisintervalle aus dem SAP ERP-System ausgelesen.");
                    MainClassGUI.panel1b.add(new JLabel("Nummernkreisintervalle aus dem SAP ERP-System wurden ausgelesen."));
                    MainClassGUI.panel1b.add(new JLabel(" "));
                }
                catch (JCoException e1) {
                    System.out.println("Auslesen der Nummernkreisintervalle aus dem SAP ERP-System fehlgeschlagen.");
                    JDialog fail = new JDialog();
                    JPanel failPanel = new JPanel();
                    failPanel.setBorder(BorderFactory.createEmptyBorder(20, 20, 20, 20));
                    fail.setResizable(false);
                    fail.add(failPanel);
                    failPanel.add(new JLabel("Nummernkreise konnten nicht ausgelesen werden"));
                    failPanel.add(new JLabel(" "));
                    failPanel.add(new JLabel(MainClassGUI.nein));
                    fail.pack();
                    fail.setLocationRelativeTo(null);
                    fail.setModal(true);
                    fail.setVisible(true);
                    MainClassGUI.panel1b.add(new JLabel("Auslesen der Nummernkreisintervalle aus dem SAP ERP-System fehlgeschlagen."));
                    MainClassGUI.panel1b.add(new JLabel(" "));
                }
            } else if (((JButton)e.getSource()).getText() == "Systemdaten laden") {
                System.out.println("Systemdaten laden...");
                this.sys.loadSYSTEMDATA(this.ausg);
            } else if (((JButton)e.getSource()).getText() == "Systemdaten speichern") {
                System.out.println("Systemdaten speichern...");
                this.sys.saveSYSTEMDATA(this.sys, this.ausg);
            } else if (((JButton)e.getSource()).getText() == "Speicherort f\u00fcr den Projektordner 'xTractorFiles' ausw\u00e4hlen") {
                System.out.println("Zielordner ausw\u00e4hlen...");
                this.ausg.choosePath(this.ausg);
            } else if (((JButton)e.getSource()).getText() == "Dateiname des Event-Logs \u00e4ndern") {
                System.out.println("Dateiname des Event-Logs \u00e4ndern...");
                this.ausg.changeName(this.ausg);
                MainClassGUI.panel3.repaint();
            } else if (((JButton)e.getSource()).getText() == "Verbindung testen") {
                System.out.println("Verbindung zum SAP ERP-System testen...");
                MainClassGUI.myFrame.setCursor(3);
                try {
                    Start.verbindungTesten(this.sys);
                    System.out.println("Die Verbindung zum SAP ERP-System funktioniert.");
                    MainClassGUI.panel1b.add(new JLabel("Die Verbindung zum SAP ERP-System funktioniert."));
                    MainClassGUI.panel1b.add(new JLabel(" "));
                    MainClassGUI.icoTEST.setText("Verbindung zum SAP ERP-System funktioniert.");
                    MainClassGUI.icoTEST.setIcon(MainClassGUI.ja);
                    MainClassGUI.scrollBar.setValue(MainClassGUI.scrollBar.getMaximum());
                }
                catch (JCoException e1) {
                    System.out.println("Keine Verbindung zum SAP ERP-System.");
                    MainClassGUI.panel1b.add(new JLabel("Keine Verbindung zum SAP ERP-System."));
                    MainClassGUI.panel1b.add(new JLabel(" "));
                    MainClassGUI.icoTEST.setText("Verbindung zum SAP ERP-System fehlgeschlagen.");
                    MainClassGUI.icoTEST.setIcon(MainClassGUI.nein);
                    MainClassGUI.scrollBar.setValue(MainClassGUI.scrollBar.getMaximum());
                }
                MainClassGUI.myFrame.revalidate();
                MainClassGUI.myFrame.setCursor(0);
            } else if (((JButton)e.getSource()).getText() == "Extraktion starten") {
                String infoSystem = "VERBINDUNGSDATEN" + System.getProperty("line.separator") + "System-ID: " + this.sys.systemID.getText() + System.getProperty("line.separator") + "Message-Server: " + this.sys.msgserver.getText() + System.getProperty("line.separator") + "SAProuter: " + this.sys.sapverver.getText() + System.getProperty("line.separator") + "Gruppe/Server: " + this.sys.group.getText() + System.getProperty("line.separator") + "Mandant: " + this.sys.mandant.getText() + System.getProperty("line.separator") + "Benutzer: " + this.sys.user.getText() + System.getProperty("line.separator") + "Sprache: " + this.sys.language.getText() + System.getProperty("line.separator") + System.getProperty("line.separator");
                String infoNummernkreise = "NUMMERNKREISE" + System.getProperty("line.separator") + "Bestellanforderungen von " + this.numkr.textfieldBANFvon.getText() + " bis " + this.numkr.textfieldBANFbis.getText() + System.getProperty("line.separator") + "Bestellungen von " + this.numkr.textfieldBESTvon.getText() + " bis " + this.numkr.textfieldBESTbis.getText() + System.getProperty("line.separator") + "Anfragen von " + this.numkr.textfieldANFRvon.getText() + " bis " + this.numkr.textfieldANFRbis.getText() + System.getProperty("line.separator") + "Kontrakte von " + this.numkr.textfieldKONTvon.getText() + " bis " + this.numkr.textfieldKONTbis.getText() + System.getProperty("line.separator") + "Lieferpl\u00e4ne von " + this.numkr.textfieldLIEFvon.getText() + " bis " + this.numkr.textfieldLIEFbis.getText() + System.getProperty("line.separator") + System.getProperty("line.separator");
                String infoAusgabedateien = "AUSGABEDATEIEN" + System.getProperty("line.separator") + "Zielverzeichnis: " + this.ausg.ausgabeDateipfad + System.getProperty("line.separator") + "Dateiname des Eventlogs: " + this.ausg.ausgabeDateiname;
                String infoPerflog = this.checkBoxPerf.isSelected() ? String.valueOf(System.getProperty("line.separator")) + "Performance-Log wird erstellt." : String.valueOf(System.getProperty("line.separator")) + "Performance-Log wird nicht erstellt.";
                String infoProtokoll = this.checkBoxProt.isSelected() ? String.valueOf(System.getProperty("line.separator")) + "Event-Log-Protokoll wird erstellt." : String.valueOf(System.getProperty("line.separator")) + "Event-Log-Protokoll wird nicht erstellt.";
                int dialog = JOptionPane.showConfirmDialog(null, String.valueOf(infoSystem) + infoNummernkreise + infoAusgabedateien + infoPerflog + infoProtokoll, "\u00dcberpr\u00fcfung der Einstellungen", 2);
                if (dialog == 0) {
                    if (this.ausg.ausgabeDatei.exists()) {
                        System.out.println("Event-Log existiert schon. \u00dcberschreiben?");
                        int dialog2 = JOptionPane.showConfirmDialog(null, "Datei '" + this.ausg.ausgabeDateiname + "' \u00fcberschreiben?", "Datei existiert bereits", 2);
                        if (dialog2 == 0) {
                            MainClassGUI.panel1b.add(new JLabel("Event-Log-Extraktion um " + new SimpleDateFormat("HH:mm:ss").format(new Date()) + " gestartet."));
                            MainClassGUI.panel1b.add(new JLabel(" "));
                            System.out.println("Extraktion starten...");
                            MainClassGUI.myFrame.revalidate();
                            MainClassGUI.myFrame.repaint();
                            MainClassGUI.myFrame.setCursor(3);
                            try {
                                Start.extraktion(this.sys, this.numkr, this.ausg, this.checkBoxPerf, this.checkBoxProt);
                                MainClassGUI.panel1b.add(new JLabel("Event-Log-Extraktion um " + new SimpleDateFormat("HH:mm:ss").format(new Date()) + " beendet."));
                                MainClassGUI.panel1b.add(new JLabel(" "));
                                MainClassGUI.panel1b.add(new JLabel("Event-Log '" + this.ausg.ausgabeDateiname + "' im Projektordner " + this.ausg.ausgabeDateipfad + " wurde \u00fcberschrieben."));
                                MainClassGUI.panel1b.add(new JLabel(" "));
                                System.out.println("Event-Log wurde \u00fcberschrieben.");
                            }
                            catch (JCoException e1) {
                                System.out.println("Extraktion fehlgeschlagen.");
                                MainClassGUI.panel1b.add(new JLabel("Die Ausf\u00fchrung der Extraktion ist fehlgeschlagen."));
                                MainClassGUI.panel1b.add(new JLabel(" "));
                            }
                            MainClassGUI.myFrame.revalidate();
                            MainClassGUI.myFrame.repaint();
                            MainClassGUI.myFrame.setCursor(0);
                            MainClassGUI.scrollBar.setValue(MainClassGUI.scrollBar.getMaximum());
                        }
                    } else {
                        MainClassGUI.panel1b.add(new JLabel("Event-Log-Extraktion um " + new SimpleDateFormat("HH:mm:ss").format(new Date()) + " gestartet."));
                        MainClassGUI.panel1b.add(new JLabel(" "));
                        System.out.println("Extraktion starten...");
                        MainClassGUI.myFrame.revalidate();
                        MainClassGUI.myFrame.setCursor(3);
                        try {
                            Start.extraktion(this.sys, this.numkr, this.ausg, this.checkBoxPerf, this.checkBoxProt);
                            MainClassGUI.panel1b.add(new JLabel("Event-Log-Extraktion um " + new SimpleDateFormat("HH:mm:ss").format(new Date()) + " beendet."));
                            MainClassGUI.panel1b.add(new JLabel(" "));
                        }
                        catch (JCoException e1) {
                            System.out.println("Extraktion fehlgeschlagen.");
                            MainClassGUI.panel1b.add(new JLabel("Die Ausf\u00fchrung der Extraktion ist fehlgeschlagen."));
                            MainClassGUI.panel1b.add(new JLabel(" "));
                        }
                        MainClassGUI.myFrame.revalidate();
                        MainClassGUI.myFrame.setCursor(0);
                        MainClassGUI.scrollBar.setValue(MainClassGUI.scrollBar.getMaximum());
                    }
                }
            }
        }
    }
}

