/*
 * Decompiled with CFR 0.152.
 */
package com.sap.conn.jco.rt;

import com.sap.conn.jco.rt.AutoJobRunner;
import com.sap.conn.jco.rt.Context;
import com.sap.conn.jco.rt.SessionTimeoutChecker;
import com.sap.conn.jco.rt.Trace;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SessionFinalizer
implements AutoJobRunner.AutoJob {
    private AutoJobRunner autoJobRunner;
    long jobCreated = System.currentTimeMillis();
    long lastExecution = 0L;
    Map<String, ? extends Context> contexts;

    SessionFinalizer(AutoJobRunner autoJobRunner, Map<String, ? extends Context> contexts) {
        this.autoJobRunner = autoJobRunner;
        this.contexts = contexts;
    }

    @Override
    public void execute() {
        this.lastExecution = System.currentTimeMillis();
        long sessionTimeout = SessionTimeoutChecker.getTimeout();
        Context[] copy = this.contexts.values().toArray(new Context[this.contexts.size()]);
        long now = System.currentTimeMillis();
        boolean removeAll = now > this.jobCreated + sessionTimeout;
        for (int i = 0; i < copy.length; ++i) {
            if (!removeAll && now <= copy[i].lastAccess + sessionTimeout) continue;
            try {
                this.contexts.remove(copy[i].getSessionID());
                copy[i].clearServerConnection();
                copy[i].removeSessionReference();
                copy[i].reset();
                continue;
            }
            catch (Throwable th) {
                if (!Trace.isOn(8)) continue;
                Trace.fireTrace(8, "[JCoAPI] " + th.getClass().getName() + " occurred while finalizing session ID: [" + copy[i].getSessionID() + "]", th);
            }
        }
        if (removeAll || this.contexts.size() == 0) {
            this.contexts = null;
            this.autoJobRunner.removeJob(this);
            this.autoJobRunner = null;
        }
    }

    @Override
    public final long getExecutePeriod() {
        return SessionTimeoutChecker.getTimeoutCheckInterval();
    }

    @Override
    public final long getLastExecutionTime() {
        return this.lastExecution;
    }
}

