/*
 * Decompiled with CFR 0.152.
 */
package com.sap.i18n.cp;

import com.sap.i18n.cp.ConvertBE2Uc;
import com.sap.i18n.cp.ConvertBase;
import com.sap.i18n.cp.ConvertDb2Uc;
import com.sap.i18n.cp.ConvertLE2Uc;
import com.sap.i18n.cp.ConvertSb2Uc;
import com.sap.i18n.cp.ConvertUtf82Uc;
import com.sap.i18n.cp.ConvertXToC;

public class ConvertXToCFactory {
    private static ShortcutBase[] ms_aShortcuts = new ShortcutBase[10000];

    public static ConvertXToC createConvertXToC(char[] sInCp, boolean bIgnoreErr) {
        return ConvertXToCFactory.createConvertXToC(sInCp, bIgnoreErr, false);
    }

    public static ConvertXToC createConvertXToC(char[] sInCp, boolean bIgnoreErr, boolean bFailOnErr) {
        String sInCpStr = new String(sInCp);
        if (sInCpStr.equals("4102")) {
            return new ConvertBE2Uc(bIgnoreErr);
        }
        if (sInCpStr.equals("4103")) {
            return new ConvertLE2Uc(bIgnoreErr);
        }
        if (sInCpStr.equals("4110")) {
            return new ConvertUtf82Uc(bIgnoreErr);
        }
        ShortcutBase oShortcut = ConvertXToCFactory.getShortcut(sInCp);
        if (oShortcut != null) {
            boolean bLoaded;
            if (oShortcut.m_bTabLoaded) {
                return oShortcut.createConvertXToC(bIgnoreErr);
            }
            if (!oShortcut.m_bTabLoadTried && (bLoaded = oShortcut.loadTab())) {
                return oShortcut.createConvertXToC(bIgnoreErr);
            }
        }
        return new ConvertXToC(sInCp, bIgnoreErr, bFailOnErr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static ShortcutBase getShortcut(char[] sCp) {
        ShortcutBase returnValue = null;
        ConvertBase.CheckConverterJNIAvailable();
        if (!ConvertBase.m_bCnvShortcutsAvailable) return returnValue;
        int nIndex = ConvertXToCFactory.getShortcutIndex(sCp);
        if (nIndex == -1) return returnValue;
        ShortcutBase[] shortcutBaseArray = ms_aShortcuts;
        synchronized (ms_aShortcuts) {
            if (ms_aShortcuts[nIndex] != null) {
                return ms_aShortcuts[nIndex];
            }
            ConvertXToC aCnvForCheck = new ConvertXToC(sCp, true);
            int nType = aCnvForCheck.GetShortcutType();
            if (nType == 1) {
                ConvertXToCFactory.ms_aShortcuts[nIndex] = new ShortcutSb2Uc(sCp);
                return ms_aShortcuts[nIndex];
            }
            if (nType != 2) return returnValue;
            ConvertXToCFactory.ms_aShortcuts[nIndex] = new ShortcutDb2Uc(sCp);
            return ms_aShortcuts[nIndex];
        }
    }

    private static int getShortcutIndex(char[] sCp) {
        int nIndex;
        int returnValue = -1;
        if (sCp.length == 4 && 0 <= (nIndex = (sCp[0] - 48) * 1000 + (sCp[1] - 48) * 100 + (sCp[2] - 48) * 10 + (sCp[3] - 48) * 1) && nIndex < 10000) {
            returnValue = nIndex;
        }
        return returnValue;
    }

    private static class ShortcutDb2Uc
    extends ShortcutBase {
        private byte[] m_abLeadByte2LengthTab = new byte[256];
        private char[] m_acLeadByte2ValueTab = new char[256];
        private int[] m_anDb2UcTab;
        private char[] m_acBrokenDb2UcTab = new char[256];

        public ShortcutDb2Uc(char[] sCp) {
            super(sCp);
        }

        public ConvertXToC createConvertXToC(boolean bIgnoreErr) {
            ConvertDb2Uc returnValue = null;
            if (this.m_bTabLoaded) {
                returnValue = new ConvertDb2Uc(this.m_sCp, bIgnoreErr, this.m_abLeadByte2LengthTab, this.m_acLeadByte2ValueTab, this.m_anDb2UcTab, this.m_acBrokenDb2UcTab);
            }
            return returnValue;
        }

        public boolean loadTab() {
            int[] aRet = new int[1];
            ConvertXToC aCnvForLoad = new ConvertXToC(this.m_sCp, true);
            this.m_anDb2UcTab = aCnvForLoad.GetDb2UcTab(this.m_abLeadByte2LengthTab, this.m_acLeadByte2ValueTab, this.m_acBrokenDb2UcTab, aRet);
            this.m_bTabLoadTried = true;
            this.m_bTabLoaded = aRet[0] == 0;
            return this.m_bTabLoaded;
        }
    }

    private static class ShortcutSb2Uc
    extends ShortcutBase {
        public char[] m_acSb2UcTab = new char[256];

        public ShortcutSb2Uc(char[] sCp) {
            super(sCp);
        }

        public ConvertXToC createConvertXToC(boolean bIgnoreErr) {
            ConvertSb2Uc returnValue = null;
            if (this.m_bTabLoaded) {
                returnValue = new ConvertSb2Uc(this.m_sCp, bIgnoreErr, this.m_acSb2UcTab);
            }
            return returnValue;
        }

        public boolean loadTab() {
            ConvertXToC aCnvForLoad = new ConvertXToC(this.m_sCp, true);
            int nRet = aCnvForLoad.GetSb2UcTab(this.m_acSb2UcTab);
            this.m_bTabLoaded = nRet == 0;
            this.m_bTabLoadTried = true;
            return this.m_bTabLoaded;
        }
    }

    private static abstract class ShortcutBase {
        public char[] m_sCp;
        public boolean m_bTabLoaded;
        public boolean m_bTabLoadTried;

        public ShortcutBase(char[] sCp) {
            this.m_sCp = sCp;
            this.m_bTabLoaded = false;
            this.m_bTabLoadTried = false;
        }

        public abstract boolean loadTab();

        public abstract ConvertXToC createConvertXToC(boolean var1);
    }
}

