/*
 * Decompiled with CFR 0.152.
 */
package com.sap.i18n.cp;

import com.sap.i18n.cp.ConvertSimpleBase;
import com.sap.i18n.cp.ConvertTImplBase;
import com.sap.i18n.cp.ConvertXToX;
import com.sap.i18n.cp.ConverterJNITestDataCpXToX;
import com.sap.i18n.cp.ConverterJNITestDataSingleXToX;
import com.sap.i18n.cp.StrUtil;
import com.sap.i18n.verify.intf.VerifyIntf;

public class ConvertXToXTImpl
extends ConvertTImplBase {
    public static ConverterJNITestDataCpXToX[] m_aTestDataXToXAll = new ConverterJNITestDataCpXToX[]{new ConverterJNITestDataCpXToX("1100", "1401", 0, new ConverterJNITestDataSingleXToX[]{new ConverterJNITestDataSingleXToX(new byte[]{65, 66, 67}, new byte[]{65, 66, 67}, 0), new ConverterJNITestDataSingleXToX(new byte[]{65, -60, 67}, new byte[]{65, -60, 67}, 0)}), new ConverterJNITestDataCpXToX("1100", "8000", 0, new ConverterJNITestDataSingleXToX[]{new ConverterJNITestDataSingleXToX(new byte[]{65, 66, 67}, new byte[]{65, 66, 67}, 0), new ConverterJNITestDataSingleXToX(new byte[]{65, -60, 67}, new byte[]{65, 35, 67}, 0)}), new ConverterJNITestDataCpXToX("8000", "4102", 0, new ConverterJNITestDataSingleXToX[]{new ConverterJNITestDataSingleXToX(new byte[]{65, 66, 67}, new byte[]{0, 65, 0, 66, 0, 67}, 0), new ConverterJNITestDataSingleXToX(new byte[]{65, -127, -127}, new byte[]{0, 65, -1, 29}, 0)}), new ConverterJNITestDataCpXToX("4102", "8000", 0, new ConverterJNITestDataSingleXToX[]{new ConverterJNITestDataSingleXToX(new byte[]{0, 65, 0, 66, 0, 67}, new byte[]{65, 66, 67}, 0), new ConverterJNITestDataSingleXToX(new byte[]{0, 65, -1, 29}, new byte[]{65, -127, -127}, 0), new ConverterJNITestDataSingleXToX(new byte[]{0, 65, 0, -60}, new byte[]{65, 35}, 0)}), new ConverterJNITestDataCpXToX("4102", "4103", 0, new ConverterJNITestDataSingleXToX[]{new ConverterJNITestDataSingleXToX(new byte[]{0, 65, 0, 66, 0, 67}, new byte[]{65, 0, 66, 0, 67, 0}, 0)}), new ConverterJNITestDataCpXToX("", "", 16, new ConverterJNITestDataSingleXToX[]{new ConverterJNITestDataSingleXToX(new byte[]{65, 66, 67}, new byte[0], 16)})};

    public ConvertXToXTImpl(VerifyIntf oVerify) {
        super(oVerify);
    }

    public void testMain() {
        this.printLogln("TEST ConvertXToXTImpl BEGIN");
        this.testConvertXToX();
        this.printLogln("testConvertXToX done");
        this.printLogln("TEST ConvertXToXTImpl END");
    }

    public void testConvertXToX() {
        for (int i = 0; i < m_aTestDataXToXAll.length; ++i) {
            ConverterJNITestDataCpXToX oDataCp = m_aTestDataXToXAll[i];
            ConvertXToX oCnvObj = new ConvertXToX(oDataCp.m_acCpIn, oDataCp.m_acCpOut, true);
            this.verifyConvertInit("ConvertXToX", oCnvObj, oDataCp.m_nReturn);
            if (oDataCp.m_nReturn != 0) {
                return;
            }
            for (int j = 0; j < oDataCp.m_aData.length; ++j) {
                ConverterJNITestDataSingleXToX oData = oDataCp.m_aData[j];
                byte[] abOut = oCnvObj.Convert(oData.m_abDataIn);
                this.verifyConvertXToX("ConverterJNI.ConvertXToX", oCnvObj, oData, abOut);
            }
        }
    }

    void verifyConvertXToX(String sName, ConvertSimpleBase oCnvObj, ConverterJNITestDataSingleXToX oTestData, byte[] abOut) {
        int nReturnExpected;
        int nReturn = oCnvObj.GetLastRet();
        this.verify(nReturn == (nReturnExpected = oTestData.m_nReturn), oCnvObj.getCnvDisplayText() + " returned: " + nReturn + " (" + nReturnExpected + ")", sName);
        String sInBytes = StrUtil.buildByteString(oTestData.m_abDataIn);
        String sOutBytes = StrUtil.buildByteString(abOut);
        String sOutExpectedBytes = StrUtil.buildByteString(oTestData.m_abDataOut);
        this.verify(sOutBytes.equals(sOutExpectedBytes), oCnvObj.getCnvDisplayText() + ": " + sInBytes + "->" + sOutBytes + " (" + sOutExpectedBytes + ")", sName);
    }
}

