/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.logging.tools.lv;

import com.sap.tc.logging.Category;
import com.sap.tc.logging.FileLog;
import com.sap.tc.logging.Location;
import com.sap.tc.logging.exceptions.LoggingBaseException;
import com.sap.tc.logging.tools.lv.CmdOptionList;
import com.sap.tc.logging.tools.lv.CmdOptionPrefixes;
import com.sap.tc.logging.tools.lv.LVAction;
import com.sap.tc.logging.tools.lv.LVOptions;
import java.io.BufferedOutputStream;
import java.io.OutputStream;
import java.io.PrintWriter;

public class LV {
    LVAction lvAction;

    public static void main(String[] args) {
        new LV(args);
    }

    public LV(String[] args) {
        this.init(new PrintWriter(new BufferedOutputStream(System.out)), args, false);
    }

    public LV(OutputStream outSystem, String[] args) {
        this.init(new PrintWriter(new BufferedOutputStream(outSystem)), args, true);
    }

    public void reset() {
        this.lvAction.reset();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init(PrintWriter outSystem, String[] args, boolean isJ2EE) {
        boolean isExcOk = true;
        try {
            CmdOptionPrefixes.setPrefixes(LVOptions.optionPrefixes);
            CmdOptionList optionList = CmdOptionList.parse(args);
            LVOptions lvOptions = new LVOptions();
            optionList.evaluate(lvOptions);
            lvOptions.outSystem = outSystem;
            if (isJ2EE) {
                lvOptions.isTail = false;
                lvOptions.isBatchMode = true;
            }
            this.execute(lvOptions);
        }
        catch (LoggingBaseException ex) {
            outSystem.println(ex.getMessage());
            outSystem.println(ex.getAdditionalInfo());
            isExcOk = false;
        }
        catch (Exception ex) {
            outSystem.println(ex.getMessage());
            isExcOk = false;
        }
        finally {
            if (isExcOk) {
                outSystem.println("LV Tool finished successfully");
            } else {
                outSystem.println("LV Tool terminated with errors!");
            }
            outSystem.flush();
        }
    }

    private void execute(LVOptions lvOpt) throws Exception {
        this.lvAction = new LVAction();
        this.lvAction.execute(lvOpt);
    }

    private void setLoggingEnv() {
        FileLog log = new FileLog("logging.log");
        Location loc = Location.getLocation("com.sap.tc.logging", "tc~logging~java", "BC-JAS-ADM-LOG-API");
        loc.addLog(log);
        loc.setEffectiveSeverity(701);
        Category.SYS_LOGGING.addLog(log);
        Category.SYS_LOGGING.setEffectiveSeverity(701);
    }
}

