/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.logging.messagedepot.impl;

import com.sap.tc.logging.messagedepot.LocalizedMessage;
import com.sap.tc.logging.messagedepot.MessageAccessor;
import com.sap.tc.logging.messagedepot.MessageID;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class MessageAccessorImpl
implements MessageAccessor {
    private ResourceBundle resBundle_;

    public MessageAccessorImpl(Locale locale) {
        if (locale == null) {
            this.resBundle_ = null;
            return;
        }
        try {
            this.resBundle_ = ResourceBundle.getBundle("messages", locale);
        }
        catch (MissingResourceException ex) {
            this.resBundle_ = null;
        }
    }

    protected String getString(String key) {
        if (this.resBundle_ == null) {
            return null;
        }
        try {
            return this.resBundle_.getString(key);
        }
        catch (MissingResourceException ex) {
            return null;
        }
    }

    public LocalizedMessage getLocalizedMessage(MessageID messageID) {
        if (messageID == null || this.resBundle_ == null) {
            return null;
        }
        String longText = this.getString("MSG_" + messageID.getID() + "_LONGTXT");
        if (longText == null) {
            return null;
        }
        String shortText = this.getString("MSG_" + messageID.getID() + "_SHORTTXT");
        return new LocalizedMessage(messageID, longText, shortText);
    }
}

