/*
 * Decompiled with CFR 0.152.
 */
package com.sap.conn.jco.rt;

import com.sap.conn.jco.JCoDestination;
import com.sap.conn.jco.JCoException;
import com.sap.conn.jco.rt.ClientConnection;
import com.sap.conn.jco.rt.ClientFactory;
import com.sap.conn.jco.rt.ConnectionAttributes;
import com.sap.conn.jco.rt.InternalDestination;
import com.sap.conn.jco.rt.JCoRuntime;
import com.sap.conn.jco.rt.MonitoredConnectionData;
import com.sap.conn.jco.rt.RepositoryConnection;
import com.sap.conn.jco.rt.Trace;
import com.sap.conn.jco.util.LimitedList;
import com.sap.conn.jco.util.ObjectList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PoolingFactory
extends ClientFactory {
    private int peakLimit;
    private int capacity;
    protected long nextExpirationCheck;
    private LimitedList<ClientConnection> available;
    private ObjectList<Thread> waitingThreads = null;
    private boolean isInitialized = false;

    protected PoolingFactory(InternalDestination destination, boolean repositoryFactory) {
        super(destination, repositoryFactory);
        this.setDestinationProperties(destination);
    }

    private void setDestinationProperties(JCoDestination destination) {
        this.master = this.repositoryFactory ? new RepositoryConnection(destination) : new ClientConnection(destination);
        this.master.pool = this;
        this.expirationCheckPeriod = destination.getExpirationCheckPeriod();
        this.expirationTime = destination.getExpirationTime();
        this.maxGetClientTime = destination.getMaxGetClientTime();
        this.capacity = destination.getPoolCapacity();
        this.setPeakLimit(destination.getPeakLimit());
        if (this.expirationTime == 0L) {
            this.setCapacity(0);
        } else {
            this.setCapacity(this.capacity);
        }
        if (this.capacity == 0 && this.expirationTime != 0L) {
            this.setExpirationTime(0L);
        }
    }

    @Override
    final void updateDestination(InternalDestination destination) {
        super.updateDestination(destination);
        this.setDestinationProperties(destination);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void init(InternalDestination destination) throws JCoException {
        PoolingFactory poolingFactory = this;
        synchronized (poolingFactory) {
            if (this.isInitialized) {
                return;
            }
            this.master.connect();
            boolean toExtern = this.master.properties.getProperty("jco.client.type", "3").equals("E");
            if (toExtern) {
                try {
                    this.master.ping();
                    String partnerCP = this.master.getAttributes().getPartnerCodepage();
                    this.master.properties.put("jco.client.codepage", partnerCP);
                }
                catch (JCoException ex) {
                    if (ex.getGroup() == 104) {
                        this.master.properties.put("jco.client.codepage", "4102");
                        this.master.middleware.initialize(this.master.properties);
                        this.master.connect();
                        this.master.ping();
                    }
                    throw ex;
                }
                this.master.middleware.initialize(this.master.properties);
            }
            ConnectionAttributes attrib = this.master.getAttributes();
            this.setAttributes(attrib);
            this.attributes.cpicConnection = destination;
            if (this.available.getLimit() > 0 && !toExtern) {
                this.available.push(this.master.hide());
            } else {
                this.master.disconnect(true);
            }
            if (JCoRuntime.properties.getProperty("jco.client.idle_timeout", null) != null) {
                int idle_timeout = Integer.parseInt(JCoRuntime.properties.getProperty("jco.client.idle_timeout")) * 1000;
                if (this.getExpirationTime() > (long)idle_timeout) {
                    this.setExpirationTime(idle_timeout);
                }
            }
            this.isInitialized = true;
        }
        this.lastActiveTimestamp = System.currentTimeMillis();
    }

    @Override
    public final int getCapacity() {
        return this.capacity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    final void setCapacity(int capacity) {
        if (Trace.isOn(64)) {
            Trace.fireTrace(64, new StringBuilder(100).append("[JCoAPI] Pool.setMaxPoolSize(").append(capacity).append(") on pool ").append(this.destinationId).toString());
        }
        if (capacity < 0) {
            throw new IllegalArgumentException(new StringBuilder(100).append("capacity [").append(capacity).append("] is less than zero").toString());
        }
        ClientConnection clientConnection = this.master;
        synchronized (clientConnection) {
            int availableSize;
            int n = availableSize = this.available == null ? 0 : this.available.size();
            if (capacity < availableSize) {
                int to = availableSize - capacity;
                for (int i = 0; i < to; ++i) {
                    ClientConnection to_close = this.available.remove(0);
                    try {
                        to_close.disconnect(true);
                        continue;
                    }
                    catch (JCoException je) {
                        // empty catch block
                    }
                }
            }
            if (this.available == null) {
                this.available = new LimitedList(capacity);
            } else {
                this.available.setLimit(capacity);
            }
        }
        this.capacity = capacity;
        if (this.capacity > this.peakLimit) {
            this.setPeakLimit(this.capacity);
        }
    }

    @Override
    public final int getPeakLimit() {
        return this.peakLimit;
    }

    @Override
    final void setPeakLimit(int peakLimit) {
        if (Trace.isOn(64)) {
            Trace.fireTrace(64, new StringBuilder(100).append("[JCoAPI] Pool.setPeakLimit(").append(peakLimit).append(") on pool ").append(this.destinationId).toString());
        }
        this.peakLimit = peakLimit;
        if (this.peakLimit < this.capacity) {
            this.setCapacity(this.peakLimit);
        }
    }

    @Override
    public final int getCurrentPoolSize() {
        int currSize = this.getNumUsed() + this.available.size();
        return currSize;
    }

    @Override
    public final int getPooledConnectionCount() {
        return this.available.size();
    }

    @Override
    public final int getNumWaitingThreads() {
        return this.waitingThreads != null ? this.waitingThreads.size() : 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected final void clear() {
        ClientConnection clientConnection = this.master;
        synchronized (clientConnection) {
            while (!this.available.isEmpty()) {
                try {
                    this.available.pop().disconnect(true);
                }
                catch (JCoException jCoException) {}
            }
            this.lastActiveTimestamp = System.currentTimeMillis();
            if (this.waitingThreads != null && this.waitingThreads.size() > 0) {
                if (Trace.isOn(4)) {
                    Trace.fireTrace(4, new StringBuilder(120).append("[JCoAPI] Warning: Pool.clear() was called, although ").append(this.waitingThreads.size()).append(" threads are still waiting in getClient().").toString());
                }
                this.master.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected ClientConnection getClient() throws JCoException {
        ClientConnection client = null;
        if (Trace.isOn(64)) {
            Trace.fireTrace(64, new StringBuilder(100).append("[JCoAPI] Pool.getClient() on pool ").append(this.destinationId).append("                 [enter]").toString());
        }
        ClientConnection clientConnection = this.master;
        synchronized (clientConnection) {
            if (this.capacity > 0 && !this.available.isEmpty()) {
                client = this.available.pop();
                this.allocate(client);
            } else if (this.getNumUsed() < this.peakLimit) {
                client = this.master.clone();
                client.pool = this;
                this.allocate(client);
            } else if (this.maxGetClientTime > 0L) {
                if (Trace.isOn(8)) {
                    Trace.fireTrace(8, "[JCoAPI] Pool.getClient() no connections available " + "[pool size " + this.getCurrentPoolSize() + ", max conns " + this.getPeakLimit() + ", waiting threads " + this.getNumWaitingThreads() + ", currently used " + this.getNumUsed() + "]");
                }
                long duration = this.maxGetClientTime;
                try {
                    if (this.waitingThreads == null) {
                        this.waitingThreads = new ObjectList();
                    }
                    this.waitingThreads.add(Thread.currentThread());
                    while (client == null && duration > 0L) {
                        long t0 = System.currentTimeMillis();
                        this.master.wait(duration);
                        int num_available = Math.min(this.capacity - this.getNumUsed(), this.waitingThreads.size());
                        for (int i = 0; i < num_available; ++i) {
                            if (this.waitingThreads.get(i) != Thread.currentThread()) continue;
                            this.waitingThreads.remove(Thread.currentThread());
                            if (this.waitingThreads.size() == 0) {
                                this.waitingThreads = null;
                            }
                            if (this.capacity > 0 && !this.available.isEmpty()) {
                                client = this.available.pop();
                                this.allocate(client);
                                break;
                            }
                            if (this.getNumUsed() >= this.peakLimit) break;
                            client = this.master.clone();
                            client.pool = this;
                            this.allocate(client);
                            break;
                        }
                        duration -= System.currentTimeMillis() - t0;
                    }
                }
                catch (InterruptedException ex) {
                    this.waitingThreads.remove(Thread.currentThread());
                    if (this.waitingThreads.size() == 0) {
                        this.waitingThreads = null;
                    }
                    if (Trace.isOn(4)) {
                        Trace.fireTrace(4, new StringBuilder(100).append("[JCoAPI] Pool.getClient(): wait(").append(duration).append(") caused ").append(ex.toString()).toString());
                    }
                    throw new JCoException(106, "JCO_ERROR_RESOURCE", ex.toString(), ex);
                }
            }
            if (client == null) {
                this.lastActiveTimestamp = System.currentTimeMillis();
                JCoException ex = new JCoException(106, "JCO_ERROR_RESOURCE", new StringBuffer("Connection pool ").append(this.destinationId).append(" is exhausted. The current pool size limit is ").append(this.peakLimit).append(" connections.").append(JCoRuntime.CRLF).append(this.describeAllocatedClients(this.allocated)).toString());
                if (Trace.isOn(4)) {
                    Trace.fireTrace(4, new StringBuilder(100).append("[JCoAPI] Pool.getClient(): No clients available. ").append(ex.toString()).toString());
                }
                throw ex;
            }
            this.setMaxUsed(this.getNumUsed());
        }
        try {
            if (client.isValid() && !client.middleware.isAlive(client)) {
                client.disconnect(true);
            }
            if ((client.state & 2) == 0) {
                client.connect();
            }
        }
        catch (JCoException ex) {
            ClientConnection clientConnection2 = this.master;
            synchronized (clientConnection2) {
                this.deallocate(client);
                this.master.notifyAll();
            }
            if (Trace.isOn(4)) {
                Trace.fireTrace(4, new StringBuilder(100).append("[JCoAPI] Pool.getClient(): ").append(ex.toString()).toString());
            }
            throw ex;
        }
        client.state = (byte)(client.state | 0x10);
        if (Trace.isOn(64)) {
            Trace.fireTrace(64, "[JCoAPI] Pool.getClient() returns [" + client.getConnectionHandle() + "|" + client.getConversationID() + "]     [leave]", Trace.isOn(32));
        }
        return client;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected final void releaseClient(ClientConnection client) throws JCoException {
        ClientConnection clientConnection;
        if (Trace.isOn(64)) {
            Trace.fireTrace(64, new StringBuilder(100).append("[JCoAPI] Pool.releaseClient([").append(client.getConnectionHandle()).append("]) in pool ").append(this.destinationId).append(" [pool size ").append(this.getCurrentPoolSize()).append(", max connections ").append(this.getPeakLimit()).append(", waiting threads ").append(this.getNumWaitingThreads()).append(", currently used ").append(this.getNumUsed()).append("]").toString());
        }
        if (client == null) {
            return;
        }
        if (client.pool == null) {
            client.disconnect(false);
            return;
        }
        ClientConnection clientConnection2 = client;
        synchronized (clientConnection2) {
            if ((client.state & 0x10) == 0) {
                return;
            }
            client.acquireBusyState("release");
            client.state = (byte)(client.state & 0xFFFFFFEF);
        }
        try {
            char partnerType = this.getAttributes().getPartnerType();
            if (this.capacity <= 0 || partnerType == 'E' || partnerType == 'R' || !client.isAlive()) {
                client.state = (byte)(client.state & 0xFFFFFFFD);
                client.middleware.disconnect(client);
            } else {
                try {
                    client.internalReset();
                }
                catch (JCoException ex) {
                    if (Trace.isOn(4)) {
                        Trace.fireTrace(4, new StringBuilder(100).append("[JCoAPI] Pool.releaseClient [").append(client.getConnectionHandle()).append("] failed with ").append(ex.toString()).toString());
                    }
                    client.middleware.disconnect(client);
                    throw ex;
                }
            }
            Object var5_6 = null;
            client.releaseBusyState();
            clientConnection = this.master;
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            client.releaseBusyState();
            ClientConnection clientConnection3 = this.master;
            synchronized (clientConnection3) {
                this.deallocate(client);
                if (client.isValid()) {
                    if (this.available.getLimit() > 0) {
                        client = this.available.push(client);
                    }
                    if (client != null) {
                        try {
                            client.middleware.disconnect(client);
                        }
                        catch (Exception ex) {
                            // empty catch block
                        }
                    }
                }
                this.master.notifyAll();
            }
            throw throwable;
        }
        synchronized (clientConnection) {
            this.deallocate(client);
            if (client.isValid()) {
                if (this.available.getLimit() > 0) {
                    client = this.available.push(client);
                }
                if (client != null) {
                    try {
                        client.middleware.disconnect(client);
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                }
            }
            this.master.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void detachFromPool(ClientConnection client) throws JCoException {
        if (client == null || client.pool == null) {
            return;
        }
        if ((client.state & 0x10) == 0) {
            JCoException ex = new JCoException(106, "JCO_ERROR_RESOURCE", new StringBuilder(100).append("A client that is not allocated from pool cannot be detached.").append(JCoRuntime.CRLF).append("Please, use JCO.getClient(String pool) first.").toString());
            if (Trace.isOn(4)) {
                Trace.fireTrace(4, new StringBuilder(100).append("[JCoAPI] PoolManager.detachFromPool(): ").append(ex.toString()).toString());
            }
            throw ex;
        }
        if (client.pool != this) {
            JCoException ex = new JCoException(106, "JCO_ERROR_RESOURCE", "A client allocated from pool " + client.pool.getName() + " cannot be detached from " + this.getName() + ".");
            if (Trace.isOn(4)) {
                Trace.fireTrace(4, new StringBuilder(100).append("[JCoAPI] PoolManager.detachFromPool(): ").append(ex.toString()).toString());
            }
            throw ex;
        }
        ClientConnection clientConnection = this.master;
        synchronized (clientConnection) {
            this.deallocate(client);
            client.pool = null;
            client.state = (byte)(client.state & 0xFFFFFFEF);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void attachToPool(ClientConnection client, boolean allocate) throws JCoException {
        client.pool = this;
        ClientConnection clientConnection = this.master;
        synchronized (clientConnection) {
            if (allocate) {
                this.allocate(client);
            } else {
                this.releaseClient(client);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected final boolean isTimedOut(long now) {
        if (now < this.nextExpirationCheck) {
            return false;
        }
        boolean isTimedOut = super.isTimedOut(now);
        ClientConnection clientConnection = this.master;
        synchronized (clientConnection) {
            int availableSize = this.available.size();
            if (availableSize > 0) {
                int i = 0;
                while (i < availableSize) {
                    ClientConnection conn = this.available.get(i);
                    if (now - conn.last_active_timestamp > this.expirationTime) {
                        this.available.remove(i);
                        --availableSize;
                        try {
                            conn.disconnect(true);
                        }
                        catch (Exception ex) {
                            if (!Trace.isOn(4)) continue;
                            Trace.fireTrace(4, new StringBuilder(100).append("[JCoAPI] Pool.CheckforTimeout: disconnect caused ").append(ex.toString()).toString());
                        }
                        continue;
                    }
                    ++i;
                }
                isTimedOut = false;
            }
        }
        this.nextExpirationCheck = now + this.getExpirationCheckPeriod();
        return isTimedOut;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void getMonitoredData(List<MonitoredConnectionData> monitoredData) {
        Object availableCopy;
        super.getMonitoredData(monitoredData);
        if (this.available.size() <= 0) {
            return;
        }
        ClientConnection clientConnection = this.master;
        synchronized (clientConnection) {
            availableCopy = this.available.clone();
        }
        ClientConnection conn = (ClientConnection)((LimitedList)availableCopy).pop();
        while (conn != null) {
            MonitoredConnectionData md = conn.getMonitoredData();
            monitoredData.add(md);
            conn = (ClientConnection)((LimitedList)availableCopy).pop();
        }
    }
}

