/*
 * Decompiled with CFR 0.152.
 */
package com.sap.conn.jco.rt;

import com.sap.conn.jco.AbapClassException;
import com.sap.conn.jco.AbapException;
import com.sap.conn.jco.JCoDestination;
import com.sap.conn.jco.JCoException;
import com.sap.conn.jco.JCoFunction;
import com.sap.conn.jco.JCoFunctionTemplate;
import com.sap.conn.jco.JCoListMetaData;
import com.sap.conn.jco.ext.Environment;
import com.sap.conn.jco.rt.DefaultParameterList;
import com.sap.conn.jco.rt.InternalDestination;
import com.sap.conn.jco.rt.JCoRuntime;
import com.sap.conn.jco.util.XMLWriterBase;
import java.io.CharConversionException;
import java.io.Serializable;

public class AbapFunction
implements Serializable,
JCoFunction {
    static final long serialVersionUID = 3000120080918L;
    private String name;
    private DefaultParameterList importParameters;
    private DefaultParameterList exportParameters;
    private DefaultParameterList changingParameters;
    private DefaultParameterList tableParameters;
    private AbapException[] exceptionList;
    private boolean supportingASXML;
    private JCoFunctionTemplate template;
    private AbapClassException.Mode abapClassExceptionMode = AbapClassException.Mode.OFF;

    protected AbapFunction(String name) {
        this(name, null, null, null, null);
    }

    protected AbapFunction(String name, DefaultParameterList input, DefaultParameterList output, DefaultParameterList changing, DefaultParameterList tables) {
        if (input != null && input.metaData.recName == null) {
            input.metaData.recName = "INPUT";
        }
        if (output != null && output.metaData.recName == null) {
            output.metaData.recName = "OUTPUT";
        }
        if (changing != null && changing.metaData.recName == null) {
            changing.metaData.recName = "CHANGING";
        }
        if (tables != null && tables.metaData.recName == null) {
            tables.metaData.recName = "TABLES";
        }
        this.name = name;
        this.importParameters = input;
        this.exportParameters = output;
        this.changingParameters = changing;
        this.tableParameters = tables;
        this.supportingASXML = false;
    }

    protected AbapFunction(JCoFunctionTemplate template) {
        this.name = template.getName();
        JCoListMetaData importMeta = template.getImportParameterList();
        JCoListMetaData exportMeta = template.getExportParameterList();
        JCoListMetaData changingMeta = template.getChangingParameterList();
        JCoListMetaData tablesMeta = template.getTableParameterList();
        this.importParameters = importMeta == null ? null : new DefaultParameterList(importMeta);
        this.exportParameters = exportMeta == null ? null : new DefaultParameterList(exportMeta);
        this.changingParameters = changingMeta == null ? null : new DefaultParameterList(changingMeta);
        this.tableParameters = tablesMeta == null ? null : new DefaultParameterList(tablesMeta);
        this.exceptionList = template.getExceptionList();
        this.supportingASXML = template.supportsASXML();
        this.template = template;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public DefaultParameterList getImportParameterList() {
        return this.importParameters;
    }

    public DefaultParameterList getExportParameterList() {
        return this.exportParameters;
    }

    public DefaultParameterList getChangingParameterList() {
        return this.changingParameters;
    }

    public DefaultParameterList getTableParameterList() {
        return this.tableParameters;
    }

    public AbapException[] getExceptionList() {
        return this.exceptionList;
    }

    public AbapException getException(String key) {
        if (this.exceptionList == null) {
            return null;
        }
        for (int i = 0; i < this.exceptionList.length; ++i) {
            if (!this.exceptionList[i].getKey().equalsIgnoreCase(key)) continue;
            AbapException ex = this.exceptionList[i];
            return new AbapException(ex.getKey(), ex.getMessage() == null ? ex.getKey() : ex.getMessage());
        }
        return null;
    }

    public void setAbapClassExceptionMode(AbapClassException.Mode mode) {
        if (!Environment.inJTS()) {
            this.abapClassExceptionMode = mode;
        }
    }

    public boolean isAbapClassExceptionEnabled() {
        return this.abapClassExceptionMode != AbapClassException.Mode.OFF;
    }

    public AbapClassException.Mode getAbapClassExceptionMode() {
        return this.abapClassExceptionMode;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Name:   " + this.getName() + JCoRuntime.CRLF);
        b.append("Input:\n" + this.importParameters + JCoRuntime.CRLF);
        b.append("Changing:\n" + this.changingParameters + JCoRuntime.CRLF);
        b.append("Output:\n" + this.exportParameters + JCoRuntime.CRLF);
        b.append("Tables:\n" + this.tableParameters + JCoRuntime.CRLF);
        if (this.exceptionList != null) {
            b.append("Exceptions: \n");
            for (int i = 0; i < this.exceptionList.length; ++i) {
                b.append(this.exceptionList[i].getKey() + JCoRuntime.CRLF);
            }
        }
        return b.toString();
    }

    public String toXML() {
        XMLWriterBase xmlWriterBase = new XMLWriterBase();
        StringBuilder b = new StringBuilder();
        String convertedName = null;
        try {
            convertedName = xmlWriterBase.escape(this.name);
        }
        catch (CharConversionException cce) {
            convertedName = this.name;
        }
        b.append('<').append(convertedName).append('>');
        if (this.importParameters != null) {
            b.append(this.importParameters.toXML());
        }
        if (this.changingParameters != null) {
            b.append(this.changingParameters.toXML());
        }
        if (this.exportParameters != null) {
            b.append(this.exportParameters.toXML());
        }
        if (this.tableParameters != null) {
            b.append(this.tableParameters.toXML());
        }
        b.append("</").append(convertedName).append('>');
        return b.toString();
    }

    public void execute(JCoDestination destination) throws JCoException {
        if (destination == null) {
            throw new JCoException(131, "JCO_ERROR_ILLEGAL_ARGUMENT", "Destination equals null is not allowed.");
        }
        ((InternalDestination)destination).execute(this);
    }

    public void execute(JCoDestination destination, String tid) throws JCoException {
        if (destination == null) {
            throw new JCoException(131, "JCO_ERROR_ILLEGAL_ARGUMENT", "Destination equals null is not allowed.");
        }
        ((InternalDestination)destination).execute(this, tid, null);
    }

    public void execute(JCoDestination destination, String tid, String queueName) throws JCoException {
        if (destination == null) {
            throw new JCoException(131, "JCO_ERROR_ILLEGAL_ARGUMENT", "Destination equals null is not allowed.");
        }
        ((InternalDestination)destination).execute(this, tid, queueName);
    }

    boolean supportsASXML() {
        return this.supportingASXML;
    }

    public JCoFunctionTemplate getFunctionTemplate() {
        return this.template;
    }
}

