/*
 * Decompiled with CFR 0.152.
 */
package com.sap.conn.jco.util;

import java.io.IOException;
import java.io.Writer;

public final class FastBufferedWriter
extends Writer {
    char[] buf;
    Writer writer;
    int capacity;
    int pos;

    public FastBufferedWriter(Writer writer) {
        this(writer, 16384);
    }

    public FastBufferedWriter(Writer writer, int capacity) {
        this.writer = writer;
        this.capacity = capacity;
        this.buf = new char[capacity];
        this.pos = 0;
    }

    public void ensureCapacity(int capacity) throws IOException {
        if (this.capacity < capacity) {
            this.flushBuffer();
        }
    }

    public void flush() throws IOException {
        this.flushBuffer();
        this.writer.flush();
    }

    public void close() throws IOException {
        this.flushBuffer();
        this.writer.flush();
        this.writer.close();
    }

    private final void flushBuffer() throws IOException {
        this.writer.write(this.buf, 0, this.pos);
        this.pos = 0;
    }

    public void write(String value, int offset, int len) throws IOException {
        if (value != null) {
            if (len > this.capacity) {
                this.flushBuffer();
                this.writer.write(value, offset, len);
            } else {
                if (this.capacity < this.pos + len) {
                    this.flushBuffer();
                }
                value.getChars(offset, len, this.buf, this.pos);
                this.pos += len;
            }
        }
    }

    public void write(String value) throws IOException {
        if (value != null) {
            int len = value.length();
            if (len > this.capacity) {
                this.flushBuffer();
                this.writer.write(value);
            } else {
                if (this.capacity < this.pos + len) {
                    this.flushBuffer();
                }
                value.getChars(0, len, this.buf, this.pos);
                this.pos += len;
            }
        }
    }

    public void write(char value) throws IOException {
        if (this.capacity < this.pos + 1) {
            this.flushBuffer();
        }
        this.buf[this.pos] = value;
        ++this.pos;
    }

    public void write(char[] value) throws IOException {
        if (value != null) {
            if (value.length > this.capacity) {
                this.flushBuffer();
                this.writer.write(value, 0, value.length);
            } else {
                if (this.capacity < this.pos + value.length) {
                    this.flushBuffer();
                }
                System.arraycopy(value, 0, this.buf, this.pos, value.length);
                this.pos += value.length;
            }
        }
    }

    public void write(char[] value, int offset, int len) throws IOException {
        if (value != null) {
            if (len > this.capacity) {
                this.flushBuffer();
                this.writer.write(value, offset, len);
            } else {
                if (this.capacity < this.pos + len) {
                    this.flushBuffer();
                }
                System.arraycopy(value, offset, this.buf, this.pos, len);
                this.pos += len;
            }
        }
    }
}

