/*
 * Decompiled with CFR 0.152.
 */
package com.sap.conn.rfc.api;

import com.sap.conn.jco.ext.Environment;
import com.sap.conn.jco.rt.JCoRuntime;
import com.sap.conn.rfc.api.RfcAcceptInfo;
import com.sap.conn.rfc.exceptions.RfcException;
import java.util.Properties;

public final class RfcRegisterInfo
extends RfcAcceptInfo {
    protected String tpname;
    protected String gwhost;
    protected String gwserv;
    protected String saprouter;
    protected boolean snc_mode = false;
    protected byte snc_qop;
    protected String snc_myname;
    protected String snc_lib;
    protected String groupKey;
    public static final byte RFC_SNC_QOP_INVALID = 0;
    public static final byte RFC_SNC_QOP_OPEN = 1;
    public static final byte RFC_SNC_QOP_INTEGRITY = 2;
    public static final byte RFC_SNC_QOP_PRIVACY = 3;
    public static final byte RFC_SNC_QOP_DEFAULT = 8;
    public static final byte RFC_SNC_QOP_MAX = 9;

    public String getDestination() {
        return new String(this.tpname);
    }

    public void checkParameters() throws RfcException {
        if (this.tpname == null) {
            throw new RfcException(19, "Required parameter program ID ('progid') is missing" + this.errMsgConnectParams(), 101, 0L, true);
        }
        if (this.gwhost == null) {
            throw new RfcException(19, "Required parameter gateway host ('gwhost') is missing" + this.errMsgConnectParams(), 101, 0L, true);
        }
        if (this.gwserv == null) {
            throw new RfcException(19, "Required parameter gateway service ('gwserv') is missing" + this.errMsgConnectParams(), 101, 0L, true);
        }
        boolean throwException = false;
        int len = this.gwserv.length();
        char c = '\u0000';
        if (len == 4) {
            for (int i = 0; i < len; ++i) {
                c = this.gwserv.charAt(i);
                if (c >= '0' && c <= '9') continue;
                throwException = true;
                break;
            }
        } else if (this.gwserv.startsWith("sapgw")) {
            if (len > 6 && this.gwserv.charAt(5) == '$' && this.gwserv.charAt(6) == '$' && (len == 7 || len == 8 && this.gwserv.charAt(7) == 's')) {
                String sysnrProfile = JCoRuntime.getProfileParameter("SAPSYSTEM");
                if (sysnrProfile == null) {
                    throw new RfcException(19, "'" + this.gwserv + "' as value for 'gwserv' requires SAPSYSTEM to be set in the environment" + this.errMsgConnectParams(), 101, 0L, true);
                }
                if (Environment.inJStartup()) {
                    boolean isDualStack;
                    String instanceName = JCoRuntime.getProfileParameter("INSTANCE_NAME");
                    boolean bl = isDualStack = instanceName != null && instanceName.length() > 0 && instanceName.charAt(0) == 'D';
                    if (!isDualStack) {
                        throw new RfcException(19, "'" + this.gwserv + "' as value for 'gwserv' is only valid in a dual stack environment" + this.errMsgConnectParams(), 101, 0L, true);
                    }
                }
                this.gwserv = len == 7 ? new StringBuilder(7).append("sapgw").append(sysnrProfile).toString() : new StringBuilder(8).append("sapgw").append(sysnrProfile).append('s').toString();
            } else if (len < 7 || len > 8) {
                throwException = true;
            } else {
                for (int i = 5; i < 7; ++i) {
                    c = this.gwserv.charAt(i);
                    if (c >= '0' && c <= '9') continue;
                    throwException = true;
                    break;
                }
                if (len == 8 && this.gwserv.charAt(7) != 's') {
                    throwException = true;
                }
            }
        }
        if (throwException) {
            throw new RfcException(19, "Parameter gateway service ('gwserv') needs to be of format ####, sapgw## or sapgw##s (where # is a digit)" + this.errMsgConnectParams(), 101, 0L, true);
        }
    }

    public String errMsgConnectParams() {
        StringBuilder buf = new StringBuilder(128);
        buf.append("\n    Connection parameters:");
        if (this.tpname != null) {
            buf.append(" TPNAME=").append(this.tpname);
        }
        if (this.gwhost != null) {
            buf.append(" GWHOST=").append(this.gwhost);
        }
        if (this.gwserv != null) {
            buf.append(" GWSERV=").append(this.gwserv);
        }
        if (this.saprouter != null) {
            buf.append(" SAPROUTER='").append(this.saprouter).append('\'');
        }
        if (this.snc_mode) {
            buf.append(" SNC_MODE=1 SNC_MYNAME='").append(this.snc_myname).append('\'');
            if (this.snc_qop != -1) {
                buf.append(" SNC_QOP=").append(this.snc_qop);
            }
        }
        return buf.toString();
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(128);
        buf.append(" -g\"").append(this.gwhost);
        buf.append("\" -x\"").append(this.gwserv);
        buf.append("\" -a\"").append(this.tpname).append('\"');
        if (this.saprouter != null) {
            buf.append(" -r\"").append(this.saprouter).append('\"');
        }
        if (this.snc_mode) {
            buf.append(" -S\"").append(this.snc_myname).append('\"');
            if (this.snc_lib != null) {
                buf.append(" -L\"").append(this.snc_lib).append('\"');
            }
            if (this.snc_qop != -1) {
                buf.append(" -Q\"").append(Byte.toString(this.snc_qop)).append('\"');
            }
        }
        if (this.rfc_trace) {
            buf.append(" -t");
        }
        return buf.toString();
    }

    public void setProperties(Properties props) {
        super.setProperties(props);
        this.groupKey = JCoRuntime.findProperty("jco.server.group_key", props);
        this.tpname = JCoRuntime.findProperty("jco.server.progid", props);
        this.gwhost = JCoRuntime.findProperty("jco.server.gwhost", props);
        this.gwserv = JCoRuntime.findProperty("jco.server.gwserv", props);
        this.saprouter = JCoRuntime.findProperty("jco.server.saprouter", props);
        this.snc_mode = JCoRuntime.toBoolean(JCoRuntime.findProperty("jco.server.snc_mode", props));
        if (this.snc_mode) {
            this.snc_myname = JCoRuntime.findProperty("jco.server.snc_myname", props);
            String qop = JCoRuntime.findProperty("jco.server.snc_qop", props);
            try {
                this.snc_qop = Byte.parseByte(qop);
            }
            catch (Exception ex) {
                this.snc_qop = (byte)8;
            }
            this.snc_lib = JCoRuntime.findProperty("jco.server.snc_lib", props);
        }
    }

    public String getSAPRouter() {
        return this.saprouter;
    }

    public String getGatewayHost() {
        return this.gwhost;
    }

    public String getGatewayService() {
        return this.gwserv;
    }

    public String getProgramID() {
        return this.tpname;
    }

    public boolean usesSNC() {
        return this.snc_mode;
    }

    public String getSNCLibrary() {
        return this.snc_lib;
    }

    public String getSNCMyName() {
        return this.snc_myname;
    }

    public byte getSNCQuality() {
        return this.snc_qop;
    }

    public int getConnectionType() {
        return 12;
    }

    public char getOwnType() {
        return 'R';
    }

    public String getGroupKey() {
        return this.groupKey;
    }
}

