/*
 * Decompiled with CFR 0.152.
 */
package com.sap.conn.jco.rt;

import com.sap.conn.jco.rt.JCoRuntime;
import com.sap.conn.jco.rt.Trace;
import java.util.ArrayList;

public class AutoJobRunner
implements Runnable {
    static long MAX_EXECUTION_PERIOD = Long.MAX_VALUE;
    private ArrayList<AutoJob> jobs = new ArrayList(5);
    private Thread ownThread = null;
    private boolean alive = true;
    private long executionPeriod = MAX_EXECUTION_PERIOD;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initialize() {
        AutoJobRunner autoJobRunner = this;
        synchronized (autoJobRunner) {
            if (this.ownThread == null) {
                this.ownThread = new Thread(JCoRuntime.jcoThreadGroup, this, "JCoTimeoutChecker");
                this.ownThread.setDaemon(true);
                this.ownThread.start();
            }
        }
    }

    void stop() {
        this.alive = false;
        this.refresh();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean addJob(AutoJob job) {
        boolean added = true;
        ArrayList<AutoJob> arrayList = this.jobs;
        synchronized (arrayList) {
            if (this.jobs.contains(job)) {
                added = false;
            } else {
                this.jobs.add(job);
            }
            long jobExecutionPeriod = job.getExecutePeriod();
            if (this.executionPeriod > jobExecutionPeriod) {
                this.executionPeriod = jobExecutionPeriod;
                this.jobs.notify();
            } else if (added && this.jobs.size() == 1) {
                this.jobs.notify();
            }
        }
        return added;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void refresh() {
        ArrayList<AutoJob> arrayList = this.jobs;
        synchronized (arrayList) {
            this.jobs.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean removeJob(AutoJob job) {
        ArrayList<AutoJob> arrayList = this.jobs;
        synchronized (arrayList) {
            return this.jobs.remove(job);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (this.alive) {
            ArrayList<AutoJob> arrayList = this.jobs;
            synchronized (arrayList) {
                this.executionPeriod = MAX_EXECUTION_PERIOD;
                for (int i = 0; i < this.jobs.size(); ++i) {
                    try {
                        AutoJob aJob = this.jobs.get(i);
                        long jobExecutionPeriod = aJob.getExecutePeriod();
                        if (this.executionPeriod > jobExecutionPeriod) {
                            this.executionPeriod = jobExecutionPeriod;
                        }
                        if (System.currentTimeMillis() <= aJob.getLastExecutionTime() + jobExecutionPeriod) continue;
                        aJob.execute();
                        continue;
                    }
                    catch (Throwable th) {
                        if (!Trace.isOn(4, true)) continue;
                        Trace.fireTrace(4, "[JCoAPI] WARNING: " + th.getClass().getName() + " occurred in JCoTimeoutChecker background thread", th);
                    }
                }
            }
            try {
                arrayList = this.jobs;
                synchronized (arrayList) {
                    if (this.jobs.isEmpty()) {
                        this.jobs.wait();
                    } else {
                        this.jobs.wait(this.executionPeriod);
                    }
                }
            }
            catch (Exception e) {
                Trace.fireTraceCritical("[JCoAPI] Unexpected " + e.getClass().getName() + " occurred in JCoTimeoutChecker background thread while being in wait()", e);
            }
        }
    }

    static interface AutoJob {
        public void execute() throws Exception;

        public long getExecutePeriod();

        public long getLastExecutionTime();
    }
}

