/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.logging.tools.lv;

import com.sap.tc.logging.tools.lv.CmdOption;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class CmdOptionList {
    static final String METHOD_PREFIX = "parse";
    static final Class OPTION_CLASS = new CmdOption().getClass();
    private List options = null;

    public static CmdOptionList parse(String[] args) {
        return CmdOptionList.parse("-", args, false);
    }

    public static CmdOptionList parse(String[] args, boolean collect) {
        return CmdOptionList.parse("-", args, true);
    }

    public static CmdOptionList parse(String opPrefix, String[] args) {
        return CmdOptionList.parse(opPrefix, args, false);
    }

    public static CmdOptionList parse(String opPrefix, String[] args, boolean collect) {
        CmdOptionList list = new CmdOptionList();
        CmdOption option = new CmdOption(opPrefix + "NoNamePrefix", opPrefix);
        for (int i = 0; i < args.length; ++i) {
            if (args[i].startsWith(opPrefix)) {
                if (collect) {
                    option = list.getOptionByName(args[i]);
                    if (option == null) {
                        option = new CmdOption(args[i], opPrefix);
                    }
                } else {
                    option = new CmdOption(args[i], opPrefix);
                }
            } else {
                option.addValue(args[i]);
            }
            list.addOption(option);
        }
        return list;
    }

    public Iterator getOptions() {
        if (this.options == null) {
            return Collections.EMPTY_LIST.iterator();
        }
        return this.options.iterator();
    }

    public CmdOption getOptionByName(String name) {
        Iterator it = this.getOptions();
        while (it.hasNext()) {
            CmdOption option = (CmdOption)it.next();
            if (!option.getName().equals(name)) continue;
            return option;
        }
        return null;
    }

    public void evaluate(Object obj) throws Exception {
        Map methodMap = this.getParseMethods(obj);
        Iterator it = this.getOptions();
        while (it.hasNext()) {
            CmdOption option = (CmdOption)it.next();
            String methodName = option.getMethodName(METHOD_PREFIX);
            Method method = (Method)methodMap.get(methodName = methodName.toUpperCase());
            if (method == null) {
                throw new IllegalArgumentException(option.toString());
            }
            method.invoke(obj, option);
        }
    }

    public static void main(String[] args) {
        try {
            CmdOptionList col = CmdOptionList.parse(args);
            System.exit(0);
        }
        catch (Exception ex) {
            System.err.println(ex.getMessage());
            System.exit(1);
        }
    }

    void addOption(CmdOption option) {
        if (this.options == null) {
            this.options = new LinkedList();
        }
        this.options.add(option);
    }

    private Map getParseMethods(Object obj) {
        HashMap<String, Method> methMap = new HashMap<String, Method>();
        Method[] methods = obj.getClass().getMethods();
        for (int i = 0; i < methods.length; ++i) {
            Class<?>[] eTypes;
            Class<?>[] pTypes;
            if (!methods[i].getName().startsWith(METHOD_PREFIX) || (pTypes = methods[i].getParameterTypes()).length != 1 || !OPTION_CLASS.isAssignableFrom(pTypes[0]) || (eTypes = methods[i].getExceptionTypes()).length > 1) continue;
            if (eTypes.length == 1) {
                // empty if block
            }
            String methodName = methods[i].getName();
            methodName = methodName.toUpperCase();
            methMap.put(methodName, methods[i]);
        }
        return methMap;
    }
}

