/*
 * Decompiled with CFR 0.152.
 */
package com.sap.conn.jco.util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IntHashTable<E> {
    private Entry<E>[] table;
    private int capacity;
    private int complexity;
    private int maxComplexity;
    private int count;

    public IntHashTable(int initialCapacity, int maxComplexity) {
        this.capacity = Math.max(initialCapacity, 89);
        this.table = new Entry[this.capacity];
        this.maxComplexity = Math.max(maxComplexity, 3);
    }

    public E put(int key, E obj) {
        E removed = this.internalAdd(key, obj);
        if (this.complexity >= this.maxComplexity) {
            this.rehash();
        }
        return removed;
    }

    public int[] keys() {
        int[] result = new int[this.count];
        Entry<E> entry = null;
        int i = this.table.length;
        int j = 0;
        while (i > 0) {
            while (entry == null && i > 0) {
                entry = this.table[--i];
            }
            while (entry != null) {
                result[j] = entry.key;
                ++j;
                entry = entry.next;
            }
        }
        return result;
    }

    public E get(int key) {
        int idx = (key & Integer.MAX_VALUE) % this.capacity;
        Entry<E> entry = this.table[idx];
        while (entry != null) {
            if (entry.key == key) {
                return entry.cntl;
            }
            entry = entry.next;
        }
        return null;
    }

    public E remove(int key) {
        int idx = (key & Integer.MAX_VALUE) % this.capacity;
        Entry<E> entry = this.table[idx];
        if (entry == null) {
            return null;
        }
        if (entry.key == key) {
            this.table[idx] = entry.next;
            --this.count;
            return entry.cntl;
        }
        Entry<E> parent = entry;
        entry = entry.next;
        while (entry != null) {
            if (entry.key == key) {
                parent.next = entry.next;
                --this.count;
                return entry.cntl;
            }
            parent = entry;
            entry = entry.next;
        }
        return null;
    }

    public int size() {
        return this.count;
    }

    private E internalAdd(int key, E cntl) {
        int idx = (key & Integer.MAX_VALUE) % this.capacity;
        Entry<E> entry = this.table[idx];
        int compl = 0;
        if (entry == null) {
            this.table[idx] = new Entry<E>(key, cntl);
            ++this.count;
            return null;
        }
        do {
            ++compl;
            if (entry.key == key) {
                entry.cntl = cntl;
                return entry.cntl;
            }
            Entry<E> parent = entry;
        } while ((entry = entry.next) != null);
        parent.next = new Entry<E>(key, cntl);
        ++this.count;
        if (this.complexity < compl) {
            this.complexity = compl;
        }
        return null;
    }

    private void rehash() {
        block5: {
            int oldCapacity = this.table.length;
            int oldCount = this.count;
            Entry<E>[] oldTable = this.table;
            this.count = 0;
            this.complexity = 0;
            try {
                this.capacity = oldCapacity * 2 + 1;
                this.table = new Entry[this.capacity];
                for (int i = 0; i < oldTable.length; ++i) {
                    Entry<E> entry = oldTable[i];
                    while (entry != null) {
                        this.internalAdd(entry.key, entry.cntl);
                        entry = entry.next;
                    }
                }
            }
            catch (Throwable th) {
                this.table = oldTable;
                this.capacity = oldCapacity;
                this.count = oldCount;
                if (th instanceof Error) {
                    throw (Error)th;
                }
                if (!(th instanceof RuntimeException)) break block5;
                throw (RuntimeException)th;
            }
        }
    }

    public String describe() {
        return "IntHashTable: count " + this.count + ", table size " + this.table.length + ", complexity " + this.complexity;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Entry<E> {
        int key;
        E cntl;
        Entry<E> next;

        Entry(int key, E cntl) {
            this.key = key;
            this.cntl = cntl;
        }
    }
}

