/*
 * Decompiled with CFR 0.152.
 */
package com.sap.conn.jco.server;

import com.sap.conn.jco.JCoRuntimeException;
import com.sap.conn.jco.server.JCoServerContext;
import com.sap.conn.jco.server.JCoServerFunctionHandler;
import com.sap.conn.jco.server.JCoServerFunctionHandlerFactory;
import com.sap.conn.jco.server.JCoServerRequestHandler;
import com.sap.conn.jco.server.JCoServerRequestHandlerFactory;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultServerHandlerFactory<T> {
    public static final String GENERIC_HANDLER = "GENERIC_HANDLER";
    protected Map<String, T> handlers = new HashMap<String, T>();

    public void sessionClosed(JCoServerContext serverCtx, String message, boolean error) {
    }

    public T getCallHandler(JCoServerContext serverCtx, String name) {
        T handler = this.handlers.get(name);
        if (handler == null) {
            handler = this.handlers.get(GENERIC_HANDLER);
        }
        if (handler == null) {
            throw new JCoRuntimeException(105, "JCO_ERROR_APPLICATION_EXCEPTION", "handler for " + name + " was not installed");
        }
        return handler;
    }

    public void registerGenericHandler(T handler) throws RuntimeException {
        this.registerHandler(GENERIC_HANDLER, handler);
    }

    public void registerHandler(String functionName, T handler) throws RuntimeException {
        if (handler == null) {
            throw new RuntimeException("Handler equals null is not allowed.");
        }
        T removed = this.handlers.put(functionName, handler);
        if (removed != null) {
            this.handlers.put(functionName, removed);
            throw new RuntimeException("Handler for " + functionName + " is already defined. Use removeHandler.");
        }
    }

    public void removeHandler(String functionName) throws RuntimeException {
        T removed = this.handlers.remove(functionName);
        if (removed == null) {
            throw new RuntimeException("Handler for " + functionName + " was not defined. Nothing to remove.");
        }
    }

    public void removeGenericHandler() throws RuntimeException {
        this.removeHandler(GENERIC_HANDLER);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class RequestHandlerFactory
    extends DefaultServerHandlerFactory<JCoServerRequestHandler>
    implements JCoServerRequestHandlerFactory {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class FunctionHandlerFactory
    extends DefaultServerHandlerFactory<JCoServerFunctionHandler>
    implements JCoServerFunctionHandlerFactory {
    }
}

