/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.logging.perf;

import com.sap.tc.logging.Category;
import com.sap.tc.logging.FileLog;
import com.sap.tc.logging.Location;
import com.sap.tc.logging.Log;
import com.sap.tc.logging.perf.ISatRecord;
import com.sap.tc.logging.perf.PerfFormatter;
import com.sap.tc.logging.perf.SatRecord;

public class PerfTracing {
    public static final String DEF_LOC_NAME = "SATRecorder";
    public static final String DEF_CAT_NAME = "/Performance";
    public static final String DEF_FILE_PATH = "./log/sat.trc";
    static final Category catWrp = Category.PERFORMANCE;
    static final Location LC = Location.getLocation("SATRecorder", "tc~logging~java", "BC-JAS-ADM-LOG-API");
    private static Log cLog;
    private String logPath = "./log/sat.trc";

    public PerfTracing() {
        this.init();
    }

    public PerfTracing(String logPath) {
        this.logPath = logPath;
        this.init();
    }

    private void init() {
        if (catWrp.getLogs().size() == 0) {
            cLog = new FileLog(this.logPath, 10000000, 10);
            cLog.setFormatter(new PerfFormatter());
            catWrp.addLog(cLog);
        }
        catWrp.setEffectiveSeverity(0);
    }

    public void logWrite(ISatRecord record) {
        catWrp.infoT(LC, "SATRecord", ((SatRecord)record).getLogArray());
    }
}

