/*
 * Decompiled with CFR 0.152.
 */
package com.sap.conn.jco.rt;

import com.sap.conn.jco.rt.AutoJobRunner;
import com.sap.conn.jco.rt.ClientFactory;
import com.sap.conn.jco.rt.ConnectionManager;
import java.util.ArrayList;

public class DefaultTimeoutChecker
implements AutoJobRunner.AutoJob {
    private static final long minCheckPeriod = 120000L;
    private static final long maxCheckPeriod = 600000L;
    private ArrayList<ClientFactory> clientFactories = new ArrayList();
    private ArrayList<ClientFactory> toAdd = new ArrayList();
    private long checkPeriod = 600000L;
    private long lastExecution = 0L;
    private ConnectionManager connManager = ConnectionManager.getConnectionManager();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void addPool(ClientFactory pool) {
        ArrayList<ClientFactory> arrayList = this.toAdd;
        synchronized (arrayList) {
            this.toAdd.add(pool);
            if (pool.getExpirationCheckPeriod() < this.checkPeriod) {
                this.checkPeriod = pool.getExpirationCheckPeriod();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void execute() {
        this.lastExecution = System.currentTimeMillis();
        boolean isTimedOut = false;
        boolean recomputeCheckPeriod = false;
        ArrayList<ClientFactory> arrayList = this.clientFactories;
        synchronized (arrayList) {
            ClientFactory factory;
            ArrayList<ClientFactory> arrayList2 = this.toAdd;
            synchronized (arrayList2) {
                int toAddSize = this.toAdd.size();
                if (toAddSize > 0) {
                    for (int i = toAddSize - 1; i >= 0; --i) {
                        factory = this.toAdd.remove(i);
                        if (this.connManager.getFactoryByDestinationID(factory.getDestinationID()) == null || this.clientFactories.contains(factory)) continue;
                        this.clientFactories.add(factory);
                    }
                    recomputeCheckPeriod = true;
                }
            }
            for (int i = this.clientFactories.size() - 1; i >= 0; --i) {
                factory = this.clientFactories.get(i);
                isTimedOut = factory.isTimedOut(this.lastExecution);
                if (!isTimedOut) continue;
                if (this.connManager.removeFactory(factory)) {
                    this.clientFactories.remove(i);
                }
                recomputeCheckPeriod = true;
            }
            if (recomputeCheckPeriod) {
                int size = this.clientFactories.size();
                this.checkPeriod = 600000L;
                for (int i = 0; i < size; ++i) {
                    long factoryCheckPeriod = this.clientFactories.get(i).getExpirationCheckPeriod();
                    if (factoryCheckPeriod < 120000L) {
                        this.checkPeriod = 120000L;
                        break;
                    }
                    if (factoryCheckPeriod >= this.checkPeriod) continue;
                    this.checkPeriod = factoryCheckPeriod;
                }
            }
        }
    }

    public long getExecutePeriod() {
        return this.checkPeriod;
    }

    public long getLastExecutionTime() {
        return this.lastExecution;
    }
}

