/*
 * Decompiled with CFR 0.152.
 */
package com.sap.conn.rfc.engine;

import com.sap.conn.jco.AbapClassException;
import com.sap.conn.jco.JCoBackgroundUnitAttributes;
import com.sap.conn.jco.JCoFunctionUnitState;
import com.sap.conn.jco.JCoRepository;
import com.sap.conn.jco.JCoUnitIdentifier;
import com.sap.conn.jco.rt.AbapBackgroundUnitAttributes;
import com.sap.conn.jco.rt.AbapFunction;
import com.sap.conn.jco.rt.ComplexParameter;
import com.sap.conn.jco.rt.Converter;
import com.sap.conn.jco.rt.DefaultParameterList;
import com.sap.conn.jco.rt.DefaultStructure;
import com.sap.conn.jco.rt.DefaultTable;
import com.sap.conn.jco.rt.FlatStructure;
import com.sap.conn.jco.rt.Parameter;
import com.sap.conn.jco.rt.StaticFunctionTemplates;
import com.sap.conn.jco.util.I18NConverters;
import com.sap.conn.jco.util.SyncDateFormat;
import com.sap.conn.rfc.api.IRfcParameter;
import com.sap.conn.rfc.api.IRfcTable;
import com.sap.conn.rfc.driver.RfcTypeRecorder;
import com.sap.conn.rfc.engine.AbSysInfo;
import com.sap.conn.rfc.engine.Compress;
import com.sap.conn.rfc.engine.RfcIoControl;
import com.sap.conn.rfc.engine.RfcIoOpenCntl;
import com.sap.conn.rfc.engine.Trc;
import com.sap.conn.rfc.exceptions.RfcException;
import com.sap.i18n.cp.ConvertXToC;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BgRfcUnit {
    public static final int UNIT_KIND_QRFC_OUTINBOUND = 1409196103;
    public static final int UNIT_KIND_TRFC_OUTBOUND = 1409196105;
    public static final int UNIT_KIND_QRFC_OUTBOUND = 1409196101;
    public static final int EXE_STATE_SRV_IN_EXECUTION = 22201;
    public static final int EXE_STATE_SRV_FINISHED = 22202;
    public static final int EXE_STATE_SRV_CONFIRMED = 22203;
    public static final int EXE_STATE_SRV_UNIT_NOT_IN_DB = 22206;
    public static final int EXE_STATE_SRV_SYSTEM_FAILURE = 22205;
    public static final int EXE_STATE_SRV_UNIT_WRONG_STATE = 22209;
    protected static final SyncDateFormat bgRfcTimestamp = new SyncDateFormat("yyyyMMddHHmmss");
    static final String BGRFC_INSTANCE_NAME = AbSysInfo.host + "_JCO_XX";
    RfcIoOpenCntl actCntl;
    RfcIoOpenCntl bgRfcCntl;
    byte[] unitID;
    int unitKind;
    Collection<String> queueNames;
    List<FunctionPayload> functions = new ArrayList<FunctionPayload>();
    private JCoBackgroundUnitAttributes attributes;
    private Converter conv = null;
    private AbapFunction bgRfcDestShip = null;

    public static JCoUnitIdentifier.Type convertUnitType(int unitKind) {
        switch (unitKind) {
            case 1409196105: {
                return JCoUnitIdentifier.Type.TYPE_T;
            }
            case 1409196101: {
                return JCoUnitIdentifier.Type.TYPE_Q;
            }
        }
        throw new RuntimeException("[JCoAPI] Internal error: unknown type of the background unit [" + unitKind + "]. Check for the current version of the Java Connector");
    }

    public static int convertState(JCoFunctionUnitState state) {
        if (state == null) {
            return 22205;
        }
        switch (state) {
            case COMMITTED: {
                return 22202;
            }
            case CONFIRMED: {
                return 22203;
            }
            case NOT_FOUND: {
                return 22206;
            }
            case IN_PROCESS: {
                return 22201;
            }
            case ROLLED_BACK: {
                return 22205;
            }
        }
        throw new RuntimeException("[JCoAPI] Internal error: unknown state of the background unit [" + (Object)((Object)state) + "]. Check for the current version of the Java Connector");
    }

    private BgRfcUnit() {
    }

    public static BgRfcUnit createUnit(RfcIoOpenCntl rfcCntl, byte[] uID) {
        BgRfcUnit unit = new BgRfcUnit();
        unit.actCntl = rfcCntl;
        unit.unitID = uID;
        unit.unitKind = 1409196105;
        return unit;
    }

    public static BgRfcUnit dispatchUnit(RfcIoOpenCntl rfcCntl, JCoRepository repository) throws RfcException {
        BgRfcUnit unit = new BgRfcUnit();
        unit.attributes = new AbapBackgroundUnitAttributes();
        unit.actCntl = rfcCntl;
        unit.dispatchBgRfcDestShip(repository);
        return unit;
    }

    public void setAttributes(JCoBackgroundUnitAttributes unitAttributes) {
        this.attributes = unitAttributes;
    }

    public JCoBackgroundUnitAttributes getAttributes() {
        return this.attributes;
    }

    public void setQueueNames(Collection<String> qNames) {
        this.queueNames = qNames;
        this.unitKind = qNames == null || qNames.isEmpty() ? 1409196105 : 1409196103;
    }

    public int getFunctionCount() {
        return this.functions.size();
    }

    public byte[] getUnitId() {
        return this.unitID;
    }

    public JCoUnitIdentifier.Type getUnitType() {
        return BgRfcUnit.convertUnitType(this.unitKind);
    }

    public void setCurrentFunctionData(int index, RfcIoOpenCntl cntl) {
        this.bgRfcCntl = cntl;
        ((RfcTypeRecorder)cntl.channel).setCurrentFunctionData(this.functions.get(index));
    }

    public void recordCall(String function, IRfcParameter[] exporting, IRfcParameter[] changing, IRfcTable[] tables, boolean supportsASXML, AbapClassException.Mode classExceptionMode) throws RfcException {
        this.bgRfcCntl = RfcIoControl.ab_rfcopen("<bgrfc client>", this.actCntl.destination, 21, null);
        FunctionPayload fData = new FunctionPayload();
        fData.FUNCNAME = function;
        fData.METADATA = supportsASXML ? "basxml=1," : "basxml=0,";
        try {
            try {
                ((RfcTypeRecorder)this.bgRfcCntl.channel).setCurrentFunctionData(fData);
                this.bgRfcCntl.setCodepage(this.actCntl.getCodepage());
                this.bgRfcCntl.setCommunicationCodepage(this.actCntl.getCommunicationCodepage());
                this.bgRfcCntl.pcs = this.actCntl.pcs;
                this.bgRfcCntl.trace = this.actCntl.trace;
                this.bgRfcCntl.stateless = false;
                this.bgRfcCntl.RfcCall(function, exporting, null, changing, tables, supportsASXML, classExceptionMode);
                this.functions.add(fData);
            }
            catch (RfcException ex) {
                this.functions.remove(this.functions.size() - 1);
                Trc.criticalTrace("exception during the serialization", ex);
                throw ex;
            }
            Object var10_8 = null;
            this.bgRfcCntl.RfcClose();
        }
        catch (Throwable throwable) {
            Object var10_9 = null;
            this.bgRfcCntl.RfcClose();
            RfcIoControl.release(this.bgRfcCntl);
            throw throwable;
        }
        RfcIoControl.release(this.bgRfcCntl);
    }

    public void commit(JCoRepository repository) throws RfcException {
        boolean shutdownActive;
        this.conv = new Converter(this.actCntl);
        this.bgRfcDestShip = StaticFunctionTemplates.getBGRFC_DEST_SHIPTemplate().getFunction();
        DefaultParameterList exportParams = this.bgRfcDestShip.getImportParameterList();
        IRfcParameter[] exports = new IRfcParameter[4];
        byte[] flags = new byte[4];
        exports[0] = new ComplexParameter(exportParams.getTable(0), "OUT_IN_QUEUE_NAME_TAB", 0, flags);
        exports[1] = new UnitSerializer(this.functions, exportParams, 1);
        FlatStructure sstateStruct = new FlatStructure(exportParams.getStructure(2), "SSTATE", 2, flags);
        sstateStruct.setConverter(this.conv);
        exports[2] = sstateStruct;
        FlatStructure supportabilityInfo = new FlatStructure(exportParams.getStructure(3), "SUPPORTABILITY_INFO", 3, flags);
        supportabilityInfo.setConverter(this.conv);
        exports[3] = supportabilityInfo;
        DefaultParameterList importParams = this.bgRfcDestShip.getExportParameterList();
        IRfcParameter[] imports = new IRfcParameter[]{new Parameter(importParams, 0, this.conv), new Parameter(importParams, 1, this.conv), new Parameter(importParams, 2, this.conv), new Parameter(importParams, 3, this.conv), new Parameter(importParams, 4, this.conv)};
        DefaultParameterList changingParams = this.bgRfcDestShip.getChangingParameterList();
        IRfcParameter[] chg = new IRfcParameter[]{new Parameter(importParams, 0, this.conv)};
        int unitType = 1409196105;
        if (this.queueNames != null && !this.queueNames.isEmpty()) {
            DefaultTable queueNameTab = exportParams.getTable("OUT_IN_QUEUE_NAME_TAB");
            queueNameTab.appendRows(this.queueNames.size());
            int pos = 0;
            for (String queue : this.queueNames) {
                queueNameTab.setRow(pos);
                queueNameTab.setValue(0, queue);
                ++pos;
            }
            unitType = 1409196103;
        }
        DefaultStructure sstate = exportParams.getStructure(2);
        sstate.setValue("UNIT_ID", this.unitID);
        sstate.setValue("UNIT_KIND", unitType);
        sstate.setValue("DESTINATION", "<Java Connector>");
        sstate.setValue("QUEUE_NAME", "");
        sstate.setValue("STATE", 0);
        sstate.setValue("UNIT_SIZE", 0);
        sstate.setValue("INBOUND_NO_EXEC", ' ');
        sstate.setValue("CALLER_CLIENT", this.attributes.getClient() != null ? this.attributes.getClient() : this.actCntl.mandt);
        sstate.setValue("CALLER_USER", this.attributes.getUserID() != null ? this.attributes.getUserID() : this.actCntl.userid);
        sstate.setValue("CALLER_TCODE", "");
        sstate.setValue("CALLER_PROGRAM", this.attributes.getProgramName() != null ? this.attributes.getProgramName() : this.getProgramName());
        sstate.setValue("SENDING_TIME", bgRfcTimestamp.format(new Date()));
        sstate.setValue("SENDING_INSTANCE", BGRFC_INSTANCE_NAME);
        sstate.setValue("NO_COMMIT_CHECK", this.attributes.isCommitCheckOn() ? (char)' ' : 'X');
        sstate.setValue("INBOUND_NO_EXEC", this.attributes.isUnitLocked() ? (char)'X' : ' ');
        DefaultStructure supInfo = exportParams.getStructure(3);
        supInfo.setValue("UNIT_ID", this.unitID);
        supInfo.setValue("UNIT_KIND", unitType);
        supInfo.setValue("KERNEL_TRACE", this.attributes.isKernelTraceOn() ? (char)'X' : ' ');
        supInfo.setValue("UNIT_HISTORY", this.attributes.isUnitHistoryOn() ? (char)'X' : ' ');
        this.actCntl.RfcCall(this.bgRfcDestShip.getName(), exports, imports, chg, null, false, this.bgRfcDestShip.getAbapClassExceptionMode());
        this.actCntl.RfcReceive(imports, chg, null, repository);
        boolean bl = shutdownActive = changingParams.getChar(0) == 'X';
        if (shutdownActive) {
            String applServer = importParams.getString("SHUTDOWN_INSTANCE");
            throw new RfcException(1, "Application server " + applServer + " is in soft shutdown mode.", 102, this.actCntl.hrfc, false);
        }
    }

    private void dispatchBgRfcDestShip(JCoRepository repository) throws RfcException {
        this.conv = new Converter(this.actCntl);
        this.bgRfcDestShip = StaticFunctionTemplates.getBGRFC_DEST_SHIPTemplate().getFunction();
        DefaultParameterList importParams = this.bgRfcDestShip.getImportParameterList();
        IRfcParameter[] imports = new IRfcParameter[4];
        byte[] flags = new byte[4];
        imports[0] = new ComplexParameter(importParams.getTable(0), "OUT_IN_QUEUE_NAME_TAB", 0, flags);
        imports[1] = new UnitSerializer(this.functions, importParams, 1);
        FlatStructure sstateStruct = new FlatStructure(importParams.getStructure(2), "SSTATE", 2, flags);
        sstateStruct.setConverter(this.conv);
        imports[2] = sstateStruct;
        FlatStructure supportabilityInfo = new FlatStructure(importParams.getStructure(3), "SUPPORTABILITY_INFO", 3, flags);
        supportabilityInfo.setConverter(this.conv);
        imports[3] = supportabilityInfo;
        this.actCntl.RfcGetData(imports, null, null, null, repository);
        DefaultStructure sstate = importParams.getStructure(2);
        this.unitID = sstate.getByteArray("UNIT_ID");
        this.unitKind = sstate.getInt("UNIT_KIND");
        if (this.unitKind == 1409196105 || this.unitKind != 1409196101) {
            // empty if block
        }
    }

    void finishDispatch() throws RfcException {
        DefaultParameterList exportParams = this.bgRfcDestShip.getExportParameterList();
        IRfcParameter[] exports = new IRfcParameter[]{new Parameter(exportParams, 0, this.conv), new Parameter(exportParams, 1, this.conv), new Parameter(exportParams, 2, this.conv), new Parameter(exportParams, 3, this.conv)};
        this.bgRfcDestShip.getExportParameterList().setValue("SERVER_STATE", 22202);
        this.actCntl.RfcSendData(exports, null, null);
    }

    private String getProgramName() {
        StackTraceElement[] stackElems = new Throwable().getStackTrace();
        for (int i = 1; i < stackElems.length; ++i) {
            String className = stackElems[i].getClassName();
            if (className.startsWith("com.sap.conn") || className.startsWith("com.sap.mw") || className.startsWith("sun.reflect") || className.startsWith("java.lang")) continue;
            int lastDot = className.lastIndexOf(46);
            if (lastDot == -1) {
                lastDot = className.length();
            }
            String programName = className.substring(0, lastDot);
            return programName;
        }
        return "external java program";
    }

    static class ByteBuffer {
        byte[] b;
        int off;
        int len;
        private int remainLen = 0;
        private boolean readComplete = true;

        ByteBuffer(int length) {
            this.b = new byte[length];
            this.off = 0;
            this.len = 0;
        }

        boolean readNext(int expectedLen, InputStream in) throws IOException {
            int readBytes = 0;
            if (this.readComplete) {
                this.off += this.remainLen;
                this.len -= this.remainLen;
            } else {
                this.len = 0;
                this.off = 0;
                expectedLen = this.remainLen - this.b.length;
            }
            this.readComplete = true;
            this.remainLen = expectedLen;
            if (this.len < expectedLen) {
                if (this.len > 0 && this.off > 0) {
                    int last = this.off + this.len;
                    int i = this.off;
                    int j = 0;
                    while (i < last) {
                        this.b[j] = this.b[i];
                        ++i;
                        ++j;
                    }
                }
                this.off = 0;
                if (expectedLen > this.b.length) {
                    expectedLen = this.b.length;
                    this.readComplete = false;
                }
                while (this.len < expectedLen) {
                    readBytes = in.read(this.b, this.len, expectedLen - this.len);
                    if (readBytes < 0) {
                        throw new IOException("unexpected end of stream: expected length is " + expectedLen + ", read from stream " + this.len);
                    }
                    this.len += readBytes;
                }
            }
            return this.readComplete;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class UnitSerializer
    extends Parameter {
        private static final byte[] TRANSPORT_HEADER = UnitSerializer.getTransportHeader();
        private static final int TRANSPORT_LENGTH = 16;
        private static final byte[] PREQUEL_BYTES = UnitSerializer.getPrequelBytes();
        private static final int OBJECT_HEADER_UNI_LENGTH = 32;
        private static final int DATA_DESCRIPTION_UNI = 7;
        private static final int LENGTH_TAB_DESCRIPTION = 9;
        private static final int LENGTH_UNI_DESCRIPTION = 5;
        private static final int LENGTH_END_OF_DESCRIPTION = 1;
        private static final byte descrID_INC_BEG = -96;
        private static final byte descrID_INC_END = -95;
        private static final byte descrID_BOX_BEG = -94;
        private static final byte descrID_BOX_END = -93;
        private static final byte descrID_VAL = -86;
        private static final byte descrID_STR_BEG = -85;
        private static final byte descrID_STR_END = -84;
        private static final byte descrID_TAB_BEG = -83;
        private static final byte descrID_TAB_END = -82;
        private static final byte descrID_ALIGN = -81;
        private static final byte valueID_INT_BEG = -68;
        private static final byte valueID_INT_END = -67;
        private static final byte valueID_TAB_BEG = -66;
        private static final byte valueID_TAB_END = -65;
        private static final byte valueID_STRING_BEG = -54;
        private static final byte valueID_STRING_END = -53;
        private static final byte objID_END = 4;
        private static final int COMPRESS_ACT = 2;
        private static final int COMPRESS_INACT = 1;
        private static final byte[] empty4bytes = new byte[]{0, 0, 0, 0};
        List<FunctionPayload> functions;
        boolean compressionOn = true;
        int numBytes = 0;

        public UnitSerializer(List<FunctionPayload> functions, DefaultParameterList parameterList, int index) {
            super(parameterList, index, null);
            this.functions = functions;
        }

        public void setCompression(boolean on) {
            this.compressionOn = on;
        }

        @Override
        public byte[] getBytes() {
            byte[] result = this.exportFunctionData().toByteArray();
            this.numBytes = result.length;
            return result;
        }

        @Override
        public int getNumBytes() {
            return this.numBytes;
        }

        @Override
        public void setBytes(byte[] rfcBytes) {
            ByteArrayInputStream bais = new ByteArrayInputStream(rfcBytes);
            this.importFunctionData(this.functions, bais);
            this.numBytes = rfcBytes.length;
        }

        private void importFunctionData(List<FunctionPayload> fList, InputStream in) {
            ByteBuffer buf = new ByteBuffer(1024);
            try {
                buf.readNext(16, in);
                if (buf.b[0] != -1) {
                    throw new RuntimeException("incorrect id value: expected 0xFF, got " + Integer.toHexString(buf.b[0]));
                }
                if (buf.b[1] != 6) {
                    throw new RuntimeException("incorrect version: expected 0x06, got " + Integer.toHexString(buf.b[1]));
                }
                boolean compressed = buf.b[4] == 2;
                String codepage = new String(buf.b, 8, 4, "US-ASCII");
                boolean isUnicode = codepage.charAt(0) == '4' && codepage.charAt(1) == '1';
                ConvertXToC x2cConverter = I18NConverters.getConvertXToC(codepage);
                if (compressed) {
                    Compress.CsInputStream csIn = new Compress.CsInputStream(in);
                    in = csIn;
                }
                buf.readNext(32, in);
                int intValue = buf.b[buf.off + 11];
                if (isUnicode) {
                    intValue *= 2;
                }
                buf.readNext(intValue, in);
                int openedTags = 0;
                do {
                    buf.readNext(7, in);
                    switch (buf.b[buf.off]) {
                        case -96: 
                        case -94: 
                        case -85: 
                        case -83: {
                            ++openedTags;
                            break;
                        }
                        case -95: 
                        case -93: 
                        case -84: 
                        case -82: {
                            --openedTags;
                            break;
                        }
                    }
                } while (openedTags > 0);
                buf.readNext(9, in);
                int functionCount = UnitSerializer.getIntFromBuffer(buf.b, buf.off + 5, true);
                for (int functionIdx = 0; functionIdx < functionCount; ++functionIdx) {
                    FunctionPayload fData = new FunctionPayload();
                    fList.add(fData);
                    buf.readNext(5, in);
                    intValue = UnitSerializer.getIntFromBuffer(buf.b, buf.off + 1, true);
                    buf.readNext(intValue, in);
                    char[] FUNCTIONNAME = x2cConverter.ConvertArr(buf.b, buf.off, buf.len);
                    fData.FUNCNAME = new String(FUNCTIONNAME);
                    buf.readNext(1, in);
                    buf.readNext(5, in);
                    intValue = UnitSerializer.getIntFromBuffer(buf.b, buf.off + 1, true);
                    buf.readNext(intValue, in);
                    char[] METADATA = x2cConverter.ConvertArr(buf.b, buf.off, buf.len);
                    fData.METADATA = new String(METADATA);
                    buf.readNext(1, in);
                    buf.readNext(1, in);
                    if (buf.b[buf.off] == -68) {
                        buf.readNext(4, in);
                        intValue = UnitSerializer.getIntFromBuffer(buf.b, buf.off, true);
                        buf.readNext(intValue + 1 + 1, in);
                    }
                    buf.readNext(8, in);
                    int blockCount = UnitSerializer.getIntFromBuffer(buf.b, buf.off + 4, true);
                    for (int blockIdx = 0; blockIdx < blockCount; ++blockIdx) {
                        boolean readComplete;
                        buf.readNext(5, in);
                        intValue = UnitSerializer.getIntFromBuffer(buf.b, buf.off + 1, true);
                        buf.readNext(intValue, in);
                        buf.readNext(1, in);
                        buf.readNext(5, in);
                        intValue = UnitSerializer.getIntFromBuffer(buf.b, buf.off + 1, true);
                        byte[] data = new byte[intValue];
                        int dataPos = 0;
                        do {
                            readComplete = buf.readNext(intValue, in);
                            System.arraycopy(buf.b, buf.off, data, dataPos, buf.len);
                            dataPos += buf.len;
                        } while (!readComplete);
                        fData.add(data);
                        buf.readNext(1, in);
                    }
                    buf.readNext(1, in);
                }
                buf.readNext(2, in);
            }
            catch (Exception e) {
                throw new RuntimeException("caused by " + e.toString(), e);
            }
        }

        private ByteArrayOutputStream exportFunctionData() throws RuntimeException {
            byte[] intervalDescriptionTab = new byte[9];
            byte[] intervalDescriptionUni = new byte[5];
            byte[] functionName = new byte[60];
            byte[] end = new byte[1];
            try {
                OutputStream out;
                int totalLength;
                ByteArrayOutputStream baos = new ByteArrayOutputStream(1024);
                byte[] transportHeader = TRANSPORT_HEADER;
                byte[] prequel = PREQUEL_BYTES;
                if (this.compressionOn) {
                    baos.write(transportHeader);
                    totalLength = this.computeByteLength();
                    Compress.CsOutputStream csOut = new Compress.CsOutputStream(baos, totalLength);
                    out = csOut;
                } else {
                    transportHeader = UnitSerializer.getTransportHeader();
                    transportHeader[4] = 1;
                    baos.write(transportHeader);
                    prequel = UnitSerializer.getPrequelBytes();
                    totalLength = this.computeByteLength();
                    this.copyIntToBuffer(prequel, 7, totalLength);
                    out = baos;
                }
                out.write(prequel, 0, prequel.length);
                intervalDescriptionTab[0] = -66;
                this.copyIntToBuffer(intervalDescriptionTab, 1, 80);
                int functionsCount = this.functions.size();
                this.copyIntToBuffer(intervalDescriptionTab, 5, functionsCount);
                out.write(intervalDescriptionTab, 0, intervalDescriptionTab.length);
                for (int i = 0; i < functionsCount; ++i) {
                    FunctionPayload functionData = this.functions.get(i);
                    this.setStartTag(intervalDescriptionUni, (byte)-68, 60, -1);
                    out.write(intervalDescriptionUni, 0, intervalDescriptionUni.length);
                    this.copyStringIntoBuffer(functionName, functionData.FUNCNAME);
                    out.write(functionName, 0, functionName.length);
                    end[0] = -67;
                    out.write(end, 0, end.length);
                    byte[] metadataString = functionData.METADATA.getBytes("UTF-16BE");
                    this.setStartTag(intervalDescriptionUni, (byte)-54, metadataString.length, -1);
                    out.write(intervalDescriptionUni, 0, intervalDescriptionUni.length);
                    out.write(metadataString, 0, metadataString.length);
                    end[0] = -53;
                    out.write(end, 0, end.length);
                    this.setStartTag(intervalDescriptionUni, (byte)-68, 4, -1);
                    out.write(intervalDescriptionUni, 0, intervalDescriptionUni.length);
                    out.write(empty4bytes, 0, empty4bytes.length);
                    end[0] = -67;
                    out.write(end, 0, end.length);
                    int blockCount = functionData.data.size();
                    this.setStartTag(intervalDescriptionTab, (byte)-66, 12, blockCount);
                    out.write(intervalDescriptionTab, 0, intervalDescriptionTab.length);
                    for (int block = 0; block < blockCount; ++block) {
                        this.setStartTag(intervalDescriptionUni, (byte)-68, 4, -1);
                        out.write(intervalDescriptionUni, 0, intervalDescriptionUni.length);
                        this.copyIntToBuffer(intervalDescriptionUni, 0, block + 1);
                        out.write(intervalDescriptionUni, 0, 4);
                        end[0] = -67;
                        out.write(end, 0, end.length);
                        byte[] blockBytes = functionData.data.get(block);
                        this.setStartTag(intervalDescriptionUni, (byte)-54, blockBytes.length, -1);
                        out.write(intervalDescriptionUni, 0, intervalDescriptionUni.length);
                        out.write(blockBytes, 0, blockBytes.length);
                        end[0] = -53;
                        out.write(end, 0, end.length);
                    }
                    end[0] = -65;
                    out.write(end, 0, end.length);
                }
                end[0] = -65;
                out.write(end, 0, end.length);
                end[0] = 4;
                out.write(end, 0, end.length);
                out.flush();
                out.close();
                return baos;
            }
            catch (IOException e) {
                throw new RuntimeException("caused by " + e.toString(), e);
            }
        }

        private void setStartTag(byte[] buffer, byte marker, int length, int count) {
            buffer[0] = marker;
            this.copyIntToBuffer(buffer, 1, length);
            if (buffer.length > 5) {
                this.copyIntToBuffer(buffer, 5, count);
            }
        }

        private void copyIntToBuffer(byte[] buffer, int offset, int intValue) {
            buffer[offset] = (byte)(0xFF & intValue >> 24);
            buffer[++offset] = (byte)(0xFF & intValue >> 16);
            buffer[++offset] = (byte)(0xFF & intValue >> 8);
            buffer[++offset] = (byte)(0xFF & intValue);
        }

        private static int getIntFromBuffer(byte[] buffer, int offset, boolean big) {
            int result = 0;
            if (big) {
                result = (0xFF & buffer[offset]) << 24;
                result |= (0xFF & buffer[++offset]) << 16;
                result |= (0xFF & buffer[++offset]) << 8;
                result |= 0xFF & buffer[++offset];
            } else {
                result = 0xFF & buffer[offset];
                result |= (0xFF & buffer[++offset]) << 8;
                result |= (0xFF & buffer[++offset]) << 16;
                result |= (0xFF & buffer[++offset]) << 24;
            }
            return result;
        }

        private void copyStringIntoBuffer(byte[] buffer, String string) {
            int i;
            int strLen = string.length();
            int maxLen = buffer.length / 2;
            for (i = 0; i < strLen; ++i) {
                char ch = string.charAt(i);
                buffer[2 * i] = (byte)(0xFF & ch >> 8);
                buffer[2 * i + 1] = (byte)(0xFF & ch);
            }
            while (i < maxLen) {
                buffer[2 * i] = 0;
                buffer[2 * i + 1] = 32;
                ++i;
            }
        }

        private int computeByteLength() {
            int len = 130;
            for (FunctionPayload fd : this.functions) {
                len += 71 + fd.METADATA.length() * 2 + 1 + 5 + 4 + 1 + 9;
                for (byte[] bytes : fd.data) {
                    len += 15 + bytes.length + 1;
                }
                ++len;
            }
            return len;
        }

        private static byte[] getTransportHeader() {
            byte[] header = new byte[]{-1, 6, 1, 1, 2, 2, -128, 0, 52, 49, 48, 50, 0, 0, 0, 0};
            return header;
        }

        private static byte[] getPrequelBytes() {
            byte[] bytes = new byte[119];
            byte[] objHead1 = new byte[]{6, 15, 0, 0, 0, 0, 80, 0, 0, 0, 0, 12, 0, 0, 0, 0};
            byte[] objHead2 = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
            byte[] serUnitT = new byte[]{0, 83, 0, 69, 0, 82, 0, 95, 0, 85, 0, 78, 0, 73, 0, 84, 0, 95, 0, 84, 0, 65, 0, 66};
            byte[] descr1 = new byte[]{-83, 15, 0, 0, 0, 0, 80, -86, 0, 0, 0, 0, 0, 60, -86, 19};
            byte[] descr2 = new byte[]{0, 0, 0, 0, 8, -81, 4, 0, 0, 0, 0, 4, -83, 15, 0, 0};
            byte[] descr3 = new byte[]{0, 0, 12, -86, 8, 0, 0, 0, 0, 4, -86, 20, 0, 0, 0, 0};
            byte[] descr4 = new byte[]{8, -82, 15, 0, 0, 0, 0, 12, -82, 15, 0, 0, 0, 0, 80};
            int offset = 0;
            System.arraycopy(objHead1, 0, bytes, offset, objHead1.length);
            System.arraycopy(objHead2, 0, bytes, offset += objHead1.length, objHead2.length);
            System.arraycopy(serUnitT, 0, bytes, offset += objHead2.length, serUnitT.length);
            System.arraycopy(descr1, 0, bytes, offset += serUnitT.length, descr1.length);
            System.arraycopy(descr2, 0, bytes, offset += descr1.length, descr2.length);
            System.arraycopy(descr3, 0, bytes, offset += descr2.length, descr3.length);
            System.arraycopy(descr4, 0, bytes, offset += descr3.length, descr4.length);
            offset += descr4.length;
            return bytes;
        }
    }

    public static class FunctionPayload {
        public String FUNCNAME;
        public String METADATA;
        public List<byte[]> data = new ArrayList<byte[]>(10);

        void reset() {
            this.FUNCNAME = "";
            this.METADATA = "";
            this.data.clear();
        }

        public void add(byte[] rfcBytes) {
            this.data.add(rfcBytes);
        }

        public byte[] get(int i) {
            return this.data.get(i);
        }

        public int size() {
            return this.data.size();
        }
    }
}

