/*
 * Decompiled with CFR 0.152.
 */
package com.sap.conn.rfc.engine;

import com.sap.conn.jco.util.I18NConverters;
import com.sap.conn.rfc.api.IRfcFunction;
import com.sap.conn.rfc.engine.RfcGet;
import com.sap.conn.rfc.engine.RfcGetInfo;
import com.sap.conn.rfc.engine.RfcIoOpenCntl;
import com.sap.conn.rfc.engine.RfcValInfo;
import com.sap.conn.rfc.engine.Trc;
import com.sap.conn.rfc.exceptions.RfcException;
import com.sap.conn.rfc.exceptions.RfcGetException;
import com.sap.conn.rfc.sysfunc.RfcDocu;
import com.sap.conn.rfc.sysfunc.RfcJPing;
import com.sap.conn.rfc.sysfunc.RfcPing;
import com.sap.conn.rfc.sysfunc.RfcSetRegServerProperty;
import com.sap.conn.rfc.sysfunc.RfcSystemInfo;
import com.sap.i18n.cp.ConvertXToC;
import java.util.Enumeration;
import java.util.Hashtable;

public abstract class RfcGetName {
    private static Hashtable<String, IRfcFunction> m_installedFunctions = new Hashtable(17);

    public static void installFunction(IRfcFunction function) {
        String name = function.getName();
        m_installedFunctions.put(name, function);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IRfcFunction[] getInstalledFunctions() {
        Hashtable<String, IRfcFunction> hashtable = m_installedFunctions;
        synchronized (hashtable) {
            Enumeration<IRfcFunction> functionEnum = m_installedFunctions.elements();
            IRfcFunction[] functions = new IRfcFunction[m_installedFunctions.size()];
            int i = 0;
            while (functionEnum.hasMoreElements()) {
                functions[i] = functionEnum.nextElement();
                ++i;
            }
            return functions;
        }
    }

    public static IRfcFunction search_function(String name) {
        IRfcFunction func = m_installedFunctions.get(name);
        return func;
    }

    public static String ab_RfcDispatchLoc(RfcIoOpenCntl act_cntl) throws RfcException {
        String funcName = null;
        IRfcFunction funcPtr = null;
        funcName = RfcGetName.ab_RfcGetName(act_cntl);
        funcPtr = RfcGetName.search_function(funcName);
        if (funcPtr == null) {
            return funcName;
        }
        if (act_cntl.trace) {
            String msg = ">>>> [" + act_cntl.hrfc + "] Dispatching call to builtin system function: " + funcName + "\n";
            Trc.ab_rfctrc(msg);
        }
        funcPtr.execute(act_cntl);
        return null;
    }

    private static char[] ab_rfcxfname(RfcIoOpenCntl act_cntl) throws RfcGetException {
        RfcGetInfo rfcget_info = new RfcGetInfo();
        RfcValInfo val_info = new RfcValInfo();
        RfcGet.RfcGetState initstate = RfcGet.RfcGetState.FUNCTIONNAME;
        byte[] fname = new byte[64];
        char[] result = null;
        rfcget_info.fbInfo = val_info;
        val_info.RfcSetValInfoScalar(fname, fname.length);
        RfcGet.ab_rfcget(act_cntl, initstate, rfcget_info);
        try {
            ConvertXToC conv = I18NConverters.getConvertXToC(act_cntl.charset);
            result = conv.ConvertArr(fname, 0, val_info.imp_leng);
        }
        catch (Exception ex) {
            String msg = "  Error> ab_rfcxfname[" + act_cntl.hrfc + "]: " + ex.getMessage();
            throw new RfcGetException(14, msg, ex);
        }
        return result;
    }

    public static String ab_RfcGetName(RfcIoOpenCntl act_cntl) throws RfcException {
        int strLen;
        char[] fname = new char[64];
        try {
            fname = RfcGetName.ab_rfcxfname(act_cntl);
        }
        catch (RfcGetException getEx) {
            String msg = "ab_RfcGetName failed: " + getEx.getMessage();
            switch (getEx.getRc()) {
                case 11: {
                    if (act_cntl.trace) {
                        Trc.ab_rfctrc("ab_rfcGetName [" + act_cntl.hrfc + "] connection closed \n");
                    }
                    throw new RfcException(6, msg, getEx.getErrorGroup(), 0L, false, getEx);
                }
                case 19: {
                    if (act_cntl.trace) {
                        Trc.ab_rfctrc("   ERROR: ab_rfcGetName [" + act_cntl.hrfc + "]\n");
                        Trc.ab_rfctrc("   Invalid protocol version detected\n");
                    }
                    throw new RfcException(22, msg, getEx.getErrorGroup(), 0L, false, getEx);
                }
                case 14: {
                    if (act_cntl.trace) {
                        Trc.ab_rfctrc("   ERROR: ab_rfcGetName [" + act_cntl.hrfc + "]\n");
                        Trc.ab_rfctrc("   Conversion error occured\n");
                    }
                    throw new RfcException(21, msg, getEx.getErrorGroup(), 0L, false, getEx);
                }
            }
            if (act_cntl.trace) {
                Trc.ab_rfctrc("   ERROR: ab_rfcGetName [" + act_cntl.hrfc + "]\n");
                Trc.ab_rfctrc("   an error occured. get_rc: " + getEx.getRc() + "\n");
            }
            throw new RfcException(1, msg, getEx.getErrorGroup(), 0L, false, getEx);
        }
        for (strLen = fname.length - 1; strLen >= 0 && fname[strLen] == ' '; --strLen) {
        }
        String trimmedFName = new String(fname, 0, strLen + 1);
        return trimmedFName;
    }

    private static synchronized void install_system_functions() {
        RfcGetName.installFunction(new RfcPing());
        RfcGetName.installFunction(new RfcJPing());
        RfcGetName.installFunction(new RfcSystemInfo());
        RfcGetName.installFunction(new RfcSetRegServerProperty());
        RfcGetName.installFunction(new RfcDocu());
    }

    static {
        try {
            RfcGetName.install_system_functions();
        }
        catch (Exception ex) {
            Trc.criticalTrace("Installation of system functions failed", ex);
        }
        catch (Error e) {
            Trc.criticalTrace("Installation of system functions failed", e);
        }
    }
}

