/*
 * Decompiled with CFR 0.152.
 */
package com.sap.conn.jco.rt;

import com.sap.conn.jco.JCoRuntimeException;
import com.sap.conn.jco.monitor.JCoConnectionData;
import com.sap.conn.jco.monitor.JCoDestinationMonitor;
import com.sap.conn.jco.rt.ClientFactory;
import com.sap.conn.jco.rt.ConnectionManager;
import com.sap.conn.jco.rt.MonitoredConnectionData;
import com.sap.conn.jco.rt.RfcDestination;
import com.sap.conn.jco.rt.Trace;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class RfcDestinationMonitor
implements JCoDestinationMonitor {
    private RfcDestination.ConfigurationState state = RfcDestination.ConfigurationState.VALID;
    private ClientFactory clientFactory = null;
    String destinationId = null;
    String originDestinationId = null;
    long lastActiveTimestamp = 0L;
    int maxUsed = 0;
    int peakLimit = 0;
    int capacity = 0;

    RfcDestinationMonitor(ClientFactory factory) {
        this.destinationId = factory.getDestinationID();
        this.originDestinationId = factory.getOriginDestinationID();
        factory.setDestinationMonitor(this);
        this.clientFactory = factory;
    }

    void markChanged() {
        this.state = RfcDestination.ConfigurationState.CHANGED;
        ClientFactory factory = this.clientFactory;
        if (factory != null) {
            factory.removeDestinationMonitor();
            this.clientFactory = null;
        }
    }

    void markDeleted() {
        this.state = RfcDestination.ConfigurationState.DELETED;
        ClientFactory factory = this.clientFactory;
        if (factory != null) {
            factory.removeDestinationMonitor();
            this.clientFactory = null;
        }
    }

    ClientFactory getClientFactory() {
        ClientFactory factory;
        if (this.state != RfcDestination.ConfigurationState.VALID) {
            String errmsg = new StringBuilder(128).append("Destination monitor is invalid. The monitored destination with ID ").append(this.destinationId).append(" has been ").append(this.state == RfcDestination.ConfigurationState.CHANGED ? "changed." : "removed.").toString();
            if (Trace.isOn(8)) {
                Trace.fireTrace(8, "[JCoAPI] " + errmsg);
            }
            throw new JCoRuntimeException(180, "JCO_ERROR_DESTINATION_DATA_INVALID", errmsg);
        }
        if (this.clientFactory == null && (factory = ConnectionManager.getConnectionManager().getFactoryByDestinationID(this.destinationId)) != null) {
            factory.setMaxUsed(this.maxUsed);
            factory.setDestinationMonitor(this);
            this.clientFactory = factory;
        }
        return this.clientFactory;
    }

    void removeClientFactory(ClientFactory factory) {
        if (this.clientFactory == factory) {
            this.originDestinationId = factory.getOriginDestinationID();
            this.lastActiveTimestamp = factory.getLastActivityTimestamp();
            this.maxUsed = factory.getMaxUsed();
            this.peakLimit = factory.getPeakLimit();
            this.capacity = factory.getCapacity();
            this.clientFactory = null;
        }
    }

    @Override
    public long getLastActivityTimestamp() {
        ClientFactory factory = this.getClientFactory();
        if (factory != null) {
            this.lastActiveTimestamp = factory.getLastActivityTimestamp();
        }
        return this.lastActiveTimestamp;
    }

    @Override
    public int getMaxUsedCount() {
        ClientFactory factory = this.getClientFactory();
        if (factory != null) {
            this.maxUsed = factory.getMaxUsed();
        }
        return this.maxUsed;
    }

    @Override
    public int getPeakLimit() {
        ClientFactory factory = this.getClientFactory();
        if (factory != null) {
            this.peakLimit = factory.getPeakLimit();
        }
        return this.peakLimit;
    }

    @Override
    public int getPoolCapacity() {
        ClientFactory factory = this.getClientFactory();
        if (factory != null) {
            this.capacity = factory.getCapacity();
        }
        return this.capacity;
    }

    @Override
    public int getPooledConnectionCount() {
        ClientFactory factory = this.getClientFactory();
        if (factory != null) {
            return factory.getPooledConnectionCount();
        }
        return 0;
    }

    @Override
    public int getUsedConnectionCount() {
        ClientFactory factory = this.getClientFactory();
        if (factory != null) {
            return factory.getNumUsed();
        }
        return 0;
    }

    @Override
    public int getWaitingThreadCount() {
        ClientFactory factory = this.getClientFactory();
        if (factory != null) {
            return factory.getNumWaitingThreads();
        }
        return 0;
    }

    @Override
    public List<? extends JCoConnectionData> getConnectionsData() {
        ClientFactory factory = this.getClientFactory();
        ArrayList<MonitoredConnectionData> monitoredData = new ArrayList<MonitoredConnectionData>();
        if (factory != null) {
            factory.getMonitoredData(monitoredData);
        }
        return monitoredData;
    }

    @Override
    public String getDestinationID() {
        return this.destinationId;
    }

    @Override
    public String getOriginDestinationID() {
        return this.originDestinationId;
    }

    @Override
    public boolean isValid() {
        return this.state == RfcDestination.ConfigurationState.VALID;
    }
}

