/*
 * Decompiled with CFR 0.152.
 */
package com.sap.conn.jco.rt;

import com.sap.conn.jco.JCoRecordFieldIterator;
import com.sap.conn.jco.JCoRecordMetaData;
import com.sap.conn.jco.JCoStructure;
import com.sap.conn.jco.rt.AbstractRecord;
import com.sap.conn.jco.rt.DefaultRecordFieldIterator;
import com.sap.conn.jco.rt.DefaultRecordMetaData;
import com.sap.conn.jco.rt.JCoRuntime;
import java.io.Serializable;

public class DefaultStructure
extends AbstractRecord
implements JCoStructure {
    static final long serialVersionUID = 3000120080918L;
    protected Type1Record type1Record = null;

    DefaultStructure(JCoRecordMetaData metaData) {
        super(2, metaData);
        if (metaData.isNestedType1Structure()) {
            this.type1Record = new Type1Record();
        }
        int i = 0;
        while (i < this.metaData.numFields) {
            int n = i++;
            this.flags[n] = (byte)(this.flags[n] | 1);
        }
    }

    public DefaultRecordMetaData getRecordMetaData() {
        return (DefaultRecordMetaData)this.metaData;
    }

    protected void copyContent(DefaultStructure src) {
        super.copyContent(src);
        if (src.type1Record != null) {
            this.type1Record = (Type1Record)src.clone();
        }
    }

    public JCoRecordFieldIterator getRecordFieldIterator() {
        return new DefaultRecordFieldIterator(this);
    }

    protected class Type1Record
    implements Cloneable,
    Serializable {
        static final long serialVersionUID = 3000120080918L;
        protected char[] type1Data = JCoRuntime.EMPTY_CHAR_ARRAY;
        protected int type1RowLength = 0;
        protected DefaultRecordMetaData.Type1MetaData type1MetaData;

        protected Type1Record() {
            this.type1MetaData = ((DefaultRecordMetaData)DefaultStructure.this.metaData).type1MetaData;
        }

        public Object clone() {
            try {
                Type1Record obj = (Type1Record)super.clone();
                obj.copy(this);
                return obj;
            }
            catch (CloneNotSupportedException ex) {
                return null;
            }
        }

        protected void copy(Type1Record type1TemplateRecord) {
            if (type1TemplateRecord == null) {
                return;
            }
            this.ensureCapacity(type1TemplateRecord.type1RowLength);
            this.type1RowLength = type1TemplateRecord.type1RowLength;
            System.arraycopy(type1TemplateRecord.type1Data, 0, this.type1Data, 0, this.type1RowLength);
        }

        private void ensureCapacity(int capacity) {
            if (this.type1Data.length < capacity) {
                char[] old_data = this.type1Data;
                this.type1Data = new char[capacity];
                System.arraycopy(old_data, 0, this.type1Data, 0, old_data.length);
            }
        }

        protected void ensureBufferCapacity() {
            if (this.type1RowLength == 0 && this.type1MetaData.type1NumFields > 0) {
                this.type1RowLength = this.type1MetaData.type1BOffset[this.type1MetaData.type1NumFields - 1] + this.type1MetaData.type1BLength[this.type1MetaData.type1NumFields - 1];
            }
            if (this.type1Data.length < this.type1RowLength) {
                char[] old_data = this.type1Data;
                this.type1Data = new char[this.type1RowLength];
                System.arraycopy(old_data, 0, this.type1Data, 0, old_data.length);
            }
        }

        protected void initialize() {
            DefaultStructure.this.initializeRow(0);
            this.nested2Flat();
        }

        protected void nested2Flat() {
            this.ensureBufferCapacity();
            this.nested2Flat(DefaultStructure.this, 0);
        }

        private final int nested2Flat(DefaultStructure record, int dataOffset) {
            int dataLength;
            int startOffset;
            int i;
            int lastCopyIndex = 0;
            for (i = 0; i < record.metaData.numFields; ++i) {
                if (record.metaData.type[i] != 17) continue;
                if (i > lastCopyIndex) {
                    startOffset = record.metaData.boffset[lastCopyIndex];
                    dataLength = record.metaData.boffset[i - 1] + record.metaData.blength[i - 1] - startOffset;
                    System.arraycopy(record.data, startOffset, this.type1Data, dataOffset, dataLength);
                    dataOffset += dataLength;
                }
                lastCopyIndex = i + 1;
                dataOffset = this.nested2Flat(record.getStructure(i), dataOffset);
            }
            if (i > lastCopyIndex) {
                startOffset = record.metaData.boffset[lastCopyIndex];
                dataLength = record.metaData.boffset[i - 1] + record.metaData.blength[i - 1] - startOffset;
                System.arraycopy(record.data, startOffset, this.type1Data, dataOffset, dataLength);
                dataOffset += dataLength;
            }
            return dataOffset;
        }

        protected void flat2Nested() {
            this.flat2Nested(DefaultStructure.this, 0);
        }

        private final int flat2Nested(DefaultStructure record, int dataOffset) {
            int dataLength;
            int startOffset;
            int i = 0;
            int lastCopyIndex = 0;
            while (i < record.metaData.numFields) {
                if (record.metaData.type[i] == 17) {
                    if (i > lastCopyIndex) {
                        startOffset = record.metaData.boffset[lastCopyIndex];
                        dataLength = record.metaData.boffset[i - 1] + record.metaData.blength[i - 1] - startOffset;
                        System.arraycopy(this.type1Data, dataOffset, record.data, startOffset, dataLength);
                        dataOffset += dataLength;
                    }
                    lastCopyIndex = i + 1;
                    dataOffset = this.flat2Nested(record.getStructure(i), dataOffset);
                }
                int n = i++;
                record.flags[n] = (byte)(record.flags[n] & 0xFFFFFFFE);
            }
            if (i > lastCopyIndex) {
                startOffset = record.metaData.boffset[lastCopyIndex];
                dataLength = record.metaData.boffset[i - 1] + record.metaData.blength[i - 1] - startOffset;
                System.arraycopy(this.type1Data, dataOffset, record.data, startOffset, dataLength);
                dataOffset += dataLength;
            }
            return dataOffset;
        }

        protected void cleanup() {
            this.type1RowLength = 0;
            this.type1Data = JCoRuntime.EMPTY_CHAR_ARRAY;
        }
    }
}

