/*
 * Decompiled with CFR 0.152.
 */
package com.sap.conn.jco.rt;

import com.sap.conn.jco.JCoClassMetaData;
import com.sap.conn.jco.JCoException;
import com.sap.conn.jco.JCoFunction;
import com.sap.conn.jco.JCoFunctionTemplate;
import com.sap.conn.jco.JCoListMetaData;
import com.sap.conn.jco.JCoRecordMetaData;
import com.sap.conn.jco.JCoRepository;
import com.sap.conn.jco.JCoRequest;
import com.sap.conn.jco.JCoRuntimeException;
import com.sap.conn.jco.monitor.JCoDestinationMonitor;
import com.sap.conn.jco.monitor.JCoRepositoryMonitor;
import com.sap.conn.jco.rt.AbapFunctionTemplate;
import com.sap.conn.jco.rt.DefaultClassMetaData;
import com.sap.conn.jco.rt.DefaultRecordMetaData;
import com.sap.conn.jco.rt.DynamicRecordMetaData;
import com.sap.conn.jco.rt.JCoRuntimeFactory;
import com.sap.conn.jco.rt.MetaDataStorage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class BasicRepository
implements JCoRepository {
    static final long serialVersionUID = 3000120080918L;
    protected String name;
    protected boolean containsUnicodeInfo = false;
    private MetaDataStorage storage = null;
    private BasicRepositoryMonitor monitor = null;
    long lastAccessTimestamp;

    BasicRepository(String name, boolean localCache) {
        this.name = name;
        this.storage = JCoRuntimeFactory.getRuntime().createMetaDataStorage(this, name, localCache);
        this.lastAccessTimestamp = System.currentTimeMillis();
    }

    public String getName() {
        return this.name;
    }

    public String getMetaDataRelease() {
        return "000";
    }

    JCoFunctionTemplate addFunctionTemplate(JCoFunctionTemplate functionTemplate) {
        this.lastAccessTimestamp = System.currentTimeMillis();
        AbapFunctionTemplate removed = null;
        try {
            removed = this.storage.saveFunctionTemplate((AbapFunctionTemplate)functionTemplate);
        }
        catch (ClassCastException e) {
            throw new JCoRuntimeException(131, "JCO_ERROR_ILLEGAL_ARGUMENT", "Only function templates created by JCo.createFunctionTemplate(...) can be saved in repository cache");
        }
        return removed;
    }

    DefaultRecordMetaData addRecordMetaData(JCoRecordMetaData recordMetaData) {
        DefaultRecordMetaData removed;
        this.lastAccessTimestamp = System.currentTimeMillis();
        recordMetaData.lock();
        try {
            removed = this.storage.saveRecordMetaData((DefaultRecordMetaData)recordMetaData);
        }
        catch (ClassCastException e) {
            throw new JCoRuntimeException(131, "JCO_ERROR_ILLEGAL_ARGUMENT", "Only metadata created by JCo.createRecordMetaData(...) can be saved in repository cache");
        }
        return removed;
    }

    DefaultClassMetaData addClassMetaData(JCoClassMetaData classMetaData) {
        DefaultClassMetaData removed;
        this.lastAccessTimestamp = System.currentTimeMillis();
        classMetaData.lock();
        try {
            removed = this.storage.saveClassMetaData((DefaultClassMetaData)classMetaData);
        }
        catch (ClassCastException e) {
            throw new JCoRuntimeException(131, "JCO_ERROR_ILLEGAL_ARGUMENT", "Only metadata created by JCo.createClassMetaData(...) can be saved in repository cache");
        }
        return removed;
    }

    public JCoFunctionTemplate getFunctionTemplate(String functionName) throws JCoException {
        this.lastAccessTimestamp = System.currentTimeMillis();
        if (functionName == null) {
            throw new IllegalArgumentException("Provide a valid function name: null is not allowed.");
        }
        return this.storage.loadFunctionTemplate(functionName, true);
    }

    JCoFunctionTemplate getFunctionTemplateFromCache(String functionName) throws JCoException {
        this.lastAccessTimestamp = System.currentTimeMillis();
        if (functionName == null) {
            throw new IllegalArgumentException("Provide a valid function name: null is not allowed.");
        }
        return this.storage.loadFunctionTemplate(functionName, false);
    }

    public JCoListMetaData getFunctionInterface(String functionName) throws JCoException {
        JCoFunctionTemplate template = this.getFunctionTemplate(functionName);
        return template == null ? null : template.getFunctionInterface();
    }

    public JCoFunction getFunction(String functionName) throws JCoException {
        JCoFunctionTemplate template = this.getFunctionTemplate(functionName);
        return template == null ? null : template.getFunction();
    }

    public JCoRequest getRequest(String functionName) throws JCoException {
        JCoFunctionTemplate template = this.getFunctionTemplate(functionName);
        return template == null ? null : template.getRequest();
    }

    public DefaultRecordMetaData getRecordMetaData(String recordName) throws JCoException {
        this.lastAccessTimestamp = System.currentTimeMillis();
        if (recordName == null) {
            throw new IllegalArgumentException("Provide a valid record name: null is not allowed.");
        }
        return this.storage.loadRecordMetaData(recordName, true);
    }

    DefaultRecordMetaData getRecordMetaDataFromCache(String recordName) throws JCoException {
        this.lastAccessTimestamp = System.currentTimeMillis();
        if (recordName == null) {
            throw new IllegalArgumentException("Provide a valid record name: null is not allowed.");
        }
        return this.storage.loadRecordMetaData(recordName, false);
    }

    public JCoRecordMetaData getStructureDefinition(String structureName) throws JCoException {
        return this.getRecordMetaData(structureName);
    }

    public DefaultClassMetaData getClassMetaData(String className) throws JCoException {
        this.lastAccessTimestamp = System.currentTimeMillis();
        if (className == null) {
            throw new IllegalArgumentException("Provide a valid class name: null is not allowed.");
        }
        return this.storage.loadClassMetaData(className, true);
    }

    DefaultClassMetaData getClassMetaDataFromCache(String className) throws JCoException {
        this.lastAccessTimestamp = System.currentTimeMillis();
        if (className == null) {
            throw new IllegalArgumentException("Provide a valid class name: null is not allowed.");
        }
        return this.storage.loadClassMetaData(className, false);
    }

    void resolveDynamicRecordMetaData(DynamicRecordMetaData meta) throws JCoException {
        this.lastAccessTimestamp = System.currentTimeMillis();
        throw new JCoRuntimeException(128, "JCO_ERROR_NOT_SUPPORTED", "Unable to resolve dynamic metadata. Use a custom repository connected to an SAP ABAP Application Server to lookup of metadata containing generic boxes instead.");
    }

    public void removeFunctionTemplateFromCache(String functionName) {
        this.lastAccessTimestamp = System.currentTimeMillis();
        if (functionName == null) {
            throw new IllegalArgumentException("Provide a valid function name: null is not allowed.");
        }
        this.storage.removeFunctionTemplate(functionName);
    }

    public void removeRecordMetaDataFromCache(String recordName) {
        this.lastAccessTimestamp = System.currentTimeMillis();
        if (recordName == null) {
            throw new IllegalArgumentException("Provide a valid record name: null is not allowed.");
        }
        this.storage.removeRecordMetaData(recordName);
    }

    public void removeClassMetaDataFromCache(String className) {
        this.lastAccessTimestamp = System.currentTimeMillis();
        if (className == null) {
            throw new IllegalArgumentException("Provide a valid class name: null is not allowed.");
        }
        this.storage.removeClassMetaData(className);
    }

    public void clear() {
        this.lastAccessTimestamp = System.currentTimeMillis();
        this.storage.clear();
    }

    protected void destroy() {
        if (JCoRuntimeFactory.getRuntime().getRepositoryManager().getRepository(this.getName()) == null) {
            this.storage.destroy();
            return;
        }
        throw new JCoRuntimeException(136, "JCO_ERROR_ILLEGAL_STATE", "Repository with ID " + this.getName() + " is still referenced by the runtime and cann't be removed");
    }

    public String[] getCachedFunctionTemplateNames() {
        this.lastAccessTimestamp = System.currentTimeMillis();
        Collection<String> names = this.storage.getCachedFunctionNames();
        return names.toArray(new String[names.size()]);
    }

    public String[] getCachedRecordMetaDataNames() {
        this.lastAccessTimestamp = System.currentTimeMillis();
        Collection<String> names = this.storage.getCachedRecordNames();
        return names.toArray(new String[names.size()]);
    }

    public String[] getCachedClassMetaDataNames() {
        this.lastAccessTimestamp = System.currentTimeMillis();
        Collection<String> names = this.storage.getCachedClassNames();
        return names.toArray(new String[names.size()]);
    }

    public boolean isUnicode() {
        this.lastAccessTimestamp = System.currentTimeMillis();
        return this.containsUnicodeInfo;
    }

    protected boolean containsRecordMetaData(String typeName) {
        this.lastAccessTimestamp = System.currentTimeMillis();
        return this.storage.containsRecord(typeName);
    }

    protected static boolean checkType1(DefaultRecordMetaData meta) {
        block4: for (int i = 0; i < meta.type.length; ++i) {
            switch (meta.type[i]) {
                case 17: {
                    if (meta.isNestedType1Structure(i)) continue block4;
                    DefaultRecordMetaData childMeta = (DefaultRecordMetaData)meta.getRecordMetaData(i);
                    if (childMeta.numOdata == 0 || BasicRepository.checkType1(childMeta)) continue block4;
                    return false;
                }
                case 29: 
                case 30: 
                case 99: {
                    return false;
                }
                default: {
                    continue block4;
                }
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BasicRepositoryMonitor getMonitor() {
        BasicRepository basicRepository = this;
        synchronized (basicRepository) {
            if (this.monitor == null) {
                this.monitor = new BasicRepositoryMonitor();
            }
        }
        return this.monitor;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class BasicRepositoryMonitor
    implements JCoRepositoryMonitor {
        BasicRepositoryMonitor() {
        }

        @Override
        public long getLastAccessTimestamp() {
            return BasicRepository.this.lastAccessTimestamp;
        }

        @Override
        public long getLastRemoteQueryTimestamp() {
            return 0L;
        }

        @Override
        public int getFunctionMetaDataCount() {
            return BasicRepository.this.storage.getFunctionMetaDataCount();
        }

        @Override
        public int getTypeMetaDataCount() {
            return BasicRepository.this.storage.getRecordMetaDataCount();
        }

        @Override
        public int getClassMetaDataCount() {
            return BasicRepository.this.storage.getClassMetaDataCount();
        }

        @Override
        public List<String> getDestinationIDs() {
            return new ArrayList<String>(0);
        }

        @Override
        public JCoDestinationMonitor getRespositoryDestinationMonitor(String destinationID) {
            throw new JCoRuntimeException(131, "JCO_ERROR_ILLEGAL_ARGUMENT", "The destination with the id " + destinationID + "is not used by this repository " + BasicRepository.this.getName());
        }

        public JCoRepository getRepository() {
            return BasicRepository.this;
        }
    }
}

