/*
 * Decompiled with CFR 0.152.
 */
package com.sap.conn.jco.rt;

import com.sap.conn.jco.ext.SessionReferenceProvider;
import com.sap.conn.jco.rt.AutoJobRunner;
import com.sap.conn.jco.rt.Context;
import com.sap.conn.jco.rt.JCoRuntimeFactory;
import com.sap.conn.jco.rt.RuntimeEnvironment;
import com.sap.conn.jco.rt.Trace;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SessionTimeoutChecker
implements AutoJobRunner.AutoJob {
    private static final int THRESHOLD_WARNING_SESSIONSALIVE = 1000;
    private static final int INTERVAL_WARNING_SESSIONSALIVE = 100;
    private static long checkPeriod = 300000L;
    private static long sessionTimeout = 600000L;
    private static int warningSessionsAlive = 1000;
    private boolean checkIsAlive;
    long lastExecution;
    Map<String, ? extends Context> contexts;

    SessionTimeoutChecker(Map<String, ? extends Context> contexts, boolean checkIsAlive) {
        this.checkIsAlive = checkIsAlive;
        this.contexts = contexts;
    }

    @Override
    public void execute() {
        this.lastExecution = System.currentTimeMillis();
        SessionReferenceProvider sessionRefProvider = RuntimeEnvironment.getSessionReferenceProvider();
        if (sessionRefProvider != null) {
            String sessionID = null;
            Context[] copy = this.contexts.values().toArray(new Context[this.contexts.size()]);
            int sessionsAlive = 0;
            long now = System.currentTimeMillis();
            for (int i = 0; i < copy.length; ++i) {
                try {
                    if (now <= copy[i].lastAccess + sessionTimeout) continue;
                    sessionID = copy[i].getSessionID();
                    if (!this.checkIsAlive || sessionID == null || !sessionRefProvider.isSessionAlive(sessionID)) {
                        copy[i].clearServerConnection();
                        JCoRuntimeFactory.getRuntime().releaseRuntimeContext(copy[i]);
                        continue;
                    }
                    ++sessionsAlive;
                    continue;
                }
                catch (Throwable th) {
                    if (!Trace.isOn(8)) continue;
                    Trace.fireTrace(8, "[JCoAPI] " + th.getClass().getName() + " occurred while processing session ID: [" + sessionID + "]", th);
                }
            }
            if (Trace.isOn(4) && sessionsAlive >= warningSessionsAlive) {
                Trace.fireTrace(4, new StringBuilder(300).append("[JCoAPI] WARNING: The SessionReferenceProvider reports ").append(sessionsAlive).append(" sessions to be still alive after the session timeout of ").append(sessionTimeout).append("ms.").append(" A permanently increasing number of sessions is an indicator for a program error in the session management area").append(" and may lead to slow performance and OutOfMemoryErrors.").toString());
                warningSessionsAlive = sessionsAlive / 100 * 100 + 100;
            } else if (Trace.isOn(32) && sessionsAlive > 0) {
                Trace.fireTrace(32, new StringBuilder(120).append("[JCoAPI] The SessionReferenceProvider reports ").append(sessionsAlive).append(" sessions to be still alive after the session timeout of ").append(sessionTimeout).append("ms.").toString());
            }
        }
    }

    static final long getTimeout() {
        return sessionTimeout;
    }

    static final void setTimeout(long milliseconds) {
        sessionTimeout = milliseconds;
    }

    static final long getTimeoutCheckInterval() {
        return checkPeriod;
    }

    static final void setTimeoutCheckInterval(long milliseconds) {
        checkPeriod = milliseconds;
    }

    static final void resetWarningSessionsAlive() {
        warningSessionsAlive = 1000;
    }

    @Override
    public final long getExecutePeriod() {
        return checkPeriod;
    }

    @Override
    public final long getLastExecutionTime() {
        return this.lastExecution;
    }
}

