/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.logging.reader;

import com.sap.tc.logging.interfaces.IFilter;
import java.util.Arrays;

class FileReadFilter
implements IFilter {
    public static int LOG_OPERATER_AND = 1;
    public static int LOG_OPERATER_OR = 2;
    private int logOperator = LOG_OPERATER_OR;
    private String[] conditions;
    private boolean isCaseSensitive;
    private boolean isFilterEnabled;

    public FileReadFilter(String[] conditions, int logOperator, boolean isCaseSensitive) {
        this.conditions = conditions;
        this.isCaseSensitive = isCaseSensitive;
        this.setLogOperator(logOperator);
        this.isFilterEnabled = this.isConditionsOk(conditions);
    }

    public void setCaseSensitive(boolean isCaseSensitive) {
        this.isCaseSensitive = isCaseSensitive;
    }

    public boolean isCaseSensitive() {
        return this.isCaseSensitive;
    }

    public void setLogOperator(int operator) {
        if (operator < LOG_OPERATER_AND || operator > LOG_OPERATER_OR) {
            operator = LOG_OPERATER_OR;
        }
        this.logOperator = operator;
    }

    public int getLogOperator() {
        return this.logOperator;
    }

    public boolean isFilterEnabled() {
        return this.isFilterEnabled;
    }

    public boolean setEnableFilter(boolean value) {
        this.isFilterEnabled = value;
        return this.isFilterEnabled;
    }

    public boolean beRead(byte[] record) {
        String token = null;
        boolean result = false;
        if (record == null || record.length == 0) {
            return false;
        }
        String strRecord = new String(record).trim();
        if (!this.isCaseSensitive) {
            strRecord = strRecord.toUpperCase();
        }
        for (int i = 0; i < this.conditions.length; ++i) {
            token = this.conditions[i];
            if (!this.isCaseSensitive) {
                token = token.toUpperCase();
            }
            if (strRecord.indexOf(token) > 0) {
                if (this.logOperator != LOG_OPERATER_OR) continue;
                result = true;
                continue;
            }
            if (this.logOperator != LOG_OPERATER_AND) continue;
            result = false;
            break;
        }
        return result;
    }

    public boolean equals(Object object) {
        boolean result = false;
        if (object instanceof IFilter) {
            FileReadFilter filter = (FileReadFilter)object;
            result = this.getConditions() != null && filter.getConditions() != null;
            result &= Arrays.equals(this.getConditions(), filter.getConditions());
            result &= this.getLogOperator() == filter.getLogOperator();
            result &= this.isCaseSensitive == filter.isCaseSensitive();
        }
        return result;
    }

    protected String[] getConditions() {
        return this.conditions;
    }

    private boolean isConditionsOk(String[] conditions) {
        boolean result = false;
        if (conditions != null) {
            result = true;
            for (int i = 0; i < conditions.length; ++i) {
                result = result && conditions[i] != null && conditions[i].length() > 0;
            }
        }
        return result;
    }
}

