/*
 * Decompiled with CFR 0.152.
 */
package com.sap.conn.jco.rt;

import com.sap.conn.jco.JCoException;
import com.sap.conn.jco.JCoRuntimeException;
import com.sap.conn.jco.rt.AbapRepository;
import com.sap.conn.jco.rt.BasicRepository;
import com.sap.conn.jco.rt.InternalDestination;
import com.sap.conn.jco.rt.RfcDestination;
import com.sap.conn.jco.rt.Trace;
import com.sap.conn.jco.util.CounterReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RepositoryManager {
    private HashMap<String, CounterReference<BasicRepository>> repositories = new HashMap(29);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BasicRepository getRepository(InternalDestination destination) throws JCoException {
        BasicRepository repository = null;
        String key = destination.getSystemID();
        CounterReference<BasicRepository> ref = this.repositories.get(key);
        if (ref == null) {
            HashMap<String, CounterReference<BasicRepository>> hashMap = this.repositories;
            synchronized (hashMap) {
                ref = this.repositories.get(key);
                if (ref == null) {
                    Trace.fireTrace(16, "[JCoAPI] Adding a repository for " + key);
                    repository = new AbapRepository(key, destination);
                    ref = new CounterReference<BasicRepository>(repository);
                    this.repositories.put(key, ref);
                } else {
                    repository = ref.get();
                    if (repository instanceof AbapRepository) {
                        ((AbapRepository)repository).destinationList.addDestination(destination);
                    }
                }
            }
        } else {
            repository = ref.get();
            if (repository instanceof AbapRepository) {
                ((AbapRepository)repository).destinationList.addDestination(destination);
            }
        }
        return repository;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BasicRepository registerRepository(BasicRepository repository) {
        HashMap<String, CounterReference<BasicRepository>> hashMap = this.repositories;
        synchronized (hashMap) {
            CounterReference<BasicRepository> ref = this.repositories.get(repository.getName());
            if (ref == null) {
                ref = new CounterReference<BasicRepository>(repository);
                this.repositories.put(repository.getName(), ref);
                if (Trace.isOn(8)) {
                    Trace.fireTrace(8, "[JCoAPI] Registering repository " + repository.getName());
                }
            } else {
                throw new JCoRuntimeException(108, "JCO_ERROR_INTERNAL", "Repository " + repository.getName() + " already registered");
            }
            return ref.get();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseRepository(RfcDestination destination) {
        if (destination.repository != null) {
            String key = destination.repository.getName();
            HashMap<String, CounterReference<BasicRepository>> hashMap = this.repositories;
            synchronized (hashMap) {
                CounterReference<BasicRepository> ref = this.repositories.get(key);
                if (ref != null) {
                    ref.release();
                    if (destination.repository instanceof AbapRepository) {
                        ((AbapRepository)destination.repository).destinationList.removeDestination(destination);
                    }
                    if (ref.getCount() == 0) {
                        this.repositories.remove(key);
                        destination.repository.destroy();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getRepositoryIDs() {
        HashMap<String, CounterReference<BasicRepository>> hashMap = this.repositories;
        synchronized (hashMap) {
            return new ArrayList<String>(this.repositories.keySet());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BasicRepository getRepository(String repositoryID) {
        BasicRepository repository = null;
        CounterReference<BasicRepository> ref = null;
        HashMap<String, CounterReference<BasicRepository>> hashMap = this.repositories;
        synchronized (hashMap) {
            ref = this.repositories.get(repositoryID);
        }
        if (ref != null) {
            repository = ref.get();
            ref.release();
        }
        return repository;
    }
}

