/*
 * Decompiled with CFR 0.152.
 */
package com.sap.conn.jco.support;

import com.sap.conn.jco.ext.DestinationDataEventListener;
import com.sap.conn.jco.ext.DestinationDataProvider;
import com.sap.conn.jco.ext.ServerDataEventListener;
import com.sap.conn.jco.ext.ServerDataProvider;
import com.sap.conn.jco.support.Test;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleDataProviderImpl
implements DestinationDataProvider,
ServerDataProvider {
    private static String DESTINATION_FILES_SUFFIX = ".jcoDestination";
    private static String SERVER_CFG_FILES_SUFFIX = ".jcoServer";
    DestinationDataEventListener ddel = null;
    ServerDataEventListener sdel = null;
    Map<String, Properties> destProps = new HashMap<String, Properties>();
    Map<String, Properties> servProps = new HashMap<String, Properties>();
    PrintWriter out;
    BufferedReader in;

    public SimpleDataProviderImpl(PrintWriter out, BufferedReader in) {
        this.out = out;
        this.in = in;
    }

    public List<String> getAvailableServerConfigurations() {
        return this.getAvailableFileNameWithExtention(".jcoServer");
    }

    public List<String> getAvailableClientDestinations() {
        return this.getAvailableFileNameWithExtention(".jcoDestination");
    }

    private List<String> getAvailableFileNameWithExtention(final String extention) {
        File currDir = new File(".");
        String[] servers = currDir.list(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.endsWith(extention);
            }
        });
        ArrayList<String> availableServers = new ArrayList<String>(servers.length);
        for (int i = 0; i < servers.length; ++i) {
            availableServers.add(servers[i].substring(0, servers[i].indexOf(extention)));
        }
        return availableServers;
    }

    @Override
    public Properties getDestinationProperties(String destinationName) {
        Properties p = this.destProps.get(destinationName);
        if (p == null) {
            p = new Properties();
            File destDataFile = new File(destinationName + DESTINATION_FILES_SUFFIX);
            if (destDataFile.exists()) {
                try {
                    p.load(new FileInputStream(destDataFile));
                }
                catch (Exception e) {
                    p.clear();
                }
            }
            if (!p.isEmpty()) {
                this.out.println("Loaded properties for the destination " + destinationName);
                this.displayDestionationData(destinationName, p);
                if (Test.ask(this.out, this.in, "use this parameters (Y/N)", "Y").equals("N")) {
                    p = this.askForDestionationData(p, destinationName);
                }
            } else {
                p = this.askForDestionationData(p, destinationName);
            }
            this.setDestinationProperties(destinationName, p);
        }
        return p;
    }

    @Override
    public Properties getServerProperties(String serverName) {
        Properties p = this.servProps.get(serverName);
        if (p == null) {
            p = new Properties();
            File serverDataFile = new File(serverName + SERVER_CFG_FILES_SUFFIX);
            if (serverDataFile.exists()) {
                try {
                    p.load(new FileInputStream(serverDataFile));
                }
                catch (Exception e) {
                    p.clear();
                }
            }
            if (!p.isEmpty()) {
                this.out.println("Loaded properties for the server " + serverName);
                this.displayServerData(serverName, p);
                if (Test.ask(this.out, this.in, "use this parameters (Y/N)", "Y").equals("N")) {
                    p = this.askForServerData(p, serverName);
                }
            } else {
                p = this.askForServerData(p, serverName);
            }
            this.setServerProperties(serverName, p);
        }
        return p;
    }

    @Override
    public boolean supportsEvents() {
        return true;
    }

    void setDestinationProperties(String name, Properties p) {
        if (p == null) {
            this.ddel.deleted(name);
            this.destProps.remove(name);
        } else {
            Properties removed = this.destProps.put(name, p);
            if (removed != null) {
                this.ddel.updated(name);
            }
        }
    }

    void setServerProperties(String name, Properties p) {
        if (p == null) {
            this.sdel.deleted(name);
            this.servProps.remove(name);
        } else {
            Properties removed = this.servProps.put(name, p);
            if (removed != null) {
                this.sdel.updated(name);
            }
        }
    }

    @Override
    public void setDestinationDataEventListener(DestinationDataEventListener eventListener) {
        this.ddel = eventListener;
    }

    @Override
    public void setServerDataEventListener(ServerDataEventListener eventListener) {
        this.sdel = eventListener;
    }

    void saveAll() {
        FileOutputStream fout;
        for (String name : this.destProps.keySet()) {
            try {
                fout = new FileOutputStream(name + DESTINATION_FILES_SUFFIX, false);
                this.destProps.get(name).store(fout, "Destination data for " + name);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        for (String name : this.servProps.keySet()) {
            try {
                fout = new FileOutputStream(name + SERVER_CFG_FILES_SUFFIX, false);
                this.servProps.get(name).store(fout, "Server data for " + name);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private Properties askForDestionationData(Properties oldP, String destName) {
        Properties newP = new Properties();
        this.out.println();
        this.out.println("\t****************************************");
        this.out.println();
        this.out.println("\tProvide the configuration parameters for");
        this.out.println("\tthe destination:" + destName);
        this.out.println();
        this.out.println("\t****************************************");
        String key = "jco.client.type";
        String value = Test.ask(this.out, this.in, "Server is R/2, R/3 or External (2/3/F/E):", oldP.getProperty(key, "3"));
        newP.setProperty(key, value);
        if (value.equals("3")) {
            value = Test.ask(this.out, this.in, "Use load balancing (Y/N)Y...............:", "Y");
            if (value.equalsIgnoreCase("Y")) {
                key = "jco.client.r3name";
                value = Test.ask(this.out, this.in, "R/3 system name.........................:", oldP.getProperty(key, "BIN"));
                newP.setProperty(key, value);
                key = "jco.client.mshost";
                value = Test.ask(this.out, this.in, "Message server..........................:", oldP.getProperty(key, "binmain"));
                newP.setProperty(key, value);
                key = "jco.client.msserv";
                value = Test.ask(this.out, this.in, "Message server service..................:", oldP.getProperty(key, "sapmsBIN"));
                newP.setProperty(key, value);
                key = "jco.client.group";
                value = Test.ask(this.out, this.in, "Selected group..........................:", oldP.getProperty(key, "SPACE"));
                newP.setProperty(key, value);
            } else {
                key = "jco.client.ashost";
                value = Test.ask(this.out, this.in, "Host name of an application server......:", oldP.getProperty(key, "binmain"));
                newP.setProperty(key, value);
                key = "jco.client.sysnr";
                value = Test.ask(this.out, this.in, "System number...........................:", oldP.getProperty(key, "53"));
                newP.setProperty(key, value);
            }
            key = "jco.client.client";
            value = Test.ask(this.out, this.in, "Client..................................:", oldP.getProperty(key, "000"));
            newP.setProperty(key, value);
            key = "jco.client.user";
            value = Test.ask(this.out, this.in, "UserID..................................:", oldP.getProperty(key, "JCOTEST"));
            newP.setProperty(key, value);
            key = "jco.client.passwd";
            value = Test.ask(this.out, this.in, "Password................................:", oldP.getProperty(key, ""));
            newP.setProperty(key, value);
            key = "jco.client.lang";
            value = Test.ask(this.out, this.in, "Language (EN)...........................:", oldP.getProperty(key, "EN"));
            newP.setProperty(key, value);
        }
        key = "jco.client.trace";
        value = Test.ask(this.out, this.in, "RFC trace (1/0)0........................:", oldP.getProperty(key, "0"));
        newP.setProperty(key, value);
        return newP;
    }

    private Properties askForServerData(Properties oldP, String servName) {
        Properties newP = new Properties();
        this.out.println();
        this.out.println("\t****************************************");
        this.out.println();
        this.out.println("\tProvide the configuration parameters for");
        this.out.println("\tthe server " + servName);
        this.out.println();
        this.out.println("\t****************************************");
        String key = "jco.server.progid";
        String value = Test.ask(this.out, this.in, "Program id..............................:", oldP.getProperty(key, ""));
        newP.setProperty(key, value);
        key = "jco.server.gwhost";
        value = Test.ask(this.out, this.in, "Gateway server..........................:", oldP.getProperty(key, "binmain"));
        newP.setProperty(key, value);
        key = "jco.server.gwserv";
        value = Test.ask(this.out, this.in, "Gateway server service..................:", oldP.getProperty(key, "sapgw53"));
        newP.setProperty(key, value);
        key = "jco.server.repository_destination";
        value = Test.ask(this.out, this.in, "Destintation for repository queries.....:", oldP.getProperty(key, "BIN"));
        newP.setProperty(key, value);
        key = "jco.server.connection_count";
        value = Test.ask(this.out, this.in, "Number of registered connections........:", oldP.getProperty(key, "1"));
        newP.setProperty(key, value);
        key = "jco.client.trace";
        value = Test.ask(this.out, this.in, "RFC trace (1/0)0........................:", oldP.getProperty(key, "0"));
        newP.setProperty(key, value);
        return newP;
    }

    private void displayDestionationData(String destName, Properties oldP) {
        String key = "jco.client.type";
        String value = oldP.getProperty(key, "3");
        this.out.println("Server type :...........................:" + value);
        if (value.equals("3")) {
            key = "jco.client.r3name";
            value = oldP.getProperty(key, null);
            if (value != null) {
                this.out.println("Using load balancing");
                this.out.println("R/3 system name.........................:" + value);
                this.out.println("Message server..........................:" + oldP.getProperty("jco.client.mshost", "null"));
                this.out.println("Message server service..................:" + oldP.getProperty("jco.client.msserv", "null"));
                this.out.println("Selected group..........................:" + oldP.getProperty("jco.client.msserv", "null"));
            } else {
                this.out.println("Using direct connection");
                this.out.println("Host name of an application server......:" + oldP.getProperty("jco.client.ashost", "null"));
                this.out.println("System number...........................:" + oldP.getProperty("jco.client.sysnr", "null"));
            }
        }
        this.out.println("Logon data");
        this.out.println("Client..................................:" + oldP.getProperty("jco.client.client", ""));
        this.out.println("UserID..................................:" + oldP.getProperty("jco.client.user", ""));
        this.out.println("Password................................:" + oldP.getProperty("jco.client.passwd", ""));
        this.out.println("Language (EN)...........................:" + oldP.getProperty("jco.client.lang", ""));
        if (oldP.getProperty("jco.destination.repository_destination", null) != null) {
            this.out.println("Destination.............................:" + oldP.getProperty("jco.destination.repository_destination", "the same"));
        }
        this.out.println("RFC trace (1/0)0........................:" + oldP.getProperty("jco.client.trace", "0"));
    }

    private void displayServerData(String servName, Properties oldP) {
        this.out.println("Server configuration data");
        this.out.println("Program id..............................:" + oldP.getProperty("jco.server.progid", ""));
        this.out.println("Gateway host............................:" + oldP.getProperty("jco.server.gwhost", ""));
        this.out.println("Gateway service.........................:" + oldP.getProperty("jco.server.gwserv", ""));
        this.out.println("Repository destination..................:" + oldP.getProperty("jco.server.repository_destination", ""));
        this.out.println("Connections.............................:" + oldP.getProperty("jco.server.connection_count", "1"));
        this.out.println("RFC trace (1/0)0........................:" + oldP.getProperty("jco.server.trace", "0"));
    }
}

