/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.logging;

import com.sap.tc.logging.GUId;
import java.io.File;
import java.io.IOException;

public class FileLogSet {
    public static final int DEF_LIMIT = 1000000;
    public static final int NO_LIMIT = 0;
    public static final int NO_CNT = 0;
    private static final int MODE_MIN = 0;
    public static final int MODE_SINGLE_FILE = 1;
    public static final int MODE_FILE_SET = 2;
    private static final int MODE_MAX = 3;
    private static final int POS_MIN = 0;
    public static final int POS_START = 1;
    public static final int POS_CURRENT = 2;
    public static final int POS_END = 3;
    private static final int POS_MAX = 4;
    private String filePattern;
    private String filePatternFile;
    private String filePatternPath;
    private String fileLog;
    private String fileLogFile;
    private String fileLogPath;
    private int fsSize;
    private int fsLimit;
    private int fsIndex = -1;
    private int fsIndexStart;
    private int fsMode = 1;
    private boolean isPartOfFileSet = false;

    public FileLogSet(String pattern, String logPath, int index, int size, int limit) {
        this.buildPattern(pattern);
        this.buildLog(logPath);
        this.fsIndex = index;
        this.fsIndexStart = index;
        this.initFileSet(size, limit);
    }

    private FileLogSet() {
    }

    public String getName() {
        return this.buildFinallSource();
    }

    public String getPattern() {
        if (this.fsMode == 2) {
            if (this.getLogPath().length() > 0) {
                return this.getLogPath() + File.separator + this.getPatternFile();
            }
            return this.getPatternFile();
        }
        return this.getLog();
    }

    public String getPatternFile() {
        if (this.filePatternFile != null) {
            return this.filePatternFile;
        }
        return "";
    }

    public String getPatternPath() {
        if (this.filePatternFile != null) {
            return this.filePatternFile;
        }
        return "";
    }

    public String getSource() {
        return this.getSource(2);
    }

    public String getSource(int pos) {
        if (this.isPartOfFileSet()) {
            switch (pos) {
                case 1: {
                    return this.expandPattern(this.findStartIndex(), false);
                }
                case 3: {
                    return this.expandPattern(this.findEndIndex(), false);
                }
            }
            return this.expandPattern(this.getIndex(), false);
        }
        return this.getLog();
    }

    public int getSize() {
        return this.fsSize;
    }

    public int getLimit() {
        return this.fsLimit;
    }

    public int getIndex() {
        return this.fsIndex;
    }

    public void moveToStart() {
        this.setIndex(this.findStartIndex());
    }

    public void moveToEnd() {
        this.setIndex(this.findEndIndex());
    }

    public boolean isStart() {
        return this.getIndex() == this.findStartIndex();
    }

    public boolean isEnd() {
        return this.getIndex() == this.findEndIndex();
    }

    public void next() {
        if (!this.isEnd() && this.isPartOfFileSet()) {
            this.fsIndex = this.findNextIndex();
        }
    }

    public void previous() {
        if (!this.isStart() && this.isPartOfFileSet()) {
            this.fsIndex = this.findPreviousIndex();
        }
    }

    public synchronized void reset() {
        this.fsIndex = 0;
    }

    public synchronized int getMode() {
        return this.fsMode;
    }

    public synchronized void setMode(int mode) {
        if (this.isPartOfFileSet() && mode > 0 && mode < 3) {
            this.fsMode = mode;
            if (mode == 2) {
                this.fsIndex = this.findStartIndex();
            }
        } else {
            this.fsMode = 1;
            this.fsIndex = this.fsIndexStart;
        }
    }

    public boolean isPartOfFileSet() {
        return this.isPartOfFileSet;
    }

    public boolean isInFileSetMode() {
        return this.fsMode == 2;
    }

    public boolean isInSingleFileMode() {
        return this.fsMode == 1;
    }

    public static String buildFileFromPattern(String pattern, int index) {
        return new FileLogSet().expandPattern(pattern, index, true, true);
    }

    protected synchronized void setIndex(int value) {
        if (value < 0 || value > this.fsSize) {
            value = this.fsSize;
        }
        this.fsIndex = value;
    }

    private String getLog() {
        if (this.fileLog != null) {
            return this.fileLog;
        }
        return "";
    }

    private String getLogPath() {
        if (this.fileLogPath != null) {
            return this.fileLogPath;
        }
        return "";
    }

    private String getLogFile() {
        if (this.fileLogFile != null) {
            return this.fileLogFile;
        }
        return "";
    }

    private void initFileSet(int size, int limit) {
        if (size < 1) {
            size = 0;
        }
        if (limit < 1) {
            limit = 0;
        }
        if (size == 0 || limit == 0) {
            limit = 1000000;
            size = 0;
            this.setIndex(0);
        }
        this.fsSize = size;
        this.fsLimit = limit;
        String origFile = this.getLog();
        String buildFile = this.expandPattern(this.buildFinallSource(), true, false);
        this.isPartOfFileSet = size > 0 && origFile.equalsIgnoreCase(buildFile);
    }

    private String expandPattern(int fileIndex, boolean onlyNewFormat) {
        return this.expandPattern(this.buildFinallSource(), fileIndex, this.isPartOfFileSet(), onlyNewFormat);
    }

    private String expandPattern(String filePattern, boolean isRotate, boolean onlyNewFormat) {
        return this.expandPattern(filePattern, this.getIndex(), isRotate, onlyNewFormat);
    }

    private String expandPattern(String filePattern, int fileCount, boolean isRotate, boolean onlyNewFormat) {
        StringBuffer buf = new StringBuffer(filePattern);
        int patternLen = filePattern.length();
        boolean numberInserted = false;
        block15: for (int i = 0; i < patternLen; ++i) {
            switch (buf.charAt(i)) {
                case '%': {
                    String replacement;
                    switch (buf.charAt(i + 1)) {
                        case 'g': {
                            replacement = Integer.toString(fileCount);
                            buf.replace(i, i + 2, replacement);
                            i += replacement.length() - 1;
                            patternLen += replacement.length() - 2;
                            numberInserted = true;
                            break;
                        }
                        case 'h': {
                            replacement = System.getProperty("user.home");
                            buf.replace(i, i + 2, replacement);
                            i += replacement.length() - 1;
                            patternLen += replacement.length() - 2;
                            break;
                        }
                        case 't': {
                            try {
                                replacement = System.getProperty("java.io.tmpdir");
                            }
                            catch (SecurityException sE) {
                                try {
                                    File file = File.createTempFile("tmp", null);
                                    replacement = file.getPath();
                                    file.delete();
                                    replacement = replacement.substring(0, replacement.lastIndexOf(File.separator));
                                }
                                catch (IOException ioE) {
                                    replacement = "";
                                }
                            }
                            buf.replace(i, i + 2, replacement);
                            i += replacement.length() - 1;
                            patternLen += replacement.length() - 2;
                            break;
                        }
                        case 'u': {
                            replacement = new GUId().toString().replace(':', '_');
                            buf.replace(i, i + 2, replacement);
                            i += replacement.length() - 1;
                            patternLen += replacement.length() - 2;
                            break;
                        }
                        case '%': {
                            buf.replace(i, i + 2, "%");
                            --patternLen;
                        }
                    }
                    continue block15;
                }
                case '/': {
                    String replacement = File.separator;
                    buf.replace(i, i + 1, replacement);
                    i += replacement.length() - 1;
                    patternLen += replacement.length() - 1;
                }
            }
        }
        if (!isRotate || numberInserted) {
            return buf.toString();
        }
        return this.createFileName(buf.toString(), "." + fileCount, onlyNewFormat);
    }

    private String createFileName(String filePattern, String append, boolean onlyNewFormat) {
        String tmpFileName;
        int pos;
        StringBuffer newPattern = new StringBuffer();
        StringBuffer tmpPattern = new StringBuffer();
        File file = new File(filePattern);
        String fileFolder = file.getParent();
        String fileName = file.getName();
        if (fileFolder != null) {
            newPattern.append(fileFolder);
            newPattern.append(File.separator);
        }
        if ((pos = fileName.indexOf(".")) > 0) {
            tmpPattern.append(fileName.substring(0, pos));
            tmpPattern.append(append);
            tmpPattern.append(fileName.substring(pos));
        } else {
            tmpPattern.append(fileName);
            tmpPattern.append(append);
            tmpPattern.append(".log");
        }
        if (!onlyNewFormat && !new File(tmpFileName = newPattern.toString() + tmpPattern.toString()).exists()) {
            tmpPattern = new StringBuffer();
            if (pos > 0) {
                tmpPattern.append(fileName);
                tmpPattern.append(append);
            } else {
                tmpPattern.append(fileName);
                tmpPattern.append(".log");
                tmpPattern.append(append);
            }
        }
        newPattern.append(tmpPattern.toString());
        return newPattern.toString();
    }

    private int findStartIndex() {
        int oldestIndex = this.getIndex();
        if (this.isPartOfFileSet()) {
            long oldestDate = Long.MAX_VALUE;
            File file = null;
            for (int i = this.getSize() - 1; i >= 0; --i) {
                file = new File(this.expandPattern(i, true));
                if (!file.exists()) continue;
                if (file.lastModified() >= oldestDate) break;
                oldestDate = file.lastModified();
                oldestIndex = i;
            }
        }
        return oldestIndex;
    }

    private int findEndIndex() {
        int latestIndex = this.getIndex();
        if (this.isPartOfFileSet()) {
            long latestDate = 0L;
            File file = null;
            for (int i = 0; i < this.getSize(); ++i) {
                file = new File(this.expandPattern(i, true));
                if (!file.exists()) continue;
                if (file.lastModified() <= latestDate) break;
                latestDate = file.lastModified();
                latestIndex = i;
            }
        }
        return latestIndex;
    }

    private int findNextIndex() {
        File file = null;
        long currDate = Long.MAX_VALUE;
        long lastDate = 0L;
        file = new File(this.expandPattern(this.getIndex(), true));
        if (file.exists()) {
            lastDate = currDate = file.lastModified();
        }
        int tmpIndex = this.getIndex();
        while (lastDate <= currDate && (tmpIndex = (tmpIndex + 1) % this.getSize()) != this.getIndex()) {
            file = new File(this.expandPattern(tmpIndex, true));
            if (!file.exists()) continue;
            lastDate = file.lastModified();
        }
        return tmpIndex;
    }

    private int findPreviousIndex() {
        File file = null;
        long currDate = Long.MAX_VALUE;
        long prevDate = 0L;
        file = new File(this.expandPattern(this.getIndex(), true));
        if (file.exists()) {
            prevDate = currDate = file.lastModified();
        }
        int tmpIndex = this.getIndex();
        while (prevDate >= currDate) {
            tmpIndex = tmpIndex == 0 ? this.getSize() - 1 : --tmpIndex;
            if (tmpIndex == this.getIndex()) break;
            file = new File(this.expandPattern(tmpIndex, true));
            if (!file.exists()) continue;
            prevDate = file.lastModified();
        }
        return tmpIndex;
    }

    private String buildFinallSource() {
        if (this.fileLogPath != null && this.fileLogPath.length() > 0) {
            return this.fileLogPath + File.separator + this.filePatternFile;
        }
        return this.filePatternFile;
    }

    private void buildPattern(String value) {
        if (value != null) {
            File file = new File(value);
            this.filePatternFile = file.getName();
            this.filePatternPath = file.getParent();
        }
        this.filePattern = value;
    }

    private void buildLog(String value) {
        if (value != null) {
            File file = new File(value);
            this.fileLogFile = file.getName();
            this.fileLogPath = file.getParent();
        }
        this.fileLog = value;
    }
}

