/*
 * Decompiled with CFR 0.152.
 */
package com.sap.conn.jco.rt;

import com.sap.conn.jco.JCoField;
import com.sap.conn.jco.JCoFieldIterator;
import com.sap.conn.jco.JCoParameterList;
import com.sap.conn.jco.JCoRecord;
import com.sap.conn.jco.rt.DefaultParameterField;
import com.sap.conn.jco.rt.DefaultRecordField;
import java.util.Iterator;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultFieldIterator
implements Iterator<JCoField>,
JCoFieldIterator {
    private JCoField[] fields;
    private int index = 0;

    protected DefaultFieldIterator(JCoRecord rec) {
        int num_fields = rec.getMetaData().getFieldCount();
        if (rec instanceof JCoParameterList) {
            this.fields = new DefaultParameterField[num_fields];
            for (int i = 0; i < num_fields; ++i) {
                this.fields[i] = new DefaultParameterField(rec, i);
            }
        } else {
            this.fields = new DefaultRecordField[num_fields];
            for (int i = 0; i < num_fields; ++i) {
                this.fields[i] = new DefaultRecordField(rec, i);
            }
        }
    }

    @Override
    public void reset() {
        this.index = 0;
    }

    @Override
    public boolean hasNextField() {
        return this.index < this.fields.length;
    }

    @Override
    public boolean hasPreviousField() {
        return this.index > 0;
    }

    @Override
    public JCoField nextField() {
        if (this.index < this.fields.length) {
            return this.fields[this.index++];
        }
        throw new NoSuchElementException("FieldEnumerator");
    }

    @Override
    public JCoField previousField() {
        if (this.index > 0) {
            return this.fields[--this.index];
        }
        throw new NoSuchElementException("FieldEnumerator");
    }

    @Override
    public boolean hasNext() {
        return this.hasNextField();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("JCoRecord does not support remove operation.");
    }

    @Override
    public JCoField next() {
        return this.nextField();
    }
}

