/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.logging;

import com.sap.tc.logging.APILogger;
import com.sap.tc.logging.ExceptionHandling;
import com.sap.tc.logging.Formatter;
import com.sap.tc.logging.LoggingManager;
import com.sap.tc.logging.MSGCollection;
import com.sap.tc.logging.Version;
import com.sap.tc.logging.exceptions.CloseException;
import com.sap.tc.logging.exceptions.OpenException;
import com.sap.tc.logging.interfaces.IBaseLog;
import com.sap.tc.logging.interfaces.IFilter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;

public abstract class BaseLog
extends ExceptionHandling
implements IBaseLog {
    private static String strLoc = "BaseLog";
    public static final int STATUS_INVALID = 0;
    public static final int STATUS_CLOSED = 1;
    public static final int STATUS_OPENED = 2;
    private String logName;
    private String logDescription;
    private int logStatus = 1;
    private String logPattern;
    private String logSource;
    private String logHeader;
    private String logFooter;
    private String logVerInUse;
    private String logEncoding;
    private int logMode;
    private Formatter logFormatter;
    private IFilter logFilter;
    private HashSet logFilters;

    protected abstract void openInt() throws OpenException;

    protected abstract void closeInt() throws CloseException;

    public synchronized void open() throws OpenException {
        this.openInt();
    }

    public synchronized void close() throws CloseException {
        this.closeInt();
    }

    public synchronized int status() {
        return this.logStatus;
    }

    public synchronized boolean isClosed() {
        return this.logStatus == 1;
    }

    public synchronized boolean isOpened() {
        return this.logStatus == 2;
    }

    public void setPattern(String value) {
        this.logPattern = value;
    }

    public String getPattern() {
        if (this.logPattern != null) {
            return this.logPattern;
        }
        return "";
    }

    public void setSource(String value) {
        this.logSource = value;
    }

    public String getSource() {
        if (this.logSource != null) {
            return this.logSource;
        }
        return "";
    }

    public synchronized void setEncoding(String encoding) {
        this.logEncoding = encoding;
    }

    public synchronized String getEncoding() {
        return this.logEncoding;
    }

    public synchronized void setFormatter(Formatter formatter) {
        if (this.status() == 2) {
            throw new UnsupportedOperationException(MSGCollection.LOGGING_EXC_FORMAT_CHANGE);
        }
        if (formatter == null) {
            this.logFormatter = LoggingManager.DEFAULT_FORMATTER;
            APILogger.logIntByAPI(300, APILogger.APILocation, strLoc + "[setFormatter(Formatter formatter)]", "ASJ.log_api.000028", "Excepted object is not specified ({0} == null) for {1}({2})! Default {3} ({4}) is created!", new String[]{"Formatter", "BaseLog", this.getName(), "Formatter", LoggingManager.DEFAULT_FORMATTER.getClass().getName()});
        } else {
            this.logFormatter = formatter;
        }
    }

    public synchronized Formatter getFormatter() {
        if (this.logFormatter == null) {
            this.logFormatter = LoggingManager.DEFAULT_FORMATTER;
        }
        return this.logFormatter;
    }

    public synchronized String getFooter() {
        if (this.logFooter != null) {
            return this.logFooter;
        }
        return "";
    }

    public synchronized String getHeader() {
        if (this.logHeader != null) {
            return this.logHeader;
        }
        return "";
    }

    public synchronized int getMode() {
        return this.logMode;
    }

    public synchronized void setMode(int mode) {
        this.logMode = mode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFilter(IFilter filter) {
        if (filter != null) {
            if (this.logFilter != null && !this.logFilter.equals(filter)) {
                if (this.logFilters == null) {
                    this.logFilters = new HashSet();
                    this.logFilters.add(this.logFilter);
                    this.logFilter = null;
                }
                HashSet hashSet = this.logFilters;
                synchronized (hashSet) {
                    this.logFilters.add(filter);
                }
            } else {
                this.logFilter = filter;
            }
        } else {
            APILogger.logIntByAPI(400, APILogger.APILocation, strLoc + "[addFilter(Filter filter)]", "ASJ.log_api.000019", "Excepted object is not specified ({0} == null) for {1}({2})!", new String[]{"Filter", "Log", this.getName()});
        }
    }

    public IFilter getFilter(int index) {
        if (this.logFilters != null && index < this.logFilters.size()) {
            return (IFilter)((List)this.getFilters()).get(index);
        }
        return this.logFilter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection getFilters() {
        if (this.logFilters != null) {
            HashSet hashSet = this.logFilters;
            synchronized (hashSet) {
                return Collections.unmodifiableCollection(new ArrayList(this.logFilters));
            }
        }
        return Collections.EMPTY_LIST;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFilter(IFilter filter) {
        if (this.logFilters != null && this.logFilters.contains(filter)) {
            HashSet hashSet = this.logFilters;
            synchronized (hashSet) {
                this.logFilters.remove(filter);
            }
        }
        this.logFilter = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFilters() {
        if (this.logFilters != null) {
            HashSet hashSet = this.logFilters;
            synchronized (hashSet) {
                this.logFilters.clear();
                this.logFilter = null;
            }
        }
    }

    public synchronized void setName(String value) {
        this.logName = value;
    }

    public synchronized String getName() {
        if (this.logName != null) {
            return this.logName;
        }
        return "";
    }

    public synchronized void setDescription(String value) {
        this.logDescription = value;
    }

    public synchronized String getDescription() {
        if (this.logDescription != null) {
            return this.logDescription;
        }
        return "";
    }

    public synchronized String getVerInUse() {
        if (this.logVerInUse != null) {
            return this.logVerInUse;
        }
        return Version.getFullVersion();
    }

    protected synchronized void setStatus(int status) {
        this.logStatus = status < 1 || status > 2 ? 0 : status;
    }

    protected synchronized void setHeader(String value) {
        this.logHeader = value;
    }

    protected synchronized void setFooter(String value) {
        this.logFooter = value;
    }

    protected synchronized void setVerInUse(String value) {
        this.logVerInUse = value;
    }

    protected Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

