/*
 * Decompiled with CFR 0.152.
 */
package com.sap.conn.jco.rt;

import com.sap.conn.jco.AbapClassException;
import com.sap.conn.jco.AbapException;
import com.sap.conn.jco.ConversionException;
import com.sap.conn.jco.JCoException;
import com.sap.conn.jco.JCoFunction;
import com.sap.conn.jco.JCoFunctionUnitState;
import com.sap.conn.jco.JCoRuntimeException;
import com.sap.conn.jco.JCoUnitIdentifier;
import com.sap.conn.jco.ext.Environment;
import com.sap.conn.jco.rt.AbapClassExceptionInfo;
import com.sap.conn.jco.rt.AbapFunction;
import com.sap.conn.jco.rt.AbapFunctionTemplate;
import com.sap.conn.jco.rt.AbstractConnection;
import com.sap.conn.jco.rt.AbstractRecord;
import com.sap.conn.jco.rt.ClientConnection;
import com.sap.conn.jco.rt.ComplexParameter;
import com.sap.conn.jco.rt.Converter;
import com.sap.conn.jco.rt.DefaultAbapObject;
import com.sap.conn.jco.rt.DefaultListMetaData;
import com.sap.conn.jco.rt.DefaultParameterList;
import com.sap.conn.jco.rt.DefaultServer;
import com.sap.conn.jco.rt.DefaultServerWorker;
import com.sap.conn.jco.rt.DefaultStructure;
import com.sap.conn.jco.rt.DefaultTable;
import com.sap.conn.jco.rt.DefaultThroughput;
import com.sap.conn.jco.rt.FlatStructure;
import com.sap.conn.jco.rt.JCoMiddleware;
import com.sap.conn.jco.rt.JCoRuntime;
import com.sap.conn.jco.rt.NestedStructure;
import com.sap.conn.jco.rt.Parameter;
import com.sap.conn.jco.rt.ServerConnection;
import com.sap.conn.jco.rt.ServerWorker;
import com.sap.conn.jco.rt.StaticFunctionTemplates;
import com.sap.conn.jco.rt.TableParameter;
import com.sap.conn.jco.rt.Trace;
import com.sap.conn.jco.util.Codecs;
import com.sap.conn.jco.util.Codepage;
import com.sap.conn.jco.util.ConnectionInfo;
import com.sap.conn.jco.util.FastStringBuffer;
import com.sap.conn.jco.util.Language;
import com.sap.conn.rfc.api.IRfcParameter;
import com.sap.conn.rfc.api.IRfcTable;
import com.sap.conn.rfc.api.RfcAcceptInfo;
import com.sap.conn.rfc.api.RfcApi;
import com.sap.conn.rfc.api.RfcConnectionState;
import com.sap.conn.rfc.api.RfcOptions;
import com.sap.conn.rfc.data.ARFCSDATA;
import com.sap.conn.rfc.data.ARFCSSTATE;
import com.sap.conn.rfc.data.RfcChars;
import com.sap.conn.rfc.engine.AbSysInfo;
import com.sap.conn.rfc.engine.BgRfcRecorderInfo;
import com.sap.conn.rfc.engine.BgRfcUnit;
import com.sap.conn.rfc.engine.GUID;
import com.sap.conn.rfc.engine.RfcGetName;
import com.sap.conn.rfc.engine.RfcIoControl;
import com.sap.conn.rfc.engine.RfcIoOpenCntl;
import com.sap.conn.rfc.engine.RfcPlaybackInfo;
import com.sap.conn.rfc.engine.Trc;
import com.sap.conn.rfc.exceptions.RfcException;
import com.sap.conn.rfc.sysfunc.RfcSystemInfo;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Locale;
import java.util.Properties;

public class MiddlewareJavaRfc
extends JCoMiddleware {
    private static final String VERSION = "2.2.8";
    private static final String REQUIRED_NATIVE_VERSION = "720.117";
    private static final String NAME = "JavaRfc";
    private static String nativeLayer_version;
    static int wait_for_request_time;
    static boolean monitorOn;
    private static final int IGNORE_PARAMETER = 14;
    private static int mw_max_startup_delay;
    static final String[] rfc_return_codes;
    protected static final String JCO_NAME = "jco.middleware.name";
    protected static final String JCO_VERSION = "jco.middleware.version";
    private static final String JCO_NATIVE_LAYER_VERSION = "jco.middleware.native_layer_version";
    private static final String JCO_SNC_LIB = "jco.middleware.snc_lib";
    private static final String JCO_WAIT_FOR_REQUEST_TIME = "jco.middleware.wait_for_request_time";
    private static final String JCO_MW_MAX_STARTUP_DELAY = "jco.middleware.max_startup_delay";
    private static final String JCO_MONITORING_MODE = "jco.middleware.monitoring";
    private static final String JRFC_TRACE = "jrfc.trace";
    private static final String CPIC_TRACE = "cpic.trace";
    private static final String JRFC_CLIENT_CONNECT_TIMEOUT = "jrfc.client_connect_timeout";
    private static final String JCO_DELTA_MANAGEMENT = "jco.delta_management";
    protected static final Properties properties;
    private static final String[][] pinfo;
    static final String[][] pinfoClient;
    static final String[][] pinfoServer;
    private static final String JCO_JRA_CONN = "jco.jra_conn";
    static DefaultListMetaData systemPrepareAttachGuiImports;
    static DefaultListMetaData systemPrepareAttachGuiExports;
    static DefaultListMetaData systemFinishAttachGuiImports;

    private static int compareVersions(String version1, String version2) {
        try {
            if (version1 == null) {
                if (version2 == null) {
                    return 0;
                }
                if (version2.length() == 0) {
                    return -1;
                }
                if (version2.equals("0")) {
                    return -1;
                }
                version1 = "0";
            }
            if (version2 == null) {
                if (version1.length() == 0) {
                    return 1;
                }
                if (version1.equals("0")) {
                    return 1;
                }
                version2 = "0";
            }
            if (version1.length() == 0) {
                if (version2.length() == 0) {
                    return 0;
                }
                if (version2.equals("0")) {
                    return -1;
                }
                version1 = "0";
            }
            if (version2.length() == 0) {
                if (version1.equals("0")) {
                    return 1;
                }
                version2 = "0";
            }
            int e1 = -1;
            int e2 = -1;
            int v1 = 0;
            int v2 = 0;
            do {
                int s1 = e1 + 1;
                int s2 = e2 + 1;
                e1 = version1.indexOf(46, s1);
                e2 = version2.indexOf(46, s2);
                if (e1 == -1) {
                    e1 = version1.length();
                }
                if (e2 == -1) {
                    e2 = version2.length();
                }
                if ((v1 = Integer.parseInt(version1.substring(s1, e1))) > (v2 = Integer.parseInt(version2.substring(s2, e2)))) {
                    return 1;
                }
                if (v1 >= v2) continue;
                return -1;
            } while (e1 < version1.length() && e2 < version2.length());
            if (e1 == version1.length() && e2 == version2.length()) {
                return 0;
            }
            if (e1 == version1.length()) {
                return -1;
            }
            return 1;
        }
        catch (NumberFormatException nfe) {
            return 0;
        }
    }

    public String[][] getPropertyInfo() {
        return pinfo;
    }

    protected int getMaxStartupDelay() {
        return mw_max_startup_delay;
    }

    public Properties getProperties() {
        return properties;
    }

    public final String getProperty(String key) {
        return properties.getProperty(key);
    }

    /*
     * Unable to fully structure code
     */
    public void setProperty(String key, String value) {
        if (key == null) {
            throw new JCoRuntimeException(131, "JCO_ERROR_ILLEGAL_ARGUMENT", "key equals null is not allowed in setProperty");
        }
        if (key.equals("jco.middleware.monitoring")) {
            try {
                iv = Integer.parseInt(value);
                if (iv != 0 && iv != 1) {
                    throw new JCoRuntimeException(131, "JCO_ERROR_ILLEGAL_ARGUMENT", "Value of property jco.middleware.monitoring must be 1 or 0.");
                }
                MiddlewareJavaRfc.monitorOn = iv == 1;
                value = String.valueOf(iv);
            }
            catch (Exception ex) {
                throw new JCoRuntimeException(131, "JCO_ERROR_ILLEGAL_ARGUMENT", "Value of property jco.middleware.monitoring not an integer.", ex);
            }
        } else if (key.equals("jrfc.trace")) {
            try {
                jrfcTrace = Integer.parseInt(value);
                RfcIoOpenCntl.setGeneralTrace(jrfcTrace > 0);
                value = String.valueOf(jrfcTrace);
            }
            catch (Exception ex) {
                throw new JCoRuntimeException(131, "JCO_ERROR_ILLEGAL_ARGUMENT", "Value of property jrfc.trace not an integer.", ex);
            }
        } else if (key.equals("cpic.trace")) {
            try {
                cpicTrace = Integer.parseInt(value);
                if (cpicTrace < 0) ** GOTO lbl67
                fName = new SimpleDateFormat("'CPIC'yyMMdd'_'HHmmssSSS'.trc'");
                RfcApi.runtime.setCpicTrace(cpicTrace, fName.format(new Date()));
            }
            catch (Exception ex) {
                throw new JCoRuntimeException(131, "JCO_ERROR_ILLEGAL_ARGUMENT", "Value of property cpic.trace not an integer.", ex);
            }
        } else if (key.equals("jrfc.client_connect_timeout")) {
            try {
                seconds = Integer.parseInt(value);
                if (seconds < 1) {
                    seconds = 1;
                } else if (seconds > 3600) {
                    seconds = 3600;
                }
                RfcIoOpenCntl.setClientConnectTimeout(seconds);
                value = String.valueOf(seconds);
            }
            catch (Exception ex) {
                throw new JCoRuntimeException(131, "JCO_ERROR_ILLEGAL_ARGUMENT", "Value of property jrfc.client_connect_timeout not an integer.", ex);
            }
        } else if (key.equals("jco.delta_management")) {
            try {
                iv = Integer.parseInt(value);
                if (iv != 0 && iv != 1) {
                    throw new JCoRuntimeException(131, "JCO_ERROR_ILLEGAL_ARGUMENT", "Value of property jco.delta_management must be 1 or 0.");
                }
                RfcApi.setDeltaManagementState(iv == 1);
            }
            catch (Exception ex) {
                throw new JCoRuntimeException(131, "JCO_ERROR_ILLEGAL_ARGUMENT", "Value of property jrfc.client_connect_timeout not an integer.", ex);
            }
        } else if (key.equals("jco.middleware.max_startup_delay")) {
            if (value != null) {
                try {
                    MiddlewareJavaRfc.mw_max_startup_delay = Integer.parseInt(value);
                    if (MiddlewareJavaRfc.mw_max_startup_delay < 0) {
                        MiddlewareJavaRfc.mw_max_startup_delay = 3600;
                    }
                    if (MiddlewareJavaRfc.mw_max_startup_delay >= 60) ** GOTO lbl67
                    if (Trace.isOn(4)) {
                        Trace.fireTrace(4, "[JCoCallStack] WARNING: environmment trys to set the default maximmum startup delay time for JCoServer to a value smaller than 60 seconds. ", true);
                    }
                    MiddlewareJavaRfc.mw_max_startup_delay = 60;
                }
                catch (Exception ex) {
                    throw new JCoRuntimeException(131, "JCO_ERROR_ILLEGAL_ARGUMENT", "Value of property jco.middleware.max_startup_delay is not an integer.", ex);
                }
            } else {
                MiddlewareJavaRfc.mw_max_startup_delay = 3600;
            }
        }
lbl67:
        // 12 sources

        if (value != null) {
            MiddlewareJavaRfc.properties.put(key, value);
        } else {
            MiddlewareJavaRfc.properties.remove(key);
        }
    }

    protected void removeProperty(String key, Properties props) {
        if (props.containsKey(key)) {
            props.remove(key);
        } else if (props.containsKey(key = key.substring(key.lastIndexOf(46) + 1))) {
            props.remove(key);
        } else if (props.containsKey(key = key.toUpperCase(Locale.ENGLISH))) {
            props.remove(key);
        }
    }

    public final String getName() {
        return properties.getProperty(JCO_NAME);
    }

    public final String getVersion() {
        return properties.getProperty(JCO_VERSION);
    }

    public static ConnectionInfo[] getConnectionsInfo() {
        return RfcIoControl.getConnectionsInfo();
    }

    public JCoMiddleware.Client getClientInterface() {
        return new JavaRfcClient();
    }

    public JCoMiddleware.Server getServerInterface() {
        return new JavaRfcServer();
    }

    public JCoMiddleware.ServerGroup getListenerGroupInterface() {
        return new JavaRfcServerGroup();
    }

    public JCoMiddleware.Dispatcher getDispatcherInterface() {
        return new JavaRfcDispatcher();
    }

    static RfcAcceptInfo createRfcAcceptInfo(Properties params) {
        String pathToSncLib;
        String routerString = JCoRuntime.findProperty("jco.server.saprouter", params);
        String gwhost = JCoRuntime.findProperty("jco.server.gwhost", params);
        if (routerString == null && (routerString = MiddlewareJavaRfc.extractRouterString(gwhost)) != null) {
            JCoRuntime.removeProperty("jco.server.gwhost", params);
            params.put("jco.server.gwhost", MiddlewareJavaRfc.getPlainHost(gwhost, routerString.length() + 3));
            params.put("jco.server.saprouter", routerString);
        }
        if (JCoRuntime.toBoolean(JCoRuntime.findProperty("jco.server.snc_mode", params)) && JCoRuntime.findProperty("jco.server.snc_lib", params) == null && (pathToSncLib = properties.getProperty(JCO_SNC_LIB)) != null) {
            params.put("jco.server.snc_lib", pathToSncLib);
        }
        RfcAcceptInfo acceptParams = RfcApi.runtime.createAcceptInfo(params);
        acceptParams.setProperties(params);
        acceptParams.setAllocationType(JCoRuntime.toBoolean(JCoRuntime.findProperty(JCO_JRA_CONN, params)) ? (byte)1 : 3);
        return acceptParams;
    }

    protected JCoException generateJCoException(RfcException re) {
        if (Trace.isOn(16)) {
            Trace.fireTrace(16, re.toString(), true);
        }
        switch (re.getRc()) {
            case 3: {
                return new JCoException(re.getErrorGroup(), re.getMessage(), re.getMessageClass(), re.getMessageType(), re.getMessageNumber(), re.getMessageParameters(), re, re.remoteSystemInfo());
            }
            case 23: {
                return new JCoException(135, re.getMessage(), re.getMessageClass(), re.getMessageType(), re.getMessageNumber(), re.getMessageParameters(), re, re.remoteSystemInfo());
            }
        }
        return new JCoException(re.getErrorGroup(), re.getMessage(), null, '\u0000', null, null, re, re.remoteSystemInfo());
    }

    protected static String extractRouterString(String host) {
        if (host == null) {
            return null;
        }
        String routerString = null;
        int where = host.lastIndexOf("/H/");
        if (where > 0) {
            routerString = host.substring(0, where);
        }
        return routerString;
    }

    protected static String getPlainHost(String host, int hostNameOffset) {
        if (host == null) {
            return null;
        }
        String realHost = null;
        int where = host.indexOf("/S/", hostNameOffset);
        realHost = where > 0 ? host.substring(hostNameOffset, where) : host.substring(hostNameOffset);
        return realHost;
    }

    protected Codepage.CPMap getCodepage(String partner_codepage, int partner_pcs, String isoLanguage) {
        Codepage.CPMap cpmap;
        if (Trace.isOn(128)) {
            Trace.fireTrace(128, "[JCoRFC] getCodepage trying codepage " + partner_codepage);
        }
        if ((cpmap = Codepage.getCPMap(partner_codepage)) == null && partner_pcs == 1) {
            if (Trace.isOn(4)) {
                Trace.fireTrace(4, "[JCoRFC] getCodepage trying logon language " + isoLanguage);
            }
            cpmap = Codepage.getCPMap(isoLanguage);
        }
        if (cpmap == null) {
            if (Trace.isOn(4)) {
                Trace.fireTrace(4, "[JCoRFC] getCodepage using default codepage 4102");
            }
            cpmap = Codepage.getCPMap("4102");
        }
        if (Trace.isOn(128)) {
            Trace.fireTrace(128, "[JCoRFC] getCodepage returns partner codepage " + cpmap.codepage);
        }
        return cpmap;
    }

    protected long countBytes(IRfcParameter[] paramList, IRfcParameter[] changings, IRfcTable[] tables) {
        int i;
        long numBytes = 0L;
        if (paramList != null) {
            for (i = 0; i < paramList.length; ++i) {
                numBytes += (long)paramList[i].getNumBytes();
            }
        }
        if (changings != null) {
            for (i = 0; i < changings.length; ++i) {
                numBytes += (long)changings[i].getNumBytes();
            }
        }
        if (tables != null) {
            for (i = 0; i < tables.length; ++i) {
                numBytes += (long)(tables[i].getNumRows() * tables[i].getRowLength());
            }
        }
        return numBytes;
    }

    static {
        block12: {
            block11: {
                nativeLayer_version = "not available";
                wait_for_request_time = 2;
                monitorOn = false;
                mw_max_startup_delay = 3600;
                rfc_return_codes = new String[]{"RFC_OK", "RFC_FAILURE", "RFC_EXCEPTION", "RFC_SYS_EXCEPTION", "RFC_CALL", "RFC_INTERNAL_COM", "RFC_CLOSED", "RFC_RETRY", "RFC_NO_TID", "RFC_EXECUTED", "RFC_SYNCHRONIZE", "RFC_MEMORY_INSUFFICIENT", "RFC_VERSION_MISMATCH", "RFC_NOT_FOUND", "RFC_CALL_NOT_SUPPORTED", "RFC_NOT_OWNER", "RFC_NOT_INITIALIZED", "RFC_SYSTEM_CALLED", "RFC_INVALID_HANDLE", "RFC_INVALID_PARAMETER", "RFC_CANCELLED", "RFC_CONVERSION", "RFC_INVALID_PROTOCOL", "RFC_IDLE_TIMEOUT", "RFC_UNKNOWN_EXCEPTION"};
                properties = new Properties();
                pinfo = new String[][]{{JCO_NAME, "Name of the middleware implementation"}, {JCO_VERSION, "Version of the middleware implementation"}, {JCO_NATIVE_LAYER_VERSION, "Version of the native layer"}, {JCO_SNC_LIB, "Path to SNC library"}, {JCO_WAIT_FOR_REQUEST_TIME, "Time in seconds to wait incessantly for incoming requests"}, {JCO_MW_MAX_STARTUP_DELAY, "Maximum server startup delay time in seconds"}, {JCO_MONITORING_MODE, "Turns on reporting performance data for each call"}};
                pinfoClient = new String[][]{{"jco.client.client", "Logon client"}, {"jco.client.user", "Logon user"}, {"jco.client.alias_user", "Alias user name"}, {"jco.client.passwd", "Logon password"}, {"jco.client.lang", "Logon language"}, {"jco.client.codepage", "Initial codepage in SAP notation"}, {"jco.client.sysnr", "R/3 system number"}, {"jco.client.ashost", "R/3 application server"}, {"jco.client.mshost", "R/3 message server"}, {"jco.client.gwhost", "Gateway host"}, {"jco.client.gwserv", "Gateway service"}, {"jco.client.r3name", "R/3 name"}, {"jco.client.group", "Group of application servers"}, {"jco.client.msserv", "R/3 port number of message server"}, {"jco.client.tpname", "Program ID of external server program"}, {"jco.client.tphost", "Host of external server program"}, {"jco.client.type", "Type of remote host 3 = R/3, E = External"}, {"jco.client.trace", "Enable/disable RFC trace (0 or 1)"}, {"jco.client.getsso2", "Get/Don't get a SSO ticket after logon (1 or 0)"}, {"jco.client.mysapsso2", "Use the specified SAP Cookie Version 2 as logon ticket"}, {"jco.client.lcheck", "Enable/Disable logon check at open time (1 or 0)"}, {"jco.client.snc_mode", "SNC mode, 0 or 1"}, {"jco.client.snc_partnername", "SNC partner, e.g. p:CN=B20, O=SAP-AG, C=DE"}, {"jco.client.snc_qop", "SNC level of security, 1 to 9"}, {"jco.client.snc_myname", "SNC name. Overrides default SNC partner"}, {"jco.client.snc_lib", "Path to library"}, {"jco.client.dest", "R/2 destination"}, {"jco.client.saplogon_id", "String defined for SAPLOGON on 32-bit Windows"}, {"jco.client.extiddata", "Data for external authentication (PAS)"}, {"jco.client.extidtype", "Type of external authentication (PAS)"}, {"jco.client.x509cert", "Use the specified X509-certificate as logon ticket"}, {"jco.client.icce", "Flags for codepage converters"}, {"jco.client.idle_timeout", "Idle timeout for the connection"}, {"jco.client.saprouter", "SAPRouter string"}, {"jco.client.destination", "Name of the destination being used"}};
                pinfoServer = new String[][]{{"jco.server.gwhost", "Gateway host"}, {"jco.server.gwserv", "Gateway service"}, {"jco.server.progid", "Program ID of the server"}, {"jco.server.trace", "Enable/disable RFC trace (1 or 0)"}, {"jco.server.snc_myname", "SNC name"}, {"jco.server.snc_qop", "SNC level of security, 1 to 9"}, {"jco.server.snc_lib", "Path to the SNC library"}, {"jco.server.max_startup_delay", "Maximum server startup delay time in seconds"}, {"jco.server.saprouter", "SAPRouter string"}};
                systemPrepareAttachGuiImports = new DefaultListMetaData("IMPORTS", 3);
                systemPrepareAttachGuiExports = new DefaultListMetaData("EXPORTS", 4);
                systemFinishAttachGuiImports = new DefaultListMetaData("IMPORTS", 3);
                properties.put(JCO_NAME, NAME);
                properties.put(JCO_VERSION, VERSION);
                properties.put(JCO_WAIT_FOR_REQUEST_TIME, "2");
                properties.put(JCO_MW_MAX_STARTUP_DELAY, "3600");
                properties.put(JCO_NATIVE_LAYER_VERSION, nativeLayer_version);
                try {
                    nativeLayer_version = RfcApi.RfcGetVersion();
                    properties.put(JCO_NATIVE_LAYER_VERSION, nativeLayer_version);
                    if (Trace.isOn(8)) {
                        Trace.fireTrace(8, "[JCoRFC] Java RFC native layer version: " + nativeLayer_version);
                    }
                }
                catch (Throwable t) {
                    if (!Environment.inStandalone()) break block11;
                    JCoRuntime.nativeLibraryLoadFailure = true;
                    throw new ExceptionInInitializerError("Error getting the version of the native layer: " + t.toString());
                }
            }
            if (MiddlewareJavaRfc.compareVersions(nativeLayer_version, REQUIRED_NATIVE_VERSION) < 0) {
                if (Environment.inStandalone()) {
                    JCoRuntime.nativeLibraryLoadFailure = true;
                    JCoRuntime.nativeLibraryVersionInfo = "Native library sapjco3 is too old. Found library " + JCoRuntime.nativeLibraryPath + " has version \"" + nativeLayer_version + "\", but required is at least version \"" + REQUIRED_NATIVE_VERSION + "\".";
                    throw new ExceptionInInitializerError(JCoRuntime.nativeLibraryVersionInfo);
                }
                Trace.fireTrace(0, "Native layer for JCo is too old to guarantee correct behavior. Found version \"" + nativeLayer_version + "\", but required is at least version \"" + REQUIRED_NATIVE_VERSION + "\".");
            }
            String jrfc_clientConnectTimeout = System.getProperty(JRFC_CLIENT_CONNECT_TIMEOUT);
            try {
                if (jrfc_clientConnectTimeout != null && jrfc_clientConnectTimeout.length() != 0) {
                    int seconds = Integer.parseInt(jrfc_clientConnectTimeout);
                    if (seconds < 1) {
                        seconds = 1;
                    } else if (seconds > 3600) {
                        seconds = 3600;
                    }
                    RfcIoOpenCntl.setClientConnectTimeout(seconds);
                }
            }
            catch (Throwable t) {
                if (!Trace.isOn(8)) break block12;
                Trace.fireTrace(8, "Could not set jrfc client connect timeout: " + t);
            }
        }
        systemPrepareAttachGuiImports.add("DEBUG", 8, 4, 4, 3);
        systemPrepareAttachGuiImports.add("GUI", 8, 4, 4, 3);
        systemPrepareAttachGuiImports.add("SNC", 8, 4, 4, 3);
        systemPrepareAttachGuiImports.lock();
        systemPrepareAttachGuiExports.add("SAPGUI_ID", 0, 32, 64, 5);
        systemPrepareAttachGuiExports.add("START_GUI_COMMAND", 0, 1024, 2048, 5);
        systemPrepareAttachGuiExports.add("SYSTEM_ID", 0, 32, 64, 5);
        systemPrepareAttachGuiExports.add("SYSTEM_NR", 8, 4, 4, 5);
        systemPrepareAttachGuiExports.lock();
        systemFinishAttachGuiImports.add("CONNECTSTRING", 0, 1024, 2048, 3);
        systemFinishAttachGuiImports.add("MESSAGE", 0, 128, 256, 3);
        systemFinishAttachGuiImports.add("SAPGUI_ID", 0, 32, 64, 2);
        systemFinishAttachGuiImports.lock();
    }

    class JavaRfcServer
    extends JavaRfcConnection
    implements JCoMiddleware.Server {
        RfcAcceptInfo acceptParams;
        private RfcException callbackException;

        JavaRfcServer() {
            this.callbackException = null;
        }

        public String[][] getPropertyInfo() {
            return pinfoServer;
        }

        public void accept(ServerConnection conn) throws JCoException {
            DefaultServer group = conn.getServer();
            conn.state = (byte)2;
            this.callbackException = null;
            if (conn.rfcHandle != null && conn.rfcHandle.isUsed()) {
                this.releaseHandle(conn);
            }
            if (Trace.isOn(128, true)) {
                Trace.fireTrace(128, "[JCoRFC] Accept before RfcAccept(" + group.connParams + ')');
            }
            try {
                conn.rfcHandle = RfcApi.RfcAccept((RfcAcceptInfo)group.getMiddlewareInterface().getAcceptParameters(), conn);
            }
            catch (RfcException re) {
                if (Trace.isOn(2, true)) {
                    Trace.fireTrace(2, "Accept in RfcAccept(" + group.connParams + ") throws " + re.toString());
                }
                int excGroup = 129;
                String key = "JCO_ERROR_SERVER_STARTUP";
                if (re.getErrorGroup() == 101) {
                    excGroup = 101;
                    key = "JCO_ERROR_CONFIGURATION";
                }
                throw new JCoException(excGroup, key, "Could not start server: " + re.getMessage(), re);
            }
            catch (Throwable t) {
                throw new JCoException(129, "JCO_ERROR_SERVER_STARTUP", "Could not start server: " + t.getMessage(), t);
            }
            if (Trace.isOn(128, true)) {
                Trace.fireTrace(128, "[JCoRFC] Accept after RfcAccept(" + group.connParams + ")=" + conn.rfcHandle.hrfc);
            }
            conn.state = (byte)(conn.state | 8);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void listen(ServerWorker server) throws JCoException {
            String functionModule;
            block71: {
                if (server.conn.rfcHandle == null) {
                    throw new JCoException(133, "JCO_ERROR_INVALID_HANDLE", "Handle equals RFC_HANDLE_NULL encountered in listen.");
                }
                int rc = 0;
                try {
                    rc = server.conn.rfcHandle.RfcListen(wait_for_request_time);
                    if (Trace.isOn(256)) {
                        Trace.fireTrace(32, "[JCoRFC] RfcListen(" + server.conn.getConnectionHandle() + ", " + wait_for_request_time + ") = " + rfc_return_codes[rc]);
                    }
                }
                catch (RfcException re) {
                    int exrc = re.getRc();
                    switch (exrc) {
                        case 0: 
                        case 7: {
                            return;
                        }
                        case 6: {
                            server.sessionClosingInternal("Session was closed by peer", false);
                            server.removeConnectionHandle();
                            server.conn.rfcHandle.RfcClose();
                            this.releaseHandle(server.conn);
                            return;
                        }
                        case 3: 
                        case 20: {
                            server.sessionClosingInternal(re.getMessage(), true);
                            server.removeConnectionHandle();
                            server.conn.rfcHandle.RfcClose();
                            this.releaseHandle(server.conn);
                            return;
                        }
                        case 25: {
                            server.sessionClosingInternal(re.getMessage(), true);
                            server.removeConnectionHandle();
                            server.conn.rfcHandle.RfcClose();
                            this.releaseHandle(server.conn);
                            throw MiddlewareJavaRfc.this.generateJCoException(re);
                        }
                    }
                    if (Trace.isOn(4)) {
                        Trace.fireTrace(4, "[JCoRFC] Listen in exception: return code " + rfc_return_codes[exrc]);
                    }
                    throw MiddlewareJavaRfc.this.generateJCoException(re);
                }
                catch (Throwable t) {
                    if (Trace.isOn(4)) {
                        Trace.fireTrace(4, "[JCoRFC] Error during communication: " + t.getMessage(), t);
                    }
                    throw new JCoException(102, "JCO_ERROR_COMMUNICATION", "Error during communication: " + t.getMessage(), t);
                }
                if (rc != 0 || (server.conn.state & 8) == 0) {
                    if (rc == 6 || rc == 20 || rc == 3) {
                        server.removeConnectionHandle();
                        if (rc == 6) {
                            server.sessionClosingInternal("Session was closed by peer", false);
                            server.conn.rfcHandle.RfcClose();
                        } else if (rc == 20 || rc == 3) {
                            server.sessionClosingInternal("Connection closed by partner", true);
                            server.conn.rfcHandle.RfcClose();
                        }
                        this.releaseHandle(server.conn);
                    }
                    return;
                }
                functionModule = null;
                try {
                    functionModule = server.conn.rfcHandle.RfcGetName();
                }
                catch (RfcException re) {
                    int exrc = re.getRc();
                    if (exrc == 6) {
                        server.removeConnectionHandle();
                        server.sessionClosingInternal("Session was closed by peer", false);
                        server.conn.rfcHandle.RfcClose();
                        this.releaseHandle(server.conn);
                    }
                    if (exrc == 0 || exrc == 7) break block71;
                    if (Trace.isOn(4)) {
                        Trace.fireTrace(4, "[JCoRFC] Listen in exception: return code " + rfc_return_codes[exrc]);
                    }
                    throw MiddlewareJavaRfc.this.generateJCoException(re);
                }
            }
            if (functionModule == null) {
                JCoException exc = new JCoException(102, "JCO_ERROR_COMMUNICATION", "Listen received null function module for " + server.conn.getConnectionHandle());
                if (Trace.isOn(4)) {
                    Trace.fireTrace(4, exc.getMessage());
                }
                throw exc;
            }
            server.setState((byte)(server.getState() | 4));
            try {
                String currentSessionID = server.callStartedInternal();
                try {
                    block72: {
                        if (server.conn.sessionId == null) {
                            server.conn.authData.reset();
                            server.conn.authData.setSSOTicket(server.conn.attributes.getSSOTicket());
                            if (Trace.isOn(128)) {
                                Trace.fireTrace(128, "[JCoRFC] DispatchRequest before RfcSncMode(" + server.conn.getConnectionHandle() + ')');
                            }
                            boolean sncMode = server.conn.rfcHandle.RfcSncMode();
                            if (Trace.isOn(128)) {
                                Trace.fireTrace(128, "[JCoRFC] DispatchRequest after RfcSncMode(" + server.conn.getConnectionHandle() + ")=" + (sncMode ? "on" : "off"));
                            }
                            if (sncMode) {
                                String sncPartnerName = server.conn.rfcHandle.RfcSncPartnerName();
                                byte[] sncPartnerAclKey = server.conn.rfcHandle.RfcSncPartnerAclKey();
                                server.conn.authData.setAuthorizationData(0, sncPartnerAclKey, sncPartnerName);
                            } else {
                                server.conn.authData.setAuthorizationData(1, null, null);
                            }
                        }
                        Thread currentThread = Thread.currentThread();
                        server.conn.threadId = currentThread.getId();
                        server.conn.threadName = currentThread.getName();
                        try {
                            this.getAttributes(server.getConnection());
                            if (functionModule.equals("ARFC_DEST_SHIP")) {
                                if (Trace.isOn(128)) {
                                    Trace.fireTrace(128, "[JCoRFC] Listen calling handletRfcRequest(" + server.conn.getConnectionHandle() + '/' + server.conn.getConversationID() + ')');
                                }
                                this.handletRfcRequest((DefaultServerWorker)server);
                                if (Trace.isOn(128)) {
                                    Trace.fireTrace(128, "[JCoRFC] Listen after handletRfcRequest(" + server.conn.getConnectionHandle() + '/' + server.conn.getConversationID() + ')');
                                }
                            } else if (functionModule.equals("ARFC_DEST_CONFIRM") || functionModule.equals("API_CLEAR_TID")) {
                                if (Trace.isOn(128)) {
                                    Trace.fireTrace(128, "[JCoRFC] Listen calling handletRfcConfirm(" + server.conn.getConnectionHandle() + '/' + server.conn.getConversationID() + ')');
                                }
                                this.handletRfcConfirm((DefaultServerWorker)server);
                                if (Trace.isOn(128)) {
                                    Trace.fireTrace(128, "[JCoRFC] Listen after handletRfcConfirm(" + server.conn.getConnectionHandle() + '/' + server.conn.getConversationID() + ')');
                                }
                            } else if (functionModule.equals("BGRFC_DEST_SHIP")) {
                                if (Trace.isOn(128)) {
                                    Trace.fireTrace(128, "[JCoRFC] Listen calling handleBgRfcDestShip(" + server.conn.getConnectionHandle() + '/' + server.conn.getConversationID() + ')');
                                }
                                this.handleBgRfcRequest((DefaultServerWorker)server);
                                if (Trace.isOn(128)) {
                                    Trace.fireTrace(128, "[JCoRFC] Listen after handleBgRfcDestShip(" + server.conn.getConnectionHandle() + '/' + server.conn.getConversationID() + ')');
                                }
                            } else if (functionModule.equals("BGRFC_DEST_CONFIRM")) {
                                if (Trace.isOn(128)) {
                                    Trace.fireTrace(128, "[JCoRFC] Listen calling handleBgRfcConfirm(" + server.conn.getConnectionHandle() + '/' + server.conn.getConversationID() + ')');
                                }
                                this.handleBgRfcConfirm((DefaultServerWorker)server);
                                if (Trace.isOn(128)) {
                                    Trace.fireTrace(128, "[JCoRFC] Listen after handleBgRfcConfirm(" + server.conn.getConnectionHandle() + '/' + server.conn.getConversationID() + ')');
                                }
                            } else if (functionModule.equals("BGRFC_CHECK_UNIT_STATE_SERVER")) {
                                if (Trace.isOn(128)) {
                                    Trace.fireTrace(128, "[JCoRFC] Listen calling handleBgRfcConfirm(" + server.conn.getConnectionHandle() + '/' + server.conn.getConversationID() + ')');
                                }
                                this.handleBgRfcCheckUnitState((DefaultServerWorker)server);
                                if (Trace.isOn(128)) {
                                    Trace.fireTrace(128, "[JCoRFC] Listen after handleBgRfcConfirm(" + server.conn.getConnectionHandle() + '/' + server.conn.getConversationID() + ')');
                                }
                            } else {
                                if (Trace.isOn(128)) {
                                    Trace.fireTrace(128, "[JCoRFC] Listen calling dispatchRequest(" + server.conn.getConnectionHandle() + '/' + server.conn.getConversationID() + ", " + functionModule + ')');
                                }
                                this.dispatchRequest(server, functionModule);
                                if (Trace.isOn(128)) {
                                    Trace.fireTrace(128, "[JCoRFC] Listen after dispatchRequest(" + server.conn.getConnectionHandle() + '/' + server.conn.getConversationID() + ", " + functionModule + ')');
                                }
                            }
                            Object var9_21 = null;
                        }
                        catch (Throwable throwable) {
                            block73: {
                                Object var9_22 = null;
                                try {
                                    server.callFinishedInternal(currentSessionID);
                                }
                                catch (Throwable th) {
                                    Trace.fireTrace(4, "[JCoRFC] Listen caught an application exception in endCall " + th.toString(), th);
                                    if (th instanceof Exception) {
                                        Trc.criticalTrace("Application threw an exception from endCall ", (Exception)th);
                                        break block73;
                                    }
                                    Trc.criticalTrace("Application threw an exception from endCall ", (Error)th);
                                }
                            }
                            throw throwable;
                        }
                        try {
                            server.callFinishedInternal(currentSessionID);
                        }
                        catch (Throwable th) {
                            Trace.fireTrace(4, "[JCoRFC] Listen caught an application exception in endCall " + th.toString(), th);
                            if (th instanceof Exception) {
                                Trc.criticalTrace("Application threw an exception from endCall ", (Exception)th);
                                break block72;
                            }
                            Trc.criticalTrace("Application threw an exception from endCall ", (Error)th);
                        }
                    }
                    server.conn.rfcHandle.flushServerConnection();
                }
                catch (DispatchException de) {
                }
                catch (RfcException re) {
                    int exrc = re.getRc();
                    if (exrc == 6) {
                        server.removeConnectionHandle();
                        server.sessionClosingInternal("Session was closed by peer", false);
                        server.conn.rfcHandle.RfcClose();
                        this.releaseHandle(server.conn);
                    } else if (exrc != 0 && exrc != 7) {
                        if (Trace.isOn(4)) {
                            Trace.fireTrace(4, "[JCoRFC] Listen caught an internal exception: return code " + rfc_return_codes[exrc]);
                        }
                        throw MiddlewareJavaRfc.this.generateJCoException(re);
                    }
                }
                catch (Exception e) {
                    server.fireServerExceptionOccurred(e);
                    String message = e.getMessage();
                    if (message == null) {
                        message = e.toString();
                    }
                    Trace.fireTrace(4, "[JCoRFC] DispatchRequest caught an exception: " + message, e);
                    Trc.criticalTrace("Exception thrown in JCo Server", e);
                    this.abort(server, message);
                }
                catch (Error e) {
                    server.fireServerErrorOccurred(e);
                    String message = e.getMessage();
                    if (message == null) {
                        message = e.toString();
                    }
                    Trace.fireTraceCritical("[JCoRFC] DispatchRequest caught an error: " + message, e);
                    Trc.criticalTrace("Error thrown in JCo Server", e);
                    this.abort(server, message);
                }
                Object var12_26 = null;
                server.setState((byte)(server.getState() & 0xFFFFFFFB));
            }
            catch (Throwable throwable) {
                Object var12_27 = null;
                server.setState((byte)(server.getState() & 0xFFFFFFFB));
                throw throwable;
            }
        }

        public void disconnect(ServerConnection conn) {
            conn.getServer().removeConnection(conn);
            super.disconnect(conn);
        }

        public void abort(ServerWorker server, String message) {
            server.sessionClosingInternal(message, true);
            try {
                server.removeConnectionHandle();
                super.abort(server.getConnection(), message);
            }
            catch (Exception e) {
                server.fireServerExceptionOccurred(e);
            }
        }

        public void getAttributes(ServerConnection conn) throws JCoException {
            super.getAttributes(conn);
        }

        protected void handletRfcRequest(DefaultServerWorker server) throws RfcException {
            int dwFlag = 0;
            IRfcTable[] tables = new TableParameter[2];
            ARFCSDATA data = new ARFCSDATA(server.conn.rfcHandle, "DATA");
            ARFCSSTATE state = new ARFCSSTATE(server.conn.rfcHandle, "STATE");
            tables[0] = data;
            tables[1] = state;
            server.conn.rfcHandle.RfcGetData(null, null, null, tables, server.getRepository());
            server.conn.rfcHandle.ab_rfccount(1);
            if (state.isActive()) {
                dwFlag = 3;
            }
            this.playbackTRfc(server.conn.rfcHandle, data, dwFlag, state, server);
            server.conn.rfcHandle.RfcSendData(null, null, tables);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        protected void playbackTRfc(RfcIoOpenCntl act_cntl, ARFCSDATA data, int dwFlag, ARFCSSTATE state, DefaultServerWorker server) throws RfcException {
            String arfcUser = null;
            String arfcTid = null;
            if ((dwFlag & 1) != 0) {
                if (!state.isActive()) throw new RfcException(1, "With/Without state", 104, act_cntl.hrfc, true);
                DefaultTable table = state.getTable();
                try {
                    table.firstRow();
                    arfcUser = table.getString(8);
                    arfcTid = table.getString(0);
                }
                catch (ConversionException ex) {}
            } else {
                arfcUser = act_cntl.userid;
                if ((dwFlag & 2) != 0) throw new RfcException(1, "No State+NoTID+CheckTID", 104, act_cntl.hrfc, true);
                arfcTid = "000000000000000000000000";
            }
            if (!data.isActive()) {
                return;
            }
            int numRows = data.getNumRows();
            if (numRows == 0) {
                throw new RfcException(1, "Empty LUW", 104, act_cntl.hrfc, true);
            }
            try {
                block34: {
                    server.setState((byte)(server.conn.state | 0x10));
                    server.ctx.tid = arfcTid;
                    boolean executeTransaction = true;
                    if ((dwFlag & 2) != 0) {
                        try {
                            if (Trace.isOn(128)) {
                                Trace.fireTrace(128, "[JCoRFC] playbackTRfc calling onCheckTID(" + server.conn.getConnectionHandle() + ", " + arfcTid + ")");
                            }
                            executeTransaction = server.onCheckTID(arfcTid);
                            if (Trace.isOn(128)) {
                                Trace.fireTrace(128, "[JCoRFC] playbackTRfc after onCheckTID(" + server.conn.getConnectionHandle() + ", " + arfcTid + ")=" + executeTransaction);
                            }
                        }
                        catch (Exception e) {
                            String message = e.getMessage();
                            if (message != null) throw new RfcException(1, "check TID fault: " + message, 104, act_cntl.hrfc, true);
                            message = e.toString();
                            throw new RfcException(1, "check TID fault: " + message, 104, act_cntl.hrfc, true);
                        }
                    }
                    if (executeTransaction) {
                        try {
                            block33: {
                                RfcPlaybackInfo info = new RfcPlaybackInfo();
                                RfcIoOpenCntl tRfcHandle = null;
                                info.itab_h = data;
                                info.checkParameters();
                                RfcIoOpenCntl origCntl = server.conn.rfcHandle;
                                server.conn.rfcHandle = tRfcHandle = this.createSubHandle(server.conn.rfcHandle, info);
                                tRfcHandle.userid = arfcUser != null && arfcUser.length() > 0 ? arfcUser : act_cntl.userid;
                                try {
                                    Object var15_20;
                                    try {
                                        this.executePlayback(tRfcHandle, server);
                                    }
                                    catch (RfcException ex) {
                                        if (ex.getRc() != 6) {
                                            if (!origCntl.trace) throw ex;
                                            Trc.ab_rfctrc("TRFC Error> playback [" + origCntl.hrfc + "] exited with: " + ex.toString() + ". \n>>>>Abort.\n");
                                            throw ex;
                                        }
                                        var15_20 = null;
                                        server.conn.rfcHandle.RfcClose();
                                        this.releaseHandle(server.conn);
                                        server.conn.rfcHandle = origCntl;
                                        break block33;
                                    }
                                    var15_20 = null;
                                    server.conn.rfcHandle.RfcClose();
                                }
                                catch (Throwable throwable) {
                                    Object var15_21 = null;
                                    server.conn.rfcHandle.RfcClose();
                                    this.releaseHandle(server.conn);
                                    server.conn.rfcHandle = origCntl;
                                    throw throwable;
                                }
                                this.releaseHandle(server.conn);
                                server.conn.rfcHandle = origCntl;
                            }
                            if ((dwFlag & 2) == 0) break block34;
                            try {
                                if (Trace.isOn(128)) {
                                    Trace.fireTrace(128, "[JCoRFC] playbackTRfc calling onCommit(" + server.conn.getConnectionHandle() + ", " + arfcTid + ")");
                                }
                                server.onCommit(arfcTid);
                            }
                            catch (Throwable th) {
                                String string;
                                if (act_cntl.trace) {
                                    StringWriter sw = new StringWriter();
                                    PrintWriter pw = new PrintWriter(sw);
                                    th.printStackTrace(pw);
                                    pw.flush();
                                    FastStringBuffer text = new FastStringBuffer(120);
                                    text.append("TRFC Error> server.onCommit(").append(arfcTid).append(") failed with application exception \n   ").append(sw.getBuffer().toString());
                                    if (act_cntl.trace) {
                                        Trc.ab_rfctrc(text.toString());
                                    }
                                }
                                String message = th.getMessage();
                                StringBuilder stringBuilder = new StringBuilder().append("Commit fault: ");
                                if (message == null) {
                                    string = th.toString();
                                    throw new RfcException(1, stringBuilder.append(string).toString(), 104, act_cntl.hrfc, true);
                                }
                                string = message;
                                throw new RfcException(1, stringBuilder.append(string).toString(), 104, act_cntl.hrfc, true);
                            }
                        }
                        catch (RfcException ex) {
                            if (ex.getRc() == 6) throw ex;
                            try {
                                if (Trace.isOn(128)) {
                                    Trace.fireTrace(128, "[JCoRFC] playbackTRfc calling onRollback(" + server.conn.getConnectionHandle() + ", " + arfcTid + ")");
                                }
                                server.onRollback(arfcTid);
                                throw ex;
                            }
                            catch (Exception e) {
                                long l;
                                if (act_cntl != null && act_cntl.trace) {
                                    StringWriter sw = new StringWriter();
                                    PrintWriter pw = new PrintWriter(sw);
                                    e.printStackTrace(pw);
                                    pw.flush();
                                    FastStringBuffer text = new FastStringBuffer(120);
                                    text.append("TRFC Error> server.onRollback(").append(arfcTid).append(") failed with application exception \n   ").append(sw.getBuffer().toString());
                                    if (act_cntl.trace) {
                                        Trc.ab_rfctrc(text.toString());
                                    }
                                }
                                String message = e.getMessage();
                                String string = "Rollback fault: " + (message == null ? "no message" : message);
                                if (act_cntl != null) {
                                    l = act_cntl.hrfc;
                                    throw new RfcException(1, string, 104, l, true);
                                }
                                l = 0L;
                                throw new RfcException(1, string, 104, l, true);
                            }
                        }
                    }
                }
                Object var18_29 = null;
                server.ctx.tid = null;
                server.setState((byte)(server.conn.state & 0xFFFFFFEF));
                return;
            }
            catch (Throwable throwable) {
                Object var18_30 = null;
                server.ctx.tid = null;
                server.setState((byte)(server.conn.state & 0xFFFFFFEF));
                throw throwable;
            }
        }

        boolean clientSupportsIsSupplied(ServerConnection conn) {
            if (conn.rfcHandle != null) {
                return conn.rfcHandle.receivedIsSupplied;
            }
            return false;
        }

        private RfcIoOpenCntl createSubHandle(RfcIoOpenCntl orgCntl, RfcAcceptInfo info) throws RfcException {
            RfcIoOpenCntl rfcHandle = RfcIoControl.ab_rfcaccept(info, orgCntl);
            if (rfcHandle == null) {
                if (orgCntl.trace) {
                    Trc.ab_rfctrc("Error> Could not open playback handle\n");
                }
                throw new RfcException(1, "Error> ab_rfcaccept failed\n", 108, orgCntl.hrfc, true);
            }
            rfcHandle.destination = orgCntl.destination;
            orgCntl.copyRawCPICConversationID(rfcHandle);
            rfcHandle.mandt = orgCntl.mandt;
            rfcHandle.lang = orgCntl.lang;
            rfcHandle.setCodepage(orgCntl.getCodepage());
            rfcHandle.intformat = orgCntl.intformat;
            rfcHandle.setCommunicationCodepage(orgCntl.getCommunicationCodepage());
            rfcHandle.pcs = orgCntl.pcs;
            rfcHandle.real_pcs = orgCntl.real_pcs;
            rfcHandle.trace = orgCntl.trace;
            rfcHandle.htRFC = orgCntl;
            rfcHandle.th_client_id = orgCntl.th_client_id;
            rfcHandle.kernel_rel = orgCntl.kernel_rel;
            rfcHandle.partner_rel = orgCntl.partner_rel;
            rfcHandle.partner_type = orgCntl.partner_type;
            rfcHandle.own_type = orgCntl.own_type;
            rfcHandle.own_rel = orgCntl.own_rel;
            rfcHandle.rfc_role = orgCntl.rfc_role;
            rfcHandle.target = orgCntl.target;
            rfcHandle.mysapsso2 = orgCntl.mysapsso2;
            return rfcHandle;
        }

        private void executePlayback(RfcIoOpenCntl cntl, ServerWorker server) throws RfcException {
            while (true) {
                String funcName = null;
                try {
                    funcName = RfcGetName.ab_RfcDispatchLoc(cntl);
                }
                catch (RfcException re) {
                    if (cntl.trace) {
                        Trc.ab_rfctrc("TRFC> RfcGetName.ab_RfcDispatchLoc[" + cntl.hrfc + "] ex.getRC returned " + re.getRc() + "\n");
                    }
                    throw re;
                }
                if (funcName == null) continue;
                if (cntl.trace) {
                    Trc.ab_rfctrc("TRFC> Call [" + cntl.hrfc + "] dispatched to: " + funcName + "\n");
                }
                try {
                    this.dispatchRequest(server, funcName);
                }
                catch (Throwable th) {
                    String message = th.getMessage();
                    throw new RfcException(1, message == null ? th.toString() : message, 104, server.conn.getConnectionHandle(), false, th);
                }
            }
        }

        protected void handletRfcConfirm(DefaultServerWorker server) {
            IRfcParameter[] parameters = new IRfcParameter[2];
            RfcChars callid = new RfcChars(server.conn.rfcHandle, "CALLID", 24);
            RfcChars tid = new RfcChars(server.conn.rfcHandle, "TID", 24);
            parameters[0] = callid;
            parameters[1] = tid;
            try {
                block6: {
                    server.conn.rfcHandle.RfcGetData(parameters, null, null, null, server.getRepository());
                    try {
                        if (Trace.isOn(128)) {
                            Trace.fireTrace(128, "[JCoRFC] handletRfcConfirm calling onConfirm(" + server.conn.getConnectionHandle() + ", " + (callid.getLength() == 0 ? tid.toString() : callid.toString()) + ")");
                        }
                        server.onConfirmTID(callid.getLength() == 0 ? tid.toString() : callid.toString());
                    }
                    catch (Throwable t) {
                        Trace.fireTraceCritical("[JCoRFC] onConfirm failed: " + t.toString(), t);
                        if (t instanceof RuntimeException) {
                            throw (RuntimeException)t;
                        }
                        if (!(t instanceof Error)) break block6;
                        throw (Error)t;
                    }
                }
                server.conn.rfcHandle.ab_rfccount(0);
                server.conn.rfcHandle.RfcSendData(null, null, null);
            }
            catch (RfcException e) {
                Trace.fireTraceCritical("[JCoRFC] onConfirm failed: " + e.toString());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private void handleBgRfcRequest(DefaultServerWorker server) throws RfcException {
            boolean executeUnit = false;
            server.setState((byte)(server.conn.state | 0x20));
            try {
                RfcIoOpenCntl origHandle = server.conn.rfcHandle;
                BgRfcUnit unit = server.conn.rfcHandle.RfcDispatchUnit(server.getRepository());
                BgRfcRecorderInfo info = new BgRfcRecorderInfo();
                server.ctx.bgRfcCallCtx.unitAttributes = unit.getAttributes();
                server.ctx.bgRfcCallCtx.unitIdentifier.update(unit.getUnitId(), unit.getUnitType());
                try {
                    executeUnit = server.unitIDHandler.checkUnitID(server.ctx, server.ctx.bgRfcCallCtx.unitIdentifier);
                }
                catch (Exception e) {
                    String message;
                    if (Trace.isOn(4, true)) {
                        Trace.fireTrace(4, "Exception in onCheckUnitID: " + e.toString(), e);
                    }
                    if ((message = e.getMessage()) != null) throw new RfcException(1, "onCheckUnitID fault: " + message, 104, origHandle.hrfc, true);
                    message = e.toString();
                    throw new RfcException(1, "onCheckUnitID fault: " + message, 104, origHandle.hrfc, true);
                }
                if (executeUnit) {
                    block21: {
                        try {
                            RfcIoOpenCntl origCntl = server.conn.rfcHandle;
                            for (int i = 0; i < unit.getFunctionCount(); ++i) {
                                Object var11_16;
                                try {
                                    try {
                                        RfcIoOpenCntl bgRfcHandle;
                                        server.conn.rfcHandle = bgRfcHandle = this.createSubHandle(server.conn.rfcHandle, info);
                                        unit.setCurrentFunctionData(i, bgRfcHandle);
                                        this.executePlayback(bgRfcHandle, server);
                                    }
                                    catch (RfcException ex) {
                                        if (ex.getRc() != 6) {
                                            if (!origCntl.trace) throw ex;
                                            Trc.ab_rfctrc("BGRFC Error> playback [" + origCntl.hrfc + "] exited with: " + ex.toString() + ". \n>>>>Abort.\n");
                                            throw ex;
                                        }
                                        var11_16 = null;
                                        server.conn.rfcHandle.RfcClose();
                                        this.releaseHandle(server.conn);
                                        server.conn.rfcHandle = origCntl;
                                        continue;
                                    }
                                    var11_16 = null;
                                    server.conn.rfcHandle.RfcClose();
                                }
                                catch (Throwable throwable) {
                                    var11_16 = null;
                                    server.conn.rfcHandle.RfcClose();
                                    this.releaseHandle(server.conn);
                                    server.conn.rfcHandle = origCntl;
                                    throw throwable;
                                }
                                this.releaseHandle(server.conn);
                                server.conn.rfcHandle = origCntl;
                            }
                            try {
                                if (Trace.isOn(128)) {
                                    Trace.fireTrace(128, "[JCoRFC] playbackBgRfc calling onCommit(" + server.conn.getConnectionHandle() + ", " + unit.getUnitId() + ")");
                                }
                                server.unitIDHandler.commit(server.ctx, server.ctx.bgRfcCallCtx.unitIdentifier);
                            }
                            catch (Throwable th) {
                                String message;
                                if (origHandle.trace) {
                                    Trc.ab_rfctrc("BGRFC Error> server.onCommit(" + unit.getUnitId() + ") failed." + th.toString(), th);
                                }
                                if ((message = th.getMessage()) != null) throw new RfcException(1, "Commit fault: " + message, 104, origHandle.hrfc, true);
                                message = th.toString();
                                throw new RfcException(1, "Commit fault: " + message, 104, origHandle.hrfc, true);
                            }
                        }
                        catch (RfcException exc) {
                            if (exc.getRc() == 6) break block21;
                            try {
                                if (Trace.isOn(128)) {
                                    Trace.fireTrace(128, "[JCoRFC] playbackTRfc calling onRollback(" + server.conn.getConnectionHandle() + ", " + unit.getUnitId() + ")");
                                }
                                server.unitIDHandler.rollback(server.ctx, server.ctx.bgRfcCallCtx.unitIdentifier);
                                throw exc;
                            }
                            catch (Exception e) {
                                if (!origHandle.trace) throw exc;
                                Trc.ab_rfctrc("BGRFC Error> server.onRollback(" + unit.getUnitId() + ") failed." + e.toString(), e);
                            }
                            throw exc;
                        }
                    }
                    server.conn.rfcHandle.ab_rfccount(1);
                    server.conn.rfcHandle.RfcFinishDispatch(unit);
                }
                Object var13_18 = null;
                server.ctx.bgRfcCallCtx.unitIdentifier.update(null, null);
                server.ctx.bgRfcCallCtx.unitAttributes = null;
                server.setState((byte)(server.conn.state & 0xFFFFFFDF));
                return;
            }
            catch (Throwable throwable) {
                Object var13_19 = null;
                server.ctx.bgRfcCallCtx.unitIdentifier.update(null, null);
                server.ctx.bgRfcCallCtx.unitAttributes = null;
                server.setState((byte)(server.conn.state & 0xFFFFFFDF));
                throw throwable;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void handleBgRfcConfirm(DefaultServerWorker server) {
            Converter conv = new Converter(server.conn.rfcHandle);
            AbapFunction bgRfcDestShip = StaticFunctionTemplates.getBGRFC_DEST_CONFIRMTemplate().getFunction();
            DefaultParameterList importParams = (DefaultParameterList)bgRfcDestShip.getImportParameterList();
            IRfcParameter[] imports = new IRfcParameter[importParams.getFieldCount()];
            for (int i = 0; i < imports.length; ++i) {
                imports[i] = new Parameter(importParams, i, conv);
            }
            try {
                try {
                    block9: {
                        server.conn.rfcHandle.RfcGetData(imports, null, null, null, server.getRepository());
                        byte[] unitIDBytes = importParams.getByteArray("UNIT_ID");
                        int unitKind = importParams.getInt("UNIT_KIND");
                        if (Trace.isOn(128)) {
                            String unitID = Codecs.Hex.encode(unitIDBytes);
                            Trace.fireTrace(128, "[JCoRFC] handleBgRfcConfirm calling confirmID(" + server.conn.getConnectionHandle() + ", " + unitID + ")");
                        }
                        server.ctx.bgRfcCallCtx.unitIdentifier.update(unitIDBytes, BgRfcUnit.convertUnitType(unitKind));
                        try {
                            server.unitIDHandler.confirmUnitID(server.ctx, server.ctx.bgRfcCallCtx.unitIdentifier);
                        }
                        catch (Throwable t) {
                            Trace.fireTraceCritical("[JCoRFC] The unit ID handler throws exception from confirmUnitID: " + t.toString(), t);
                            if (t instanceof RuntimeException) {
                                throw (RuntimeException)t;
                            }
                            if (!(t instanceof Error)) break block9;
                            throw (Error)t;
                        }
                    }
                    server.conn.rfcHandle.ab_rfccount(0);
                    server.conn.rfcHandle.RfcSendData(null, null, null);
                }
                catch (RfcException e) {
                    Trace.fireTraceCritical("[JCoRFC] onConfirm failed: " + e.toString());
                    Object var10_13 = null;
                    server.ctx.bgRfcCallCtx.unitIdentifier.update(null, null);
                }
                Object var10_12 = null;
                server.ctx.bgRfcCallCtx.unitIdentifier.update(null, null);
            }
            catch (Throwable throwable) {
                Object var10_14 = null;
                server.ctx.bgRfcCallCtx.unitIdentifier.update(null, null);
                throw throwable;
            }
        }

        private void handleBgRfcCheckUnitState(DefaultServerWorker server) throws RfcException {
            Converter conv = new Converter(server.conn.rfcHandle);
            AbapFunction bgRfcDestShip = StaticFunctionTemplates.getBGRFC_CHECK_UNIT_STATE_SERVERTemplate().getFunction();
            DefaultParameterList importParams = (DefaultParameterList)bgRfcDestShip.getImportParameterList();
            IRfcParameter[] imports = new IRfcParameter[importParams.getFieldCount()];
            for (int i = 0; i < imports.length; ++i) {
                imports[i] = new Parameter(importParams, i, conv);
            }
            DefaultParameterList exportParams = (DefaultParameterList)bgRfcDestShip.getExportParameterList();
            IRfcParameter[] exports = new IRfcParameter[exportParams.getFieldCount()];
            for (int i = 0; i < exports.length; ++i) {
                exports[i] = new Parameter(exportParams, i, conv);
            }
            try {
                try {
                    JCoFunctionUnitState state;
                    block10: {
                        server.conn.rfcHandle.RfcGetData(imports, null, null, null, server.getRepository());
                        byte[] unitIDBytes = importParams.getByteArray("UNIT_ID");
                        int unitKind = importParams.getInt("UNIT_KIND");
                        if (Trace.isOn(128)) {
                            String unitID = Codecs.Hex.encode(unitIDBytes);
                            Trace.fireTrace(128, "[JCoRFC] handleBgRfcConfirm calling getFunctionUnitState(" + server.conn.getConnectionHandle() + ", " + unitID + ")");
                        }
                        server.ctx.bgRfcCallCtx.unitIdentifier.update(unitIDBytes, BgRfcUnit.convertUnitType(unitKind));
                        state = null;
                        try {
                            state = server.unitIDHandler.getFunctionUnitState(server.ctx, server.ctx.bgRfcCallCtx.unitIdentifier);
                        }
                        catch (Throwable t) {
                            Trace.fireTraceCritical("[JCoRFC] The unit ID handler throws exception from getFunctionUnitState: " + t.toString(), t);
                            if (t instanceof RuntimeException) {
                                throw (RuntimeException)t;
                            }
                            if (!(t instanceof Error)) break block10;
                            throw (Error)t;
                        }
                    }
                    int ababState = BgRfcUnit.convertState(state);
                    exportParams.setValue("STATE", ababState);
                    server.conn.rfcHandle.ab_rfccount(0);
                    server.conn.rfcHandle.RfcSendData(exports, null, null);
                }
                catch (RfcException e) {
                    Trace.fireTraceCritical("[JCoRFC] getFunctionUnitState failed: " + e.toString());
                    throw e;
                }
                Object var13_16 = null;
                server.ctx.bgRfcCallCtx.unitIdentifier.update(null, null);
            }
            catch (Throwable throwable) {
                Object var13_17 = null;
                server.ctx.bgRfcCallCtx.unitIdentifier.update(null, null);
                throw throwable;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        protected void dispatchRequest(ServerWorker server, String functionModule) throws RfcException, Exception, DispatchException {
            long tstart = 0L;
            long ttotal = 0L;
            long tmarshall = 0L;
            long tunmarshall = 0L;
            long tmiddleware = 0L;
            long temp = 0L;
            long trequest = 0L;
            long receivedBytes = 0L;
            long sentBytes = 0L;
            JCoFunction function = null;
            ttotal = System.currentTimeMillis();
            try {
                try {
                    IRfcTable[] tables_rfc;
                    IRfcParameter[] exports_rfc;
                    IRfcParameter[] changings_rfc;
                    block90: {
                        IRfcParameter param;
                        int i;
                        DefaultParameterList tab;
                        DefaultParameterList chn;
                        block88: {
                            ArrayList<IRfcParameter> exports;
                            DefaultParameterList exp;
                            block89: {
                                block87: {
                                    FastStringBuffer buf;
                                    if (Trace.isOn(128)) {
                                        Trace.fireTrace(128, "[JCoRFC] Dispatching request for " + server.conn.getConnectionHandle() + ": " + functionModule);
                                    }
                                    this.getAttributes(server.getConnection());
                                    boolean authorized = server.checkAuthorization(functionModule, server.conn.authData);
                                    if (!authorized) {
                                        throw new JCoException(120, "JCO_ERROR_EXTENSION", "Not authorized to execute " + functionModule);
                                    }
                                    try {
                                        function = server.getFunction(functionModule);
                                    }
                                    catch (Exception e) {
                                        String shortText = e.getMessage();
                                        if (shortText == null || shortText.length() == 0) {
                                            shortText = e.toString();
                                        }
                                        shortText = shortText + " causes '" + functionModule + "' could not be created.";
                                        String message = "Server repository could not create function template for '" + functionModule + "' caused by: " + e.toString();
                                        Trc.criticalTrace(message, e);
                                        Trace.fireTraceCritical(message);
                                        throw new JCoException(123, "JCO_ERROR_FUNCTION_NOT_FOUND", shortText, e);
                                    }
                                    if (function == null) {
                                        String message = "'" + functionModule + "' could not be found in the server repository.";
                                        Trace.fireTraceCritical(message);
                                        throw new JCoException(123, "JCO_ERROR_FUNCTION_NOT_FOUND", message);
                                    }
                                    if (server.conn.rfcHandle.abapClassExceptionMode != AbapClassException.Mode.OFF) {
                                        function.setAbapClassExceptionMode(server.conn.rfcHandle.abapClassExceptionMode);
                                    }
                                    tstart = System.currentTimeMillis();
                                    DefaultParameterList imp = (DefaultParameterList)function.getImportParameterList();
                                    chn = (DefaultParameterList)function.getChangingParameterList();
                                    exp = (DefaultParameterList)function.getExportParameterList();
                                    tab = (DefaultParameterList)function.getTableParameterList();
                                    IRfcParameter[] imports_rfc = null;
                                    changings_rfc = null;
                                    exports_rfc = null;
                                    tables_rfc = null;
                                    if (imp != null) {
                                        ArrayList<IRfcParameter> imports = new ArrayList<IRfcParameter>(imp.metaData.numFields);
                                        for (i = 0; i < imp.metaData.numFields; ++i) {
                                            param = this.getParameter(imp, i);
                                            if (param == null) continue;
                                            imports.add(param);
                                        }
                                        if (imports.size() > 0) {
                                            imports_rfc = new IRfcParameter[imports.size()];
                                            imports_rfc = imports.toArray(imports_rfc);
                                        }
                                    }
                                    if (chn != null) {
                                        ArrayList<IRfcParameter> changings = new ArrayList<IRfcParameter>(chn.metaData.numFields);
                                        for (i = 0; i < chn.metaData.numFields; ++i) {
                                            param = this.getParameter(chn, i);
                                            if (param == null) continue;
                                            changings.add(param);
                                        }
                                        if (changings.size() > 0) {
                                            changings_rfc = new IRfcParameter[changings.size()];
                                            changings_rfc = changings.toArray(changings_rfc);
                                        }
                                    }
                                    if (exp != null) {
                                        ArrayList<IRfcParameter> exports2 = new ArrayList<IRfcParameter>(exp.metaData.numFields);
                                        for (i = 0; i < exp.metaData.numFields; ++i) {
                                            param = this.getParameter(exp, i);
                                            if (param == null) continue;
                                            exports2.add(param);
                                        }
                                        if (exports2.size() > 0) {
                                            exports_rfc = new IRfcParameter[exports2.size()];
                                            exports_rfc = exports2.toArray(exports_rfc);
                                        }
                                    }
                                    if (tab != null) {
                                        ArrayList<TableParameter> tables = new ArrayList<TableParameter>(tab.metaData.numFields);
                                        for (i = 0; i < tab.metaData.numFields; ++i) {
                                            if ((tab.flags[i] & 8) != 0 || (tab.flags[i] & 2) != 0) continue;
                                            tables.add(new TableParameter((DefaultTable)tab.odata[tab.metaData.oindex[i]], tab.metaData.name[i], this.converter, i));
                                        }
                                        if (tables.size() > 0) {
                                            tables_rfc = new TableParameter[tables.size()];
                                            tables_rfc = (TableParameter[])tables.toArray(tables_rfc);
                                        }
                                    }
                                    temp = System.currentTimeMillis();
                                    tmarshall = temp - tstart;
                                    tstart = temp;
                                    if (Trace.isOn(128)) {
                                        buf = new FastStringBuffer();
                                        buf.append("[JCoRFC] DispatchRequest before RfcGetData(").append(server.conn.getConnectionHandle()).append(", ");
                                        buf.append(functionModule).append(", ").append(imports_rfc == null ? "null" : Integer.toString(imports_rfc.length));
                                        buf.append(", ").append(changings_rfc == null ? "null" : Integer.toString(changings_rfc.length));
                                        buf.append(", ").append(tables_rfc == null ? "null" : Integer.toString(tables_rfc.length)).append(')');
                                        Trace.fireTrace(128, buf.toString());
                                    }
                                    server.conn.rfcHandle.RfcGetData(imports_rfc, exports_rfc, changings_rfc, tables_rfc, server.getRepository());
                                    if (Trace.isOn(128)) {
                                        buf = new FastStringBuffer();
                                        buf.append("[JCoRFC] DispatchRequest after RfcGetData(").append(server.conn.getConnectionHandle()).append(", ");
                                        buf.append(functionModule).append(", ").append(imports_rfc == null ? "null" : Integer.toString(imports_rfc.length));
                                        buf.append(", ").append(changings_rfc == null ? "null" : Integer.toString(changings_rfc.length));
                                        buf.append(", ").append(tables_rfc == null ? "null" : Integer.toString(tables_rfc.length)).append(')');
                                        Trace.fireTrace(128, buf.toString());
                                    }
                                    if (this.changeAttributes) {
                                        String savedTicket = server.conn.attributes.sso_ticket;
                                        this.getAttributes(server.conn);
                                        if (server.conn.attributes.sso_ticket == null && savedTicket != null) {
                                            server.conn.attributes.sso_ticket = savedTicket;
                                        }
                                    }
                                    temp = System.currentTimeMillis();
                                    tmiddleware = temp - tstart;
                                    tstart = temp;
                                    if (exports_rfc != null && this.clientSupportsIsSupplied(server.conn)) {
                                        for (int i2 = 0; i2 < exports_rfc.length; ++i2) {
                                            if (exports_rfc[i2].isActive()) continue;
                                            int n = exports_rfc[i2].getIndex();
                                            exp.flags[n] = (byte)(exp.flags[n] | 3);
                                        }
                                    }
                                    if (tables_rfc != null) {
                                        ArrayList<IRfcTable> tables = new ArrayList<IRfcTable>(tab.metaData.numFields);
                                        for (i = 0; i < tables_rfc.length; ++i) {
                                            if (!((TableParameter)tables_rfc[i]).isActive()) {
                                                int n = ((TableParameter)tables_rfc[i]).getIndex();
                                                tab.flags[n] = (byte)(tab.flags[n] | 3);
                                                continue;
                                            }
                                            if (((TableParameter)tables_rfc[i]).getNumRows() == 0) {
                                                int n = ((TableParameter)tables_rfc[i]).getIndex();
                                                tab.flags[n] = (byte)(tab.flags[n] | 1);
                                                tables.add(tables_rfc[i]);
                                                continue;
                                            }
                                            tables.add(tables_rfc[i]);
                                            int n = ((TableParameter)tables_rfc[i]).getIndex();
                                            tab.flags[n] = (byte)(tab.flags[n] & 0xFFFFFFFE);
                                        }
                                        if (tables.size() > 0) {
                                            tables_rfc = new TableParameter[tables.size()];
                                            tables_rfc = (TableParameter[])tables.toArray(tables_rfc);
                                        } else {
                                            tables_rfc = null;
                                        }
                                    }
                                    if (server.conn.throughput != null || monitorOn) {
                                        receivedBytes = MiddlewareJavaRfc.this.countBytes(imports_rfc, changings_rfc, tables_rfc);
                                    }
                                    if (Trace.isOn(128)) {
                                        Trace.fireTrace(128, "[JCoRFC] DispatchRequest before RfcGetClientId(" + server.conn.getConnectionHandle() + ')');
                                    }
                                    server.conn.passport_bytes = server.conn.rfcHandle.RfcGetClientId();
                                    if (Trace.isOn(128)) {
                                        Trace.fireTrace(128, "[JCoRFC] DispatchRequest after RfcGetClientId(" + server.conn.getConnectionHandle() + "), received " + (server.conn.passport_bytes == null ? "no passport" : "passport with length " + server.conn.passport_bytes.length));
                                    }
                                    server.conn.rfm_name = functionModule;
                                    server.conn.start_time = ttotal;
                                    if (server.conn.throughput != null || monitorOn) {
                                        server.conn.beginCall();
                                    }
                                    if (Trace.isOn(128)) {
                                        Trace.fireTrace(128, "[JCoRFC] DispatchRequest before JCO.Server.dispatchRequest " + functionModule);
                                    }
                                    try {
                                        server.dispatchRequest(function);
                                        if (this.callbackException != null) {
                                            throw this.callbackException;
                                        }
                                    }
                                    catch (Exception e) {
                                        if (this.callbackException != null) {
                                            if (Trace.isOn(4)) {
                                                Trace.fireTrace(4, "[JCoRFC] dispatchRequest: due to exception during the callback (" + this.callbackException.getCause().toString() + ") request is canceled");
                                            }
                                            server.sessionClosingInternal("Connection closed due to exception during a callback", true);
                                            server.removeConnectionHandle();
                                            this.callbackException = null;
                                            throw new DispatchException();
                                        }
                                        String message = e.getMessage();
                                        if (message == null) {
                                            message = e.toString();
                                        }
                                        if ((server.getState() & 0x30) != 0) {
                                            if (!Trace.isOn(4)) throw new RfcException(1, message, 104, server.conn.getConnectionHandle(), false, e);
                                            Trace.fireTrace(4, "[JCoRFC] dispatchRequest caught an application exception: " + message + " thrown within the background transaction.");
                                            Trc.criticalTrace("Exception thrown by application running in JCo Server", e);
                                            throw new RfcException(1, message, 104, server.conn.getConnectionHandle(), false, e);
                                        }
                                        if (e instanceof AbapException) {
                                            AbapException jae = (AbapException)e;
                                            if (Trace.isOn(128)) {
                                                Trace.fireTrace(128, "[JCoRFC] dispatchRequest caught an application ABAP exception: " + jae.getMessage());
                                            }
                                            try {
                                                server.conn.rfcHandle.RfcRaiseErrorMessage(jae.getKey(), jae.getMessage(), jae.getMessageClass(), jae.getMessageType(), jae.getMessageNumber(), jae.getMessageParameters());
                                                throw new DispatchException();
                                            }
                                            catch (RfcException re) {
                                                Trace.fireTrace(4, "[JCoRFC] dispatchRequest: RaiseErrorMessage failed: " + re);
                                            }
                                            throw new DispatchException();
                                        }
                                        if (e instanceof AbapClassException) {
                                            AbapClassException ace = (AbapClassException)e;
                                            Trace.fireTrace(132, "[JCoRFC] dispatchRequest caught an application ABAP class exception: " + ace.getMessage());
                                            if (server.conn.rfcHandle.abapClassExceptionMode == AbapClassException.Mode.OFF) {
                                                String abortMessage = ace.getClassName() + ": " + ace.getMessage();
                                                Trace.fireTrace(128, "[JCoRFC] dispatchRequest: client does not expect ABAP class exceptions, sending a system failure instead: " + abortMessage);
                                                this.abort(server, abortMessage);
                                                throw new DispatchException();
                                            }
                                            try {
                                                DefaultAbapObject exceptionInstance;
                                                String destinationValue;
                                                if ("CX_REMOTE_APPL_ERROR".equals(ace.getClassName()) && ((destinationValue = (exceptionInstance = (DefaultAbapObject)ace.toAbapObject()).getString("DESTINATION")) == null || destinationValue.length() == 0)) {
                                                    exceptionInstance.internalUpdateAttribute("DESTINATION", server.conn.rfcHandle.destination);
                                                }
                                                server.conn.rfcHandle.raiseAbapClassException(ace);
                                                throw new DispatchException();
                                            }
                                            catch (RfcException re) {
                                                Trace.fireTrace(4, "[JCoRFC] dispatchRequest: RaiseAbapClassException failed: " + re);
                                                throw new DispatchException();
                                            }
                                        }
                                        if (function.getException(message) != null) {
                                            if (Trace.isOn(128)) {
                                                Trace.fireTrace(128, "[JCoRFC] dispatchRequest caught an application exception: " + e.toString());
                                            }
                                            try {
                                                server.conn.rfcHandle.RfcRaise(message);
                                                throw new DispatchException();
                                            }
                                            catch (RfcException re) {
                                                Trace.fireTrace(4, "[JCoRFC] dispatchRequest: Raise failed: " + re);
                                            }
                                            throw new DispatchException();
                                        }
                                        if (Trace.isOn(4)) {
                                            Trace.fireTrace(4, "[JCoRFC] dispatchRequest caught an application non-abap exception: " + message);
                                        }
                                        Trc.criticalTrace("Exception thrown by application running in JCo Server", e);
                                        this.abort(server, message);
                                        throw new DispatchException();
                                    }
                                    catch (Error e) {
                                        String message = e.getMessage();
                                        Trace.fireTrace(4, "[JCoRFC] dispatchRequest caught an application error: " + (message == null ? e.toString() : message));
                                        Trc.criticalTrace("Error thrown by application running in JCo Server", e);
                                        if ((server.getState() & 0x30) != 0) {
                                            String string;
                                            if (message == null) {
                                                string = e.toString();
                                                throw new RfcException(1, string, 104, server.conn.getConnectionHandle(), false, e);
                                            }
                                            string = message;
                                            throw new RfcException(1, string, 104, server.conn.getConnectionHandle(), false, e);
                                        }
                                        this.abort(server, message == null ? e.toString() : message);
                                        throw new DispatchException();
                                    }
                                    if (Trace.isOn(128)) {
                                        Trace.fireTrace(128, "[JCoRFC] DispatchRequest after JCO.Server.dispatchRequest " + functionModule);
                                    }
                                    temp = System.currentTimeMillis();
                                    trequest = temp - tstart;
                                    tstart = temp;
                                    if ((server.conn.state & 0x30) != 0) break block87;
                                    if (exports_rfc == null) break block88;
                                    exports = new ArrayList<IRfcParameter>(exports_rfc.length);
                                    break block89;
                                }
                                tables_rfc = null;
                                changings_rfc = null;
                                exports_rfc = null;
                                break block90;
                            }
                            for (i = 0; i < exports_rfc.length; ++i) {
                                param = this.refetchParameter(exp, exports_rfc[i]);
                                if (param == null) continue;
                                exports.add(param);
                            }
                            if (exports.size() > 0) {
                                exports_rfc = new IRfcParameter[exports.size()];
                                exports_rfc = exports.toArray(exports_rfc);
                            } else {
                                exports_rfc = null;
                            }
                        }
                        if (changings_rfc != null) {
                            ArrayList<IRfcParameter> changings = new ArrayList<IRfcParameter>(changings_rfc.length);
                            for (i = 0; i < changings_rfc.length; ++i) {
                                param = this.refetchParameter(chn, changings_rfc[i]);
                                if (param == null) continue;
                                changings.add(param);
                            }
                            if (changings.size() > 0) {
                                changings_rfc = new IRfcParameter[changings.size()];
                                changings_rfc = changings.toArray(changings_rfc);
                            } else {
                                changings_rfc = null;
                            }
                        }
                        if (tables_rfc != null) {
                            for (int i3 = 0; i3 < tables_rfc.length; ++i3) {
                                ((TableParameter)tables_rfc[i3]).setTable((DefaultTable)tab.odata[tab.metaData.oindex[((TableParameter)tables_rfc[i3]).getIndex()]]);
                            }
                        }
                        temp = System.currentTimeMillis();
                        tmarshall += temp - tstart;
                        tstart = temp;
                    }
                    if (Trace.isOn(128)) {
                        FastStringBuffer buf2 = new FastStringBuffer();
                        buf2.append("[JCoRFC] DispatchRequest before RfcSendData(").append(server.conn.getConnectionHandle()).append(", ");
                        buf2.append(functionModule).append(", ").append(exports_rfc == null ? "null" : Integer.toString(exports_rfc.length));
                        buf2.append(", ").append(changings_rfc == null ? "null" : Integer.toString(changings_rfc.length));
                        buf2.append(", ").append(tables_rfc == null ? "null" : Integer.toString(tables_rfc.length)).append(')');
                        Trace.fireTrace(128, buf2.toString());
                    }
                    server.conn.rfcHandle.RfcSendData(exports_rfc, changings_rfc, tables_rfc);
                    if (server.conn.throughput != null || monitorOn) {
                        sentBytes = MiddlewareJavaRfc.this.countBytes(exports_rfc, changings_rfc, tables_rfc);
                    }
                    if (Trace.isOn(128)) {
                        FastStringBuffer buf3 = new FastStringBuffer();
                        buf3.append("[JCoRFC] DispatchRequest after RfcSendData(").append(server.conn.getConnectionHandle()).append(", ");
                        buf3.append(functionModule).append(", ").append(exports_rfc == null ? "null" : Integer.toString(exports_rfc.length));
                        buf3.append(", ").append(changings_rfc == null ? "null" : Integer.toString(changings_rfc.length));
                        buf3.append(", ").append(tables_rfc == null ? "null" : Integer.toString(tables_rfc.length)).append(')');
                        Trace.fireTrace(128, buf3.toString());
                    }
                    tmiddleware += System.currentTimeMillis() - tstart;
                }
                catch (DispatchException de) {
                    throw de;
                }
                catch (RfcException re) {
                    throw re;
                }
                catch (Exception e) {
                    server.fireServerExceptionOccurred(e);
                    if (!Trace.isOn(4)) throw e;
                    String message = e.getMessage();
                    Trace.fireTrace(4, "[JCoRFC] dispatchRequest caught an exception: " + (message == null ? e.toString() : message));
                    throw e;
                }
                catch (Error e) {
                    server.fireServerErrorOccurred(e);
                    if (!Trace.isOn(4)) throw e;
                    String message = e.getMessage();
                    Trace.fireTraceCritical("[JCoRFC] dispatchRequest caught an error: " + (message == null ? e.toString() : message));
                    throw e;
                }
                Object var37_52 = null;
                ttotal = System.currentTimeMillis() - ttotal;
                if (server.conn.throughput != null) {
                    DefaultThroughput defaultThroughput = server.conn.throughput;
                    synchronized (defaultThroughput) {
                        ++server.conn.throughput.num_calls;
                        server.conn.throughput.time_marshall += tmarshall;
                        server.conn.throughput.time_unmarshall += tunmarshall;
                        server.conn.throughput.time_middleware += tmiddleware;
                        server.conn.throughput.time_handle_request += trequest;
                        server.conn.throughput.time_total += ttotal;
                        server.conn.throughput.num_sent_bytes += sentBytes;
                        server.conn.throughput.num_received_bytes += receivedBytes;
                        if (!monitorOn) {
                            this.fireEndCall(server);
                        }
                    }
                }
                if (!monitorOn) return;
                server.conn.time_handle_request = trequest;
                server.conn.time_middleware = tmiddleware;
                server.conn.time_total = ttotal;
                server.conn.num_sent_bytes = sentBytes;
                server.conn.num_received_bytes = receivedBytes;
                this.fireEndCall(server);
                return;
            }
            catch (Throwable throwable) {
                Object var37_53 = null;
                ttotal = System.currentTimeMillis() - ttotal;
                if (server.conn.throughput != null) {
                    DefaultThroughput defaultThroughput = server.conn.throughput;
                    synchronized (defaultThroughput) {
                        ++server.conn.throughput.num_calls;
                        server.conn.throughput.time_marshall += tmarshall;
                        server.conn.throughput.time_unmarshall += tunmarshall;
                        server.conn.throughput.time_middleware += tmiddleware;
                        server.conn.throughput.time_handle_request += trequest;
                        server.conn.throughput.time_total += ttotal;
                        server.conn.throughput.num_sent_bytes += sentBytes;
                        server.conn.throughput.num_received_bytes += receivedBytes;
                        if (!monitorOn) {
                            this.fireEndCall(server);
                        }
                    }
                }
                if (!monitorOn) throw throwable;
                server.conn.time_handle_request = trequest;
                server.conn.time_middleware = tmiddleware;
                server.conn.time_total = ttotal;
                server.conn.num_sent_bytes = sentBytes;
                server.conn.num_received_bytes = receivedBytes;
                this.fireEndCall(server);
                throw throwable;
            }
        }

        private void fireEndCall(ServerWorker server) {
            try {
                server.conn.endCall();
            }
            catch (Throwable th) {
                Trace.fireTrace(4, "[JCoRFC] listen caught an exception or error of endCall() " + th.toString(), th);
                if (th instanceof Exception) {
                    Trc.criticalTrace("Application has thrown an exception in endCall() ", (Exception)th);
                }
                Trc.criticalTrace("Application has thrown an error in endCall() ", (Error)th);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void execute(ServerWorker server, String name, DefaultParameterList imp, DefaultParameterList imptab, DefaultParameterList chn, DefaultParameterList exp, boolean supportsASXML, AbapClassException.Mode classExceptionMode) throws JCoException {
            long tstart = 0L;
            long ttotal = 0L;
            long tmiddleware = 0L;
            long tmarshall = 0L;
            long tunmarshall = 0L;
            long temp = 0L;
            long receivedBytes = 0L;
            long sentBytes = 0L;
            if (Trace.isOn(64)) {
                Trace.fireTrace(64, "[JCoRFC] Executing " + name + " for handle " + server.conn.getConnectionHandle());
            }
            ttotal = System.currentTimeMillis();
            if (this.callbackException != null) {
                throw new JCoException(102, "JCO_ERROR_COMMUNICATION", "connection closed due to the previous failure", this.callbackException);
            }
            if (server.conn.rfcHandle == null) {
                throw new JCoException(121, "JCO_ERROR_NULL_HANDLE", "Invalid rfc_handle = NULL encountered");
            }
            try {
                try {
                    FastStringBuffer buf;
                    IRfcParameter param;
                    int i;
                    if (this.converter == null) {
                        this.getAttributes(server.conn);
                    }
                    tstart = System.currentTimeMillis();
                    IRfcParameter[] imports_rfc = null;
                    IRfcParameter[] changings_rfc = null;
                    IRfcParameter[] exports_rfc = null;
                    IRfcTable[] tables_rfc = null;
                    if (imp != null) {
                        ArrayList<IRfcParameter> imports = new ArrayList<IRfcParameter>(imp.metaData.numFields);
                        for (i = 0; i < imp.metaData.numFields; ++i) {
                            param = this.getParameter(imp, i);
                            if (param == null) continue;
                            imports.add(param);
                        }
                        if (imports.size() > 0) {
                            imports_rfc = new IRfcParameter[imports.size()];
                            imports_rfc = imports.toArray(imports_rfc);
                        }
                    }
                    if (chn != null) {
                        ArrayList<IRfcParameter> changings = new ArrayList<IRfcParameter>(chn.metaData.numFields);
                        for (i = 0; i < chn.metaData.numFields; ++i) {
                            param = this.getParameter(chn, i);
                            if (param == null) continue;
                            changings.add(param);
                        }
                        if (changings.size() > 0) {
                            changings_rfc = new IRfcParameter[changings.size()];
                            changings_rfc = changings.toArray(changings_rfc);
                        }
                    }
                    if (imptab != null) {
                        ArrayList<TableParameter> importTables = new ArrayList<TableParameter>(imptab.metaData.numFields);
                        for (i = 0; i < imptab.metaData.numFields; ++i) {
                            if ((imptab.flags[i] & 8) != 0 || (imptab.flags[i] & 2) != 0) continue;
                            importTables.add(new TableParameter((DefaultTable)imptab.odata[imptab.metaData.oindex[i]], imptab.metaData.name[i], this.converter));
                        }
                        if (importTables.size() > 0) {
                            tables_rfc = new TableParameter[importTables.size()];
                            tables_rfc = importTables.toArray(tables_rfc);
                        }
                    }
                    if (exp != null) {
                        ArrayList<IRfcParameter> exports = new ArrayList<IRfcParameter>(exp.metaData.numFields);
                        for (i = 0; i < exp.metaData.numFields; ++i) {
                            param = this.getParameter(exp, i);
                            if (param == null) continue;
                            exports.add(param);
                        }
                        if (exports.size() > 0) {
                            exports_rfc = new IRfcParameter[exports.size()];
                            exports_rfc = exports.toArray(exports_rfc);
                        }
                    }
                    temp = System.currentTimeMillis();
                    tmarshall = temp - tstart;
                    tstart = temp;
                    if (server.conn.passport_bytes != null) {
                        if (Trace.isOn(128)) {
                            Trace.fireTrace(128, "[JCoRFC] Execute before RfcSetClientId(" + server.conn.getConnectionHandle() + ", " + server.conn.passport_bytes.length + ')');
                        }
                        server.conn.rfcHandle.RfcSetClientId(server.conn.passport_bytes);
                        if (Trace.isOn(128)) {
                            Trace.fireTrace(128, "[JCoRFC] Execute after RfcSetClientId(" + server.conn.getConnectionHandle() + ", " + server.conn.passport_bytes.length + ')');
                        }
                    }
                    if (Trace.isOn(128)) {
                        buf = new FastStringBuffer();
                        buf.append("[JCoRFC] Execute before RfcCall(").append(server.conn.getConnectionHandle()).append(", ");
                        buf.append(name).append(", ").append(imports_rfc == null ? "null" : Integer.toString(imports_rfc.length));
                        buf.append(", ").append(changings_rfc == null ? "null" : Integer.toString(changings_rfc.length));
                        buf.append(", ").append(tables_rfc == null ? "null" : Integer.toString(tables_rfc.length)).append(')');
                        Trace.fireTrace(128, buf.toString());
                        if (imports_rfc != null && Trace.isOn(16)) {
                            for (i = 0; i < imports_rfc.length; ++i) {
                                Trace.fireTrace(16, "[JCoRFC] Sent Parameter " + imports_rfc[i].getName());
                            }
                        }
                        if (tables_rfc != null && Trace.isOn(16)) {
                            for (i = 0; i < tables_rfc.length; ++i) {
                                Trace.fireTrace(16, "[JCoRFC] Sent Table " + ((TableParameter)tables_rfc[i]).getName());
                            }
                        }
                    }
                    server.conn.rfcHandle.RfcCall(name, imports_rfc, exports_rfc, changings_rfc, tables_rfc, supportsASXML, classExceptionMode);
                    if (server.conn.throughput != null || monitorOn) {
                        sentBytes = MiddlewareJavaRfc.this.countBytes(imports_rfc, changings_rfc, tables_rfc);
                    }
                    if (Trace.isOn(128)) {
                        buf = new FastStringBuffer();
                        buf.append("[JCoRFC] Execute after RfcCall(").append(server.conn.getConnectionHandle()).append(", ");
                        buf.append(name).append(", ").append(imports_rfc == null ? "null" : Integer.toString(imports_rfc.length));
                        buf.append(", ").append(changings_rfc == null ? "null" : Integer.toString(changings_rfc.length));
                        buf.append(", ").append(tables_rfc == null ? "null" : Integer.toString(tables_rfc.length)).append(')');
                        Trace.fireTrace(128, buf.toString());
                        buf.reset();
                        buf.append("[JCoRFC] Execute before RfcReceive(").append(server.conn.getConnectionHandle()).append(", ");
                        buf.append(name).append(", ").append(exports_rfc == null ? "null" : Integer.toString(exports_rfc.length));
                        buf.append(", ").append(changings_rfc == null ? "null" : Integer.toString(changings_rfc.length));
                        buf.append(", ").append(tables_rfc == null ? "null" : Integer.toString(tables_rfc.length)).append(')');
                        Trace.fireTrace(128, buf.toString());
                        if (exports_rfc != null && Trace.isOn(16)) {
                            for (i = 0; i < exports_rfc.length; ++i) {
                                Trace.fireTrace(16, "[JCoRFC] Expecting Parameter " + exports_rfc[i].getName());
                            }
                        }
                        if (tables_rfc != null && Trace.isOn(16)) {
                            for (i = 0; i < tables_rfc.length; ++i) {
                                Trace.fireTrace(16, "[JCoRFC] Expecting Table " + ((TableParameter)tables_rfc[i]).getName());
                            }
                        }
                    }
                    server.conn.rfcHandle.RfcReceive(exports_rfc, changings_rfc, tables_rfc, server.getRepository());
                    if (this.changeAttributes) {
                        this.getAttributes(server.conn);
                    }
                    if (server.conn.throughput != null || monitorOn) {
                        receivedBytes = MiddlewareJavaRfc.this.countBytes(exports_rfc, changings_rfc, tables_rfc);
                    }
                    if (Trace.isOn(128)) {
                        buf = new FastStringBuffer();
                        buf.append("[JCoRFC] Execute after RfcReceive(").append(server.conn.getConnectionHandle()).append(", ");
                        buf.append(name).append(", ").append(exports_rfc == null ? "null" : Integer.toString(exports_rfc.length));
                        buf.append(", ").append(changings_rfc == null ? "null" : Integer.toString(changings_rfc.length));
                        buf.append(", ").append(tables_rfc == null ? "null" : Integer.toString(tables_rfc.length)).append(')');
                        Trace.fireTrace(128, buf.toString());
                    }
                    if (tables_rfc != null) {
                        for (int i2 = 0; i2 < tables_rfc.length; ++i2) {
                            ((TableParameter)tables_rfc[i2]).table.row = 0;
                        }
                    }
                    tmiddleware = System.currentTimeMillis() - tstart;
                }
                catch (RfcException re) {
                    JCoException ex;
                    switch (re.getRc()) {
                        case 2: {
                            ex = new AbapException(re.getMessage(), re.getMessageClass(), re.getMessageType(), re.getMessageNumber(), re.getMessageParameters());
                            break;
                        }
                        case 24: {
                            AbapClassExceptionInfo classExceptionInfo = re.getClassExceptionInfo();
                            ex = new AbapClassException(classExceptionInfo.getMessage(), classExceptionInfo.getName() == null ? classExceptionInfo.getExceptionInstance().getClassMetaData().getName() : classExceptionInfo.getName(), classExceptionInfo.getExceptionInstance(), classExceptionInfo.getRemoteContext());
                            break;
                        }
                        default: {
                            this.callbackException = re;
                            ex = MiddlewareJavaRfc.this.generateJCoException(re);
                        }
                    }
                    server.fireServerExceptionOccurred(ex);
                    throw ex;
                }
                Object var33_28 = null;
            }
            catch (Throwable throwable) {
                Object var33_29 = null;
                ttotal = System.currentTimeMillis() - ttotal;
                if (server.conn.throughput == null) throw throwable;
                DefaultThroughput defaultThroughput = server.conn.throughput;
                synchronized (defaultThroughput) {
                    ++server.conn.throughput.num_calls;
                    server.conn.throughput.time_marshall += tmarshall;
                    server.conn.throughput.time_middleware += tmiddleware;
                    server.conn.throughput.time_unmarshall += tunmarshall;
                    server.conn.throughput.time_total += ttotal;
                    server.conn.throughput.num_sent_bytes += sentBytes;
                    server.conn.throughput.num_received_bytes += receivedBytes;
                    throw throwable;
                }
            }
            ttotal = System.currentTimeMillis() - ttotal;
            if (server.conn.throughput == null) return;
            DefaultThroughput defaultThroughput = server.conn.throughput;
            synchronized (defaultThroughput) {
                ++server.conn.throughput.num_calls;
                server.conn.throughput.time_marshall += tmarshall;
                server.conn.throughput.time_middleware += tmiddleware;
                server.conn.throughput.time_unmarshall += tunmarshall;
                server.conn.throughput.time_total += ttotal;
                server.conn.throughput.num_sent_bytes += sentBytes;
                server.conn.throughput.num_received_bytes += receivedBytes;
                return;
            }
        }

        public String createSessionId(ServerConnection conn) {
            if (conn.rfcHandle == null) {
                throw new JCoRuntimeException(133, "JCO_ERROR_INVALID_HANDLE", "Handle 0 encountered in setSessionId");
            }
            String sessionId = GUID.toString(conn.rfcHandle.rfc_uuid);
            return sessionId;
        }
    }

    class JavaRfcServerGroup
    implements JCoMiddleware.ServerGroup {
        RfcAcceptInfo acceptParams;

        JavaRfcServerGroup() {
        }

        public String initialize(Properties params) {
            if (Trace.isOn(128)) {
                Trace.fireTrace(128, "[JCoRFC] initialize server with parameters: " + params.toString());
            }
            this.acceptParams = MiddlewareJavaRfc.createRfcAcceptInfo(params);
            return this.acceptParams.toString();
        }

        public Object getAcceptParameters() {
            return this.acceptParams;
        }
    }

    class JavaRfcDispatcher
    extends JCoMiddleware.Dispatcher {
        JavaRfcDispatcher() {
        }

        protected ServerConnection getNextListener() {
            RfcIoOpenCntl cntl = RfcApi.RfcGetNextListener();
            if (cntl != null) {
                try {
                    return (ServerConnection)cntl.getConnectionReference();
                }
                catch (ClassCastException e) {
                    Trc.criticalTrace(cntl, "Connection reference on the RFC handle has " + cntl.getConnectionReference().getClass().getName() + " instead of ServerConenction");
                }
            }
            return null;
        }

        protected int waitForRequest(int timeout) {
            int rc = RfcApi.RfcWaitForCpicRequest(timeout);
            if (rc == 4) {
                return 1;
            }
            if (rc == 7) {
                return 0;
            }
            return 0;
        }

        public int getNumServerConnections(Properties props) throws JCoException {
            RfcAcceptInfo acceptParams = MiddlewareJavaRfc.createRfcAcceptInfo(props);
            try {
                return RfcApi.runtime.getNumServerConnections(acceptParams);
            }
            catch (RfcException ex) {
                throw new JCoException(ex.getErrorGroup(), ex.getKey(), ex.getMessage());
            }
        }
    }

    class JavaRfcClient
    extends JavaRfcConnection
    implements JCoMiddleware.Client {
        RfcOptions logonParams;
        private boolean invokeInvisibleGui;
        private JCoMiddleware.CallContext ctx;

        JavaRfcClient() {
            this.invokeInvisibleGui = false;
            this.ctx = new JCoMiddleware.CallContext();
        }

        public String[][] getPropertyInfo() {
            return pinfoClient;
        }

        public void initialize(Properties params) throws JCoException {
            String snc_mode;
            boolean noRouterProperty;
            if (params == null) {
                Trace.fireTraceCritical("[JCoRFC] initialze was invoked with params == null.");
                return;
            }
            if (Trace.isOn(128)) {
                Properties p = (Properties)params.clone();
                Trace.fireTrace(128, "[JCoRFC] initialize client with parameters: " + Trace.bufferForConnectionProperties(p));
            }
            this.logonParams = new RfcOptions();
            String value = JCoRuntime.findProperty("jco.client.type", params);
            String routerString = JCoRuntime.findProperty("jco.client.saprouter", params);
            boolean bl = noRouterProperty = routerString == null;
            if (value == null) {
                value = "3";
            }
            switch (value.charAt(0)) {
                case '3': {
                    String r3name = JCoRuntime.findProperty("jco.client.r3name", params);
                    if (r3name != null) {
                        params.put("jco.client.type", "B");
                        String mshost = JCoRuntime.findProperty("jco.client.mshost", params);
                        if (mshost == null || routerString != null || (routerString = MiddlewareJavaRfc.extractRouterString(mshost)) == null) break;
                        MiddlewareJavaRfc.this.removeProperty("jco.client.mshost", params);
                        params.put("jco.client.mshost", MiddlewareJavaRfc.getPlainHost(mshost, routerString.length() + 3));
                        break;
                    }
                    String ashost = JCoRuntime.findProperty("jco.client.ashost", params);
                    if (routerString == null && (routerString = MiddlewareJavaRfc.extractRouterString(ashost)) != null) {
                        MiddlewareJavaRfc.this.removeProperty("jco.client.ashost", params);
                        params.put("jco.client.ashost", MiddlewareJavaRfc.getPlainHost(ashost, routerString.length() + 3));
                    }
                    params.put("jco.client.type", "A");
                    break;
                }
                case 'V': {
                    RfcApi.runtime.updateClientConnectionProperties('V', params);
                    if (value.length() <= 0) break;
                    params.put("jco.client.type", value.substring(0, 1));
                    break;
                }
                default: {
                    String gwhost = JCoRuntime.findProperty("jco.client.gwhost", params);
                    if (routerString == null && (routerString = MiddlewareJavaRfc.extractRouterString(gwhost)) != null) {
                        MiddlewareJavaRfc.this.removeProperty("jco.client.gwhost", params);
                        params.put("jco.client.gwhost", MiddlewareJavaRfc.getPlainHost(gwhost, routerString.length() + 3));
                    }
                    if (value.length() <= 0) break;
                    params.put("jco.client.type", value.substring(0, 1));
                }
            }
            if (noRouterProperty && routerString != null) {
                params.put("jco.client.saprouter", routerString);
            }
            if ((snc_mode = JCoRuntime.findProperty("jco.client.snc_mode", params)) != null && snc_mode.equals("1")) {
                String middlewareValue;
                if (JCoRuntime.findProperty("jco.client.snc_qop", params) == null) {
                    params.put("jco.client.snc_qop", "8");
                }
                if (JCoRuntime.findProperty("jco.client.snc_lib", params) == null && (middlewareValue = MiddlewareJavaRfc.this.getProperty(MiddlewareJavaRfc.JCO_SNC_LIB)) != null) {
                    params.put("jco.client.snc_lib", middlewareValue);
                }
            }
            try {
                this.logonParams.setProperties(params, "jco.client.");
            }
            catch (RfcException re) {
                throw MiddlewareJavaRfc.this.generateJCoException(re);
            }
            this.logonParams.setAllocationType(JCoRuntime.toBoolean(JCoRuntime.findProperty(MiddlewareJavaRfc.JCO_JRA_CONN, params)) ? (byte)1 : 3);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void connect(ClientConnection client) throws JCoException {
            long tstart = 0L;
            long ttotal = 0L;
            long tmiddleware = 0L;
            ttotal = System.currentTimeMillis();
            if (Trace.isOn(128)) {
                Trace.fireTrace(128, "[JCoRFC] Connect before RfcOpen(" + this.logonParams + ')');
            }
            tstart = System.currentTimeMillis();
            try {
                if (this.logonParams == null) {
                    this.initialize(client.properties);
                    this.logonParams.checkParameters();
                }
                client.rfcHandle = RfcApi.RfcOpen(this.logonParams);
            }
            catch (RfcException re) {
                if (Trace.isOn(4, true) && re.getErrorGroup() == 103) {
                    Trace.fireTrace(4, "[JCoRFC] Connect failed during logon in RfcOpen(" + this.logonParams + ")");
                }
                if (re.getRc() == 19) {
                    String destinationName = client.getProperty("jco.client.destination");
                    boolean isJRAConfiguration = false;
                    if (destinationName.startsWith("JRA") && destinationName.length() > 3) {
                        isJRAConfiguration = true;
                        for (int i = 3; i < destinationName.length(); ++i) {
                            if (Character.isDigit(destinationName.charAt(i))) continue;
                            isJRAConfiguration = false;
                            break;
                        }
                    }
                    String msg = isJRAConfiguration ? "Configuration of JRA instance used is incomplete: " : "Configuration of destination " + destinationName + " is incomplete: ";
                    msg = msg + re.getMessage();
                    throw new JCoException(re.getErrorGroup(), re.getKey(), msg, null, '\u0000', null, null, re, re.remoteSystemInfo());
                }
                throw MiddlewareJavaRfc.this.generateJCoException(re);
            }
            if (Trace.isOn(128)) {
                Trace.fireTrace(128, "[JCoRFC] Connect after RfcOpen(" + this.logonParams + ")=" + client.getConnectionHandle());
            }
            tmiddleware = System.currentTimeMillis() - tstart;
            if (client.rfcHandle == null) {
                throw new JCoException(103, "JCO_ERROR_LOGON_FAILURE", "Could not get a connection handle");
            }
            this.getAttributes(client);
            if (this.logonParams.getUseSAPGui() != 0) {
                this.startSAPGui(client, this.logonParams.getUseSAPGui());
            }
            ttotal = System.currentTimeMillis() - ttotal;
            if (client.throughput != null) {
                DefaultThroughput defaultThroughput = client.throughput;
                synchronized (defaultThroughput) {
                    client.throughput.time_middleware += tmiddleware;
                    client.throughput.time_total += ttotal;
                }
            }
        }

        public void abort(ClientConnection client, String message) {
            try {
                super.abort(client, message);
            }
            catch (JCoException jCoException) {
                // empty catch block
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void reset(ClientConnection client) throws JCoException {
            if (client.rfcHandle == null) {
                return;
            }
            if (client.rfcHandle.close_pending) {
                super.disconnect(client);
                return;
            }
            if (client.rfcHandle.needsReset()) {
                char partnerType = client.rfcHandle.partner_type;
                int kernelRel = client.attributes.getKernelReleaseNumber();
                if (partnerType == '3' && (client.rfcHandle.pcs == 2 || kernelRel >= 463)) {
                    client.rfcHandle.ab_rfcreset_send();
                    boolean isStateful = client.rfcHandle.isStateful();
                    try {
                        try {
                            client.rfcHandle.setStateful(true);
                            if (Trace.isOn(128)) {
                                Trace.fireTrace(128, "[JCoRFC] Reset before RfcCleanupContext(" + client.getConnectionHandle() + ')');
                            }
                            client.rfcHandle.RfcCallReceive("SYSTEM_RESET_RFC_SERVER", null, null, null, null, AbapClassException.Mode.OFF, null);
                            if (Trace.isOn(128)) {
                                Trace.fireTrace(128, "[JCoRFC] Reset after RfcCleanupContext(" + client.getConnectionHandle() + ')');
                            }
                            client.rfcHandle.identified = false;
                            client.rfcHandle.th_client_id = null;
                        }
                        catch (RfcException re) {
                            if (re.getRc() == 6) {
                                super.disconnect(client);
                            } else {
                                MiddlewareJavaRfc.this.generateJCoException(re);
                            }
                            Object var7_6 = null;
                            if (client.rfcHandle == null) return;
                            client.rfcHandle.setStateful(isStateful);
                            return;
                        }
                        Object var7_5 = null;
                        if (client.rfcHandle == null) return;
                        client.rfcHandle.setStateful(isStateful);
                        return;
                    }
                    catch (Throwable throwable) {
                        Object var7_7 = null;
                        if (client.rfcHandle == null) throw throwable;
                        client.rfcHandle.setStateful(isStateful);
                        throw throwable;
                    }
                } else {
                    super.disconnect(client);
                    this.connect(client);
                }
                return;
            } else {
                if (!Trace.isOn(128)) return;
                Trace.fireTrace(128, "[JCoRFC] Reset implicitely done by kernel of partner [" + client.getConnectionHandle() + ']');
            }
        }

        public void getAttributes(ClientConnection client) throws JCoException {
            super.getAttributes(client);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void execute(ClientConnection client, String name, DefaultParameterList imp, DefaultParameterList imptab, DefaultParameterList chn, DefaultParameterList exp, boolean supportsASXML, AbapClassException.Mode classExceptionMode) throws JCoException {
            long tstart = 0L;
            long ttotal = 0L;
            long tmiddleware = 0L;
            long tmarshall = 0L;
            long tunmarshall = 0L;
            long temp = 0L;
            long receivedBytes = 0L;
            long sentBytes = 0L;
            boolean isTransactional = this.ctx != null && this.ctx.isTransactional();
            boolean isTraceOn = Trace.isOn(64);
            if (isTraceOn && Trace.isOn(64)) {
                Trace.fireTrace(64, "[JCoRFC] Executing " + name + " for handle " + client.getConnectionHandle());
            }
            ttotal = System.currentTimeMillis();
            if (client.rfcHandle == null) {
                throw new JCoException(121, "JCO_ERROR_NULL_HANDLE", "Invalid rfc_handle = NULL encountered");
            }
            try {
                try {
                    block76: {
                        Object buf;
                        int i;
                        IRfcTable[] tables_rfc;
                        IRfcParameter[] exports_rfc;
                        IRfcParameter[] changings_rfc;
                        IRfcParameter[] imports_rfc;
                        block74: {
                            block77: {
                                block75: {
                                    IRfcParameter param;
                                    if (this.converter == null) {
                                        this.getAttributes(client);
                                    }
                                    tstart = System.currentTimeMillis();
                                    imports_rfc = null;
                                    changings_rfc = null;
                                    exports_rfc = null;
                                    tables_rfc = null;
                                    if (imp != null) {
                                        ArrayList<IRfcParameter> imports = new ArrayList<IRfcParameter>(imp.metaData.numFields);
                                        for (i = 0; i < imp.metaData.numFields; ++i) {
                                            param = this.getParameter(imp, i);
                                            if (param == null) continue;
                                            imports.add(param);
                                        }
                                        if (imports.size() > 0) {
                                            imports_rfc = new IRfcParameter[imports.size()];
                                            imports_rfc = imports.toArray(imports_rfc);
                                        }
                                    }
                                    if (chn != null) {
                                        ArrayList<IRfcParameter> changings = new ArrayList<IRfcParameter>(chn.metaData.numFields);
                                        for (i = 0; i < chn.metaData.numFields; ++i) {
                                            param = this.getParameter(chn, i);
                                            if (param == null) continue;
                                            changings.add(param);
                                        }
                                        if (changings.size() > 0) {
                                            changings_rfc = new IRfcParameter[changings.size()];
                                            changings_rfc = changings.toArray(changings_rfc);
                                        }
                                    }
                                    if (imptab != null) {
                                        ArrayList<TableParameter> importTables = new ArrayList<TableParameter>(imptab.metaData.numFields);
                                        for (i = 0; i < imptab.metaData.numFields; ++i) {
                                            if ((imptab.flags[i] & 8) != 0 || (imptab.flags[i] & 2) != 0) continue;
                                            importTables.add(new TableParameter((DefaultTable)imptab.odata[imptab.metaData.oindex[i]], imptab.metaData.name[i], this.converter));
                                        }
                                        if (importTables.size() > 0) {
                                            tables_rfc = new TableParameter[importTables.size()];
                                            tables_rfc = importTables.toArray(tables_rfc);
                                        }
                                    }
                                    if (!isTransactional && exp != null) {
                                        ArrayList<IRfcParameter> exports = new ArrayList<IRfcParameter>(exp.metaData.numFields);
                                        for (i = 0; i < exp.metaData.numFields; ++i) {
                                            param = this.getParameter(exp, i);
                                            if (param == null) continue;
                                            exports.add(param);
                                        }
                                        if (exports.size() > 0) {
                                            exports_rfc = new IRfcParameter[exports.size()];
                                            exports_rfc = exports.toArray(exports_rfc);
                                        }
                                    }
                                    temp = System.currentTimeMillis();
                                    tmarshall = temp - tstart;
                                    tstart = temp;
                                    if (client.passport_bytes != null) {
                                        if (isTraceOn && Trace.isOn(128)) {
                                            Trace.fireTrace(128, "[JCoRFC] Execute before RfcSetClientId(" + client.getConnectionHandle() + ", " + client.passport_bytes.length + ')');
                                        }
                                        client.rfcHandle.RfcSetClientId(client.passport_bytes);
                                        if (isTraceOn && Trace.isOn(128)) {
                                            Trace.fireTrace(128, "[JCoRFC] Execute after RfcSetClientId(" + client.getConnectionHandle() + ", " + client.passport_bytes.length + ')');
                                        }
                                    }
                                    if (!isTransactional) break block74;
                                    if (!this.ctx.isQRfc()) break block75;
                                    if (isTraceOn && Trace.isOn(128)) {
                                        buf = new FastStringBuffer();
                                        ((FastStringBuffer)buf).append("[JCoRFC] Execute before RfcQueueInsert(").append(client.getConnectionHandle()).append(", ");
                                        ((FastStringBuffer)buf).append(name).append(", ").append(imports_rfc == null ? "null" : Integer.toString(imports_rfc.length));
                                        ((FastStringBuffer)buf).append(", ").append(tables_rfc == null ? "null" : Integer.toString(tables_rfc.length));
                                        ((FastStringBuffer)buf).append(", ").append(this.ctx.queueName).append(", ").append(this.ctx.tid24).append(')');
                                        Trace.fireTrace(128, ((FastStringBuffer)buf).toString());
                                        if (imports_rfc != null && Trace.isOn(16)) {
                                            for (i = 0; i < imports_rfc.length; ++i) {
                                                Trace.fireTrace(16, "[JCoRFC] Sent Parameter " + imports_rfc[i].getName());
                                            }
                                        }
                                        if (tables_rfc != null && Trace.isOn(16)) {
                                            for (i = 0; i < tables_rfc.length; ++i) {
                                                Trace.fireTrace(16, "[JCoRFC] Sent Table " + ((TableParameter)tables_rfc[i]).getName());
                                            }
                                        }
                                    }
                                    client.rfcHandle.RfcQueueInsert(name, imports_rfc, tables_rfc, this.ctx.queueName, this.ctx.tid24, supportsASXML, classExceptionMode);
                                    if (client.throughput != null || monitorOn) {
                                        sentBytes = MiddlewareJavaRfc.this.countBytes(imports_rfc, null, tables_rfc);
                                    }
                                    if (isTraceOn && Trace.isOn(128)) {
                                        buf = new FastStringBuffer();
                                        ((FastStringBuffer)buf).append("[JCoRFC] Execute after RfcQueueInsert(").append(client.getConnectionHandle()).append(", ");
                                        ((FastStringBuffer)buf).append(name).append(", ").append(imports_rfc == null ? "null" : Integer.toString(imports_rfc.length));
                                        ((FastStringBuffer)buf).append(", ").append(tables_rfc == null ? "null" : Integer.toString(tables_rfc.length));
                                        ((FastStringBuffer)buf).append(", ").append(this.ctx.queueName).append(", ").append(this.ctx.tid24).append(')');
                                        Trace.fireTrace(128, ((FastStringBuffer)buf).toString());
                                    }
                                    break block76;
                                }
                                if (!this.ctx.isTRfc()) break block77;
                                if (isTraceOn && Trace.isOn(128)) {
                                    buf = new FastStringBuffer();
                                    ((FastStringBuffer)buf).append("[JCoRFC] Execute before RfcIndirectCall(").append(client.getConnectionHandle()).append(", ");
                                    ((FastStringBuffer)buf).append(name).append(", ").append(imports_rfc == null ? "null" : Integer.toString(imports_rfc.length));
                                    ((FastStringBuffer)buf).append(", ").append(tables_rfc == null ? "null" : Integer.toString(tables_rfc.length));
                                    ((FastStringBuffer)buf).append(", ").append(this.ctx.tid24).append(')');
                                    Trace.fireTrace(128, ((FastStringBuffer)buf).toString());
                                    if (imports_rfc != null && Trace.isOn(16)) {
                                        for (i = 0; i < imports_rfc.length; ++i) {
                                            Trace.fireTrace(16, "[JCoRFC] Sent Parameter " + imports_rfc[i].getName());
                                        }
                                    }
                                    if (tables_rfc != null && Trace.isOn(16)) {
                                        for (i = 0; i < tables_rfc.length; ++i) {
                                            Trace.fireTrace(16, "[JCoRFC] Sent Table " + ((TableParameter)tables_rfc[i]).getName());
                                        }
                                    }
                                }
                                client.rfcHandle.RfcQueueInsert(name, imports_rfc, tables_rfc, null, this.ctx.tid24, supportsASXML, classExceptionMode);
                                if (client.throughput != null || monitorOn) {
                                    sentBytes = MiddlewareJavaRfc.this.countBytes(imports_rfc, null, tables_rfc);
                                }
                                if (isTraceOn && Trace.isOn(128)) {
                                    buf = new FastStringBuffer();
                                    ((FastStringBuffer)buf).append("[JCoRFC] Execute after RfcIndirectCall(").append(client.getConnectionHandle()).append(", ");
                                    ((FastStringBuffer)buf).append(name).append(", ").append(imports_rfc == null ? "null" : Integer.toString(imports_rfc.length));
                                    ((FastStringBuffer)buf).append(", ").append(tables_rfc == null ? "null" : Integer.toString(tables_rfc.length));
                                    ((FastStringBuffer)buf).append(", ").append(this.ctx.tid24).append(')');
                                    Trace.fireTrace(128, ((FastStringBuffer)buf).toString());
                                }
                                break block76;
                            }
                            if (this.ctx.isBgRfc()) {
                                if (isTraceOn && Trace.isOn(128)) {
                                    buf = new StringBuilder(200);
                                    ((StringBuilder)buf).append("[JCoRFC] Execute before BgRfcUnit.recordCall(").append(client.getConnectionHandle()).append(", ");
                                    ((StringBuilder)buf).append(name).append(", ").append(imports_rfc == null ? "null" : Integer.toString(imports_rfc.length));
                                    ((StringBuilder)buf).append(", ").append(tables_rfc == null ? "null" : Integer.toString(tables_rfc.length));
                                    ((StringBuilder)buf).append(", ").append(Codecs.Hex.encode(this.ctx.unitIdBytes)).append(')');
                                    Trace.fireTrace(128, ((StringBuilder)buf).toString());
                                    if (imports_rfc != null && Trace.isOn(16)) {
                                        for (i = 0; i < imports_rfc.length; ++i) {
                                            Trace.fireTrace(16, "[JCoRFC] Sent Parameter " + imports_rfc[i].getName());
                                        }
                                    }
                                    if (tables_rfc != null && Trace.isOn(16)) {
                                        for (i = 0; i < tables_rfc.length; ++i) {
                                            Trace.fireTrace(16, "[JCoRFC] Sent Table " + ((TableParameter)tables_rfc[i]).getName());
                                        }
                                    }
                                }
                                this.ctx.bgRfcUnit.recordCall(name, imports_rfc, changings_rfc, tables_rfc, supportsASXML, classExceptionMode);
                                if (client.throughput != null || monitorOn) {
                                    sentBytes = MiddlewareJavaRfc.this.countBytes(imports_rfc, changings_rfc, tables_rfc);
                                }
                                if (isTraceOn && Trace.isOn(128)) {
                                    buf = new StringBuilder();
                                    ((StringBuilder)buf).append("[JCoRFC] Execute after BgRfcUnit.recordCall(").append(client.getConnectionHandle()).append(", ");
                                    ((StringBuilder)buf).append(name).append(", ").append(imports_rfc == null ? "null" : Integer.toString(imports_rfc.length));
                                    ((StringBuilder)buf).append(", ").append(tables_rfc == null ? "null" : Integer.toString(tables_rfc.length));
                                    ((StringBuilder)buf).append(", ").append(Codecs.Hex.encode(this.ctx.unitIdBytes)).append(')');
                                    Trace.fireTrace(128, ((StringBuilder)buf).toString());
                                }
                            }
                            break block76;
                        }
                        if (isTraceOn && Trace.isOn(128)) {
                            buf = new FastStringBuffer();
                            ((FastStringBuffer)buf).append("[JCoRFC] Execute before RfcCall(").append(client.getConnectionHandle()).append(", ");
                            ((FastStringBuffer)buf).append(name).append(", ").append(imports_rfc == null ? "null" : Integer.toString(imports_rfc.length));
                            ((FastStringBuffer)buf).append(", ").append(changings_rfc == null ? "null" : Integer.toString(changings_rfc.length));
                            ((FastStringBuffer)buf).append(", ").append(tables_rfc == null ? "null" : Integer.toString(tables_rfc.length)).append(')');
                            Trace.fireTrace(128, ((FastStringBuffer)buf).toString());
                            if (imports_rfc != null && Trace.isOn(16)) {
                                for (i = 0; i < imports_rfc.length; ++i) {
                                    Trace.fireTrace(16, "[JCoRFC] Sent Parameter " + imports_rfc[i].getName());
                                }
                            }
                            if (tables_rfc != null && Trace.isOn(16)) {
                                for (i = 0; i < tables_rfc.length; ++i) {
                                    Trace.fireTrace(16, "[JCoRFC] Sent Table " + ((TableParameter)tables_rfc[i]).getName());
                                }
                            }
                        }
                        client.rfcHandle.RfcCall(name, imports_rfc, exports_rfc, changings_rfc, tables_rfc, supportsASXML, classExceptionMode);
                        if (client.throughput != null || monitorOn) {
                            sentBytes = MiddlewareJavaRfc.this.countBytes(imports_rfc, changings_rfc, tables_rfc);
                        }
                        if (isTraceOn && Trace.isOn(128)) {
                            buf = new FastStringBuffer();
                            ((FastStringBuffer)buf).append("[JCoRFC] Execute after RfcCall(").append(client.getConnectionHandle()).append(", ");
                            ((FastStringBuffer)buf).append(name).append(", ").append(imports_rfc == null ? "null" : Integer.toString(imports_rfc.length));
                            ((FastStringBuffer)buf).append(", ").append(changings_rfc == null ? "null" : Integer.toString(changings_rfc.length));
                            ((FastStringBuffer)buf).append(", ").append(tables_rfc == null ? "null" : Integer.toString(tables_rfc.length)).append(')');
                            Trace.fireTrace(128, ((FastStringBuffer)buf).toString());
                            ((FastStringBuffer)buf).reset();
                            ((FastStringBuffer)buf).append("[JCoRFC] Execute before RfcReceive(").append(client.getConnectionHandle()).append(", ");
                            ((FastStringBuffer)buf).append(name).append(", ").append(exports_rfc == null ? "null" : Integer.toString(exports_rfc.length));
                            ((FastStringBuffer)buf).append(", ").append(changings_rfc == null ? "null" : Integer.toString(changings_rfc.length));
                            ((FastStringBuffer)buf).append(", ").append(tables_rfc == null ? "null" : Integer.toString(tables_rfc.length)).append(')');
                            Trace.fireTrace(128, ((FastStringBuffer)buf).toString());
                            if (exports_rfc != null && Trace.isOn(16)) {
                                for (i = 0; i < exports_rfc.length; ++i) {
                                    Trace.fireTrace(16, "[JCoRFC] Expecting Parameter " + exports_rfc[i].getName());
                                }
                            }
                            if (tables_rfc != null && Trace.isOn(16)) {
                                for (i = 0; i < tables_rfc.length; ++i) {
                                    Trace.fireTrace(16, "[JCoRFC] Expecting Table " + ((TableParameter)tables_rfc[i]).getName());
                                }
                            }
                        }
                        client.rfcHandle.RfcReceive(exports_rfc, changings_rfc, tables_rfc, this.ctx != null ? this.ctx.repository : null);
                        if (this.changeAttributes) {
                            this.getAttributes(client);
                        }
                        if (client.throughput != null || monitorOn) {
                            receivedBytes = MiddlewareJavaRfc.this.countBytes(exports_rfc, changings_rfc, tables_rfc);
                        }
                        if (Trace.isOn(128)) {
                            buf = new FastStringBuffer();
                            ((FastStringBuffer)buf).append("[JCoRFC] Execute after RfcReceive(").append(client.getConnectionHandle()).append(", ");
                            ((FastStringBuffer)buf).append(name).append(", ").append(exports_rfc == null ? "null" : Integer.toString(exports_rfc.length));
                            ((FastStringBuffer)buf).append(", ").append(changings_rfc == null ? "null" : Integer.toString(changings_rfc.length));
                            ((FastStringBuffer)buf).append(", ").append(tables_rfc == null ? "null" : Integer.toString(tables_rfc.length)).append(')');
                            Trace.fireTrace(128, ((FastStringBuffer)buf).toString());
                        }
                        if (tables_rfc != null) {
                            for (int i2 = 0; i2 < tables_rfc.length; ++i2) {
                                ((TableParameter)tables_rfc[i2]).table.row = 0;
                            }
                        }
                        if (this.invokeInvisibleGui) {
                            if (Trace.isOn(128)) {
                                FastStringBuffer buf2 = new FastStringBuffer();
                                buf2.append("[JCoRFC] Execute before hiding SAPGui(").append(client.getConnectionHandle()).append(')');
                                Trace.fireTrace(128, buf2.toString());
                            }
                            client.rfcHandle.RfcCallReceive("SYSTEM_INVISIBLE_GUI", null, null, null, null, AbapClassException.Mode.OFF, null);
                            if (Trace.isOn(128)) {
                                FastStringBuffer buf3 = new FastStringBuffer();
                                buf3.append("[JCoRFC] Execute after hiding SAPGui(").append(client.getConnectionHandle()).append(')');
                                Trace.fireTrace(128, buf3.toString());
                            }
                        }
                    }
                    tmiddleware = System.currentTimeMillis() - tstart;
                }
                catch (RfcException re) {
                    switch (re.getRc()) {
                        case 2: {
                            throw new AbapException(re.getMessage(), re.getMessageClass(), re.getMessageType(), re.getMessageNumber(), re.getMessageParameters());
                        }
                        case 24: {
                            String string;
                            AbapClassExceptionInfo exceptionInfo = re.getClassExceptionInfo();
                            String string2 = exceptionInfo.getMessage();
                            if (exceptionInfo.getName() == null) {
                                string = exceptionInfo.getExceptionInstance().getClassMetaData().getName();
                                throw new AbapClassException(string2, string, exceptionInfo.getExceptionInstance(), exceptionInfo.getRemoteContext());
                            }
                            string = exceptionInfo.getName();
                            throw new AbapClassException(string2, string, exceptionInfo.getExceptionInstance(), exceptionInfo.getRemoteContext());
                        }
                    }
                    throw MiddlewareJavaRfc.this.generateJCoException(re);
                }
                Object var35_31 = null;
            }
            catch (Throwable throwable) {
                Object var35_32 = null;
                ttotal = System.currentTimeMillis() - ttotal;
                if (client.throughput != null) {
                    DefaultThroughput defaultThroughput = client.throughput;
                    synchronized (defaultThroughput) {
                        ++client.throughput.num_calls;
                        client.throughput.time_marshall += tmarshall;
                        client.throughput.time_middleware += tmiddleware;
                        client.throughput.time_unmarshall += tunmarshall;
                        client.throughput.time_total += ttotal;
                        client.throughput.num_sent_bytes += sentBytes;
                        client.throughput.num_received_bytes += receivedBytes;
                    }
                }
                if (!monitorOn) throw throwable;
                client.time_middleware = tmiddleware;
                client.time_total = ttotal;
                client.num_sent_bytes = sentBytes;
                client.num_received_bytes = receivedBytes;
                throw throwable;
            }
            ttotal = System.currentTimeMillis() - ttotal;
            if (client.throughput != null) {
                DefaultThroughput defaultThroughput = client.throughput;
                synchronized (defaultThroughput) {
                    ++client.throughput.num_calls;
                    client.throughput.time_marshall += tmarshall;
                    client.throughput.time_middleware += tmiddleware;
                    client.throughput.time_unmarshall += tunmarshall;
                    client.throughput.time_total += ttotal;
                    client.throughput.num_sent_bytes += sentBytes;
                    client.throughput.num_received_bytes += receivedBytes;
                }
            }
            if (!monitorOn) return;
            client.time_middleware = tmiddleware;
            client.time_total = ttotal;
            client.num_sent_bytes = sentBytes;
            client.num_received_bytes = receivedBytes;
        }

        public void confirmUnitID(ClientConnection client, JCoUnitIdentifier unitIdentifier) throws JCoException {
            AbapFunctionTemplate confirmT = StaticFunctionTemplates.getBGRFC_DEST_CONFIRMTemplate();
            AbapFunction confirm = confirmT.getFunction();
            DefaultParameterList imports = confirm.getImportParameterList();
            imports.setValue("UNIT_ID", unitIdentifier.getIDAsBytes());
            int unitKind = 1409196103;
            if (unitIdentifier.getType() == JCoUnitIdentifier.Type.TYPE_T) {
                unitKind = 1409196105;
            }
            imports.setValue("UNIT_KIND", unitKind);
            this.execute(client, confirm.getName(), imports, null, null, null, confirm.supportsASXML(), confirm.getAbapClassExceptionMode());
        }

        public void confirmTID(ClientConnection client, String tid) throws JCoException {
            if (client.rfcHandle == null) {
                throw new JCoException(121, "JCO_ERROR_NULL_HANDLE", "Invalid rfc_handle = NULL encountered");
            }
            try {
                FastStringBuffer buf;
                if (Trace.isOn(128)) {
                    buf = new FastStringBuffer();
                    buf.append("[JCoRFC] ConfirmTid before RfcConfirmTransId(").append(client.getConnectionHandle());
                    buf.append(", ").append(tid).append(')');
                    Trace.fireTrace(128, buf.toString());
                }
                client.rfcHandle.RfcConfirmTransId(tid);
                if (Trace.isOn(128)) {
                    buf = new FastStringBuffer();
                    buf.append("[JCoRFC] ConfirmTid after RfcConfirmTransId(").append(client.getConnectionHandle());
                    buf.append(", ").append(tid).append(')');
                    Trace.fireTrace(128, buf.toString());
                }
            }
            catch (RfcException re) {
                throw MiddlewareJavaRfc.this.generateJCoException(re);
            }
        }

        public String createTID(ClientConnection client) throws JCoException {
            if (client.rfcHandle == null) {
                throw new JCoException(121, "JCO_ERROR_NULL_HANDLE", "Invalid rfc_handle = NULL encountered");
            }
            try {
                if (Trace.isOn(128)) {
                    FastStringBuffer buf = new FastStringBuffer();
                    buf.append("[JCoRFC] CreateTID before RfcCreateTransId(").append(client.getConnectionHandle());
                    buf.append(')');
                    Trace.fireTrace(128, buf.toString());
                }
                String tid = client.rfcHandle.RfcCreateTransID();
                if (Trace.isOn(128)) {
                    FastStringBuffer buf = new FastStringBuffer();
                    buf.append("[JCoRFC] CreateTID after RfcCreateTransId(").append(client.getConnectionHandle());
                    buf.append(")=").append(tid);
                    Trace.fireTrace(128, buf.toString());
                }
                return tid;
            }
            catch (RfcException re) {
                throw MiddlewareJavaRfc.this.generateJCoException(re);
            }
        }

        public Object getConnectionState(ClientConnection client) throws JCoException {
            return super.getConnectionState(client);
        }

        public void restoreConnection(ClientConnection client, Object connectionState) throws JCoException {
            super.restoreConnection(client, connectionState);
        }

        public void free(ClientConnection client) {
            super.free(client);
        }

        public JCoMiddleware.Client createCopy() {
            JavaRfcClient copy = (JavaRfcClient)super.createCopy();
            copy.logonParams = this.logonParams;
            copy.ctx = new JCoMiddleware.CallContext();
            return copy;
        }

        public JCoMiddleware.CallContext getCallContext(ClientConnection client) {
            this.ctx.conn = client;
            return this.ctx;
        }

        private void startSAPGui(ClientConnection client, int useSAPGui) throws JCoException {
            String[] connectStringAndMessage;
            DefaultParameterList importsPrepare = new DefaultParameterList(systemPrepareAttachGuiImports);
            importsPrepare.setValue(1, useSAPGui);
            if (this.logonParams.usesAbapDebug()) {
                importsPrepare.setValue(0, 1);
            }
            if (this.logonParams.getSnc_mode() > 0) {
                importsPrepare.setValue(2, 1);
            }
            DefaultParameterList exportsPrepare = new DefaultParameterList(systemPrepareAttachGuiExports);
            this.execute(client, "SYSTEM_PREPARE_ATTACH_GUI", importsPrepare, null, null, exportsPrepare, false, AbapClassException.Mode.OFF);
            String sapGuiId = exportsPrepare.getString(0);
            String startCommand = exportsPrepare.getString(1);
            String systemID = exportsPrepare.getString(2);
            int systemNr = exportsPrepare.getInt(3);
            String sapRouter = this.logonParams.getSaprouter();
            if (sapRouter != null) {
                if (sapRouter.endsWith("/H/")) {
                    sapRouter = sapRouter.substring(0, sapRouter.length() - 3);
                }
                startCommand = sapRouter + startCommand;
            }
            if ((connectStringAndMessage = RfcApi.runtime.launchSapGui(client.rfcHandle, startCommand, sapGuiId, systemID, systemNr)) == null) {
                throw new JCoException(108, "JCO_ERROR_INTERNAL", "Critical error in native layer when trying to start SAP GUI: Check native traces.");
            }
            DefaultParameterList importsFinish = new DefaultParameterList(systemFinishAttachGuiImports);
            if (connectStringAndMessage[0] != null) {
                importsFinish.setValue(0, connectStringAndMessage[0]);
            } else {
                importsFinish.setValue(1, connectStringAndMessage[1]);
            }
            importsFinish.setValue(2, sapGuiId);
            this.execute(client, "SYSTEM_FINISH_ATTACH_GUI", importsFinish, null, null, null, false, AbapClassException.Mode.OFF);
            if (connectStringAndMessage[0] == null) {
                throw new JCoException(136, "JCO_ERROR_ILLEGAL_STATE", "Launching SAP GUI failed, though it was requested (error message: " + connectStringAndMessage[1] + ")");
            }
            this.invokeInvisibleGui = useSAPGui == 2;
        }
    }

    class JavaRfcConnection
    implements JCoMiddleware.Connection,
    Cloneable {
        Converter converter;
        boolean changeAttributes = false;

        JavaRfcConnection() {
        }

        public boolean isAlive(AbstractConnection conn) {
            block3: {
                if (conn.rfcHandle != null) {
                    try {
                        conn.rfcHandle.RfcIsValidHandle();
                        return true;
                    }
                    catch (RfcException re) {
                        int exrc = re.getRc();
                        if (exrc != 6) break block3;
                        conn.rfcHandle.RfcClose();
                        this.releaseHandle(conn);
                    }
                }
            }
            return false;
        }

        public void cancel(AbstractConnection conn) throws JCoException {
            if (conn.rfcHandle == null) {
                throw new JCoException(121, "JCO_ERROR_NULL_HANDLE", "Invalid rfc_handle = NULL encountered");
            }
            conn.rfcHandle.RfcCancel();
        }

        public void abort(AbstractConnection conn, String message) throws JCoException {
            if (conn.rfcHandle != null) {
                try {
                    block6: {
                        try {
                            long handle = conn.getConnectionHandle();
                            if (Trace.isOn(128)) {
                                Trace.fireTrace(128, "[JCoRFC] Abort before RfcAbort(" + handle + ", " + message + ')');
                            }
                            conn.rfcHandle.RfcAbort(message);
                            if (!Trace.isOn(128)) break block6;
                            Trace.fireTrace(128, "[JCoRFC] Abort after RfcAbort(" + handle + ", " + message + ')');
                        }
                        catch (RfcException e) {
                            throw MiddlewareJavaRfc.this.generateJCoException(e);
                        }
                    }
                    Object var6_5 = null;
                    this.releaseHandle(conn);
                }
                catch (Throwable throwable) {
                    Object var6_6 = null;
                    this.releaseHandle(conn);
                    throw throwable;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void disconnect(AbstractConnection conn) {
            long tstart = 0L;
            long ttotal = 0L;
            long tmiddleware = 0L;
            ttotal = System.currentTimeMillis();
            if (conn.rfcHandle != null) {
                try {
                    if (Trace.isOn(128)) {
                        Trace.fireTrace(128, "[JCoRFC] Disconnect before RfcClose(" + conn.getConnectionHandle() + ')');
                    }
                    tstart = System.currentTimeMillis();
                    conn.rfcHandle.RfcClose();
                    tmiddleware = System.currentTimeMillis() - tstart;
                    if (Trace.isOn(128)) {
                        Trace.fireTrace(128, "[JCoRFC] Disconnect after RfcClose(" + conn.getConnectionHandle() + ')');
                    }
                    Object var9_5 = null;
                    this.releaseHandle(conn);
                }
                catch (Throwable throwable) {
                    Object var9_6 = null;
                    this.releaseHandle(conn);
                    throw throwable;
                }
            }
            ttotal = System.currentTimeMillis() - ttotal;
            if (conn.throughput != null) {
                DefaultThroughput defaultThroughput = conn.throughput;
                synchronized (defaultThroughput) {
                    conn.throughput.time_middleware += tmiddleware;
                    conn.throughput.time_total += ttotal;
                }
            }
        }

        protected IRfcParameter getParameter(DefaultParameterList parameterList, int index) {
            if ((parameterList.flags[index] & 0xE) != 0) {
                return null;
            }
            switch (parameterList.metaData.type[index]) {
                case 17: {
                    DefaultStructure struct = (DefaultStructure)parameterList.odata[parameterList.metaData.oindex[index]];
                    if (struct.getRecordMetaData().isNestedType1Structure()) {
                        return new NestedStructure(struct, parameterList.metaData.name[index], this.converter, index, parameterList.flags);
                    }
                    if (struct.odata.length == 0) {
                        return new FlatStructure(struct, parameterList.metaData.name[index], this.converter, index, parameterList.flags);
                    }
                }
                case 5: 
                case 42: 
                case 99: {
                    return new ComplexParameter((AbstractRecord)parameterList.odata[parameterList.metaData.oindex[index]], parameterList.metaData.name[index], index, parameterList.flags);
                }
            }
            return new Parameter(parameterList, index, this.converter);
        }

        protected IRfcParameter refetchParameter(DefaultParameterList parameterList, IRfcParameter parameter) {
            int index = parameter.getIndex();
            if ((parameterList.flags[index] & 0xE) != 0) {
                return null;
            }
            switch (parameterList.metaData.type[index]) {
                case 17: {
                    if (parameter instanceof FlatStructure) {
                        ((FlatStructure)parameter).setStructure((DefaultStructure)parameterList.odata[parameterList.metaData.oindex[index]]);
                        return parameter;
                    }
                }
                case 5: 
                case 42: 
                case 99: {
                    ((ComplexParameter)parameter).setRecord((AbstractRecord)parameterList.odata[parameterList.metaData.oindex[index]]);
                    return parameter;
                }
            }
            return parameter;
        }

        protected void getAttributes(AbstractConnection conn) throws JCoException {
            if (conn.rfcHandle == null) {
                throw new JCoException(121, "JCO_ERROR_NULL_HANDLE", "Invalid rfc_handle = NULL encountered");
            }
            RfcIoOpenCntl handleAttributes = conn.rfcHandle;
            if (handleAttributes.mysapsso2 != null) {
                conn.attributes.sso_ticket = handleAttributes.mysapsso2;
            }
            if (handleAttributes.htRFC != null) {
                RfcIoOpenCntl originalHandle = handleAttributes.htRFC;
                conn.attributes.dest = originalHandle.destination;
            } else {
                conn.attributes.dest = handleAttributes.destination;
            }
            conn.attributes.own_host = AbSysInfo.host;
            conn.attributes.partner_host = handleAttributes.target == null ? "UNKNOWN" : handleAttributes.target;
            conn.attributes.systnr = handleAttributes.systnr;
            if (handleAttributes.sysid != null) {
                conn.attributes.sysid = handleAttributes.sysid;
            }
            conn.attributes.client = handleAttributes.mandt;
            conn.attributes.user = handleAttributes.userid;
            if (conn.attributes.user == null) {
                conn.attributes.user = "";
            }
            conn.attributes.language = handleAttributes.lang;
            if (conn.attributes.language == null) {
                conn.attributes.language = " ";
            }
            conn.attributes.ISO_language = Language.getISOLanguage(conn.attributes.language);
            if (conn.attributes.ISO_language == null) {
                conn.attributes.ISO_language = conn.attributes.language + ' ';
            }
            conn.attributes.own_rel = handleAttributes.own_rel;
            boolean updateAttributes = false;
            if (handleAttributes.partner_rel == null) {
                if ((this.changeAttributes || handleAttributes.rfc_role == 'C') && handleAttributes.partner_type == '3') {
                    RfcIoOpenCntl communicationHandle = handleAttributes;
                    if (handleAttributes.htRFC != null) {
                        RfcIoOpenCntl originalHandle;
                        communicationHandle = originalHandle = handleAttributes.htRFC;
                    }
                    try {
                        DefaultStructure rfcsi = new RfcSystemInfo().clientExecute(communicationHandle);
                        communicationHandle.kernel_rel = rfcsi.getString("RFCKERNRL");
                        communicationHandle.partner_rel = rfcsi.getString("RFCSAPRL");
                        communicationHandle.partner_type = (char)(rfcsi.getString("RFCDATABS").length() == 0 ? 69 : 51);
                        handleAttributes.kernel_rel = communicationHandle.kernel_rel;
                        handleAttributes.partner_rel = communicationHandle.partner_rel;
                        handleAttributes.partner_type = communicationHandle.partner_type;
                    }
                    catch (RfcException re) {
                        Trc.criticalTrace("RfcException while querying missing attributes on [" + handleAttributes.hrfc + "]", re);
                    }
                } else {
                    updateAttributes = true;
                }
            }
            conn.attributes.partner_rel = handleAttributes.partner_rel;
            conn.attributes.kernel_rel = handleAttributes.kernel_rel;
            this.changeAttributes = false;
            if (handleAttributes.partner_type == '\u0000') {
                conn.attributes.partner_type = (char)69;
                if (handleAttributes.charset == null && handleAttributes.rfc_role == 'C') {
                    try {
                        ClientConnection client = (ClientConnection)conn;
                        if (client.pool.getAttributes() != null) {
                            handleAttributes.charset = client.pool.attributes.partner_codepage;
                            if (handleAttributes.getCommunicationCodepage() == null) {
                                handleAttributes.setCommunicationCodepage(client.pool.attributes.partner_codepage);
                            }
                            conn.attributes.dest = client.pool.attributes.dest;
                            conn.attributes.partner_host = client.pool.attributes.partner_host;
                            conn.attributes.systnr = client.pool.attributes.systnr;
                            conn.attributes.sysid = "EXTERN";
                            conn.attributes.own_codepage = client.pool.attributes.own_codepage;
                            conn.attributes.own_charset = client.pool.attributes.own_charset;
                            conn.attributes.own_encoding = client.pool.attributes.own_encoding;
                            conn.attributes.own_bytes_per_char = client.pool.attributes.own_bytes_per_char;
                            conn.attributes.partner_codepage = client.pool.attributes.partner_codepage;
                            conn.attributes.partner_charset = client.pool.attributes.partner_charset;
                            conn.attributes.partner_encoding = client.pool.attributes.partner_encoding;
                            conn.attributes.partner_bytes_per_char = client.pool.attributes.partner_bytes_per_char;
                            conn.attributes.partner_rel = client.pool.attributes.partner_rel;
                            conn.attributes.partner_rel_number = client.pool.attributes.partner_rel_number;
                            conn.attributes.partner_type = client.pool.attributes.partner_type;
                            conn.attributes.trace = client.pool.attributes.trace;
                            conn.attributes.rfc_role = client.pool.attributes.rfc_role;
                            conn.attributes.own_type = client.pool.attributes.own_type;
                        } else {
                            conn.attributes.sysid = "EXTERN";
                        }
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                updateAttributes = true;
            } else {
                conn.attributes.partner_type = handleAttributes.partner_type;
            }
            conn.attributes.own_codepage = handleAttributes.pcs == 2 ? handleAttributes.getCodepage() : handleAttributes.getCommunicationCodepage();
            String cachedPartnerCodepage = conn.attributes.partner_codepage;
            conn.attributes.partner_codepage = handleAttributes.getCommunicationCodepage();
            conn.attributes.trace = (char)(handleAttributes.trace ? 88 : 32);
            conn.attributes.rfc_role = handleAttributes.rfc_role;
            conn.attributes.own_type = handleAttributes.own_type;
            if (handleAttributes.changeComm_cp || handleAttributes.unicodeHeader != null || updateAttributes) {
                this.changeAttributes = true;
            }
            Codepage.CPMap receiveCodepage = MiddlewareJavaRfc.this.getCodepage(conn.attributes.partner_codepage, handleAttributes.pcs, conn.attributes.ISO_language);
            Codepage.CPMap sendCodepage = Codepage.getCPMap(conn.attributes.own_codepage);
            conn.attributes.own_charset = sendCodepage.encoding;
            conn.attributes.own_encoding = sendCodepage.mimeCharset;
            conn.attributes.own_bytes_per_char = (byte)(sendCodepage.is2byte ? 2 : 1);
            conn.attributes.partner_charset = receiveCodepage.encoding;
            conn.attributes.partner_encoding = receiveCodepage.mimeCharset;
            conn.attributes.partner_bytes_per_char = (byte)(receiveCodepage.is2byte ? 2 : 1);
            if (conn.attributes.partner_codepage == null) {
                conn.attributes.partner_codepage = receiveCodepage.codepage;
            }
            if (!(conn.attributes.rfc_role != 'C' || conn.attributes.partner_type != 'E' && conn.attributes.partner_type != 'R' || conn.attributes.partner_codepage.equals(cachedPartnerCodepage))) {
                conn.properties.put("jco.client.codepage", conn.attributes.partner_codepage);
            }
            if (this.converter != null) {
                this.converter.update(receiveCodepage.codepage, sendCodepage.codepage, 1 == handleAttributes.intformat);
            } else {
                this.converter = new Converter(receiveCodepage.codepage, sendCodepage.codepage, 1 == handleAttributes.intformat);
            }
        }

        public Object getConnectionState(AbstractConnection conn) throws JCoException {
            if (conn.rfcHandle == null) {
                throw new JCoException(121, "JCO_ERROR_NULL_HANDLE", "null handle in getConnectionState");
            }
            return conn.rfcHandle.getRfcConnectionState();
        }

        public void restoreConnection(AbstractConnection conn, Object connectionState) throws JCoException {
            try {
                conn.rfcHandle = RfcIoControl.restoreConnection((RfcConnectionState)connectionState, conn);
            }
            catch (RfcException e) {
                throw new JCoException(e.getErrorGroup(), e.getKey(), e.getMessage(), e);
            }
            catch (ClassCastException e) {
                throw new JCoException(131, "JCO_ERROR_ILLEGAL_ARGUMENT", "stored state of the middleware connection is not instance of RfcConnectionState", e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void free(AbstractConnection conn) {
            try {
                conn.rfcHandle.clearRfcConnection();
                Object var3_2 = null;
                this.releaseHandle(conn);
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                this.releaseHandle(conn);
                throw throwable;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void releaseHandle(AbstractConnection conn) {
            if (conn.rfcHandle != null) {
                try {
                    RfcIoControl.release(conn.rfcHandle);
                    Object var3_2 = null;
                    conn.rfcHandle = null;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    conn.rfcHandle = null;
                    throw throwable;
                }
            }
        }

        public JCoMiddleware.Connection createCopy() {
            try {
                JavaRfcConnection copy = (JavaRfcConnection)super.clone();
                copy.converter = null;
                copy.changeAttributes = false;
                return copy;
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                return null;
            }
        }
    }

    private class DispatchException
    extends Exception {
        static final long serialVersionUID = 3000120080918L;

        DispatchException() {
            super("foo");
        }
    }
}

