/*
 * Decompiled with CFR 0.152.
 */
package com.sap.i18n.cp;

import com.sap.i18n.cp.ConvertArrException;
import com.sap.i18n.cp.ConvertCCCDataErrInfo;
import com.sap.i18n.cp.ConvertCToX;

public class ConvertUc2Utf8
extends ConvertCToX {
    public ConvertUc2Utf8(boolean bIgnoreErr) {
        super("4110".toCharArray(), bIgnoreErr);
    }

    public int ConvertArrImpl(char[] acIn, int nInBeginIndex, int nInEndIndex, byte[] abOut, int nOutBeginIndex, int nOutEndIndex) throws ConvertArrException {
        this.m_oCnvLastErr = null;
        int i = nInBeginIndex;
        int j = nOutBeginIndex;
        while (i < nInEndIndex && j < nOutEndIndex) {
            boolean bRepl = false;
            int nCurPosSave = i;
            int nCurChar = acIn[i];
            if (nCurChar < 128) {
                abOut[j++] = (byte)acIn[i++];
            } else if (nCurChar < 2048) {
                if (j + 2 > nOutEndIndex) break;
                abOut[j++] = (byte)(acIn[i] >> 6 | 0xC0);
                abOut[j++] = (byte)(acIn[i++] & 0x3F | 0x80);
            } else if (nCurChar < 55296 || nCurChar > 57343) {
                if (j + 3 > nOutEndIndex) break;
                abOut[j++] = (byte)(acIn[i] >> 12 | 0xE0);
                abOut[j++] = (byte)(acIn[i] >> 6 & 0x3F | 0x80);
                abOut[j++] = (byte)(acIn[i++] & 0x3F | 0x80);
            } else if (nCurChar > 56319) {
                abOut[j++] = 35;
                ++i;
                bRepl = true;
            } else if (i == nInEndIndex - 1) {
                abOut[j++] = 35;
                ++i;
                bRepl = true;
            } else if ((acIn[i + 1] & 0xFFFF) < 56320 || (acIn[i + 1] & 0xFFFF) > 57343) {
                abOut[j++] = 35;
                ++i;
                bRepl = true;
            } else {
                if (j + 4 > nOutEndIndex) break;
                nCurChar = ((acIn[i] & 0x3FF) << 10 | acIn[i + 1] & 0x3FF) + 65536;
                abOut[j++] = (byte)(nCurChar >> 18 | 0xF0);
                abOut[j++] = (byte)(nCurChar >> 12 & 0x3F | 0x80);
                abOut[j++] = (byte)(nCurChar >> 6 & 0x3F | 0x80);
                abOut[j++] = (byte)(nCurChar & 0x3F | 0x80);
                i += 2;
            }
            if (this.m_bIgnoreErr || !bRepl) continue;
            ConvertCCCDataErrInfo oCnvErrInfo = this.createCnvErr("ConvertUc2Utf8Arr", 2048, acIn, nInBeginIndex, nInEndIndex, nCurPosSave, abOut, nOutBeginIndex, j);
            throw new ConvertArrException(oCnvErrInfo);
        }
        if (i < nInEndIndex) {
            ConvertCCCDataErrInfo oCnvErrInfo = this.createCnvErr("ConvertUc2Utf8Arr", 32, acIn, nInBeginIndex, nInEndIndex, i, abOut, nOutBeginIndex, j);
            throw new ConvertArrException(oCnvErrInfo);
        }
        return j - nOutBeginIndex;
    }

    public int outLength(char[] acIn, int nInBeginIndex, int nInEndIndex) {
        int i = nInBeginIndex;
        int j = 0;
        while (i < nInEndIndex) {
            int nCurChar = acIn[i] & 0xFFFF;
            if (nCurChar < 128) {
                ++i;
                ++j;
                continue;
            }
            if (nCurChar < 2048) {
                ++i;
                j += 2;
                continue;
            }
            if (nCurChar < 55296 || nCurChar > 57343) {
                ++i;
                j += 3;
                continue;
            }
            if (nCurChar > 56319) {
                ++i;
                ++j;
                continue;
            }
            if (i == nInEndIndex - 1) {
                ++j;
                break;
            }
            if ((acIn[i + 1] & 0xFFFF) < 56320 || (acIn[i + 1] & 0xFFFF) > 57343) {
                ++i;
                ++j;
                continue;
            }
            i += 2;
            j += 4;
        }
        return j;
    }

    protected boolean isShortcut() {
        return true;
    }
}

