/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.logging;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;

public class Severity {
    protected static final int OFFSET = 100;
    public static final int ALL = 0;
    public static final int DEBUG = 100;
    public static final int PATH = 200;
    public static final int INFO = 300;
    public static final int WARNING = 400;
    public static final int ERROR = 500;
    public static final int FATAL = 600;
    public static final int MIN = 0;
    public static final int MAX = 700;
    public static final int GROUP = 800;
    public static final int NONE = 701;
    private static final String[] PRIVATE_VALUES = new String[]{"All", "Debug", "Path", "Info", "Warning", "Error", "Fatal", "Min", "Max", "None"};
    public static final List VALUES = Collections.unmodifiableList(Arrays.asList(PRIVATE_VALUES));
    protected static final String INVALID_SEVERITY_EMSG = "invalid severity";
    protected static final String UNKNOWN_SEVERITY_EMSG = "unknown severity constant";
    private static HashMap severities = new HashMap();

    public static String toString(int severity) {
        if (severity < 100) {
            return "All";
        }
        if (severity < 200) {
            return "Debug";
        }
        if (severity < 300) {
            return "Path";
        }
        if (severity < 400) {
            return "Info";
        }
        if (severity < 500) {
            return "Warning";
        }
        if (severity < 600) {
            return "Error";
        }
        if (severity <= 700) {
            return "Fatal";
        }
        if (severity == 701) {
            return "None";
        }
        if (severity == 800) {
            return "Group";
        }
        return "Unknown";
    }

    public static void check(int severity) {
        if ((severity < 0 || 700 < severity) && severity != 701 && severity != 0 && severity != 800) {
            throw new IllegalArgumentException(INVALID_SEVERITY_EMSG);
        }
    }

    public static void msgCheck(int severity) {
        if ((severity < 0 || 700 < severity) && severity != 800) {
            throw new IllegalArgumentException(INVALID_SEVERITY_EMSG);
        }
    }

    public static int correct(int severity) {
        block3: {
            try {
                Severity.check(severity);
            }
            catch (IllegalArgumentException e) {
                if (severity < 0) {
                    severity = 0;
                }
                if (700 >= severity) break block3;
                severity = 700;
            }
        }
        return severity;
    }

    public static int msgCorrect(int severity) {
        block3: {
            try {
                Severity.msgCheck(severity);
            }
            catch (IllegalArgumentException e) {
                if (severity < 0) {
                    severity = 0;
                }
                if (700 >= severity) break block3;
                severity = 700;
            }
        }
        return severity;
    }

    public static int parse(String name) {
        try {
            return (Integer)severities.get(name.toUpperCase().trim().toUpperCase());
        }
        catch (NullPointerException exc) {
            throw new IllegalArgumentException(UNKNOWN_SEVERITY_EMSG);
        }
    }

    static {
        severities.put("DEBUG", new Integer(100));
        severities.put("PATH", new Integer(200));
        severities.put("INFO", new Integer(300));
        severities.put("WARNING", new Integer(400));
        severities.put("ERROR", new Integer(500));
        severities.put("FATAL", new Integer(600));
        severities.put("GROUP", new Integer(800));
        severities.put("MIN", new Integer(0));
        severities.put("MAX", new Integer(700));
        severities.put("NONE", new Integer(701));
        severities.put("ALL", new Integer(0));
    }
}

