/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.logging;

import com.sap.tc.logging.Category;
import com.sap.tc.logging.Location;
import com.sap.tc.logging.LogController;
import com.sap.tc.logging.LogRecord;
import com.sap.tc.logging.LoggingManager;

public class SimpleLogger {
    public static boolean isWritable(int severity, LogController lc) {
        return lc.getIsActivityTrackingEnabled() && lc.isActivityTracking(severity) || severity >= lc.getEffectiveSeverity();
    }

    public static LogRecord trace(int severity, Location location, String message) {
        LogRecord writtenRec = null;
        if (SimpleLogger.isWritable(severity, location)) {
            writtenRec = location.logInt(severity, (LogController)location, null, null, null, location == null ? null : location.csnComponent, location == null ? null : location.dcName, message, 0, null, null);
        }
        return writtenRec;
    }

    public static LogRecord trace(int severity, Location location, String messageID, String message) {
        LogRecord writtenRec = null;
        if (SimpleLogger.isWritable(severity, location)) {
            writtenRec = location.logInt(severity, (LogController)location, null, null, messageID == null ? "" : location.vendor + messageID, location == null ? null : location.csnComponent, location == null ? null : location.dcName, message, 0, null, null);
        }
        return writtenRec;
    }

    public static LogRecord trace(int severity, Location location, String message, Object ... args) {
        return SimpleLogger.trace(severity, location, null, message, args);
    }

    public static LogRecord trace(int severity, Location location, String messageID, String message, Object ... args) {
        LogRecord writtenRec = null;
        if (SimpleLogger.isWritable(severity, location)) {
            if (args != null) {
                StringBuilder messageBuilder = new StringBuilder(message);
                int ind = 0;
                for (Object o : args) {
                    int ii = messageBuilder.indexOf("{" + ind + "}");
                    if (ii >= 0) {
                        messageBuilder.replace(ii, ii + 3, o == null ? "null" : o.toString());
                    }
                    ++ind;
                }
                message = messageBuilder.toString();
            }
            writtenRec = location.logInt(severity, (LogController)location, null, null, messageID == null ? "" : location.vendor + messageID, location == null ? null : location.csnComponent, location == null ? null : location.dcName, message, 0, null, null);
        }
        return writtenRec;
    }

    public static LogRecord trace(int severity, Location location, String dcName, String csnComponent, String messageID, String message, Throwable exc, Object ... args) {
        LogRecord writtenRec = null;
        if (SimpleLogger.isWritable(severity, location)) {
            if (args != null) {
                StringBuilder messageBuilder = new StringBuilder(message);
                int ind = 0;
                for (Object o : args) {
                    int ii = messageBuilder.indexOf("{" + ind + "}");
                    if (ii >= 0) {
                        messageBuilder.replace(ii, ii + 3, o == null ? "null" : o.toString());
                    }
                    ++ind;
                }
                message = messageBuilder.toString();
            }
            if (dcName != null && csnComponent == null) {
                if (LoggingManager.classLoadInfoProvider != null) {
                    csnComponent = LoggingManager.classLoadInfoProvider.getCsnComponent(dcName);
                }
                if (csnComponent == null && LoggingManager.deployInfoProvider != null) {
                    csnComponent = LoggingManager.deployInfoProvider.getCsnComponentByDcName(dcName);
                }
                if (csnComponent == null) {
                    csnComponent = "N/A";
                }
            }
            writtenRec = location.logInt(severity, (LogController)location, null, null, messageID == null ? "" : location.vendor + messageID, (String)(csnComponent == null ? (location == null ? null : location.csnComponent) : csnComponent), (String)(dcName == null ? (location == null ? null : location.dcName) : dcName), message, 0, null, exc);
        }
        return writtenRec;
    }

    public static LogRecord traceThrowable(int severity, Location location, String message, Throwable exc) {
        LogRecord writtenRec = null;
        if (SimpleLogger.isWritable(severity, location)) {
            writtenRec = location.logInt(severity, (LogController)location, null, null, null, location == null ? null : location.csnComponent, location == null ? null : location.dcName, message, 0, null, exc);
        }
        return writtenRec;
    }

    public static LogRecord traceThrowable(int severity, Location location, String messageID, String message, Throwable exc) {
        LogRecord writtenRec = null;
        if (SimpleLogger.isWritable(severity, location)) {
            writtenRec = location.logInt(severity, (LogController)location, null, null, messageID == null ? "" : location.vendor + messageID, location == null ? null : location.csnComponent, location == null ? null : location.dcName, message, 0, null, exc);
        }
        return writtenRec;
    }

    public static LogRecord traceThrowable(int severity, Location location, Throwable exc, String messageID, String message, Object ... args) {
        LogRecord writtenRec = null;
        if (SimpleLogger.isWritable(severity, location)) {
            if (args != null) {
                StringBuilder messageBuilder = new StringBuilder(message);
                int ind = 0;
                for (Object o : args) {
                    int ii = messageBuilder.indexOf("{" + ind + "}");
                    if (ii >= 0) {
                        messageBuilder.replace(ii, ii + 3, o == null ? "null" : o.toString());
                    }
                    ++ind;
                }
                message = messageBuilder.toString();
            }
            writtenRec = location.logInt(severity, (LogController)location, null, null, messageID == null ? "" : location.vendor + messageID, location == null ? null : location.csnComponent, location == null ? null : location.dcName, message, 0, null, exc);
        }
        return writtenRec;
    }

    public static LogRecord log(int severity, Category category, Location location, String messageID, String message, Object ... args) {
        int typeOfMessage = args == null ? 0 : 1;
        LogRecord writtenRec = null;
        if (SimpleLogger.isWritable(severity, category)) {
            writtenRec = category.logSeverityInt(severity, (LogController)location, new LogController[]{location}, null, messageID == null ? "" : location.vendor + messageID, location == null ? null : location.csnComponent, location == null ? null : location.dcName, message, typeOfMessage, args);
        } else if (location != null && location.beLogged(severity)) {
            if (args != null) {
                StringBuilder messageBuilder = new StringBuilder(message);
                int ind = 0;
                for (Object o : args) {
                    int ii = messageBuilder.indexOf("{" + ind + "}");
                    if (ii >= 0) {
                        messageBuilder.replace(ii, ii + 3, o == null ? "null" : o.toString());
                    }
                    ++ind;
                }
                message = messageBuilder.toString();
            }
            location.logInt(severity, (LogController)location, new LogController[]{category}, null, messageID == null ? "" : location.vendor + messageID, location == null ? null : location.csnComponent, location == null ? null : location.dcName, message, 0, args, null);
        }
        return writtenRec;
    }

    public static LogRecord log(int severity, Category category, Location location, String dcName, String csnComponent, String messageID, String message, Object ... args) {
        int typeOfMessage;
        LogRecord writtenRec = null;
        int n = typeOfMessage = args == null ? 0 : 1;
        if (dcName != null && csnComponent == null && LoggingManager.deployInfoProvider != null) {
            csnComponent = LoggingManager.deployInfoProvider.getCsnComponentByDcName(dcName);
        }
        if (SimpleLogger.isWritable(severity, category)) {
            writtenRec = category.logSeverityInt(severity, (LogController)location, new LogController[]{location}, null, messageID == null ? "" : location.vendor + messageID, (String)(csnComponent == null ? (location == null ? null : location.csnComponent) : csnComponent), (String)(dcName == null ? (location == null ? null : location.dcName) : dcName), message, typeOfMessage, args);
        } else if (location != null && location.beLogged(severity)) {
            if (args != null) {
                StringBuilder messageBuilder = new StringBuilder(message);
                int ind = 0;
                for (Object o : args) {
                    int ii = messageBuilder.indexOf("{" + ind + "}");
                    if (ii >= 0) {
                        messageBuilder.replace(ii, ii + 3, o == null ? "null" : o.toString());
                    }
                    ++ind;
                }
                message = messageBuilder.toString();
            }
            location.logInt(severity, (LogController)location, new LogController[]{category}, null, messageID == null ? "" : location.vendor + messageID, (String)(csnComponent == null ? (location == null ? null : location.csnComponent) : csnComponent), (String)(dcName == null ? (location == null ? null : location.dcName) : dcName), message, 0, args, null);
        }
        return writtenRec;
    }

    public static LogRecord log(int severity, Category category, Location location, String messageID, String message) {
        LogRecord writtenRec = null;
        if (SimpleLogger.isWritable(severity, category)) {
            writtenRec = category.logSeverityInt(severity, (LogController)location, new LogController[]{location}, null, messageID == null ? "" : location.vendor + messageID, location == null ? null : location.csnComponent, location == null ? null : location.dcName, message, 0, (Object[])null);
        } else if (location != null && location.beLogged(severity)) {
            location.logInt(severity, (LogController)location, new LogController[]{category}, null, messageID == null ? "" : location.vendor + messageID, location == null ? null : location.csnComponent, location == null ? null : location.dcName, message, 0, null, null);
        }
        return writtenRec;
    }
}

