/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.logging;

import com.sap.tc.logging.Category;
import com.sap.tc.logging.ExceptionManager;
import com.sap.tc.logging.Location;
import com.sap.tc.logging.LogRecord;
import com.sap.tc.logging.MsgObject;

public class APILogger {
    protected static Location APILocation = Location.getLocation(APILogger.class.getName(), "tc~logging~java", "BC-JAS-ADM-LOG-API");
    protected static Location loggingPachkageLocation = Location.getLocation("com.sap.tc.logging", "tc~logging~java", "BC-JAS-ADM-LOG-API");

    protected static LogRecord logIntByAPI(int severity, Location loc, String subloc, String msgCode, String msgClear, Object[] args) {
        APILogger.init();
        if (Category.SYS_LOGGING.beLogged(severity)) {
            return Category.SYS_LOGGING.logIntByAPI(severity, loc, subloc, msgCode, msgClear, args);
        }
        if (APILocation.beLogged(severity)) {
            return APILocation.logIntByAPI(severity, loc, subloc, msgCode, msgClear, args);
        }
        return null;
    }

    protected static LogRecord logIntByAPI(int severity, String subloc, String msgCode, String msgClear, Object[] args) {
        APILogger.init();
        if (Category.SYS_LOGGING.beLogged(severity)) {
            return Category.SYS_LOGGING.logIntByAPI(severity, APILocation, subloc, msgCode, msgClear, args);
        }
        if (APILocation.beLogged(severity)) {
            return APILocation.logIntByAPI(severity, APILocation, subloc, msgCode, msgClear, args);
        }
        return null;
    }

    public static LogRecord traceThrowableIntByAPI(int severity, String loc, String msgClear, Exception exc) {
        APILogger.init();
        return loggingPachkageLocation.logTInt(severity, APILocation, null, loc, msgClear, 1, new Object[]{ExceptionManager.getStackTrace(exc)});
    }

    protected static LogRecord logIntByAPI(int severity, String subloc, MsgObject msgObject, Object[] args) {
        APILogger.init();
        if (Category.SYS_LOGGING.beLogged(severity)) {
            return Category.SYS_LOGGING.logIntByAPI(severity, APILocation, subloc, msgObject.getMsgKeyAndID(), msgObject.getMsgText(), args);
        }
        if (APILocation.beLogged(severity)) {
            return APILocation.logIntByAPI(severity, APILocation, subloc, msgObject.getMsgKeyAndID(), msgObject.getMsgText(), args);
        }
        return null;
    }

    protected static LogRecord instrumentIntByAPI(String subloc, MsgObject msgObject, Object[] args) {
        APILogger.init();
        return APILocation.debugT(msgObject.getMsgText(), args);
    }

    protected static LogRecord instrumentIntByAPI(int sev, String message, Object[] args) {
        APILogger.init();
        return APILocation.logT(sev, message, args);
    }

    protected static LogRecord catchingIntByAPI(Throwable exc) {
        if (Category.SYS_LOGGING.bePath()) {
            return Category.SYS_LOGGING.catchingIntByAPI(exc);
        }
        if (APILocation.bePath()) {
            return APILocation.catchingIntByAPI(exc);
        }
        return null;
    }

    protected static boolean beLogged(int severity) {
        return Category.SYS_LOGGING.beLogged(severity);
    }

    private static void init() {
        if (APILocation == null) {
            APILocation = Location.getLocation(APILogger.class.getName(), "tc~logging~java", "BC-JAS-ADM-LOG-API");
        }
    }
}

